/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogTablePanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogMainFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.SelectInstancesTreePanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntry;
import oracle.dbtools.raptor.timesten.grid.loginspector.UpdateLogsSwingWorker;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class LogInspectorMainWindow
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private List<InstanceLogTablePanel> instancesPanes;
    private List<BoundedRangeModel> instancesPanesScrollModel;
    private SelectInstancesTreePanel selectInstancesTree;
    private JScrollPane selectInstancesScroll;
    private GridObject currentGrid;
    private JEWTDialog dialog;
    private UpdateLogsSwingWorker logUpdater;
    private JEWTDialog findDialog;
    private JEWTDialog filterDialog;
    private static final Logger logger = Logger.getLogger(LogInspectorMainWindow.class.getName());
    private JPanel instructionsPanel;
    private JSplitPane upPane;
    private JSplitPane bottomPane;
    private JSplitPane mainRightHandSplitPane;
    private JSplitPane mainPanelSplitPane;
    private LogMainFilterPanel filterPanel;
    private JMenuBar menuBar;
    private JMenu logMenu;
    private JMenu columnsMenu;
    private JCheckBoxMenuItem severityColumnControl;
    private JCheckBoxMenuItem progColumnControl;
    private JCheckBoxMenuItem pidColumnControl;
    private JMenuItem updateLogsMenu;
    private JMenuItem filtersMenu;
    private JMenuItem loadLogMenu;
    private JMenuItem saveFilteredMenu;
    private JCheckBoxMenuItem scrollSimult;
    private Set<InstanceLogTablePanel.TABLE_COLUMN> columnsShowing;
    private LogViewerType type;

    public void setDialog(JEWTDialog jEWTDialog) {
        this.dialog = jEWTDialog;
        jEWTDialog.setJMenuBar(this.menuBar);
        jEWTDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    public LogInspectorMainWindow(GridObject gridObject, LogViewerType logViewerType) {
        this.type = logViewerType;
        this.currentGrid = gridObject;
        ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        gridObject.getHosts().forEach(hostObject -> arrayList.addAll(hostObject.getInstances()));
        LogFilter.getFilterObjectInstance().clearFilter();
        this.initGUI(arrayList);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, logViewerType == LogViewerType.MSG ? TimesTenHelpID.GRID_INSPECT_SUPPORT_LOG.toString() : TimesTenHelpID.GRID_INSPECT_USER_LOG.toString());
    }

    private void initGUI(List<InstanceObject> list2) {
        this.setLayout(new GridBagLayout());
        this.instructionsPanel = new JPanel(new GridBagLayout());
        this.instructionsPanel.add((Component)new JLabel(Messages.getString("TimestenGrid.SelectInstancesInstructions1")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 20, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.instructionsPanel.add((Component)new JLabel(Messages.getString("TimestenGrid.SelectInstancesInstructions3")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 19, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.instancesPanes = new ArrayList<InstanceLogTablePanel>();
        this.instancesPanesScrollModel = new ArrayList<BoundedRangeModel>();
        this.upPane = new JSplitPane(1);
        this.bottomPane = new JSplitPane(1);
        this.mainRightHandSplitPane = new JSplitPane(0, this.upPane, this.bottomPane);
        this.mainRightHandSplitPane.setResizeWeight(0.7);
        this.upPane.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> {
            if (this.upPane.getDividerLocation() != this.bottomPane.getDividerLocation()) {
                this.bottomPane.setDividerLocation(this.upPane.getDividerLocation());
            }
        });
        this.bottomPane.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> {
            if (this.upPane.getDividerLocation() != this.bottomPane.getDividerLocation()) {
                this.upPane.setDividerLocation(this.bottomPane.getDividerLocation());
            }
        });
        UpdateSelectedInstances updateSelectedInstances = (list, bl) -> SwingUtilities.invokeLater(() -> {
            this.upPane.setLeftComponent(null);
            this.upPane.setRightComponent(null);
            this.bottomPane.setLeftComponent(null);
            this.bottomPane.setRightComponent(null);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (list.isEmpty()) {
                this.mainPanelSplitPane.setRightComponent(this.instructionsPanel);
            } else {
                this.mainPanelSplitPane.setRightComponent(this.mainRightHandSplitPane);
            }
            if (list.size() >= 1) {
                this.upPane.setLeftComponent(this.getInstancePanel((InstanceObject)list.get(0)));
                this.bottomPane.setLeftComponent(this.getInstancePanel((InstanceObject)list.get(0)).getEntryViewer());
                d3 = 0.0;
                d2 = 0.0;
                d = 0.7;
            }
            if (list.size() >= 2) {
                this.upPane.setRightComponent(this.getInstancePanel((InstanceObject)list.get(1)));
                this.bottomPane.setRightComponent(this.getInstancePanel((InstanceObject)list.get(1)).getEntryViewer());
                d2 = 0.5;
                d = 0.7;
                d3 = 0.5;
            }
            for (InstanceLogTablePanel instanceLogTablePanel : this.instancesPanes) {
                if (!list.contains(instanceLogTablePanel.getInstance())) continue;
                instanceLogTablePanel.fireTableDataChanged();
            }
            this.mainPanelSplitPane.setDividerLocation(0);
            this.mainRightHandSplitPane.setDividerLocation(d);
            this.upPane.setDividerLocation(d2);
            this.bottomPane.setDividerLocation(d3);
        });
        UpdateSelectedInstances updateSelectedInstances2 = (list, bl) -> {
            this.logUpdater = new UpdateLogsSwingWorker(this.currentGrid, updateSelectedInstances, this.type);
            this.logUpdater.setInstancesToUpdate(list);
            this.logUpdater.setUpdate(bl);
            this.logUpdater.execute();
        };
        this.selectInstancesTree = new SelectInstancesTreePanel(this.currentGrid, updateSelectedInstances2);
        this.selectInstancesScroll = new JScrollPane(this.selectInstancesTree);
        this.menuBar = new JMenuBar();
        this.logMenu = new JMenu(Messages.getString("TimesTenGrid.Logs"));
        this.filtersMenu = new JMenuItem(Messages.getString("TimesTenGrid.LogFilter"));
        this.updateLogsMenu = new JMenuItem(Messages.getString("TimesTenGrid.LogRefresh"));
        this.scrollSimult = new JCheckBoxMenuItem(Messages.getString("TimesTenGrid.LogSimultaneousScroll"));
        this.loadLogMenu = new JMenuItem(Messages.getString("TimesTenGrid.LogLoadFromFile"));
        this.columnsMenu = new JMenu(Messages.getString("TimesTenGrid.LogHideShowColumns"));
        this.saveFilteredMenu = new JMenuItem("Save filtered messages");
        this.severityColumnControl = new JCheckBoxMenuItem(Messages.getString("TimesTenGrid.LogSeverity"));
        this.severityColumnControl.setSelected(false);
        this.progColumnControl = new JCheckBoxMenuItem(Messages.getString("TimesTenGrid.LogProgName"));
        this.progColumnControl.setSelected(false);
        this.pidColumnControl = new JCheckBoxMenuItem(Messages.getString("TimesTenGrid.LogPID"));
        this.pidColumnControl.setSelected(false);
        this.columnsShowing = new HashSet<InstanceLogTablePanel.TABLE_COLUMN>();
        this.columnsShowing.add(InstanceLogTablePanel.TABLE_COLUMN.DATE);
        this.columnsShowing.add(InstanceLogTablePanel.TABLE_COLUMN.SEVERITY);
        this.columnsShowing.add(InstanceLogTablePanel.TABLE_COLUMN.MESSAGE);
        this.severityColumnControl.setSelected(true);
        this.columnsMenu.add(this.severityColumnControl);
        this.columnsMenu.add(this.progColumnControl);
        this.columnsMenu.add(this.pidColumnControl);
        for (InstanceObject instanceObject : this.selectInstancesTree.getAllInstances()) {
            InstanceLogTablePanel instanceLogTablePanel = new InstanceLogTablePanel(instanceObject, this.columnsShowing);
            this.instancesPanes.add(instanceLogTablePanel);
            this.instancesPanesScrollModel.add(instanceLogTablePanel.getVerticalScroll().getModel());
        }
        this.severityColumnControl.addActionListener(actionEvent -> this.controlColumn(this.severityColumnControl.isSelected(), InstanceLogTablePanel.TABLE_COLUMN.SEVERITY));
        this.progColumnControl.addActionListener(actionEvent -> this.controlColumn(this.progColumnControl.isSelected(), InstanceLogTablePanel.TABLE_COLUMN.PROGRAM));
        this.pidColumnControl.addActionListener(actionEvent -> this.controlColumn(this.pidColumnControl.isSelected(), InstanceLogTablePanel.TABLE_COLUMN.PID));
        this.loadLogMenu.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
            jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.LogSelectLog"));
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Log File (.log)", "log"));
            jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
            int n = 0;
            n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                InstanceObject instanceObject = new InstanceObject(new HostObject(jFileChooser.getSelectedFile().getName(), null), null);
                instanceObject.setName("(Local)");
                instanceObject.getLog().setLogFile(jFileChooser.getSelectedFile());
                instanceObject.getLog().setLogLoaded(true);
                instanceObject.setAppliedToCurrent(false);
                InstanceLogTablePanel instanceLogTablePanel = new InstanceLogTablePanel(instanceObject, this.columnsShowing);
                this.instancesPanes.add(instanceLogTablePanel);
                this.instancesPanesScrollModel.add(instanceLogTablePanel.getVerticalScroll().getModel());
                this.selectInstancesTree.addLocalLogAsInstanceNode(instanceObject);
                updateSelectedInstances2.update(this.selectInstancesTree.getSelectedInstances(), false);
            }
        });
        this.scrollSimult.addActionListener(actionEvent -> {});
        if (this.filterPanel == null) {
            this.filterPanel = new LogMainFilterPanel();
        }
        this.filterDialog = UIUtils.createPanelDialog((JPanel)this.filterPanel, (String)Messages.getString("TimesTenGrid.LogFilters"), (ActionListener)this.filterPanel);
        this.filterDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.filterDialog.setSize(new Dimension(600, 500));
        this.filterDialog.setButtonMask(2);
        this.filterDialog.setDefaultCloseOperation(1);
        this.filterPanel.getOkBtn().addActionListener(actionEvent -> {
            if (this.filterPanel.isValidFilter()) {
                this.logUpdater = new UpdateLogsSwingWorker(this.currentGrid, updateSelectedInstances, this.type);
                this.logUpdater.setInstancesToUpdate(this.selectInstancesTree.getSelectedInstances());
                this.logUpdater.execute();
                this.filterDialog.setVisible(false);
            } else {
                Common.displayInfoMsg(this, Messages.getString("TimesTenGrid.LogInvalidFilter"), Messages.getString("TimesTenGrid.LogInvalidFilterTitle"));
            }
        });
        this.filterDialog.addCustomButton((Component)this.filterPanel.getOkBtn());
        this.filtersMenu.addActionListener(actionEvent -> {
            this.filterPanel.restoreFilterPanels();
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.filterDialog);
            this.filterDialog.setVisible(true);
        });
        this.updateLogsMenu.addActionListener(actionEvent -> updateSelectedInstances2.update(this.selectInstancesTree.getSelectedInstances(), true));
        this.saveFilteredMenu.addActionListener(actionEvent -> this.showSaveDialog());
        this.logMenu.add(this.filtersMenu);
        this.logMenu.add(this.updateLogsMenu);
        this.logMenu.add(this.columnsMenu);
        this.logMenu.add(this.loadLogMenu);
        this.logMenu.add(this.saveFilteredMenu);
        this.menuBar.add(this.logMenu);
        String string = "ctrlFAction";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("control F"), string);
        this.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent2) {
                FindPanel findPanel = new FindPanel();
                LogInspectorMainWindow.this.findDialog = UIUtils.createPanelDialog((JPanel)findPanel, (String)Messages.getString("TimesTenGrid.LogFind"), (ActionListener)findPanel);
                LogInspectorMainWindow.this.findDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                Dimension dimension = new Dimension(300, 100);
                LogInspectorMainWindow.this.findDialog.setSize(dimension);
                LogInspectorMainWindow.this.findDialog.setMinimumSize(dimension);
                LogInspectorMainWindow.this.findDialog.setMaximumSize(dimension);
                LogInspectorMainWindow.this.findDialog.setPreferredSize(dimension);
                LogInspectorMainWindow.this.findDialog.setButtonMask(0);
                LogInspectorMainWindow.this.findDialog.addCustomButton((Component)findPanel.getFindBtn());
                LogInspectorMainWindow.this.findDialog.setDefaultCloseOperation(2);
                findPanel.getFindBtn().addActionListener(actionEvent -> {
                    for (InstanceObject instanceObject : LogInspectorMainWindow.this.selectInstancesTree.getSelectedInstances()) {
                        InstanceLogTablePanel instanceLogTablePanel = LogInspectorMainWindow.this.getInstancePanel(instanceObject);
                        instanceLogTablePanel.findTextSelectNext(findPanel.getTxtToFind());
                    }
                });
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)LogInspectorMainWindow.this.findDialog);
                LogInspectorMainWindow.this.findDialog.setVisible(true);
                for (InstanceObject instanceObject : LogInspectorMainWindow.this.selectInstancesTree.getSelectedInstances()) {
                    InstanceLogTablePanel instanceLogTablePanel = LogInspectorMainWindow.this.getInstancePanel(instanceObject);
                    instanceLogTablePanel.setResultsLabelMsg("");
                }
            }
        });
        this.mainPanelSplitPane = new JSplitPane(1, this.selectInstancesScroll, this.instructionsPanel);
        this.mainPanelSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.mainPanelSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void controlColumn(boolean bl, InstanceLogTablePanel.TABLE_COLUMN tABLE_COLUMN) {
        if (bl) {
            this.columnsShowing.add(tABLE_COLUMN);
        } else {
            this.columnsShowing.remove((Object)tABLE_COLUMN);
        }
        for (InstanceObject instanceObject : this.selectInstancesTree.getAllInstances()) {
            InstanceLogTablePanel instanceLogTablePanel = this.getInstancePanel(instanceObject);
            instanceLogTablePanel.setColumnsToShow(this.columnsShowing);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void showSaveDialog() {
        for (InstanceObject instanceObject : this.selectInstancesTree.getSelectedInstances()) {
            JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
            jFileChooser.setDialogTitle("Save log to file");
            jFileChooser.setSelectedFile(new File(instanceObject.getFullName() + "_" + this.type.getName() + ".log"));
            if (jFileChooser.showOpenDialog(this) != 0) continue;
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            this.saveLogToFile(instanceObject, jFileChooser.getSelectedFile());
        }
    }

    private void saveLogToFile(final InstanceObject instanceObject, final File file) {
        instanceObject.getLog().readAllPreviousMessages(new Runnable(){

            @Override
            public void run() {
                ListIterator<TTLogEntry> listIterator = instanceObject.getLog().getLogMessages().listIterator(instanceObject.getLog().getLogMessages().size());
                try (PrintWriter printWriter = new PrintWriter(file);){
                    printWriter.println(LogFilter.getFilterObjectInstance().toString());
                    while (listIterator.hasPrevious()) {
                        printWriter.println(listIterator.previous());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.warning("Could not write to:" + file.getAbsolutePath());
                }
            }
        });
    }

    private InstanceLogTablePanel getInstancePanel(InstanceObject instanceObject) {
        for (InstanceLogTablePanel instanceLogTablePanel : this.instancesPanes) {
            if (instanceLogTablePanel.getInstance() != instanceObject) continue;
            return instanceLogTablePanel;
        }
        return null;
    }

    public static enum LogViewerType {
        MSG("ttmesg"),
        ERROR("tterrors");

        String logName;

        private LogViewerType(String string2) {
            this.logName = string2;
        }

        public String getName() {
            return this.logName;
        }
    }

    static interface UpdateSelectedInstances {
        public void update(List<InstanceObject> var1, boolean var2);
    }

    private static class FindPanel
    extends JPanel
    implements ActionListener {
        private JLabel findLbl;
        private JTextField findTxt;
        private JButton findBtn;

        public FindPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.findLbl = new JLabel(Messages.getString("TimesTenGrid.LogTextToFind"));
            this.findTxt = new JTextField(20);
            this.findTxt.setMinimumSize(this.findTxt.getPreferredSize());
            this.findBtn = new JButton(Messages.getString("TimesTenGrid.LogFind"));
            this.findTxt.addActionListener(actionEvent -> {
                for (ActionListener actionListener : this.findBtn.getActionListeners()) {
                    actionListener.actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.findLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.findTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public JButton getFindBtn() {
            return this.findBtn;
        }

        public String getTxtToFind() {
            return this.findTxt.getText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

