/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.instance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.navigator.NodeFilterPanel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ExecuteCommandPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private JTextField inputField;
    private JButton executeButton;
    private JButton stopButton;
    private JButton closeButton;
    private JButton clearAllButton;
    private GridObject currentGrid;
    private JEWTDialog parentDialog;
    private JScrollPane _scrollSelect;
    private SelectObjectsPanel _selectObjectsPanel;
    private GridCommand cmd;
    private static int fontSize = 12;
    private static final int maxCommandsInHist = 2;
    private static final Logger logger = Logger.getLogger(ExecuteCommandPanel.class.getName());
    private ArrayList<String> commandHistory;
    private int pos;
    private RaptorTask<Void> task;
    private JTabbedPane outputPanesTab;
    private List<CommandOutputPane> objectsOutputPane;
    private List<Executable> selectedObjects;
    private List<Executable> allObjects;
    private static final int MAX_TABS_SHOWING = 4;
    private JLabel runCmd;
    private JPanel instructionsPanel;
    private ExecuteCommandPanel thisPanel;
    private JButton saveAllButton;
    private boolean commandRunning;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public ExecuteCommandPanel(InstanceObject instanceObject, GridObject gridObject) {
        this.currentGrid = gridObject;
        this.commandHistory = new ArrayList(2);
        this.initGUI(Arrays.asList(instanceObject));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.INST_EXECUTE_CMD.toString());
    }

    public ExecuteCommandPanel(HostObject hostObject, GridObject gridObject) {
        this.currentGrid = gridObject;
        this.commandHistory = new ArrayList(2);
        this.initGUI(Arrays.asList(hostObject));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.HOST_EXECUTE_CMD.toString());
    }

    public ExecuteCommandPanel(GridObject gridObject) {
        this.currentGrid = gridObject;
        this.commandHistory = new ArrayList(2);
        ArrayList arrayList = new ArrayList();
        gridObject.getHosts().forEach(hostObject -> arrayList.addAll(hostObject.getInstances()));
        this.initGUI(arrayList);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.GRID_EXECUTE_CMD.toString());
    }

    private void initGUI(List<? extends Executable> list) {
        this.setLayout(new GridBagLayout());
        this.commandRunning = false;
        this.thisPanel = this;
        this.outputPanesTab = new JTabbedPane();
        this.instructionsPanel = new JPanel(new GridBagLayout());
        this.instructionsPanel.add((Component)new JLabel(Messages.getString("TimestenGrid.SelectInstancesInstructions1")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 20, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.instructionsPanel.add((Component)new JLabel(Messages.getString("TimestenGrid.SelectInstancesInstructions2")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 19, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.objectsOutputPane = new ArrayList<CommandOutputPane>();
        this.allObjects = new ArrayList<Executable>();
        if (list.get(0) instanceof InstanceObject) {
            this.currentGrid.getHosts().forEach(hostObject -> this.allObjects.addAll(hostObject.getInstances()));
        } else if (list.get(0) instanceof HostObject) {
            this.allObjects.addAll(this.currentGrid.getHosts());
        }
        this.allObjects.forEach(executable -> {
            if (executable.isAvailableForExec()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
                jMenuItem.setText(Messages.getString("TimesTenGrid.copy"));
                jPopupMenu.add(jMenuItem);
                JTextPane jTextPane = ExecuteCommandPanel.createEditorPane();
                jTextPane.setComponentPopupMenu(jPopupMenu);
                CommandOutputPane commandOutputPane = new CommandOutputPane(jTextPane, (Executable)executable);
                this.objectsOutputPane.add(commandOutputPane);
            }
        });
        this.inputField = new JTextField();
        this.executeButton = new JButton(Messages.getString("TimesTenGrid.executeCommand"));
        this.executeButton.addActionListener(this);
        this.stopButton = new JButton(Messages.getString("TimesTenGrid.stopCMD"));
        this.stopButton.addActionListener(this);
        this.closeButton = new JButton(Messages.getString("TimesTenGrid.Close"));
        this.closeButton.addActionListener(this);
        this.clearAllButton = new JButton(Messages.getString("TimesTenGrid.clearAll"));
        this.clearAllButton.addActionListener(this);
        this.saveAllButton = new JButton(Messages.getString("TimesTenGrid.saveAll"));
        this.saveAllButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        this.selectedObjects = list.stream().filter(executable -> executable.isAvailableForExec()).limit(4L).collect(Collectors.toList());
        this._selectObjectsPanel = new SelectObjectsPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.ShowDSG"));
        jCheckBox.setSelected(false);
        jCheckBox.addActionListener(actionEvent -> this._selectObjectsPanel.showDSGsFolders(jCheckBox.isSelected()));
        jPanel.add((Component)this._selectObjectsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._scrollSelect = new JScrollPane(jPanel);
        this.runCmd = new JLabel(Messages.getString("TimesTenGrid.runCmd"));
        this._selectObjectsPanel.setSelectedObjectsOutputPanes();
        this.inputField.addActionListener(this);
        this.inputField.addKeyListener(this);
        this.inputField.setActionCommand(Messages.getString("TimesTenGrid.executeCommand"));
        this.outputPanesTab.setTabLayoutPolicy(1);
        this.outputPanesTab.setPreferredSize(this.outputPanesTab.getPreferredSize());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.runCmd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 20, 2, new Insets(15, 10, 4, 0), 0, 0));
        jPanel2.add((Component)this.inputField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 20, 2, new Insets(17, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this.stopButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 20, 2, new Insets(17, 5, 0, 10), 0, 0));
        jPanel2.add((Component)this.outputPanesTab, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this._scrollSelect);
        jSplitPane.setRightComponent(jPanel2);
        jSplitPane.setOneTouchExpandable(true);
        this.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 20, 1, new Insets(15, 10, 4, 0), 0, 0));
        this.setNames();
    }

    private static JTextPane createEditorPane() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setAutoscrolls(true);
        jTextPane.setEditable(false);
        jTextPane.setText("");
        Style style = jTextPane.addStyle("Bold", null);
        StyleConstants.setBold(style, true);
        StyleConstants.setFontSize(style, fontSize);
        StyleConstants.setFontFamily(style, "monospaced");
        style = jTextPane.addStyle("Regular", null);
        StyleConstants.setFontSize(style, fontSize);
        StyleConstants.setFontFamily(style, "monospaced");
        style = jTextPane.addStyle("Red", null);
        StyleConstants.setForeground(style, Color.RED);
        StyleConstants.setFontSize(style, fontSize);
        StyleConstants.setFontFamily(style, "monospaced");
        return jTextPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.executeButton || actionEvent.getActionCommand().equalsIgnoreCase(Messages.getString("TimesTenGrid.executeCommand"))) {
            if (this.inputField.getText().isEmpty()) {
                return;
            }
            this.commandRunning = true;
            this.commandHistory.add(this.inputField.getText());
            this.pos = this.commandHistory.size() - 1;
            if (this.inputField.getText().equalsIgnoreCase("clear")) {
                this.inputField.setText("");
                this.objectsOutputPane.forEach(commandOutputPane -> commandOutputPane.clearOutput());
                this.commandRunning = false;
            } else {
                this.executeButton.setEnabled(false);
                this.inputField.setEditable(false);
                this.stopButton.setEnabled(true);
                this.cmd = GridCommand.CUSTOM_COMMAND;
                this.cmd.prepareCommand(this.inputField.getText());
                this.objectsOutputPane.forEach(commandOutputPane -> {
                    if (this.selectedObjects.contains(commandOutputPane.getObject())) {
                        commandOutputPane.setCommand(this.inputField.getText());
                    }
                });
                this.inputField.setText("");
                this.execute(this.cmd);
            }
        } else if (actionEvent.getSource() == this.stopButton) {
            RaptorTaskManager.getInstance().cancelTask(this.task);
            this.executeButton.setEnabled(true);
            this.inputField.setEditable(true);
            this.stopButton.setEnabled(false);
            this.objectsOutputPane.forEach(commandOutputPane -> {
                if (this.selectedObjects.contains(commandOutputPane.getObject())) {
                    commandOutputPane.setErrMsg(Messages.getString("TimesTenGrid.stopCMDMsg"));
                }
            });
        } else if (actionEvent.getSource() == this.clearAllButton) {
            this.inputField.setText("");
            this.objectsOutputPane.forEach(commandOutputPane -> commandOutputPane.clearOutput());
        } else if (actionEvent.getSource() == this.saveAllButton) {
            this.saveOutputToSingleFileAction();
        } else if (actionEvent.getSource() == this.closeButton) {
            if (this.commandRunning) {
                if (MessageDialog.confirm((Component)this, (Object)Messages.getString("TimesTenGrid.ExecExitWarning"), (String)Messages.getString("TimesTenGrid.ExecExitTitle"), null)) {
                    RaptorTaskManager.getInstance().cancelTask(this.task);
                    this.parentDialog.dispose();
                }
            } else {
                this.parentDialog.dispose();
            }
        }
    }

    private void execute(final GridCommand gridCommand) {
        this.task = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                try {
                    ArrayList<GridCommandExecutor.ExecOutput> arrayList = ExecuteCommandPanel.this.currentGrid.getExecutor().execCommand(ExecuteCommandPanel.this.selectedObjects, gridCommand, false, GridCommand.ExecMode.DATA);
                    for (GridCommandExecutor.ExecOutput execOutput : arrayList) {
                        for (CommandOutputPane commandOutputPane : ExecuteCommandPanel.this.objectsOutputPane) {
                            if (!execOutput.getObject().isSameObject(commandOutputPane.getObject())) continue;
                            commandOutputPane.setOutput(execOutput);
                        }
                    }
                }
                catch (GridCommandException gridCommandException) {
                    logger.log(Level.SEVERE, gridCommandException.getMessage());
                }
                finally {
                    ExecuteCommandPanel.this.commandRunning = false;
                    SwingUtilities.invokeLater(() -> {
                        ExecuteCommandPanel.this.executeButton.setEnabled(true);
                        ExecuteCommandPanel.this.inputField.setEditable(true);
                        ExecuteCommandPanel.this.stopButton.setEnabled(false);
                    });
                }
                return null;
            }

            public boolean cancel() {
                ExecuteCommandPanel.this.currentGrid.getExecutor().stopCurrentExecution();
                return super.cancel();
            }
        };
        RaptorTaskManager.getInstance().addTask(this.task);
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this.parentDialog = jEWTDialog;
        this.parentDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ExecuteCommandPanel.this.task != null) {
                    RaptorTaskManager.getInstance().cancelTask(ExecuteCommandPanel.this.task);
                }
                super.windowClosing(windowEvent);
            }
        });
        jEWTDialog.setMinimumSize(600, 400);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            if (!this.commandHistory.isEmpty()) {
                int n;
                if (this.pos > 0) {
                    int n2 = this.pos;
                    n = n2;
                    this.pos = n2 - 1;
                } else {
                    n = 0;
                }
                this.inputField.setText(this.commandHistory.get(n));
            }
        } else if (keyEvent.getKeyCode() == 40 && !this.commandHistory.isEmpty()) {
            int n;
            if (this.pos < this.commandHistory.size() - 1) {
                int n3 = this.pos;
                n = n3;
                this.pos = n3 + 1;
            } else {
                n = this.commandHistory.size() - 1;
            }
            this.inputField.setText(this.commandHistory.get(n));
        }
    }

    public JButton getClearAllButton() {
        return this.clearAllButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getSaveAllButton() {
        return this.saveAllButton;
    }

    public JButton getExecuteButton() {
        return this.executeButton;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    private void saveOutputToSingleFileAction() {
        String string = "output.txt";
        JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(Messages.getString("IndexAdvisor.saveStatistics"));
        int n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            try {
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println("*****Commands execute on GRID " + this.currentGrid.getName() + "*****");
                for (CommandOutputPane commandOutputPane : this.objectsOutputPane) {
                    if (!this.selectedObjects.contains(commandOutputPane.getObject())) continue;
                    printWriter.println("*****" + commandOutputPane.getObject().getTargetName() + "*****");
                    printWriter.println(commandOutputPane.getOutputPaneText());
                }
                printWriter.close();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
        }
    }

    private void setNames() {
        this.inputField.setName("inputField");
        this.executeButton.setName(Messages.getString("TimesTenGrid.executeCommand"));
        this.stopButton.setName(Messages.getString("TimesTenGrid.stopCMD"));
        this.closeButton.setName(Messages.getString("TimesTenGrid.Close"));
        this.clearAllButton.setName(Messages.getString("TimesTenGrid.clearAll"));
        this.runCmd.setName(Messages.getString("TimesTenGrid.clearAll"));
        this.saveAllButton.setName(Messages.getString("TimesTenGrid.runCmd"));
    }

    private final class SelectObjectsPanel
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private JTree _objectsTree;
        private JScrollPane _treeScrollPane;
        private IconNode root = null;
        private IconNode includedFolderNode = null;
        private IconNode excludedFolderNode = null;
        private DefaultTreeModel _model;
        private JPopupMenu popup;
        private JMenuItem moveMenu;
        private JMenuItem filterMenu;
        private JPopupMenu filterPopup;
        private ArrayList<IconNode> dsgSelectedFolder;
        private ArrayList<IconNode> dsgAvailableFolder;
        private boolean showDSGsFolders;
        private String filterTxt;
        private LogFilter.FilterMode filterMode;
        private int unassignedIndex;

        public SelectObjectsPanel() {
            this.initGUI();
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            this.unassignedIndex = ExecuteCommandPanel.this.currentGrid.getProperties().getK();
            this.filterTxt = "%";
            this.filterMode = LogFilter.FilterMode.LIKE;
            this.popup = new JPopupMenu();
            this.moveMenu = new JMenuItem(Messages.getString("TimesTenGrid.Move"));
            this.popup.add(this.moveMenu);
            this.filterPopup = new JPopupMenu();
            this.filterMenu = new JMenuItem(Messages.getString("TimesTenGrid.LogFilter"));
            this.filterPopup.add(this.filterMenu);
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("TimesTenGrid.clear"));
            this.filterPopup.add(jMenuItem);
            this.showDSGsFolders = false;
            this.dsgAvailableFolder = new ArrayList();
            this.dsgSelectedFolder = new ArrayList();
            this.filterMenu.addActionListener(actionEvent -> this.launchNodeFilter());
            jMenuItem.addActionListener(actionEvent -> {
                this.excludedFolderNode.setName(Messages.getString("TimesTenGrid.Available"));
                this.filterTxt = "%";
                this.filterMode = LogFilter.FilterMode.LIKE;
                this.reloadNodes();
            });
            this.moveMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block0: for (int n : SelectObjectsPanel.this._objectsTree.getSelectionRows()) {
                        boolean bl;
                        IconNode iconNode = (IconNode)SelectObjectsPanel.this._objectsTree.getPathForRow(n).getLastPathComponent();
                        if (SelectObjectsPanel.this.showDSGsFolders) {
                            bl = (IconNode)SelectObjectsPanel.this._objectsTree.getPathForRow(n).getParentPath().getParentPath().getLastPathComponent() == SelectObjectsPanel.this.includedFolderNode;
                        } else {
                            boolean bl2 = bl = (IconNode)SelectObjectsPanel.this._objectsTree.getPathForRow(n).getParentPath().getLastPathComponent() == SelectObjectsPanel.this.includedFolderNode;
                        }
                        if (bl) {
                            for (Executable executable : ExecuteCommandPanel.this.allObjects) {
                                if (!executable.getTargetName().equalsIgnoreCase(iconNode.getName())) continue;
                                ExecuteCommandPanel.this.selectedObjects.remove(executable);
                                if (SelectObjectsPanel.this.showDSGsFolders) {
                                    SelectObjectsPanel.this.dsgSelectedFolder.get(executable.getDSG() == 0 ? SelectObjectsPanel.this.unassignedIndex : executable.getDSG() - 1).remove(iconNode);
                                    if (!SelectObjectsPanel.this.matches(executable.getTargetName())) continue block0;
                                    SelectObjectsPanel.this.dsgAvailableFolder.get(executable.getDSG() == 0 ? SelectObjectsPanel.this.unassignedIndex : executable.getDSG() - 1).add(iconNode);
                                    continue block0;
                                }
                                SelectObjectsPanel.this.includedFolderNode.remove(iconNode);
                                if (!SelectObjectsPanel.this.matches(executable.getTargetName())) continue block0;
                                SelectObjectsPanel.this.excludedFolderNode.add(iconNode);
                                continue block0;
                            }
                            continue;
                        }
                        for (Executable executable : ExecuteCommandPanel.this.allObjects) {
                            if (!executable.getTargetName().equalsIgnoreCase(iconNode.getName())) continue;
                            ExecuteCommandPanel.this.selectedObjects.add(executable);
                            if (SelectObjectsPanel.this.showDSGsFolders) {
                                SelectObjectsPanel.this.dsgAvailableFolder.get(executable.getDSG() == 0 ? SelectObjectsPanel.this.unassignedIndex : executable.getDSG() - 1).remove(iconNode);
                                SelectObjectsPanel.this.dsgSelectedFolder.get(executable.getDSG() == 0 ? SelectObjectsPanel.this.unassignedIndex : executable.getDSG() - 1).add(iconNode);
                                continue block0;
                            }
                            SelectObjectsPanel.this.excludedFolderNode.remove(iconNode);
                            SelectObjectsPanel.this.includedFolderNode.add(iconNode);
                            continue block0;
                        }
                    }
                    SelectObjectsPanel.this._model.reload();
                    SelectObjectsPanel.this.setSelectedObjectsOutputPanes();
                    SelectObjectsPanel.this.expandTree();
                }
            });
            String string = null;
            if (ExecuteCommandPanel.this.allObjects.get(0) instanceof InstanceObject) {
                string = Messages.getString("TimesTenGrid.instances");
            } else if (ExecuteCommandPanel.this.allObjects.get(0) instanceof HostObject) {
                string = Messages.getString("TimesTenGrid.hosts");
            }
            this.root = new IconNode(string, true, OracleIcons.getIcon((String)"folder.png"));
            this.includedFolderNode = new IconNode(Messages.getString("TimesTenGrid.executeOn"), true, OracleIcons.getIcon((String)"folder.png"));
            this.excludedFolderNode = new IconNode(Messages.getString("TimesTenGrid.Available"), true, OracleIcons.getIcon((String)"folder.png"));
            this._model = new DefaultTreeModel(this.root);
            this.root.add(this.includedFolderNode);
            this.root.add(this.excludedFolderNode);
            for (int i = 0; i < ExecuteCommandPanel.this.currentGrid.getProperties().getK(); ++i) {
                String object = MessageFormat.format(Messages.getString("TimesTenGrid.dsg"), i + 1);
                this.dsgAvailableFolder.add(new IconNode(object, true, OracleIcons.getIcon((String)"folder.png")));
                this.dsgSelectedFolder.add(new IconNode(object, true, OracleIcons.getIcon((String)"folder.png")));
            }
            this.dsgAvailableFolder.add(new IconNode(Messages.getString("TimesTenGrid.unassignedHosts"), true, OracleIcons.getIcon((String)"folder.png")));
            this.dsgSelectedFolder.add(new IconNode(Messages.getString("TimesTenGrid.unassignedHosts"), true, OracleIcons.getIcon((String)"folder.png")));
            this._objectsTree = new JTree(this._model){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                        return null;
                    }
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).toString();
                }
            };
            this._objectsTree.setToolTipText("");
            this._objectsTree.getSelectionModel().setSelectionMode(4);
            for (Executable executable : ExecuteCommandPanel.this.allObjects) {
                if (!executable.isAvailableForExec()) continue;
                IconNode iconNode = new IconNode(executable.getTargetName(), false, OracleIcons.getIcon((String)"laptop.png"));
                if (ExecuteCommandPanel.this.selectedObjects.contains(executable)) {
                    this.includedFolderNode.add(iconNode);
                    continue;
                }
                this.excludedFolderNode.add(iconNode);
            }
            this.expandTree();
            this._objectsTree.setCellRenderer(new IconNodeRenderer());
            this._objectsTree.addMouseListener(this);
            this._treeScrollPane = new JScrollPane(this._objectsTree);
            this.add((Component)this._treeScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 19, 1, new Insets(5, 5, 5, 5), 20, 20));
        }

        public void showDSGsFolders(boolean bl) {
            this.showDSGsFolders = bl;
            this.reloadNodes();
        }

        private void setSelectedObjectsOutputPanes() {
            ExecuteCommandPanel.this.outputPanesTab.removeAll();
            for (Executable executable : ExecuteCommandPanel.this.selectedObjects) {
                for (CommandOutputPane commandOutputPane : ExecuteCommandPanel.this.objectsOutputPane) {
                    if (!commandOutputPane.getObject().isSameObject(executable)) continue;
                    ExecuteCommandPanel.this.outputPanesTab.add(executable.getTargetName(), commandOutputPane.getContentPane());
                }
            }
            if (ExecuteCommandPanel.this.selectedObjects.isEmpty()) {
                ExecuteCommandPanel.this.outputPanesTab.add(ExecuteCommandPanel.this.instructionsPanel);
            }
        }

        private void expandTree() {
            for (int i = 0; i < this._objectsTree.getRowCount(); ++i) {
                this._objectsTree.expandRow(i);
            }
        }

        private boolean matches(String string) {
            Pattern pattern;
            String string2 = null;
            boolean bl = false;
            switch (this.filterMode) {
                case EQUAL: 
                case REGEX: {
                    string2 = this.filterTxt;
                    break;
                }
                case NOT_LIKE: {
                    string2 = this.filterTxt.replace("%", ".*").replace("_", ".{1}");
                    bl = true;
                    break;
                }
                case LIKE: {
                    string2 = this.filterTxt.replace("%", ".*").replace("_", ".{1}");
                    break;
                }
                case NOT_EQUAL: {
                    string2 = this.filterTxt;
                    bl = true;
                }
            }
            try {
                pattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return true;
            }
            if (!bl) {
                return pattern.matcher(string).matches();
            }
            return !pattern.matcher(string).matches();
        }

        private void launchNodeFilter() {
            NodeFilterPanel nodeFilterPanel = new NodeFilterPanel(ExecuteCommandPanel.this.currentGrid);
            nodeFilterPanel.setFilterInfo(this.filterTxt, this.filterMode);
            Dimension dimension = new Dimension(350, 100);
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)nodeFilterPanel, (String)Messages.getString("TimesTenGrid.LogFilter"), null);
            nodeFilterPanel.setDialog(jEWTDialog);
            jEWTDialog.setButtonMask(7);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setMaximumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.setVisible(true);
            if (jEWTDialog.isOked()) {
                if (this.filterTxt.isEmpty()) {
                    this.excludedFolderNode.setName(Messages.getString("TimesTenGrid.Available"));
                    this.filterTxt = "%";
                    this.filterMode = LogFilter.FilterMode.REGEX;
                } else {
                    this.excludedFolderNode.setName(Messages.getString("TimesTenGrid.AvailableFiltered"));
                    this.filterTxt = nodeFilterPanel.getFilterTxt();
                    this.filterMode = nodeFilterPanel.getFilterType();
                }
                this.reloadNodes();
            }
        }

        private void reloadNodes() {
            this.includedFolderNode.removeAllChildren();
            this.excludedFolderNode.removeAllChildren();
            for (int i = 0; i < ExecuteCommandPanel.this.currentGrid.getProperties().getK() + 1; ++i) {
                this.dsgAvailableFolder.get(i).removeAllChildren();
                this.dsgSelectedFolder.get(i).removeAllChildren();
            }
            for (Executable executable : ExecuteCommandPanel.this.allObjects) {
                if (!executable.isAvailableForExec()) continue;
                IconNode iconNode = new IconNode(executable.getTargetName(), false, OracleIcons.getIcon((String)"laptop.png"));
                if (ExecuteCommandPanel.this.selectedObjects.contains(executable)) {
                    if (this.showDSGsFolders) {
                        this.dsgSelectedFolder.get(executable.getDSG() == 0 ? this.unassignedIndex : executable.getDSG() - 1).add(iconNode);
                        continue;
                    }
                    this.includedFolderNode.add(iconNode);
                    continue;
                }
                if (!this.matches(executable.getTargetName())) continue;
                if (this.showDSGsFolders) {
                    this.dsgAvailableFolder.get(executable.getDSG() == 0 ? this.unassignedIndex : executable.getDSG() - 1).add(iconNode);
                    continue;
                }
                this.excludedFolderNode.add(iconNode);
            }
            if (this.showDSGsFolders) {
                for (int i = 0; i < ExecuteCommandPanel.this.currentGrid.getProperties().getK() + 1; ++i) {
                    this.includedFolderNode.add(this.dsgSelectedFolder.get(i));
                    this.excludedFolderNode.add(this.dsgAvailableFolder.get(i));
                }
            }
            this._model.reload();
            this.expandTree();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2;
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n3;
                int n4 = mouseEvent.getX();
                IconNode iconNode = (IconNode)this._objectsTree.getPathForLocation(n4, n3 = mouseEvent.getY()).getLastPathComponent();
                if (iconNode != this.root && iconNode != this.includedFolderNode && !this.dsgAvailableFolder.contains(iconNode) && !this.dsgSelectedFolder.contains(iconNode)) {
                    if (iconNode == this.excludedFolderNode) {
                        this.filterPopup.show(this._objectsTree, n4, n3);
                    } else {
                        this.popup.show(this._objectsTree, n4, n3);
                    }
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._objectsTree.getPathForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY()) != null) {
                IconNode iconNode = (IconNode)this._objectsTree.getPathForLocation(n2, n).getLastPathComponent();
                for (int i = 0; i < ExecuteCommandPanel.this.outputPanesTab.getTabCount(); ++i) {
                    if (!ExecuteCommandPanel.this.outputPanesTab.getTitleAt(i).equalsIgnoreCase(iconNode.getName())) continue;
                    ExecuteCommandPanel.this.outputPanesTab.setSelectedIndex(i);
                    return;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private class IconNode
        extends DefaultMutableTreeNode {
            private Icon icon;
            private String name;

            public IconNode(Object object, boolean bl, Icon icon) {
                super(object, bl);
                this.icon = icon;
                this.name = object.toString();
            }

            public Icon getIcon() {
                return this.icon;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String string) {
                this.name = string;
            }
        }

        private class IconNodeRenderer
        extends DefaultTreeCellRenderer {
            private IconNodeRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                this.setIcon(((IconNode)object).getIcon());
                this.setText(((IconNode)object).getName());
                return this;
            }
        }
    }

    private static class CommandOutputPane
    extends JFrame {
        private Executable object;
        private JTextPane outputPane;
        private JScrollPane scrollPane;
        private JButton clearButton;
        private JButton saveButton;

        public CommandOutputPane(JTextPane jTextPane, Executable executable) {
            this.outputPane = jTextPane;
            this.object = executable;
            this.initGUI();
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            this.scrollPane = new JScrollPane(this.outputPane);
            this.clearButton = new JButton(Messages.getString("TimesTenGrid.clear"));
            this.saveButton = new JButton(Messages.getString("IndexAdvisor.saveStatistics"));
            this.clearButton.addActionListener(actionEvent -> this.clearOutput());
            this.saveButton.addActionListener(actionEvent -> this.saveOutputToFileAction());
            this.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.saveButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.clearButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        public void setOutput(GridCommandExecutor.ExecOutput execOutput) {
            SwingUtilities.invokeLater(() -> {
                try {
                    StyledDocument styledDocument = this.outputPane.getStyledDocument();
                    if (execOutput.getExitCode() == 0) {
                        styledDocument.insertString(styledDocument.getLength(), execOutput.getOutput(), styledDocument.getStyle("Regular"));
                        if (execOutput.hasError()) {
                            this.setErrMsg(execOutput.getError());
                        }
                    } else {
                        styledDocument.insertString(styledDocument.getLength(), execOutput.getOutput(), styledDocument.getStyle("Red"));
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.log(Level.SEVERE, badLocationException.getMessage());
                }
            });
        }

        public Executable getObject() {
            return this.object;
        }

        public void setErrMsg(String string) {
            try {
                StyledDocument styledDocument = this.outputPane.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), string, styledDocument.getStyle("Red"));
                styledDocument.insertString(styledDocument.getLength(), LINE_SEPARATOR, null);
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage());
            }
        }

        public void setCommand(String string) {
            try {
                StyledDocument styledDocument = this.outputPane.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), "$" + string, styledDocument.getStyle("Bold"));
                styledDocument.insertString(styledDocument.getLength(), LINE_SEPARATOR, null);
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage());
            }
        }

        public void clearOutput() {
            try {
                StyledDocument styledDocument = this.outputPane.getStyledDocument();
                this.outputPane.getDocument().remove(0, styledDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage());
            }
        }

        public String getOutputPaneText() {
            return this.outputPane.getText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveOutputToFileAction() {
            File file = new File(this.getObject().getTargetName() + "_output.txt");
            JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle(Messages.getString("IndexAdvisor.saveStatistics"));
            int n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                try (PrintWriter printWriter = null;){
                    file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
                    printWriter = new PrintWriter(file);
                    printWriter.println(this.getOutputPaneText());
                }
            }
        }
    }
}

