/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import oracle.dbtools.raptor.timesten.Messages;

public abstract class DBDefAttribute<T> {
    protected String attributeName;
    private String definition;
    private DBDefAttributeType attributeType;
    private boolean mandatory;
    protected T value;
    protected T defaultValue;

    public DBDefAttribute(String string, String string2, DBDefAttributeType dBDefAttributeType, boolean bl) {
        this.attributeName = string;
        this.definition = string2;
        this.attributeType = dBDefAttributeType;
        this.mandatory = bl;
    }

    public DBDefAttribute(DBDefAttribute dBDefAttribute) {
        this.attributeName = dBDefAttribute.getAttribute();
        this.definition = dBDefAttribute.getDefinition();
        this.attributeType = dBDefAttribute.getAttributeType();
        this.mandatory = dBDefAttribute.isMandatory();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public DBDefAttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setAttributeType(DBDefAttributeType dBDefAttributeType) {
        this.attributeType = dBDefAttributeType;
    }

    public String getAttribute() {
        return this.attributeName;
    }

    public void setAttribute(String string) {
        this.attributeName = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String toString() {
        return this.getAttribute();
    }

    public void setValueToDefault() {
        this.value = this.defaultValue;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    public abstract void setValueFromString(String var1);

    public abstract String getValueAsString();

    public abstract boolean isValid();

    public abstract String getErrorMessage();

    public abstract String getDBDefValue();

    public boolean isSameAttribute(DBDefAttribute dBDefAttribute) {
        return this.getAttribute().equalsIgnoreCase(dBDefAttribute.getAttribute());
    }

    public boolean equals(DBDefAttribute dBDefAttribute) {
        return this.isSameAttribute(dBDefAttribute) && this.getValueAsString().equalsIgnoreCase(dBDefAttribute.getValueAsString());
    }

    public boolean isPasswordAttribute() {
        return DBDefAttribute.isPasswordAttribute(this.attributeName);
    }

    public static boolean isPasswordAttribute(String string) {
        return (string = string.toLowerCase()).contains("pwd") || string.contains("password");
    }

    public static enum DBDefAttributeType {
        DATASTORE("database", Messages.getString("TimesTenGrid.datastoreAttribute")),
        FIRST_CONNECTION("firstconnection", Messages.getString("TimesTenGrid.firstConnectionAttribute")),
        GENERAL_CONNECTION("generalconnection", Messages.getString("TimesTenGrid.generalConnectionAttribute")),
        CUSTOM("custom", Messages.getString("TimesTenGrid.customAttribute"));

        private String jsonName;
        private String showName;

        private DBDefAttributeType(String string2, String string3) {
            this.jsonName = string2;
            this.showName = string3;
        }

        public String getJsonName() {
            return this.jsonName;
        }

        public String getShowName() {
            return this.showName;
        }

        public String toString() {
            return this.showName;
        }

        public static DBDefAttributeType fromString(String string) {
            if (string != null) {
                for (DBDefAttributeType dBDefAttributeType : DBDefAttributeType.values()) {
                    if (!string.equalsIgnoreCase(dBDefAttributeType.getJsonName())) continue;
                    return dBDefAttributeType;
                }
            }
            return null;
        }

        public static String[] getNames() {
            String[] stringArray = new String[DBDefAttributeType.values().length];
            int n = 0;
            for (DBDefAttributeType dBDefAttributeType : DBDefAttributeType.values()) {
                stringArray[n++] = dBDefAttributeType.getShowName();
            }
            return stringArray;
        }
    }
}

