/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.SelectPhysicalGroupsPanel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class NewStandaloneHostPanel
extends TTGUIBasePanel {
    private JLabel _nameLabel;
    private JLabel _internalAddrLabel;
    private JLabel _externalAddrLabel;
    private JLabel _dsgLabel;
    private JLabel _PGsLabel;
    private JLabel _PGsSelected;
    private JButton _selectPGsButton;
    private AutoCompleteComponent _nameTxtField;
    private AutoCompleteComponent _internalAddrTxtField;
    private AutoCompleteComponent _externalAddrTxtField;
    private JComboBox<String> _dsgComboBox;
    private boolean isStandAlone;
    private JCheckBox _useDefaultCheckBox;
    private String hostName = null;
    private HostObject host;
    static final String CONFIRMATION_ID = "NewHostConfirmation";
    private static Logger _logger = Logger.getLogger(NewStandaloneHostPanel.class.getPackage().getName());
    private SelectPhysicalGroupsPanel selectPGPanel;

    public NewStandaloneHostPanel() {
        this.initGUI(this.grid.getProperties().getK());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.NEW_HOST.toString());
        this.isStandAlone = true;
    }

    public NewStandaloneHostPanel(int n) {
        this.initGUI(n);
        this.isStandAlone = true;
    }

    private void initGUI(int n) {
        this.host = new HostObject();
        this._internalAddrTxtField = new AutoCompleteComponent(15, HostObject.getHostInternalAddressSuggestions());
        this._nameTxtField = new AutoCompleteComponent(15, HostObject.getHostNameSuggestions());
        this._externalAddrTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._dsgComboBox = Common.getDSGComboBox(n);
        this._dsgComboBox.setSelectedIndex(0);
        this._internalAddrLabel = new JLabel(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._externalAddrLabel = new JLabel(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._dsgLabel = new JLabel(Messages.getString("TimesTenGrid.DSGLabel"));
        this._PGsLabel = new JLabel(Messages.getString("TimesTenGrid.physicalGroups2"));
        this._PGsSelected = new JLabel(this.host.getPhysicalGroupsString());
        this._selectPGsButton = new JButton(Messages.getString("TimesTenGrid.selectButton"));
        this._nameLabel = new JLabel(Messages.getString("TimesTenGrid.hostNameColumn"));
        this._useDefaultCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.useDefault"));
        this._internalAddrLabel.setLabelFor(this._internalAddrTxtField);
        this._externalAddrLabel.setLabelFor(this._externalAddrTxtField);
        this._nameLabel.setLabelFor(this._nameTxtField);
        this._dsgLabel.setLabelFor(this._dsgComboBox);
        this._selectPGsButton.addActionListener(actionEvent -> this.showSelectPGSDialog(this.host));
        this._nameTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (NewStandaloneHostPanel.this._internalAddrTxtField.getText().isEmpty()) {
                    NewStandaloneHostPanel.this._internalAddrTxtField.setText(NewStandaloneHostPanel.this._nameTxtField.getText());
                }
                if (NewStandaloneHostPanel.this._externalAddrTxtField.getText().isEmpty()) {
                    NewStandaloneHostPanel.this._externalAddrTxtField.setText(NewStandaloneHostPanel.this._nameTxtField.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this._internalAddrTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewStandaloneHostPanel.this._externalAddrTxtField.setText(NewStandaloneHostPanel.this._internalAddrTxtField.getText());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._nameTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._useDefaultCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._internalAddrLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._internalAddrTxtField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._externalAddrLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._externalAddrTxtField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._dsgLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add(this._dsgComboBox, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._PGsLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._PGsSelected, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._selectPGsButton, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._useDefaultCheckBox.addChangeListener(changeEvent -> this._nameTxtField.setEnabled(!this._useDefaultCheckBox.isSelected()));
        this._useDefaultCheckBox.setSelected(false);
        this._useDefaultCheckBox.setEnabled(true);
        this._useDefaultCheckBox.setSelected(true);
        this._nameTxtField.setEnabled(false);
        this.setNames();
    }

    public void setHostInfo(HostObject hostObject) {
        this._nameTxtField.setText(hostObject.getName());
        this._internalAddrTxtField.setText(hostObject.getInternalAddress());
        this._externalAddrTxtField.setText(hostObject.getExternalAddress());
        this._dsgComboBox.setSelectedIndex(hostObject.getDataSpaceGroup());
        this._PGsSelected.setText(hostObject.getPhysicalGroupsString());
        this.host = hostObject;
    }

    public void setHostInfoBorder() {
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.hostInfo")));
    }

    private void showSelectPGSDialog(HostObject hostObject) {
        this.selectPGPanel = new SelectPhysicalGroupsPanel(this.grid);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)this.selectPGPanel, (String)Messages.getString("TimesTenGrid.physicalGroups2"), (ActionListener)this);
        jEWTDialog.setButtonMask(3);
        jEWTDialog.setSize(new Dimension(300, 300));
        jEWTDialog.setMinimumSize(new Dimension(300, 300));
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        this.selectPGPanel.setSelection(hostObject.getPhysicalGroups());
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isOked()) {
            hostObject.getPhysicalGroups().clear();
            hostObject.getPhysicalGroups().addAll(this.selectPGPanel.getSelected());
            this._PGsSelected.setText(hostObject.getPhysicalGroupsString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            this.oked = false;
            return;
        }
        this.host.setName(this.hostName);
        this.host.setInternalAddress(this._internalAddrTxtField.getText().trim());
        this.host.setExternalAddress(this._externalAddrTxtField.getText().trim());
        this.host.setDataSpaceGroup(this._dsgComboBox.getSelectedIndex());
        super.actionPerformed(actionEvent);
        this.oked = true;
        if (this.isStandAlone) {
            this.createHost();
        }
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public void setIsStandAlone(boolean bl) {
        this.isStandAlone = bl;
    }

    private boolean validInput() {
        String string;
        String string2 = this._internalAddrTxtField.getText().isEmpty() ? this._nameTxtField.getText() : this._internalAddrTxtField.getText().trim();
        String string3 = string = this._externalAddrTxtField.getText().isEmpty() ? this._nameTxtField.getText() : this._externalAddrTxtField.getText().trim();
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInternalAddrError"));
            return false;
        }
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noExternalAddrError"));
            return false;
        }
        if (!Common.validAddress(string2)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.internalAddrFormatError"));
            return false;
        }
        if (!Common.validAddress(string)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.externalAddrFormatError"));
            return false;
        }
        this.hostName = this._nameTxtField.getText().trim();
        if (!this._useDefaultCheckBox.isSelected()) {
            if (this.hostName.isEmpty()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noNameError"));
                return false;
            }
        } else {
            try {
                this.hostName = SSHChannel.getHostName(string, this.grid.getExecutor().getWorkingHost().getInstanceAdmin(), this.grid.getExecutor().getWorkingHost().getPwd(), this.grid.getExecutor().getWorkingHost().getKeyFile());
            }
            catch (MySSHException mySSHException) {
                _logger.log(Level.SEVERE, mySSHException.getMessage());
                Common.displayErrorMsg(this, mySSHException.getMessage());
                return false;
            }
        }
        for (HostObject hostObject : this.grid.getHosts()) {
            if (!hostObject.getName().equalsIgnoreCase(this.hostName)) continue;
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.repeatedHostGrid"));
            return false;
        }
        String string4 = Common.validateName(this.hostName, Messages.getString("TimesTen.common.hostName"));
        if (string4 != null) {
            Common.displayErrorMsg(null, string4);
            return false;
        }
        return true;
    }

    private void createHost() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.newHost"), Messages.getString("TimesTenGrid.addingNewHosts"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.saveExpansionState();
                    customProgressMonitor.start();
                    if (NewStandaloneHostPanel.this.hostName.isEmpty()) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.gettingHostName"));
                        NewStandaloneHostPanel.this.hostName = SSHChannel.getHostName(NewStandaloneHostPanel.this.host.getExternalAddress(), NewStandaloneHostPanel.this.grid.getExecutor().getWorkingHost().getInstanceAdmin(), NewStandaloneHostPanel.this.grid.getExecutor().getWorkingHost().getPwd(), NewStandaloneHostPanel.this.grid.getExecutor().getWorkingHost().getKeyFile());
                    }
                    GridCommand gridCommand = GridCommand.HOST_FULL_CREATE;
                    gridCommand.prepareHostCreateCommand(NewStandaloneHostPanel.this.host);
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingHost"), NewStandaloneHostPanel.this.host.getName()));
                    NewStandaloneHostPanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    NewStandaloneHostPanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException | MySSHException exception) {
                    _logger.log(Level.SEVERE, exception.getMessage());
                    this.firePropertyChange("error", null, exception.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.hostCreationCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.hostCreationCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    GridMouseListener.expander.restoreExpansionState();
                    NewStandaloneHostPanel.this.showModelNeedsApplyWarning();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
        this._dialog.dispose();
    }

    @Override
    public void setDialog(final JEWTDialog jEWTDialog) {
        super.setDialog(jEWTDialog);
        this._dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (MessageDialog.getPersistence().getConfirmed(NewStandaloneHostPanel.CONFIRMATION_ID) != null) {
                    return;
                }
                if (!Common.displayOptionalConfirm(NewStandaloneHostPanel.CONFIRMATION_ID, componentEvent.getComponent(), Messages.getString("TimesTenGrid.pwdLessWarningHC"), Messages.getString("TimesTenGrid.pwdLessSSH"), null)) {
                    jEWTDialog.dispose();
                    return;
                }
            }
        });
    }

    private void setNames() {
        this._nameLabel.setName(Messages.getString("TimesTenGrid.hostNameColumn"));
        this._internalAddrLabel.setName(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._externalAddrLabel.setName(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._dsgLabel.setName(Messages.getString("TimesTenGrid.DSGLabel"));
        this._PGsLabel.setName(Messages.getString("TimesTenGrid.physicalGroups2"));
        this._selectPGsButton.setName(Messages.getString("TimesTenGrid.selectButton"));
        this._useDefaultCheckBox.setName(Messages.getString("TimesTenGrid.useDefault"));
        this._PGsSelected.setName("_PGsSelected");
        this._nameTxtField.setName("_nameTxtField", "_nameCmbBx");
        this._internalAddrTxtField.setName("_internalAddrTxtField", "_internalAddrCmbBox");
        this._externalAddrTxtField.setName("_externalAddrTxtField", "_externalAddrCmbBox");
        this._dsgComboBox.setName("_dsgComboBox");
    }
}

