/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.database.WizardMain;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.Ide;

public class LatestModelChangesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(LatestModelChangesPanel.class.getPackage().getName());
    private JTable _table;
    private ModelComparisonTableModel _model;
    private JLabel titleLabel;
    private JScrollPane _scrollPane;
    private GridObject grid2Compare;
    private GridObject gridLatest;
    private GridObject gridCurrent;
    private DifferenceObject diff;
    private ModelComparisonWorker mcw;
    private boolean loadModels;
    private boolean showNoChangesWarn;
    private boolean showChanges;
    private boolean database;
    private JEWTDialog _dialog;
    private final int OBJ_TYPE = 0;
    private final int OBJ_NAME = 1;
    private final int ACTION = 2;

    public LatestModelChangesPanel(GridObject gridObject, boolean bl) {
        this(gridObject, bl, false, false);
    }

    public LatestModelChangesPanel(GridObject gridObject, boolean bl, boolean bl2) {
        this(gridObject, bl, bl2, false);
    }

    public LatestModelChangesPanel(GridObject gridObject, boolean bl, boolean bl2, boolean bl3) {
        this.showChanges = bl2;
        this.grid2Compare = gridObject;
        this.loadModels = bl;
        this.database = bl3;
        this.showNoChangesWarn = true;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._model = new ModelComparisonTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = LatestModelChangesPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    _logger.log(Level.INFO, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setDefaultRenderer(Object.class, new BackgroundRowColorRenderer());
        this._table.setRowSelectionAllowed(false);
        this._table.setCellSelectionEnabled(false);
        this.titleLabel = new JLabel(this.showChanges ? (this.database ? Messages.getString("TimesTenGrid.PendingChangesDatabase") : Messages.getString("TimesTenGrid.PendingChanges")) : Messages.getString("TimesTenGrid.CTTable"));
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.mcw = new ModelComparisonWorker();
        this.mcw.execute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    private class ModelComparisonTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.CTObjectType"), Messages.getString("TimesTenGrid.CTObject"), Messages.getString("TimesTenGrid.CTAction")};

        private ModelComparisonTableModel() {
        }

        @Override
        public int getRowCount() {
            return LatestModelChangesPanel.this.diff != null ? LatestModelChangesPanel.this.diff.getDiffNumber() : 0;
        }

        @Override
        public int getColumnCount() {
            return this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return LatestModelChangesPanel.this.diff.getObjectsChanged().get(n).getObjectType();
                }
                case 1: {
                    if (LatestModelChangesPanel.this.diff.getObjectsChanged().get(n) instanceof InstanceObject || LatestModelChangesPanel.this.diff.getObjectsChanged().get(n) instanceof InstallationObject || LatestModelChangesPanel.this.diff.getObjectsChanged().get(n) instanceof ConnectableObject) {
                        return LatestModelChangesPanel.this.diff.getObjectsChanged().get(n).getFullName();
                    }
                    return LatestModelChangesPanel.this.diff.getObjectsChanged().get(n).getName();
                }
                case 2: {
                    return LatestModelChangesPanel.this.diff.getOperation().get(n);
                }
            }
            return null;
        }

        public Color getRowColor(int n) {
            switch (LatestModelChangesPanel.this.diff.getOperation().get(n)) {
                case ADDED: {
                    return Color.GREEN;
                }
                case EDITED: {
                    return Color.ORANGE;
                }
                case REMOVED: {
                    return Color.RED;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class BackgroundRowColorRenderer
    extends DefaultTableCellRenderer {
        private BackgroundRowColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ModelComparisonTableModel modelComparisonTableModel = (ModelComparisonTableModel)jTable.getModel();
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 2) {
                jLabel.setBackground(modelComparisonTableModel.getRowColor(n));
            } else {
                jLabel.setBackground(Color.WHITE);
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class ModelComparisonWorker
    extends SwingWorker<Void, Void> {
        private CustomProgressMonitor progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.comparingModels"), Messages.getString("TimesTenGrid.comparingModels"), null);
        private JsonObject currentModel;
        private JsonObject latestModel;

        public ModelComparisonWorker() {
            this.addPropertyChangeListener(this.progressMonitor);
            this.progressMonitor.setSwingWorker(this);
            this.progressMonitor.setDetailVisible(false);
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.progressMonitor.start();
            try {
                if (LatestModelChangesPanel.this.loadModels) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateGridTask"));
                    this.progressMonitor.updateMessage(Messages.getString("TimesTenGrid.updateGridTask"));
                    this.latestModel = LatestModelChangesPanel.this.grid2Compare.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, false);
                    this.currentModel = LatestModelChangesPanel.this.grid2Compare.getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    this.progressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                    LatestModelChangesPanel.this.gridLatest = new GridObject("latest", LatestModelChangesPanel.this.grid2Compare.getExecutor());
                    LatestModelChangesPanel.this.gridLatest.setGridComponents(this.latestModel, false);
                    LatestModelChangesPanel.this.gridCurrent = new GridObject("current", LatestModelChangesPanel.this.grid2Compare.getExecutor());
                    LatestModelChangesPanel.this.gridCurrent.setGridComponents(this.currentModel, false);
                } else {
                    LatestModelChangesPanel.this.gridLatest = LatestModelChangesPanel.this.grid2Compare;
                    LatestModelChangesPanel.this.gridCurrent = LatestModelChangesPanel.this.grid2Compare.getGridCurrentModel();
                }
            }
            catch (GridCommandException gridCommandException) {
                _logger.log(Level.SEVERE, "Error retrieving grid versions:" + gridCommandException.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                LatestModelChangesPanel.this.diff = LatestModelChangesPanel.this.gridCurrent.diff(LatestModelChangesPanel.this.gridLatest);
                if (!LatestModelChangesPanel.this.diff.areDifferences()) {
                    LatestModelChangesPanel.this.grid2Compare.getGridNode().updateIcon(true);
                    LatestModelChangesPanel.this._dialog.closeDialog(true);
                    if (LatestModelChangesPanel.this.showNoChangesWarn) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.MCNoChangesWarning"));
                        this.progressMonitor.updateMessage(Messages.getString("TimesTenGrid.MCNoChangesWarning"));
                    }
                } else {
                    LatestModelChangesPanel.this.grid2Compare.getGridNode().updateIcon(false);
                    this.progressMonitor.close();
                    LatestModelChangesPanel.this._dialog.setVisible(true);
                    if (LatestModelChangesPanel.this._dialog.isOked() && LatestModelChangesPanel.this.showChanges && !LatestModelChangesPanel.this.database) {
                        LatestModelChangesPanel.this.grid2Compare.getExecutor().executeApplyModel(LatestModelChangesPanel.this.grid2Compare);
                    }
                    if (LatestModelChangesPanel.this._dialog.isCancelled() && LatestModelChangesPanel.this.database) {
                        WizardMain.getInstance().getCurrentWizardDialog().dispose();
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        LatestModelChangesPanel.this._model.fireTableDataChanged();
                        TableColumnSizer.setColumnsWidthToFit(LatestModelChangesPanel.this._table, true, true);
                    } else {
                        SwingUtilities.invokeAndWait(() -> {
                            LatestModelChangesPanel.this._model.fireTableDataChanged();
                            TableColumnSizer.setColumnsWidthToFit(LatestModelChangesPanel.this._table, true, true);
                        });
                    }
                }
            }
            catch (InterruptedException | InvocationTargetException exception) {
                JOptionPane.showMessageDialog((Component)LatestModelChangesPanel.this._dialog, exception.getMessage());
            }
            finally {
                this.progressMonitor.finish();
            }
            super.done();
        }
    }
}

