/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.DSGAssignmentPanel;
import oracle.dbtools.raptor.timesten.grid.DataInstancesPanel;
import oracle.dbtools.raptor.timesten.grid.object.InvalidInputException;
import oracle.dbtools.raptor.timesten.grid.topology.Topology;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DSGAllocTraversablePanel
extends DefaultTraversablePanel {
    private DSGAssignmentPanel _dsgPanel;
    private Topology topology;

    public DSGAllocTraversablePanel() {
        this.setLayout(new GridBagLayout());
        this._dsgPanel = new DSGAssignmentPanel();
        this.add(this._dsgPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            this.topology = new Topology((Integer)traversableContext.get("K_SAFETY"));
            for (DataInstancesPanel.Host host : (List)traversableContext.get("HOSTS")) {
                this.topology.save(host);
            }
            this._dsgPanel.setTopology(this.topology);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 2) {
            return;
        }
        try {
            this._dsgPanel.validInput();
        }
        catch (InvalidInputException invalidInputException) {
            throw new TraversalException(invalidInputException.getMessage());
        }
        ArrayList<DataInstancesPanel.Host> arrayList = new ArrayList<DataInstancesPanel.Host>();
        for (TopologyElement topologyElement : this.topology.getNotInTopology()) {
            DataInstancesPanel.Host host = (DataInstancesPanel.Host)topologyElement;
            host.setDSG(this.topology.getToAddDSG().get(topologyElement) != null ? this.topology.getToAddDSG().get(topologyElement) : 0);
            if (host.getName().equalsIgnoreCase((String)traversableContext.get("HOSTNAME"))) {
                traversableContext.put("DSG", (Object)host.getDSG());
            }
            arrayList.add(host);
        }
        for (DataInstancesPanel.Host host : arrayList) {
            if (host.getDSG() != 0) continue;
            if (Common.displayConfirm((Component)((Object)this), Messages.getString("TimesTenGrid.hostWithNoDSGWarning"), Messages.getString("TimesTenGrid.dsgAlloc"), null, true)) break;
            throw new TraversalException(null);
        }
        traversableContext.put("HOSTS", arrayList);
    }
}

