/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenNavigatorResource;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGridWizMain;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class Common {
    private static Logger _logger = Logger.getLogger(Common.class.getPackage().getName());
    private static Random rand = new Random(System.currentTimeMillis());
    public static int GRID_COUNT = 0;
    public static int HOST_COUNT = 0;
    public static int DATABASE_COUNT = 0;
    public static int N_CALLS = 0;
    public static final int TT_DEFAULT_DAEMONPORT = 6624;
    public static final int TT_DEFAULT_CSPORT = 6625;
    public static final int TT_DEFAULT_MGMTPORT = 3754;
    public static final int MAX_KSAFETY_SUPPORTED = 5;
    public static final int RECOMMENDED_KSAFETY = 2;
    public static final int COMPLETE = 100;
    public static final int WAIT_FOR_DBSTATUS = 5000;
    public static final int MAX_TRIES = 60;
    public static final String FORCE_DISCONNECT_FLAG = "-forceDisconnect";
    public static final String DB_DISCONNECT_FLAG = "-dbDisconnect";
    public static final int PARAMCHECK_COUNT = CheckIndex.values().length;
    static final int FILE_ADDRESS = 0;
    static final int FILE_INSTNAME = 1;
    static final int FILE_INSTDIR = 2;
    static final int FILE_DAEMONPORT = 3;
    static final int FILE_CSPORT = 4;
    static final int FILE_INSTALLLOC = 5;
    public static final int DEFAULT_CMD_TIMEOUT = 600;
    static final int CMD_WAIT_TIME_MS = 500;
    static final int CMD_TIMEOUT = Integer.getInteger("oracle.dbtools.raptor.timesten.grid.commandTimeout", 600);
    static final int DEFAULT_UPDATE_CONN_TIMEOUT = 600;
    public static final int UPDATE_CONN_TIMEOUT = Integer.getInteger("oracle.dbtools.raptor.timesten.grid.updateConnectionsTimeout", 600);
    public static final String DB_DISCONNECT_TTVERSION = "18.1.2.0.0";
    public static final String KEY_GRIDNAME = "GRID_NAME";
    public static final String KEY_KSAFETY = "K_SAFETY";
    public static final String KEY_MEMSERVICE = "MEM_SERVICE";
    public static final String KEY_MEMCONFIG = "MEM_CONFIG";
    public static final String KEY_ADDRESS = "ADDRESS";
    public static final String KEY_EXTADDRESS = "EXTADDRESS";
    public static final String KEY_INTADDRESS = "INTADDRESS";
    public static final String KEY_HOSTNAME = "HOSTNAME";
    public static final String KEY_DSG = "DSG";
    public static final String KEY_NAME = "NAME";
    public static final String KEY_CSPORT = "CS_PORT";
    public static final String KEY_DAEMONPORT = "DAEMON_PORT";
    public static final String KEY_LOCATION = "INSTANCE_LOCATION";
    public static final String KEY_MGMTPORT = "MANAGEMENT_PORT";
    public static final String KEY_INSTALLLOCATION = "INSTALLATION_LOCATION";
    public static final String KEY_INSTANCEADMIN = "INSTANCE_ADMIN";
    public static final String KEY_PWD = "PWD";
    public static final String KEY_SSHKEYFILE = "SSH_KEY_FILE";
    public static final String KEY_SAVEPWD = "SAVE_PWD";
    public static final String KEY_SWLOCATION = "SW_LOCATION";
    public static final String KEY_TTGROUP = "TT_GROUP";
    public static final String KEY_LOCALPATH = "LOCAL_PATH";
    public static final String KEY_HOSTS = "HOSTS";
    public static final String KEY_ISLOCALHOST = "IS_LOCAL_HOST";
    public static final String KEY_APPLY = "APPLY";
    public static final String KEY_DBDEFATTRIBUTES = "DF_DEF_ATTRIBUTES";
    public static final String KEY_DBNAME = "DB_NAME";
    public static final String KEY_TPLGY = null;
    public static final String KEY_INST_ROOT_DIR = "INST_ROOT_DIR";
    public static final String KEY_DIRS_TO_CREATE = "DIRS_TO_CREATE";
    public static final String MESSAGE = "message";
    public static final String PROGRESS = "progress";
    public static final String ERROR = "error";
    public static final String SUCCESSFUL = "successful";
    public static final String COMMAND = "command";
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    public static final String CODE = "code";
    public static final String GRIDNAME = "gridName";
    public static final String GRIDGUID = "gridGuid";
    public static final String VERSION = "version";
    public static final String JSONVER = "jsonVer";
    public static final String WHENCREATED = "whenCreated";
    public static final String APPLIED = "applied";
    public static final String WHENAPPLIED = "whenApplied";
    public static final String K = "k";
    public static final String MEMBERSHIP = "membership";
    public static final String MEMBERSHIPCONFIG = "membershipConfig";
    public static final String INSTANCECONFIG = "instanceConfig";
    public static final String TNSNAMES = "TNSNames";
    public static final String SQLNET = "SQLNet";
    public static final String MEMBERSHIPSERVICE = "membershipService";
    public static final String CREATED = "created";
    public static final String ADMINUID = "adminUID";
    public static final String KEYFILE = "keyFile";
    public static final String ADMINGROUP = "adminGroup";
    public static final String ADMINGID = "adminGID";
    public static final String RETAINDAYS = "retainDays";
    public static final String RETAINVERSIONS = "retainVersions";
    public static final String MAJORRELEASE = "majorRelease";
    public static final String CREATEDRELEASE = "createdRelease";
    public static final String STATUS = "status";
    public static final String SITES = "sites";
    public static final String REPOSITORIES = "repositories";
    public static final String REPOSITORY = "repository";
    public static final String REPOSITORY_PATH = "repositoryPath";
    public static final String REPOSITORY_NAME = "repositoryName";
    public static final String REPOSITORY_ADDRESS = "repositoryAddress";
    public static final String DATASPACEGROUPS = "dataSpaceGroups";
    public static final String DBDEFS = "dbdefs";
    public static final String HOSTS = "hosts";
    public static final String HOST = "host";
    public static final String TTREPSTATEGET = "ttRepStateGet";
    public static final String REPSTARTED = "repStarted";
    public static final String ACTIVE = "ACTIVE";
    public static final String IDLE = "IDLE";
    public static final String STANDBY = "STANDBY";
    public static final String DOWN = "Down";
    public static final String NAME = "name";
    public static final String ADDRESS = "address";
    public static final String INTERNALADDRESS = "internalAddress";
    public static final String RECOMMENDATIONS = "recommendations";
    public static final String CMDS = "cmds";
    public static final String DBGUID = "dbGuid";
    public static final String DBDEFGUID = "dbdefGuid";
    public static final String LOADED = "loaded";
    public static final String OPENED = "opened";
    public static final String OPEN = "open";
    public static final String UNLOADING = "Unloading";
    public static final String LOADING = "Loading";
    public static final String CREATE_FAILED = "createFailed";
    public static final String DELETEPENDING = "deletePending";
    public static final String LASTCHANGEEND = "lastChangeEnd";
    public static final String LASTCHANGECODE = "lastChangeCode";
    public static final String LASTCHANGESTART = "lastChangeStart";
    public static final String SYNCREPSET = "syncReplicaSet";
    public static final String DSG = "dataSpace";
    public static final String REMOVEDISTMAP = "removeInNextDistMap";
    public static final String CURDISTMAP = "inCurDistMap";
    public static final String PREVDISTMAP = "inPrevDistMap";
    public static final String ADDDISTMAP = "addInNextDistMap";
    public static final String IS_REMOVED = "isRemoved";
    public static final String IS_EVICTED = "isEvicted";
    public static final String RS = "rs";
    public static final String OVERALL = "overall";
    public static final String SUMMARY = "summary";
    public static final String N_INSTANCES = "nInstances";
    public static final String N_DOWN = "nDown";
    public static final String N_CREATED = "nCreated";
    public static final String N_CREATE_FAILED = "nCreateFailed";
    public static final String N_INSTANCES_OPENED = "nInstancesOpened";
    public static final String N_INSTANCES_LOADED = "nInstancesLoaded";
    public static final String N_CREATING = "nCreating";
    public static final String N_LOADING = "nLoading";
    public static final String STATE = "state";
    public static final String LAST_CHNG_MSG = "lastChangeMsg";
    public static final String Y = "Y";
    public static final String N = "N";
    public static final String METHOD = "method";
    public static final String RECENT_BACKUPS = "recentBackups";
    public static final String RECENT_EXPORTS = "recentExports";
    public static final String DBNAME = "dbName";
    public static final String WHEN_STARTED = "whenStarted";
    public static final String ELEMENT_NO = "elementNo";
    public static final SimpleDateFormat DBSTATUSDATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final String EXTERNALADDRESS = "externalAddress";
    public static final String INSTALLATIONS = "installations";
    public static final String INSTALLATION = "installation";
    public static final String DATASPACEGROUP = "dataSpaceGroup";
    public static final String PHYSICALGROUPS = "physicalGroups";
    public static final String LOCATION = "location";
    public static final String RELEASE = "release";
    public static final String SOURCE_ADDR = "sourceAddr";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String SOURCE_RELEASE = "sourceRelease";
    public static final String INSTANCES = "instances";
    public static final String INSTANCE = "instance";
    public static final String INSTANCEHOME = "instanceHome";
    public static final String WALLETDIR = "walletDir";
    public static final String DATABASES = "databases";
    public static final String HOST_NAME = "hostName";
    public static final String ELEMENTS = "elements";
    public static final String ELEMENT_NUMBER = "elementNumber";
    public static final String INSTALLATION_LOCATION = "installationLocation";
    public static final String INSTANCE_NAME = "instanceName";
    public static final String GUID = "guid";
    public static final String CSPORT = "csPort";
    public static final String DAEMONPORT = "daemonPort";
    public static final String MGMTPORT = "mgmtPort";
    public static final String INST_TYPE = "instanceType";
    public static final String INST_TYPE_MGMT = "M";
    public static final String INST_TYPE_DATA = "D";
    public static final String CREATEINSTANCE = "createInstance";
    public static final String TTGRIDADMIN = "TTGRIDADMIN";
    public static final String DATASTORE = "datastore";
    public static final String DATABASECHARACTERSET = "databasecharacterset";
    public static final String PERMSIZE = "permsize";
    public static final String TEMPSIZE = "tempsize";
    public static final String CONNECTABLES = "connectables";
    public static final String CONNECTIONCHARACTERSET = "connectioncharacterset";
    public static final String CACHEGRIDENABLE = "cachegridenable";
    public static final String CLIENTSERVER = "clientServer";
    public static final String ONLY = "__ONLY0";
    public static final String ERRNO = "errno";
    public static final String ERRMSG = "errmsg";
    public static final String ATTRS = "attrs";
    public static final String TYPE = "type";
    public static final String SUMMARY_ATTR = "SummaryAttr";
    public static final String SUMMARY_VALS = "SummaryVals";
    public static final String DB_INFO = "db info";
    public static final String NUM_CONNS = "# of conns";
    public static final String DB_NAME = "database name";
    public static final String START = "start";
    public static final String INSTANCEGUID = "instanceGuid";
    public static final String MAXSEQ = "maxSeq";
    public static final String INMEMBERSHIP = "inMembership";
    public static final String LOAD_READINESS = "Load Readiness";
    public static final String REPLICA_SETS = "Replica Sets";
    public static final String REPLICA_SET_STATE = "State";
    public static final String REPLICA_SET = "rs";
    public static final String NOT_LOADABLE = "Not loadable";
    public static final String READY = "Ready";
    public static final String CREATE_DIR = "$$CREATE_DIR$$";
    public static final String PERL_SCRIPT_FILE_NAME = "gridCompositeCommands.pl";
    public static final String PERL_EXECUTABLE_LOCATION = "/PERL/bin/perl";
    public static final String TIMESTEN_INSTALL_ROOT = "TIMESTEN_INSTALL_ROOT";
    public static final String DEFAULT_INSTALLATION_NAME = "installation1";
    public static final String JSON_SUFFIX = ".json";
    public static final String ORA_SUFFIX = ".ora";
    public static final int SUCCESS = 0;
    public static final int PERL_WAIT_FOR_DB_STATE_TIMEOUT = 3;
    public static final int PERL_SSH_TIMEOUT = 4;
    public static final int INTERNAL_ERR = 255;
    public static final int SYNTAX_ERR = 254;
    public static final int OBJ_ALREADY_EXIST = 1;
    public static final int OBJ_DOESNT_EXIST = 2;
    public static final int FILE_NOT_FOUND = 3;
    public static final int NO_MODEL_VERSION_APPLIED = 4;
    public static final int OBJ_STILL_INUSE = 5;
    public static final int NAME_ISNT_UNIQUE = 6;
    public static final int OBJ_ALREADY_ASSIGNED_MEMBERSHIP = 7;
    public static final int OBJ_ALREADY_DELETED = 8;
    public static final int DB_ALREADY_OPEN = 21;
    public static final int DB_NOT_LOADED = 22;
    public static final int DB_ALREADY_LOADED = 23;
    public static final int DB_ALREADY_CLOSED = 24;
    public static final int DB_OPEN = 25;
    public static final int HOST_NOT_ASSIGNED_TO_DSG = 26;
    public static final int DBDEF_NOT_FOUND = 27;
    public static final int CANNOT_DELETE_CONNECTABLE = 28;
    public static final int MGMT_NOT_RUNNING = 67;
    public static final Icon FOLDER_ICON = OracleIcons.getIcon((String)"folder.png");
    public static final Icon HOST_ICON = OracleIcons.getIcon((String)"laptop.png");
    public static final Icon INSTANCE_ICON = OracleIcons.getIcon((String)"component.png");
    public static final Icon INSTALLATION_ICON = OracleIcons.getIcon((String)"application.png");
    public static final Icon UP_ICON = OracleIcons.getIcon((String)"gutter/up.png");
    public static final Icon DOWN_ICON = OracleIcons.getIcon((String)"gutter/down.png");
    public static final Icon GEAR_FOLDER_ICON = TimesTenNavigatorResource.getIcon("GEAR_FOLDER_ICON");
    public static final Icon BACKUP_ICON = OracleIcons.getIcon((String)"restore_save_point.png");
    public static final Icon EXPORT_ICON = OracleIcons.getIcon((String)"export.png");
    public static final Icon FILE_ICON = OracleIcons.getIcon((String)"file.png");
    public static final Icon REPOSITORY_ICON = OracleIcons.getIcon((String)"files.png");
    public static final String CREATE_PATH_ID = "CreatePathID";
    public static final String MODEL_CHANGES_ID = "ModelChangesID";
    public static final String DB_FIRST_CONN_ID = "FirstConnectID";
    public static final String TT_INSTANCE_CREATE = "ttInstanceCreate";
    private static Logger logger = Logger.getLogger(Common.class.getName());
    private static final String ADDRESS_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-_]*[A-Za-z0-9])$";
    private static final Pattern addressPattern = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-_]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-_]*[A-Za-z0-9])$");
    public static final String ASTERISKS_MASK = "******";
    public static final int MAX_NAME_LENGTH = 256;
    private static final String NAME_REGEX = "[\\w_-]*";
    private static final Pattern namePattern = Pattern.compile("[\\w_-]*");
    private static final String NEWGRID_CONFIRMATION_ID = "NewGridConfirmation";
    public static final String APP_CONNECTION_TYPE = "application";
    public static final String SERVER_CONNECTION_TYPE = "server";
    public static final String CS_CONNECTION_TYPE = "C/S";
    public static final String PROXY_CONNECTION_TYPE = "Proxy";
    public static final String DIRECT_CONNECTION_TYPE = "Direct";
    public static final int[] INTERVALS = new int[]{15, 30, 60, 300};
    public static final String[] INTERVAL_OPTIONS = new String[]{Messages.getString("TimestenGrid.manual"), MessageFormat.format(Messages.getString("TimesTenGrid.refreshIntervalSeconds"), INTERVALS[0]), MessageFormat.format(Messages.getString("TimesTenGrid.refreshIntervalSeconds"), INTERVALS[1]), MessageFormat.format(Messages.getString("TimesTenGrid.refreshIntervalSeconds"), INTERVALS[2]), MessageFormat.format(Messages.getString("TimesTenGrid.refreshIntervalSeconds"), INTERVALS[3])};
    public static final String WINDOWS_OS = "MS_WIN";
    public static final String LINUX_OS = "LINUX";
    public static final String MAC_OS = "MAC_OS";
    public static final String UNKNOWN_OS = "UNKNOWN";
    public static final String[] SSH_WARNINGS = new String[]{"FIPS integrity verification test failed", "NOTE: unknown or unsupported java version, setting values for JDK"};
    public static final Comparator<InstanceObject> INSTANCE_ORDER = new Comparator<InstanceObject>(){

        @Override
        public int compare(InstanceObject instanceObject, InstanceObject instanceObject2) {
            if (instanceObject.isMgmtInstance()) {
                return instanceObject2.isMgmtInstance() ? 0 : -1;
            }
            return instanceObject2.isMgmtInstance() ? 1 : 0;
        }
    };
    public static final String DBSTATUS_CONNECTIONS_TTVERSION = "18.1.1.3.0";
    public static final String KGREATERTHAN2_TTVERSION = "22.1.0.0.0";
    public static final String MIN_SCALEOUT_TTVERSION = "18.1.0.0.0";
    public static final String MAX_SCALEOUT_TTVERSION = "25.1.0.0.0";
    public static final Pattern folderVersionPattern = Pattern.compile("tt(\\d+\\.\\d+\\.\\d+\\.\\d+\\.\\d+)\\/");

    public static boolean isWarning(String string) {
        for (String string2 : SSH_WARNINGS) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static int getRandomNum(int n, int n2) {
        return rand.nextInt(n2 - n + 1) + n;
    }

    public static void displayErrorMsg(final Component component, final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            MessageDialog.error((Component)component, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error((Component)component, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                }
            });
        }
    }

    public static void displayInfoMsg(final Component component, final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            MessageDialog.information((Component)component, (Object)string, (String)string2, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information((Component)component, (Object)string, (String)string2, null);
                }
            });
        }
    }

    public static void displayOptionalInformation(final String string, final Component component, final String string2, final String string3, final String string4) {
        if (SwingUtilities.isEventDispatchThread()) {
            MessageDialog.optionalInformation((String)string, (Component)component, (Object)string2, (String)string3, (String)string4);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.optionalInformation((String)string, (Component)component, (Object)string2, (String)string3, (String)string4);
                }
            });
        }
    }

    public static boolean displayOptionalConfirm(String string, Component component, String string2, String string3, String string4) {
        return MessageDialog.optionalConfirm((String)string, (Component)component, (Object)string2, (String)string3, (String)string4);
    }

    public static boolean displayConfirm(Component component, String string, String string2, String string3) {
        return MessageDialog.confirm((Component)component, (Object)string, (String)string2, (String)string3);
    }

    public static boolean displayConfirm(Component component, String string, String string2, String string3, boolean bl) {
        return MessageDialog.confirm((Component)component, (Object)string, (String)string2, (String)string3, (boolean)bl);
    }

    public static boolean validAddress(String string) {
        return addressPattern.matcher(string).matches();
    }

    public static String removeTrailingFileSeparator(String string, String string2) {
        String string3 = "\\" + string2 + "+$";
        return string.replaceFirst(string3, "");
    }

    public static boolean isLocalHost(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(enumeration)) {
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                for (InetAddress inetAddress2 : Collections.list(enumeration2)) {
                    if (!inetAddress.getHostAddress().equalsIgnoreCase(inetAddress2.getHostAddress())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage());
        }
        return false;
    }

    public static boolean validPort(int n) {
        return n > 1024 && n <= 65535;
    }

    public static boolean isAFile(String string) {
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean isADirectory(String string, boolean bl) {
        try {
            Path path = FileSystems.getDefault().getPath(string, new String[0]);
            if (bl) {
                return Files.isWritable(path);
            }
            return Files.isDirectory(path, new LinkOption[0]);
        }
        catch (SecurityException securityException) {
            logger.log(Level.INFO, securityException.getMessage());
            return false;
        }
    }

    public static boolean validTTSWFile(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".zip") || string2.endsWith(".tar") || string2.endsWith(".gz");
    }

    public static boolean isRunningInTTView() {
        return System.getenv(TIMESTEN_INSTALL_ROOT) != null && System.getenv(TIMESTEN_INSTALL_ROOT).length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File streamToFile(InputStream inputStream) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            file = File.createTempFile("foo", ".tmp");
            file.deleteOnExit();
            fileOutputStream = new FileOutputStream(file);
            while (inputStream.available() > 0) {
                fileOutputStream.write(inputStream.read());
            }
        }
        catch (IOException iOException) {
            _logger.severe("Error while trying to generate perl script file: " + iOException.getMessage());
            file = null;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public static InstanceObject getWorkingInstanceObject() {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        if (gridObject != null) {
            for (HostObject hostObject : gridObject.getHosts()) {
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    if (!Common.isWorkingInstance(gridObject, instanceObject)) continue;
                    return instanceObject;
                }
            }
        }
        return null;
    }

    public static boolean isWorkingInstance(GridObject gridObject, InstanceObject instanceObject) {
        return gridObject.getExecutor().getWorkingHost().getIPaddress().equalsIgnoreCase(instanceObject.getHost().getExternalAddress()) && gridObject.getExecutor().getWorkingHost().getInstanceHome().equalsIgnoreCase(instanceObject.getHome());
    }

    public static JComboBox<String> getDSGComboBox(int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Messages.getString("TimesTen.common.none"));
        for (int i = 1; i <= n; ++i) {
            jComboBox.addItem(String.valueOf(i));
        }
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public static String getDefaultInstanceName() {
        return Common.getDefaultInstanceName(false);
    }

    public static String getDefaultInstanceName(boolean bl) {
        if (bl) {
            return "mgmt_instance1";
        }
        return "instance1";
    }

    public static void rowsInserted(JTable jTable, AbstractTableModel abstractTableModel, int n, int n2) {
        abstractTableModel.fireTableRowsInserted(n, n2);
        TableColumnSizer.setColumnsWidthToFit(jTable, true, true);
    }

    public static void rowsDeleted(JTable jTable, AbstractTableModel abstractTableModel, int n, int n2) {
        abstractTableModel.fireTableRowsDeleted(n, n2);
        TableColumnSizer.setColumnsWidthToFit(jTable, true, true);
    }

    public static boolean sameDirectories(String string, String string2) {
        try {
            Path path = FileSystems.getDefault().getPath(string, new String[0]);
            Path path2 = FileSystems.getDefault().getPath(string2, new String[0]);
            return Files.isSameFile(path, path2);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, iOException.getMessage());
            return false;
        }
    }

    public static List<String[]> readHostInstanceFile(String string) {
        try {
            String string2;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string2 = string2.trim()).startsWith("#") || (stringArray = string2.split(",")).length <= 0 || stringArray[0].isEmpty()) continue;
                int n = -1;
                int n2 = -1;
                String string3 = "";
                String string4 = "";
                String string5 = stringArray[0];
                String string6 = "";
                if (stringArray.length > 1 && !stringArray[1].isEmpty()) {
                    string6 = stringArray[1];
                }
                if (stringArray.length > 2 && !stringArray[2].isEmpty()) {
                    string3 = stringArray[2];
                }
                if (stringArray.length > 3 && !stringArray[3].isEmpty()) {
                    try {
                        n = Integer.parseInt(stringArray[3]);
                        if (!Common.validPort(n)) {
                            n = -1;
                        }
                    }
                    catch (Exception exception) {
                        _logger.log(Level.INFO, exception.getMessage());
                    }
                }
                if (stringArray.length > 4 && !stringArray[4].isEmpty()) {
                    try {
                        n2 = Integer.parseInt(stringArray[4]);
                        if (!Common.validPort(n2)) {
                            n2 = -1;
                        }
                    }
                    catch (Exception exception) {
                        _logger.log(Level.INFO, exception.getMessage());
                    }
                }
                if (stringArray.length > 5 && !stringArray[5].isEmpty()) {
                    string4 = stringArray[5];
                }
                arrayList.add(new String[]{string5, string6, string3, String.valueOf(n), String.valueOf(n2), string4});
            }
            bufferedReader.close();
            return arrayList;
        }
        catch (Exception exception) {
            _logger.log(Level.INFO, exception.getMessage());
            Common.displayErrorMsg((Component)Ide.getMainWindow(), exception.getMessage());
            return null;
        }
    }

    public static String getParentFolder(String string) {
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private static boolean isValidName(String string) {
        return namePattern.matcher(string).matches();
    }

    private static boolean isReservedName(String string) {
        return string.equalsIgnoreCase("ALL") || string.equalsIgnoreCase("DEFAULT");
    }

    public static String validateName(String string, String string2) {
        if (string.length() > 256) {
            return MessageFormat.format(Messages.getString("TimesTenGrid.nameLengthError"), string2);
        }
        if (!Common.isValidName(string)) {
            return MessageFormat.format(Messages.getString("TimesTenGrid.malformedNameError"), string2);
        }
        if (Common.isReservedName(string)) {
            return MessageFormat.format(Messages.getString("TimesTenGrid.reservedName"), string);
        }
        return null;
    }

    public static int loadedDBsCount(List<DatabaseObject> list) {
        return Common.loadedDBsCount(list, true);
    }

    public static int loadedDBsCount(List<DatabaseObject> list, boolean bl) {
        int n = 0;
        for (DatabaseObject databaseObject : list) {
            if (databaseObject.getDBStatus().isLoaded()) {
                ++n;
                continue;
            }
            if (!bl || !databaseObject.getDBStatus().isPartiallyLoaded()) continue;
            ++n;
        }
        return n;
    }

    public static void styleAsHyperLink(JLabel jLabel) {
        Font font = jLabel.getFont();
        Map<TextAttribute, ?> map = font.getAttributes();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(Color.BLUE);
        jLabel.setFont(font.deriveFont(map));
    }

    public static void replaceWithHyperlink(final JTextPane jTextPane, String string, int n, Runnable runnable, Object ... objectArray) {
        final StyledDocument styledDocument = jTextPane.getStyledDocument();
        Style style = styledDocument.addStyle("hyperlink", StyleContext.getDefaultStyleContext().getStyle("default"));
        StyleConstants.setForeground(style, Color.BLUE);
        StyleConstants.setUnderline(style, true);
        style.addAttribute("onClick", runnable);
        jTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                Element element = styledDocument.getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()));
                AttributeSet attributeSet = element.getAttributes();
                Runnable runnable = (Runnable)attributeSet.getAttribute("onClick");
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        String[] stringArray = string.split("\\{" + n + "\\}");
        String string2 = n > 0 ? MessageFormat.format(stringArray[0], objectArray) : stringArray[0];
        String string3 = n < objectArray.length - 1 ? MessageFormat.format(stringArray[1], objectArray) : stringArray[1];
        try {
            styledDocument.insertString(styledDocument.getLength(), string2, null);
            styledDocument.insertString(styledDocument.getLength(), objectArray[n].toString(), style);
            styledDocument.insertString(styledDocument.getLength(), string3, null);
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.INFO, badLocationException.getMessage());
        }
    }

    public static boolean forceStart(String string) {
        return string.contains("Pid file exists:") && string.contains("use -force.");
    }

    public static boolean forceStop(String string) {
        return string.contains("use -force.");
    }

    public static boolean validFilePermission(String string) {
        Path path = null;
        try {
            path = Paths.get(string.replaceFirst("^/(.:/)", "$1"), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            logger.warning("Error while constructing path : " + string.replaceFirst("^/(.:/)", "$1") + ", reason: " + invalidPathException.getLocalizedMessage());
            return false;
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
                return !set.contains((Object)PosixFilePermission.GROUP_READ) && !set.contains((Object)PosixFilePermission.GROUP_WRITE) && !set.contains((Object)PosixFilePermission.GROUP_EXECUTE) && !set.contains((Object)PosixFilePermission.OTHERS_READ) && !set.contains((Object)PosixFilePermission.OTHERS_WRITE) && !set.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
            }
            catch (IOException iOException) {
                logger.warning("Error while checking " + string + ": " + iOException.getMessage());
                return false;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.warning(System.getProperty("os.name") + " does not support POSIXFileAttributeView: " + unsupportedOperationException.getMessage());
                return true;
            }
        }
        return false;
    }

    public static int getIntegerFromString(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
    }

    public static Version getVersionFromZipFolder(String string) {
        Matcher matcher = folderVersionPattern.matcher(string);
        if (matcher.find()) {
            return new Version(matcher.group(1));
        }
        return null;
    }

    public static Version getGridVersion(GridObject gridObject) {
        GridCommandExecutor.WorkingHost workingHost = gridObject.getExecutor().getWorkingHost();
        ArrayList<Version> arrayList = new ArrayList<Version>();
        for (InstanceObject instanceObject : gridObject.getAllMgmtInstances()) {
            if (workingHost.getInstanceHome().equals(instanceObject.getHome()) && workingHost.getHostName().equals(instanceObject.getHost().getName())) {
                return new Version(instanceObject.getInstallation().getSourceRelease());
            }
            arrayList.add(new Version(instanceObject.getInstallation().getSourceRelease()));
        }
        Version version = arrayList.stream().min(Version::compareTo).orElse(null);
        return version;
    }

    public static boolean gridVersionGreaterThan(GridObject gridObject, String string) {
        Version version = Common.getGridVersion(gridObject);
        return version.compareTo(new Version(string)) > 0;
    }

    public static boolean gridVersionGreaterThanOrEqual(GridObject gridObject, String string) {
        return !Common.gridVersionLesserThan(gridObject, string);
    }

    public static boolean gridVersionLesserThan(GridObject gridObject, String string) {
        Version version = Common.getGridVersion(gridObject);
        return version.compareTo(new Version(string)) < 0;
    }

    public static boolean gridVersionLesserThanOrEqual(GridObject gridObject, String string) {
        return !Common.gridVersionGreaterThan(gridObject, string);
    }

    public static boolean gridVersionEquals(GridObject gridObject, String string) {
        Version version = Common.getGridVersion(gridObject);
        return version.equals((Object)new Version(string));
    }

    public static boolean gridVersionInRange(GridObject gridObject, String string, String string2) {
        Version version = Common.getGridVersion(gridObject);
        Version version2 = new Version(string);
        Version version3 = new Version(string2);
        if (version2.equals((Object)version) || version3.equals((Object)version)) {
            return true;
        }
        return version.compareTo(version2) > 0 && version.compareTo(version3) < 0;
    }

    public static enum CheckIndex {
        MEMCONFIG_IDX,
        INSTDIR_IDX,
        TTINSTALL_IDX,
        TTSW_IDX,
        INSTALLLOC_IDX,
        FIRSTINST_IDX,
        INSTNAME_IDX,
        TTGROUP_IDX;

    }

    static class WizComponentListener
    implements ComponentListener {
        private boolean warningShown = false;

        WizComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (this.warningShown) {
                return;
            }
            if (MessageDialog.getPersistence().getConfirmed(Common.NEWGRID_CONFIRMATION_ID) != null) {
                return;
            }
            if (!Common.displayOptionalConfirm(Common.NEWGRID_CONFIRMATION_ID, componentEvent.getComponent(), Messages.getString("TimesTenGrid.pwdLessWarningGC"), Messages.getString("TimesTenGrid.pwdLessSSH"), null)) {
                TTGridWizMain.getInstance().getCurrentWizardDialog().dispose();
            }
            this.warningShown = true;
        }
    }

    public static class FromPerlException
    extends Exception {
        public FromPerlException(String string) {
            super(string);
        }
    }

    public static enum RepAgentStatus {
        UP,
        DOWN,
        NOT_APPLICABLE;


        public String toString() {
            switch (this) {
                case UP: {
                    return Messages.getString("TimesTenGrid.up");
                }
                case DOWN: {
                    return Messages.getString("TimesTenGrid.down");
                }
            }
            return "";
        }
    }

    public static enum TypePort {
        CSPORT,
        DAEMONPORT;

    }
}

