/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexInfo;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.javatools.dialogs.MessageDialog;

public class Constraint
implements Comparable<Constraint> {
    private String name;
    private IndexInfo.ConstraintType type;
    private String rName;
    private String rTableName;
    private List<Column> columns;
    private Constraint rConstraint;
    private boolean addConst;
    private static Logger _logger = Logger.getLogger(Constraint.class.getPackage().getName());

    public Constraint(String string, IndexInfo.ConstraintType constraintType, String string2) {
        this.name = string;
        this.type = constraintType;
        this.rName = string2;
        this.columns = new ArrayList<Column>();
    }

    public String getName() {
        return this.name;
    }

    public IndexInfo.ConstraintType getConstraintType() {
        return this.type;
    }

    public String getRName() {
        return this.rName;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getColumnStr() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.columns.isEmpty()) {
            stringBuilder.append(this.columns.get(0));
            for (int i = 1; i < this.columns.size(); ++i) {
                stringBuilder.append("," + this.columns.get(i));
            }
        }
        return stringBuilder.toString();
    }

    public boolean addConstraint() {
        return this.addConst;
    }

    public void setAddConstraint(boolean bl) {
        this.addConst = bl;
    }

    public Constraint getRConstraint() {
        return this.rConstraint;
    }

    public void setRConstraint(Constraint constraint) {
        this.rConstraint = constraint;
    }

    public String getRTableName() {
        return this.rTableName;
    }

    public void setRTableName(String string) {
        this.rTableName = string;
    }

    public void addColumn(String string, int n) {
        this.columns.add(new Column(string, n));
    }

    public boolean containsColumn(String string, int n) {
        return this.columns.contains(new Column(string, n));
    }

    public boolean equals(Object object) {
        try {
            Constraint constraint = (Constraint)object;
            return this.name.equalsIgnoreCase(constraint.getName()) && this.type == constraint.getConstraintType() && this.rName.equalsIgnoreCase(constraint.getRName());
        }
        catch (Exception exception) {
            _logger.log(Level.INFO, exception.getMessage());
            return false;
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Constraint constraint) {
        if (this.type == constraint.getConstraintType()) {
            if (this.name.equalsIgnoreCase(constraint.getName())) {
                return 0;
            }
            return this.name.compareToIgnoreCase(constraint.getName());
        }
        return Integer.valueOf(this.type.ordinal()).compareTo(constraint.getConstraintType().ordinal());
    }

    static class Column {
        private String name;
        private int position;

        public Column(String string, int n) {
            this.name = string;
            this.position = n;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean equals(Object object) {
            try {
                Column column = (Column)object;
                return this.name.equalsIgnoreCase(column.getName()) && this.position == column.getPosition();
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, exception.getMessage());
                return false;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum DistributionType {
        HASH(Messages.getString("PartitionTablePanel.distributedByHash")),
        DUPLICATE(Messages.getString("PartitionTablePanel.duplicate")),
        REFERENCE(Messages.getString("PartitionTablePanel.distributedByReference"));

        private final String text;

        private DistributionType(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class TableDistribution {
        DistributionType type;
        Constraint foreignKey;
        List<Column> hashColumns;

        public TableDistribution(DistributionType distributionType) {
            this.type = distributionType;
            this.hashColumns = new ArrayList<Column>();
        }

        public DistributionType getDistributionType() {
            return this.type;
        }

        public Constraint getForeignKey() {
            return this.foreignKey;
        }

        public void setForeignKey(Constraint constraint) {
            this.foreignKey = constraint;
        }

        public List<Column> getHashColumns() {
            return this.hashColumns;
        }

        public void setColumnHash(List<Column> list) {
            this.hashColumns = list;
        }

        public String getDDL() {
            StringBuilder stringBuilder = new StringBuilder("\n");
            stringBuilder.append("ALTER TABLE #TABLE# ");
            stringBuilder.append(this.type.toString().toUpperCase());
            if (this.type == DistributionType.HASH && !this.hashColumns.isEmpty()) {
                stringBuilder.append("(");
                stringBuilder.append(this.hashColumns.get(0));
                for (int i = 1; i < this.hashColumns.size(); ++i) {
                    stringBuilder.append(", " + this.hashColumns.get(i));
                }
                stringBuilder.append(")");
            } else if (this.type == DistributionType.REFERENCE) {
                stringBuilder.append("(");
                stringBuilder.append(this.foreignKey.getName());
                stringBuilder.append(")");
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
    }

    static class DistributedHashPanel
    extends ShuttlePanel<Column>
    implements ShuttleListener {
        private static final long serialVersionUID = 1L;

        public DistributedHashPanel() {
            super(null, Messages.getString("PartitionTablePanel.availableColumns"), Messages.getString("PartitionTablePanel.selectedColumns"));
        }

        public void refreshHashColumns(List<Column> list, List<Column> list2) {
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (Column column : list) {
                if (list2.contains(column)) continue;
                arrayList.add(column);
            }
            this.setFromList(arrayList);
            this.setToList(list2);
            this.getShuttle().addShuttleListener((ShuttleListener)this);
        }

        public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        }

        public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        }

        public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
        }

        public List<Column> getSelectedHashColumns() {
            return this.getToList();
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.shuttle.setEnabled(bl);
        }
    }

    static class DistributedReferencePanel
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private JComboBox<Constraint> foreignKeyCombo;
        private JTable constraintTable;
        private ConstraintJtableModel tableModel;
        private List<Constraint> constraints;
        private Constraint currentConstraint;

        public DistributedReferencePanel(List<Constraint> list) {
            this.constraints = list;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel(Messages.getString("TimesTen.common.FK"));
            this.foreignKeyCombo = new JComboBox();
            this.foreignKeyCombo.addItemListener(this);
            jPanel.add(jLabel);
            jPanel.add(this.foreignKeyCombo);
            this.tableModel = new ConstraintJtableModel();
            this.constraintTable = new JTable(this.tableModel);
            this.add((Component)jPanel, "North");
            this.add((Component)new JScrollPane(this.constraintTable), "Center");
        }

        @Override
        public void setEnabled(boolean bl) {
            this.foreignKeyCombo.setEnabled(bl);
            super.setEnabled(bl);
        }

        public void refreshFKValues(Constraint constraint) {
            this.foreignKeyCombo.removeAllItems();
            for (Constraint constraint2 : this.constraints) {
                if (constraint2.getConstraintType() != IndexInfo.ConstraintType.FOREIGN || !constraint2.addConstraint()) continue;
                this.foreignKeyCombo.addItem(constraint2);
            }
            if (constraint != null) {
                this.foreignKeyCombo.setSelectedItem(constraint);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.currentConstraint = (Constraint)this.foreignKeyCombo.getSelectedItem();
            this.tableModel.fireTableDataChanged();
        }

        public Constraint getCurrentConstraint() {
            return this.currentConstraint;
        }

        private class ConstraintJtableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private final String[] HEADER = new String[]{Messages.getString("PartitionTablePanel.localColumn"), Messages.getString("PartitionTablePanel.referencedColumn")};

            private ConstraintJtableModel() {
            }

            @Override
            public int getRowCount() {
                return DistributedReferencePanel.this.currentConstraint == null ? 0 : DistributedReferencePanel.this.currentConstraint.getColumns().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (DistributedReferencePanel.this.currentConstraint == null) {
                    return null;
                }
                if (n2 == 0) {
                    return DistributedReferencePanel.this.currentConstraint.getColumns().get(n);
                }
                if (n2 == 1) {
                    Constraint constraint = DistributedReferencePanel.this.currentConstraint.getRConstraint();
                    return constraint.getColumns().get(n);
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                return this.HEADER[n];
            }
        }
    }

    static class DistributionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private LoadTableRow table;
        private JLabel _distLabel;
        private JComboBox<DistributionType> _distComboBox;
        private DistributedHashPanel _distHashPanel;
        private DistributedReferencePanel _distRefPanel;

        public DistributionPanel(LoadTableRow loadTableRow) {
            this.table = loadTableRow;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            this._distComboBox = new JComboBox();
            this._distComboBox.addItem(DistributionType.DUPLICATE);
            this._distComboBox.addItem(DistributionType.HASH);
            this._distComboBox.addItem(DistributionType.REFERENCE);
            this._distLabel = new JLabel(Messages.getString("PartitionTablePanel.distributionMethod"));
            this._distLabel.setLabelFor(this._distComboBox);
            jPanel.add(this._distLabel);
            jPanel.add(this._distComboBox);
            this.add((Component)jPanel, "North");
            this._distHashPanel = new DistributedHashPanel();
            this._distRefPanel = new DistributedReferencePanel(this.table.getConstraints());
            this._distComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    BorderLayout borderLayout = (BorderLayout)this.getLayout();
                    Component component = borderLayout.getLayoutComponent("Center");
                    if (component != null) {
                        this.remove(component);
                    }
                    if (itemEvent.getItem().equals((Object)DistributionType.DUPLICATE)) {
                        this.revalidate();
                    } else if (itemEvent.getItem().equals((Object)DistributionType.HASH)) {
                        this.add((Component)((Object)_distHashPanel), "Center");
                        _distHashPanel.refreshHashColumns(table.getAvailableColumns(), table.getTableDistribution().getHashColumns());
                        this.revalidate();
                    } else if (itemEvent.getItem().equals((Object)DistributionType.REFERENCE)) {
                        this.add((Component)_distRefPanel, "Center");
                        _distRefPanel.refreshFKValues(table.getTableDistribution().getForeignKey());
                        this.revalidate();
                    }
                    this.invalidate();
                    this.repaint();
                }
            });
            this._distComboBox.setSelectedItem((Object)this.table.getTableDistribution().getDistributionType());
        }

        public TableDistribution getTableDistribution() {
            TableDistribution tableDistribution = null;
            tableDistribution = new TableDistribution((DistributionType)((Object)this._distComboBox.getSelectedItem()));
            if (this._distComboBox.getSelectedItem().equals((Object)DistributionType.HASH)) {
                tableDistribution.setColumnHash(this._distHashPanel.getSelectedHashColumns());
            } else if (this._distComboBox.getSelectedItem().equals((Object)DistributionType.REFERENCE)) {
                tableDistribution.setForeignKey(this._distRefPanel.getCurrentConstraint());
            }
            return tableDistribution;
        }

        public boolean validTableDistribution() {
            TableDistribution tableDistribution = this.getTableDistribution();
            if (tableDistribution == null) {
                MessageDialog.error((Component)this, (Object)Messages.getString("LoadTablesFromOracle.invalidTableDist"), (String)Messages.getString("TimesTen.common.error"), null);
                return false;
            }
            if (tableDistribution.getDistributionType() == DistributionType.REFERENCE && tableDistribution.getForeignKey() == null) {
                MessageDialog.error((Component)this, (Object)Messages.getString("LoadTablesFromOracle.invalidTableDistRef"), (String)Messages.getString("TimesTen.common.error"), null);
                return false;
            }
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this._distComboBox.setEnabled(bl);
            this._distHashPanel.setEnabled(bl);
            this._distRefPanel.setEnabled(bl);
        }
    }
}

