/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.help.HelpSystem;

public class TTProfilePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_PROFILE_NAME_LENGTH = 30;
    private static final int MIN_INT_PWD_PARAM_VAL = 1;
    private static final double MIN_PWD_PARAM_VAL = 1.15741E-5;
    private static final double MAX_PWD_PARAM_VAL = 1.06751991E8;
    private static final double SECONDS_IN_DAY = 86400.0;
    private static final String GET_NUM_PROFILE_DATA = "select resource_map.name, profile$.limit# from profile$, profname$, resource_map where profile$.profile# = profname$.profile# and profile$.resource# = resource_map.resource# and profile$.type# = 0 and resource_map.type# = 0 and profname$.name = ?";
    private static final String GET_STR_PROFILE_DATA = "select resource_name, limit from dba_profiles where profile = ? and resource_type = 'PASSWORD'";
    private static final String FAILED_LOGIN_ATTEMPTS = "FAILED_LOGIN_ATTEMPTS";
    private static final String PASSWORD_LIFE_TIME = "PASSWORD_LIFE_TIME";
    private static final String PASSWORD_REUSE_TIME = "PASSWORD_REUSE_TIME";
    private static final String PASSWORD_REUSE_MAX = "PASSWORD_REUSE_MAX";
    private static final String PASSWORD_LOCK_TIME = "PASSWORD_LOCK_TIME";
    private static final String PASSWORD_GRACE_TIME = "PASSWORD_GRACE_TIME";
    private static final String PASSWORD_COMPLEXITY_CHECKER = "PASSWORD_COMPLEXITY_CHECKER";
    private static final String TT_COMPLEXITY_CHECKER = "TT_COMPLEXITY_CHECKER";
    private static final String TT_STRONG_COMPLEXITY_CHECKER = "TT_STRONG_COMPLEXITY_CHECKER";
    private static final String TT_STIG_COMPLEXITY_CHECKER = "TT_STIG_COMPLEXITY_CHECKER";
    private JTextField profileNameTxtFld;
    private JComboBox<String> failedLoginAttemptsCmbBx;
    private JComboBox<String> pwdLifeTimeCmbBx;
    private JComboBox<String> pwdReuseTimeCmbBx;
    private JComboBox<String> pwdReuseMaxCmbBx;
    private JComboBox<String> pwdLockTimeCmbBx;
    private JComboBox<String> pwdGraceTimeCmbBx;
    private JComboBox<String> pwdComplexityCheckerCmbBx;
    private static final String DEFAULT = "DEFAULT";
    private static final String UNLIMITED = "UNLIMITED";
    private static final String NULL = "NULL";
    private final String[] PREDEFINED_OPTIONS = new String[]{"DEFAULT", "UNLIMITED"};
    private final String[] PREDEFINED_DEFAULT_PROFILE_OPTIONS = new String[]{"UNLIMITED"};
    private Connection connection;
    private String profile;
    private String[] pwdComplexityCheckers;
    private String[] pwdParamOptions;
    private static Logger logger = Logger.getLogger(TTProfilePanel.class.getName());

    public TTProfilePanel(Connection connection, String string) {
        this.connection = connection;
        this.profile = string;
        this.setPwdComplexityCheckers();
        this.init();
    }

    private void init() {
        this.pwdParamOptions = this.profile == null ? this.PREDEFINED_OPTIONS : (this.profile.equalsIgnoreCase(DEFAULT) ? this.PREDEFINED_DEFAULT_PROFILE_OPTIONS : this.PREDEFINED_OPTIONS);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.CREATE_PROFILE.toString());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        int n = 0;
        jPanel.setLayout(gridBagLayout);
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("TTCreateProfile.profileName"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.profileNameTxtFld = new JTextField();
        this.profileNameTxtFld.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.profileName"));
        jPanel.add((Component)this.profileNameTxtFld, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JSeparator(0), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(Messages.getString("TTCreateProfile.failedLoginAttempts"));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.failedLoginAttemptsCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.failedLoginAttemptsCmbBx.setEditable(true);
        this.failedLoginAttemptsCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.failedLoginAttempts"));
        jPanel.add(this.failedLoginAttemptsCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(Messages.getString("TTCreateProfile.pwdLifeTime"));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.pwdLifeTimeCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.pwdLifeTimeCmbBx.setEditable(true);
        this.pwdLifeTimeCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdLifeTime"));
        jPanel.add(this.pwdLifeTimeCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(Messages.getString("TTCreateProfile.pwdReuseTime"));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.pwdReuseTimeCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.pwdReuseTimeCmbBx.setEditable(true);
        this.pwdReuseTimeCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdReuseTime"));
        jPanel.add(this.pwdReuseTimeCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(Messages.getString("TTCreateProfile.pwdReuseMax"));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.pwdReuseMaxCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.pwdReuseMaxCmbBx.setEditable(true);
        this.pwdReuseMaxCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdReuseMax"));
        jPanel.add(this.pwdReuseMaxCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(Messages.getString("TTCreateProfile.pwdLockTime"));
        jPanel.add((Component)jLabel6, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.pwdLockTimeCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.pwdLockTimeCmbBx.setEditable(true);
        this.pwdLockTimeCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdLockTime"));
        jPanel.add(this.pwdLockTimeCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(Messages.getString("TTCreateProfile.pwdGraceTime"));
        jPanel.add((Component)jLabel7, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.pwdGraceTimeCmbBx = new JComboBox<String>(this.pwdParamOptions);
        this.pwdGraceTimeCmbBx.setEditable(true);
        this.pwdGraceTimeCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdGraceTime"));
        jPanel.add(this.pwdGraceTimeCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        if (this.pwdComplexityCheckers != null) {
            JLabel jLabel8 = new JLabel();
            jLabel8.setText(Messages.getString("TTCreateProfile.pwdComplexityChecker"));
            jPanel.add((Component)jLabel8, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.pwdComplexityCheckerCmbBx = new JComboBox<String>(this.pwdComplexityCheckers);
            this.pwdComplexityCheckerCmbBx.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateProfile.pwdComplexityChecker"));
            jPanel.add(this.pwdComplexityCheckerCmbBx, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        }
        this.add((Component)jPanel, "North");
        if (this.profile != null) {
            this.profileNameTxtFld.setText(this.profile);
            this.profileNameTxtFld.setEditable(false);
            this.populateProfileInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateProfileInfo() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            ProfileNumValues profileNumValues = this.getProfileNumericValues();
            statement = this.connection.prepareStatement(GET_STR_PROFILE_DATA);
            statement.setString(1, this.profile);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(2);
                boolean bl = this.isPredefinedValue(string);
                switch (resultSet.getString(1)) {
                    case "FAILED_LOGIN_ATTEMPTS": {
                        if (bl) {
                            this.failedLoginAttemptsCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.failedLoginAttemptsCmbBx.getEditor().setItem(profileNumValues.failedLoginAttempts);
                        break;
                    }
                    case "PASSWORD_LIFE_TIME": {
                        if (bl) {
                            this.pwdLifeTimeCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.pwdLifeTimeCmbBx.getEditor().setItem(profileNumValues.pwdLifeTime);
                        break;
                    }
                    case "PASSWORD_REUSE_TIME": {
                        if (bl) {
                            this.pwdReuseTimeCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.pwdReuseTimeCmbBx.getEditor().setItem(profileNumValues.pwdReuseTime);
                        break;
                    }
                    case "PASSWORD_REUSE_MAX": {
                        if (bl) {
                            this.pwdReuseMaxCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.pwdReuseMaxCmbBx.getEditor().setItem(profileNumValues.pwdReuseMax);
                        break;
                    }
                    case "PASSWORD_LOCK_TIME": {
                        if (bl) {
                            this.pwdLockTimeCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.pwdLockTimeCmbBx.getEditor().setItem(profileNumValues.pwdLockTime);
                        break;
                    }
                    case "PASSWORD_GRACE_TIME": {
                        if (bl) {
                            this.pwdGraceTimeCmbBx.getEditor().setItem(string);
                            break;
                        }
                        this.pwdGraceTimeCmbBx.getEditor().setItem(profileNumValues.pwdGraceTime);
                        break;
                    }
                    case "PASSWORD_COMPLEXITY_CHECKER": {
                        if (this.pwdComplexityCheckerCmbBx == null) break;
                        this.pwdComplexityCheckerCmbBx.setSelectedItem(string);
                        break;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            logger.severe("Error while getting user profile data: " + sQLException.getMessage());
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.severe("Error while closing Statement: " + sQLException.getMessage());
            }
        }
    }

    private ProfileNumValues getProfileNumericValues() throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ProfileNumValues profileNumValues = new ProfileNumValues();
        try {
            preparedStatement = this.connection.prepareStatement(GET_NUM_PROFILE_DATA);
            preparedStatement.setString(1, this.profile);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                switch (resultSet.getString(1)) {
                    case "FAILED_LOGIN_ATTEMPTS": {
                        profileNumValues.failedLoginAttempts = String.valueOf(resultSet.getLong(2));
                        break;
                    }
                    case "PASSWORD_LIFE_TIME": {
                        profileNumValues.pwdLifeTime = String.valueOf(this.toDays(resultSet.getLong(2)));
                        break;
                    }
                    case "PASSWORD_REUSE_TIME": {
                        profileNumValues.pwdReuseTime = String.valueOf(this.toDays(resultSet.getLong(2)));
                        break;
                    }
                    case "PASSWORD_REUSE_MAX": {
                        profileNumValues.pwdReuseMax = String.valueOf(resultSet.getLong(2));
                        break;
                    }
                    case "PASSWORD_LOCK_TIME": {
                        profileNumValues.pwdLockTime = String.valueOf(this.toDays(resultSet.getLong(2)));
                        break;
                    }
                    case "PASSWORD_GRACE_TIME": {
                        profileNumValues.pwdGraceTime = String.valueOf(this.toDays(resultSet.getLong(2)));
                        break;
                    }
                }
            }
            Object object = profileNumValues;
            return object;
        }
        catch (SQLException sQLException) {
            logger.severe("Error while getting user profile numeric data: " + sQLException.getMessage());
            throw sQLException;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                logger.severe("Error while closing Statement: " + sQLException.getMessage());
            }
        }
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- PROFILE SQL\n");
        if (this.profile != null) {
            stringBuffer.append("ALTER PROFILE \"");
        } else {
            stringBuffer.append("CREATE PROFILE \"");
        }
        stringBuffer.append(this.profileNameTxtFld.getText());
        stringBuffer.append("\" LIMIT \n");
        stringBuffer.append("FAILED_LOGIN_ATTEMPTS ");
        stringBuffer.append(this.failedLoginAttemptsCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        stringBuffer.append("PASSWORD_LIFE_TIME ");
        stringBuffer.append(this.pwdLifeTimeCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        stringBuffer.append("PASSWORD_REUSE_TIME ");
        stringBuffer.append(this.pwdReuseTimeCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        stringBuffer.append("PASSWORD_REUSE_MAX ");
        stringBuffer.append(this.pwdReuseMaxCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        stringBuffer.append("PASSWORD_LOCK_TIME ");
        stringBuffer.append(this.pwdLockTimeCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        stringBuffer.append("PASSWORD_GRACE_TIME ");
        stringBuffer.append(this.pwdGraceTimeCmbBx.getEditor().getItem().toString().trim());
        stringBuffer.append(" \n");
        if (this.pwdComplexityCheckerCmbBx != null) {
            stringBuffer.append("PASSWORD_COMPLEXITY_CHECKER ");
            stringBuffer.append(this.pwdComplexityCheckerCmbBx.getSelectedItem());
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }

    private void setPwdComplexityCheckers() {
        if (DataSheet.pwdComplexityCheckerFunctionsSupported(this.connection)) {
            this.pwdComplexityCheckers = this.profile != null && this.profile.equalsIgnoreCase(DEFAULT) ? new String[]{TT_COMPLEXITY_CHECKER, TT_STRONG_COMPLEXITY_CHECKER, TT_STIG_COMPLEXITY_CHECKER, NULL} : new String[]{DEFAULT, TT_COMPLEXITY_CHECKER, TT_STRONG_COMPLEXITY_CHECKER, TT_STIG_COMPLEXITY_CHECKER, NULL};
        }
    }

    public boolean validInput() {
        int n;
        String string = this.profileNameTxtFld.getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TTCreateProfile.emptyProfileName"));
            return false;
        }
        if (string.length() > 30) {
            Common.displayErrorMsg(this, MessageFormat.format(Messages.getString("TTCreateProfile.maxLenExceedProfileName"), 30));
            return false;
        }
        string = this.failedLoginAttemptsCmbBx.getEditor().getItem().toString().trim();
        if (!string.equalsIgnoreCase(DEFAULT) && !string.equalsIgnoreCase(UNLIMITED)) {
            try {
                n = Integer.valueOf(string);
                if (n < 1) {
                    this.displayIntPwdParamErrorMsg("TTCreateProfile.errorFailedLoginAtt");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayIntPwdParamErrorMsg("TTCreateProfile.errorFailedLoginAtt");
                return false;
            }
        }
        if (!(string = this.pwdLifeTimeCmbBx.getEditor().getItem().toString().trim()).equalsIgnoreCase(DEFAULT) && !string.equalsIgnoreCase(UNLIMITED)) {
            try {
                Double d = new Double(string);
                if (d < 1.15741E-5 || d > 1.06751991E8) {
                    this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdLifeTime");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdLifeTime");
                return false;
            }
        }
        if (!(string = this.pwdReuseTimeCmbBx.getEditor().getItem().toString().trim()).equalsIgnoreCase(DEFAULT) && !string.equalsIgnoreCase(UNLIMITED)) {
            try {
                Double d = new Double(string);
                if (d < 1.15741E-5 || d > 1.06751991E8) {
                    this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdReuseTime");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdReuseTime");
                return false;
            }
        }
        if (!(string = this.pwdReuseMaxCmbBx.getEditor().getItem().toString().trim()).equalsIgnoreCase(DEFAULT) && !string.equals(UNLIMITED)) {
            try {
                n = Integer.parseInt(string);
                if (n < 1) {
                    this.displayIntPwdParamErrorMsg("TTCreateProfile.errorPwdReuseMax");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayIntPwdParamErrorMsg("TTCreateProfile.errorPwdReuseMax");
                return false;
            }
        }
        if (!(string = this.pwdLockTimeCmbBx.getEditor().getItem().toString().trim()).equalsIgnoreCase(DEFAULT) && !string.equalsIgnoreCase(UNLIMITED)) {
            try {
                Double d = new Double(string);
                if (d < 1.15741E-5 || d > 1.06751991E8) {
                    this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdLockTime");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdLockTime");
                return false;
            }
        }
        if (!(string = this.pwdGraceTimeCmbBx.getEditor().getItem().toString().trim()).equalsIgnoreCase(DEFAULT) && !string.equalsIgnoreCase(UNLIMITED)) {
            try {
                Double d = new Double(string);
                if (d < 1.15741E-5 || d > 1.06751991E8) {
                    this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdGraceTime");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayPwdParamErrorMsg("TTCreateProfile.errorPwdGraceTime");
                return false;
            }
        }
        return true;
    }

    private void displayPwdParamErrorMsg(String string) {
        Common.displayErrorMsg(this, MessageFormat.format(Messages.getString(string), String.valueOf(1.15741E-5), 1.06751991E8));
    }

    private void displayIntPwdParamErrorMsg(String string) {
        Common.displayErrorMsg(this, MessageFormat.format(Messages.getString(string), 1));
    }

    private String toDays(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##########");
        decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        return decimalFormat.format((double)l / 86400.0);
    }

    private boolean isPredefinedValue(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(DEFAULT) || string.equalsIgnoreCase(UNLIMITED) || string.equalsIgnoreCase(NULL);
    }

    private static class ProfileNumValues {
        String failedLoginAttempts;
        String pwdGraceTime;
        String pwdLifeTime;
        String pwdLockTime;
        String pwdReuseMax;
        String pwdReuseTime;

        private ProfileNumValues() {
        }
    }
}

