/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.controls.celleditor.popups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.ide.util.ResourceUtils;

public class TTDateTimeEditPanel
extends AbstractPopupCellEditor {
    protected DateEditor dateEditor = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected boolean _canChange = false;
    private Connection m_conn = null;
    private static Logger theLogger = Logger.getLogger(TTDateTimeEditPanel.class.getPackage().getName());

    public void createDateTimeEditPanel(Timestamp timestamp, boolean bl, Connection connection) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.createDateEditor(timestamp);
        this.add((Component)this.dateEditor, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.getButtonPanel(), gridBagConstraints);
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)Messages.getString("TTDateTimeEditPanel.1"));
        this.setTodayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTDateTimeEditPanel.this.dateEditor.setCalendar(Calendar.getInstance());
                String string = TTDateTimeEditPanel.this.getTSFormat(new Timestamp(System.currentTimeMillis()));
                TTDateTimeEditPanel.this.dateEditor.setDateFormat((DateFormat)new SimpleDateFormat(string));
            }
        });
        this.setTodayButton.setEnabled(this._canChange);
        return this.setTodayButton;
    }

    private void createDateEditor(Timestamp timestamp) {
        String string = this.getTSFormat(timestamp);
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0);
        }
        this.dateEditor = new DateEditor((java.util.Date)timestamp, Calendar.getInstance(), (DateFormat)simpleDateFormat);
    }

    private String getTSFormat(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(14, timestamp.getNanos() / 1000000);
        String string = "yyyy-MM-dd HH:mm:ss.SSS";
        if (calendar.get(0) == 0) {
            string = "-yyyy-MM-dd HH:mm:ss.SSS";
        }
        return string;
    }

    private String getTSFormat(Calendar calendar) {
        String string = "yyyy-MM-dd HH:mm:ss.SSS";
        if (calendar.get(0) == 0) {
            string = "-yyyy-MM-dd HH:mm:ss.SSS";
        }
        return string;
    }

    public void dismissPopupEditor() {
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getDefaultComponent() {
        return this.dateEditor;
    }

    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    public Object getValue() {
        Calendar calendar = this.dateEditor.getCalendar();
        String string = this.getTSFormat(calendar);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        String string2 = simpleDateFormat.format(calendar.getTimeInMillis());
        return string2.toUpperCase();
    }

    public boolean isNULL() {
        return false;
    }

    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }

    public void setValue(Object object) {
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new java.util.Date().getTime());
        } else if (object instanceof Date) {
            object = new Timestamp(((java.util.Date)object).getTime());
        } else if (object instanceof String) {
            String string = (String)object;
            boolean bl = false;
            if (string.charAt(0) == '-') {
                bl = true;
                string = string.substring(1);
            }
            try {
                object = Timestamp.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    object = Date.valueOf(string);
                    object = new Timestamp(((Date)object).getTime());
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        object = Time.valueOf(string);
                        object = new Timestamp(((Time)object).getTime());
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
            }
            Timestamp timestamp = null;
            try {
                timestamp = (Timestamp)object;
            }
            catch (Exception exception) {
                object = null;
            }
            if (timestamp != null && bl) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(timestamp.getTime());
                calendar.set(0, 0);
                calendar.set(14, timestamp.getNanos() / 1000000);
                object = new Timestamp(calendar.getTimeInMillis());
                ((Timestamp)object).setNanos(timestamp.getNanos());
            }
        } else {
            theLogger.log(Level.SEVERE, "Unexpected object type: " + object.getClass().getName());
        }
        try {
            if (object == null || object.toString().equals("")) {
                object = new Timestamp(new java.util.Date().getTime());
            }
            this.createDateTimeEditPanel((Timestamp)object, this._canChange, this.m_conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String validateValue() {
        return null;
    }

    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    public boolean isEditable() {
        return this._canChange;
    }

    public void setEditable(boolean bl) {
        this._canChange = bl;
    }
}

