/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.connections.db.AbstractConnectionCreator;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;

public class TimesTenConnectionCreator
extends AbstractConnectionCreator {
    public static final String SUBTYPE_THIRD_PARTY = "TimesTen";
    private static final Logger LOGGER = Logger.getLogger(TimesTenConnectionCreator.class.getPackage().getName());
    public static final String ORACLE_PWD_KEY = "sys2";
    public static final String ORACLE_NSN_KEY = "ORANETSERVICENAME";
    public static final String ORACLE_USER_KEY = "user";
    public static final String TIMESTEN_USER_KEY = "ttuser";
    private static final int ACADIA_MIN_SUPPORTED_MAJOR1 = 18;
    public static final String ACADIA_PROP = "isAcadia";
    public static boolean IS_TIMESTEN = false;

    protected void setCustomProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties2.getProperty(string) != null) continue;
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    protected boolean allowNullPassword() {
        return true;
    }

    public boolean shouldEncrypt(String string) {
        if (string.equals("oraclePassword")) {
            return true;
        }
        return super.shouldEncrypt(string);
    }

    public boolean shouldPromptForPassword(Properties properties) {
        boolean bl = TimesTenConnectionCreator.shouldPromptForPasswordImpl(properties);
        return bl;
    }

    public static boolean shouldPromptForPasswordImpl(Properties properties) {
        String string = properties.getProperty(ORACLE_USER_KEY);
        String string2 = properties.getProperty("password");
        TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
        boolean bl = tTInstanceInformation.accessControlEnabled();
        if (bl) {
            if (string == null) {
                return false;
            }
            if (string.length() == 0 || string.equals(TimesTenConnectionCreator.getCurrentUserName())) {
                return false;
            }
            if (string2 == null) {
                return true;
            }
        }
        return false;
    }

    private static String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        Version version;
        int[] nArray;
        Object object;
        Object object2;
        String string;
        X10ConnectionProperties x10ConnectionProperties = X10ConnectionProperties.getTheInstance();
        IS_TIMESTEN = true;
        String string2 = properties.getProperty("ConnName");
        String string3 = properties.getProperty("password");
        String string4 = properties.getProperty(ORACLE_USER_KEY);
        if (string2 == null) {
            string = properties.getProperty("URL");
            object2 = string.split("[;=]+");
            string2 = "";
            for (int i = 0; i < ((String[])object2).length - 1; ++i) {
                if (!object2[i].equalsIgnoreCase("ConnectionName")) continue;
                string2 = object2[i + 1];
                break;
            }
        }
        x10ConnectionProperties.addProperty(string2, TIMESTEN_USER_KEY, string4);
        if (string3 != null) {
            x10ConnectionProperties.addProperty(string2, "sys1", string3);
        }
        if ((string3 = properties.getProperty("oraclePassword")) != null) {
            x10ConnectionProperties.addProperty(string2, ORACLE_PWD_KEY, string3);
            properties.setProperty("oraclePassword", string3);
            x10ConnectionProperties.addProperty(string2, ORACLE_NSN_KEY, properties.getProperty(ORACLE_NSN_KEY));
            x10ConnectionProperties.addProperty(string2, ORACLE_USER_KEY, string4);
        } else if (x10ConnectionProperties.getProperty(string2, ORACLE_PWD_KEY) != null) {
            x10ConnectionProperties.removeProperty(string2, ORACLE_PWD_KEY);
            x10ConnectionProperties.removeProperty(string2, ORACLE_NSN_KEY);
            x10ConnectionProperties.removeProperty(string2, ORACLE_USER_KEY);
        }
        string = properties.getProperty("AUTOCOMMIT");
        if (string != null) {
            x10ConnectionProperties.addProperty(string2, "AUTOCOMMIT", string);
        }
        object2 = super.getConnection(properties);
        StringBuilder stringBuilder = new StringBuilder();
        for (SQLWarning sQLWarning = object2.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            final String string5 = string2;
            object = sQLWarning;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ SQLWarning val$wrng;
                {
                    this.val$wrng = sQLWarning;
                }

                @Override
                public void run() {
                    SQLErrorDialog.showWarningDialog((String)string5, null, (SQLWarning)this.val$wrng);
                }
            });
        }
        if (string4.isEmpty() && string3 != null) {
            x10ConnectionProperties.addProperty(string2, ORACLE_USER_KEY, object2.getMetaData().getUserName());
        }
        boolean bl = false;
        object = TimesTenUtil.ttFullDotVersion((Connection)object2);
        if (object != null && (nArray = (version = new Version((String)object)).toIntArray()) != null && nArray.length > 0) {
            bl = nArray[0] >= 18;
        }
        x10ConnectionProperties.addProperty(string2, ACADIA_PROP, String.valueOf(bl));
        return object2;
    }
}

