/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.connection.TTComponentView;
import oracle.dbtools.raptor.timesten.connection.TTConnectionPanel;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionType;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public class TTCSPanel
extends JPanel
implements TTComponentView {
    private static final int MIN_TIMEOUT_VALUE = 0;
    private static final int MAX_TIMEOUT_VALUE = 99999;
    private static final String[] ERROR_STRINGS = new String[]{Messages.getString("TTConnectionPanel.DSNcannotBeNULL"), Messages.getString("TTConnectionPanel.hostnameCannotBeNULL"), Messages.getString("TTConnectionPanel.portCannotBeNULL"), Messages.getString("TTConnectionPanel.portCannotBeAString"), Messages.getString("TTConnectionPanel.OraclePwdnull"), Messages.getString("TTConnectionPanel.timeoutCannotBeAString"), Messages.getString("TTConnectionPanel.wrongTimeoutRange")};
    private JLabel theServerLbl = new JLabel();
    protected JTextField theServerJTF = new JTextField(15);
    private JLabel theDSNLbl = new JLabel();
    protected JTextField theDSNJTF = new JTextField(15);
    private JLabel thePortLbl = new JLabel();
    protected JTextField theTimeoutJTF = new JTextField(15);
    private JLabel theTimeoutLbl = new JLabel();
    protected JTextField thePortJTF = new JTextField(15);
    private JLabel cachePWDLabel = new JLabel(Messages.getString("TTConnectionPanel.oraclePassword"));
    protected JPasswordField theCachePWDField = new JPasswordField(16);
    protected JCheckBox theEnableOraclePwdJCB = new JCheckBox();
    private JLabel theEnableOraclePwdLabel = new JLabel();
    public static final String ORACLE_PWD = "oraclePassword";
    private TTConnectionPanel theConnPanel;
    private JLabel theOraServiceNameLbl = new JLabel();
    protected JTextField theOraServiceNameJTF = new JTextField(15);

    public TTCSPanel(TTConnectionPanel tTConnectionPanel) {
        try {
            this.theConnPanel = tTConnectionPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void clear() {
        this.theServerJTF.setText("");
        this.theDSNJTF.setText("");
        this.thePortJTF.setText("");
        this.theOraServiceNameJTF.setText("");
    }

    @Override
    public void populateComponent(Properties properties) throws ConnectionException {
        String string = this.getDSNUrl();
        properties.put("URL", string);
        properties.put("customUrl", string);
        if (this.theEnableOraclePwdJCB.isSelected()) {
            String string2 = new String(this.theCachePWDField.getPassword());
            if (string2.length() <= 0) {
                this.theConnPanel.setErrorStatus(ERROR_STRINGS[4]);
                throw new ConnectionException(ERROR_STRINGS[4]);
            }
            properties.put(ORACLE_PWD, string2);
            if (this.theOraServiceNameJTF.getText().length() > 0) {
                properties.put("ORANETSERVICENAME", this.theOraServiceNameJTF.getText().toUpperCase().trim());
            }
        }
        properties.put("ENABLECACHE", Boolean.toString(this.theEnableOraclePwdJCB.isSelected()));
        properties.setProperty("TimesTenConnectionType", TimesTenConnectionType.CLIENTSERVER.name());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.theServerLbl, (Component)this.theServerJTF, (String)Messages.getString("TTConnectionPanel.serverhostname"));
        ResourceUtils.resLabel((JLabel)this.theDSNLbl, (Component)this.theDSNJTF, (String)Messages.getString("TTConnectionPanel.serverdsn"));
        ResourceUtils.resLabel((JLabel)this.thePortLbl, (Component)this.thePortJTF, (String)Messages.getString("TTConnectionPanel.serverport"));
        ResourceUtils.resLabel((JLabel)this.theTimeoutLbl, (Component)this.theTimeoutJTF, (String)Messages.getString("TTConnectionPanel.timeout"));
        Insets insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.theServerLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.add((Component)this.theServerJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        this.add((Component)this.theDSNLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.add((Component)this.theDSNJTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        this.add((Component)this.thePortLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.add((Component)this.thePortJTF, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        this.add((Component)this.theTimeoutLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.add((Component)this.theTimeoutJTF, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theEnableOraclePwdLabel, (Component)this.theEnableOraclePwdJCB, (String)Messages.getString("TTConnectionPanel.enableCacheFromOracle"));
        this.add((Component)this.theEnableOraclePwdLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theEnableOraclePwdJCB, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.cachePWDLabel, (Component)this.theCachePWDField, (String)Messages.getString("TTConnectionPanel.oraclePassword"));
        this.add((Component)this.cachePWDLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theCachePWDField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theOraServiceNameLbl, (Component)this.theOraServiceNameJTF, (String)Messages.getString("TTConnectionPanel.oracleServiceName"));
        this.add((Component)this.theOraServiceNameLbl, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theOraServiceNameJTF, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.theServerJTF.setText("localhost");
        this.thePortJTF.setText("6625");
        this.theCachePWDField.setEnabled(false);
        this.theOraServiceNameJTF.setEnabled(false);
        this.theEnableOraclePwdJCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                System.err.println(itemEvent.getStateChange());
                if (itemEvent.getStateChange() == 1) {
                    TTCSPanel.this.theCachePWDField.setEnabled(true);
                    TTCSPanel.this.theOraServiceNameJTF.setEnabled(true);
                } else {
                    TTCSPanel.this.theCachePWDField.setEnabled(false);
                    TTCSPanel.this.theOraServiceNameJTF.setEnabled(false);
                    TTCSPanel.this.cleanCacheParameters();
                }
            }
        });
    }

    private String getDSNUrl() throws ConnectionException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = this.theOraServiceNameJTF.getText().toUpperCase().trim();
        Object object = "";
        if (this.theEnableOraclePwdJCB.isSelected() && (string != null || string.length() > 0)) {
            object = "OracleNetServiceName=" + string + ";";
        }
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer2.append("jdbc:timesten:");
        String string2 = this.theDSNJTF.getText();
        String string3 = this.theServerJTF.getText();
        String string4 = this.thePortJTF.getText();
        String string5 = this.theTimeoutJTF.getText();
        if (string2 == null || string2.length() < 1) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[0]);
            throw new ConnectionException(ERROR_STRINGS[0]);
        }
        stringBuffer.append("ttc_server_dsn=" + string2);
        if (string3 == null || string3.length() < 1) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[1]);
            throw new ConnectionException(ERROR_STRINGS[1]);
        }
        stringBuffer.append(";ttc_server=" + string3);
        if (string4 == null || string4.length() < 1) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[2]);
            throw new ConnectionException(ERROR_STRINGS[2]);
        }
        try {
            Integer n = new Integer(string4);
            stringBuffer.append(";tcp_port=" + string4);
        }
        catch (NumberFormatException numberFormatException) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[3]);
            throw new ConnectionException(ERROR_STRINGS[3]);
        }
        if (string5 != null && !string5.isEmpty()) {
            try {
                int n = Integer.parseInt(string5);
                if (n < 0 || n > 99999) {
                    this.theConnPanel.setErrorStatus(ERROR_STRINGS[6]);
                    throw new ConnectionException(ERROR_STRINGS[6]);
                }
                stringBuffer.append(";ttc_timeout=" + n);
            }
            catch (NumberFormatException numberFormatException) {
                this.theConnPanel.setErrorStatus(ERROR_STRINGS[5]);
                throw new ConnectionException(ERROR_STRINGS[5]);
            }
        }
        stringBuffer2.append(bl ? "client:" : "direct:");
        stringBuffer2.append(stringBuffer.toString());
        if (!stringBuffer.toString().endsWith(";")) {
            stringBuffer2.append(";");
        }
        stringBuffer2.append((String)object);
        stringBuffer2.append("ConnectionName=");
        stringBuffer2.append(this.theConnPanel.getConnectionName());
        return stringBuffer2.toString();
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    public void cleanCacheParameters() {
        this.theCachePWDField.setText("");
        this.theOraServiceNameJTF.setText("");
    }
}

