/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.TTComponentView;
import oracle.dbtools.raptor.timesten.connection.TTConnectionPanel;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionType;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public class TTBasicPanel
extends JPanel
implements TTComponentView {
    private static final String[] ERROR_STRINGS = new String[]{Messages.getString("TTConnectionPanel.ConnectionCannotBeEmptyForUserSpecifiedDSN"), Messages.getString("TTConnectionPanel.ConnectionStringNeedsToIncludeDSNAttribure"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainDSNAttribute"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainOraclePWD"), Messages.getString("TTConnectionPanel.AccessControlIsEnabledUsernameORPassword"), Messages.getString("TTConnectionPanel.OraclePwdnull")};
    private TTInstanceInformation theInstance;
    public static final String ORACLE_PWD = "oraclePassword";
    private static final String TIMESTEN_DRIVERS_REGEX = TimesTenUtil.getRegExForSupportedDrivers();
    private static final Pattern TIMESTEN_DRIVERS_REGEX_PATTERN = Pattern.compile(TIMESTEN_DRIVERS_REGEX, 2);
    private static final String ODBC_REGISTRY_KEY = "SOFTWARE\\ODBC\\ODBC.INI";
    private static final String ODBC_DATA_SOURCES_REGISTRY_KEY = "\\ODBC Data Sources";
    private static final String ACADIA_DEFAULT_SYSODBCINI_DIR = "conf";
    private static final String DEFAULT_USER_ODBCINI_FILE = ".odbc.ini";
    private static final String DEFAULT_SYSTEM_ODBCINI_FILE = "sys.odbc.ini";
    private static final String DEFAULT_SYSTEM_INIFILE = "/var/TimesTen/sys.odbc.ini";
    private static final String COMMON_INIFILE = "/etc/odbc.ini";
    private static final String DATA_SOURCES_SECTION_REGEX = "\\[ODBC\\s+Data\\s+Sources\\]";
    public static final String DIRECT_DRIVER_CLASSNAME = "com.timesten.jdbc.TimesTenDriver";
    private List<String> theClientDSN = new ArrayList<String>(8);
    protected List theCompleteDSNList = new ArrayList(32);
    private static Logger theLogger = Logger.getLogger(TTBasicPanel.class.getPackage().getName());
    private JLabel theDSNLabel = new JLabel("DSN");
    protected JComboBox theDsnListJCB;
    private JLabel theConnAttribLabel = new JLabel(Messages.getString("TTConnectionPanel.connAttributes"));
    protected JTextField theConnectionAttribJTF = new JTextField(15);
    private JLabel cachePWDLabel = new JLabel(Messages.getString("TTConnectionPanel.oraclePassword"));
    protected JPasswordField theCachePWDField = new JPasswordField(16);
    protected JCheckBox theEnableOraclePwdJCB = new JCheckBox();
    private JLabel theEnableOraclePwdLabel = new JLabel();
    private TTConnectionPanel theConnPanel;
    private JLabel theOraServiceNameLbl = new JLabel();
    protected JTextField theOraServiceNameJTF = new JTextField(15);

    public TTBasicPanel(TTConnectionPanel tTConnectionPanel, TTInstanceInformation tTInstanceInformation) {
        try {
            this.theConnPanel = tTConnectionPanel;
            this.theInstance = tTInstanceInformation;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void clear() {
        this.theDsnListJCB.setSelectedIndex(-1);
        this.theConnectionAttribJTF.setText("");
        this.theOraServiceNameJTF.setText("");
    }

    @Override
    public void populateComponent(Properties properties) throws ConnectionException {
        String string = this.getDSNUrl();
        properties.put("URL", string);
        properties.put("customUrl", string);
        if (this.theEnableOraclePwdJCB.isSelected()) {
            String string2 = new String(this.theCachePWDField.getPassword());
            if (string2.length() <= 0) {
                this.theConnPanel.setErrorStatus(ERROR_STRINGS[5]);
                throw new ConnectionException(ERROR_STRINGS[5]);
            }
            properties.put(ORACLE_PWD, string2);
            if (this.theOraServiceNameJTF.getText().length() > 0) {
                properties.put("ORANETSERVICENAME", this.theOraServiceNameJTF.getText().toUpperCase().trim());
            }
        }
        properties.put("ENABLECACHE", Boolean.toString(this.theEnableOraclePwdJCB.isSelected()));
        this.theConnPanel.suppressPasswordAndUserName(properties, TTBasicPanel.isCSUrl(string));
        properties.setProperty("TimesTenConnectionType", TimesTenConnectionType.DIRECT.name());
    }

    private void jbInit() throws Exception {
        if (this.theDsnListJCB == null) {
            this.theDsnListJCB = new JComboBox();
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                this.processWindowsDsn();
            } else {
                this.processUnixDsn();
            }
        }
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.theDSNLabel, (Component)this.theDsnListJCB, (String)"DSN");
        ResourceUtils.resLabel((JLabel)this.theConnAttribLabel, (Component)this.theConnectionAttribJTF, (String)Messages.getString("TTConnectionPanel.connAttributes"));
        Insets insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.theDSNLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theDsnListJCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this.theConnAttribLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theConnectionAttribJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theEnableOraclePwdLabel, (Component)this.theEnableOraclePwdJCB, (String)Messages.getString("TTConnectionPanel.enableCacheFromOracle"));
        this.add((Component)this.theEnableOraclePwdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theEnableOraclePwdJCB, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.cachePWDLabel, (Component)this.theCachePWDField, (String)Messages.getString("TTConnectionPanel.oraclePassword"));
        this.add((Component)this.cachePWDLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theCachePWDField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theOraServiceNameLbl, (Component)this.theOraServiceNameJTF, (String)Messages.getString("TTConnectionPanel.oracleServiceName"));
        this.add((Component)this.theOraServiceNameLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theOraServiceNameJTF, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.theCachePWDField.setEnabled(false);
        this.theOraServiceNameJTF.setEnabled(false);
        this.theEnableOraclePwdJCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                System.err.println(itemEvent.getStateChange());
                if (itemEvent.getStateChange() == 1) {
                    TTBasicPanel.this.theCachePWDField.setEnabled(true);
                    TTBasicPanel.this.theOraServiceNameJTF.setEnabled(true);
                } else {
                    TTBasicPanel.this.theCachePWDField.setEnabled(false);
                    TTBasicPanel.this.theOraServiceNameJTF.setEnabled(false);
                    TTBasicPanel.this.cleanCacheParameters();
                }
            }
        });
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    public static boolean isCSUrl(String string) {
        return string.indexOf(":client:") != -1;
    }

    private String getDSNUrl() throws ConnectionException {
        boolean bl = false;
        Object object = this.theConnectionAttribJTF.getText().toUpperCase().trim();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("jdbc:timesten:");
        String string = this.theDsnListJCB.getSelectedItem().toString();
        String string2 = this.theOraServiceNameJTF.getText().toUpperCase().trim();
        Object object2 = "";
        if (this.theEnableOraclePwdJCB.isSelected() && (string2 != null || string2.length() > 0)) {
            object2 = "OracleNetServiceName=" + string2 + ";";
        }
        if (((String)object).indexOf("DSN=") != -1) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[2]);
            throw new ConnectionException(ERROR_STRINGS[2]);
        }
        if (this.theConnPanel.hasPassword((String)object)) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[3]);
            throw new ConnectionException(ERROR_STRINGS[3]);
        }
        bl = this.isCSDsn(string);
        stringBuffer.append(bl ? "client:" : "direct:");
        object = "DSN=" + string + ";" + (String)object;
        stringBuffer.append((String)object);
        if (!((String)object).endsWith(";")) {
            stringBuffer.append(";");
        }
        stringBuffer.append((String)object2);
        stringBuffer.append("ConnectionName=");
        stringBuffer.append(this.theConnPanel.getConnectionName());
        return stringBuffer.toString();
    }

    private List<String> getUnixODBCFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        try {
            String string = System.getProperty("user.home");
            String string2 = string + "/.odbc.ini";
            String string3 = System.getProperty("ODBCINI", string2);
            theLogger.log(Level.INFO, "Using ODBCINI file" + string3);
            arrayList.add(string3);
            Object object = this.theInstance.getEffectiveInstanceHome() + "/conf";
            if (!new File((String)object).exists()) {
                theLogger.log(Level.INFO, "conf directory is not present.");
                object = this.theInstance.getEffectiveDaemonHome();
                if (object == null || ((String)object).equals("")) {
                    object = this.theInstance.getEffectiveInstanceHome() + "/info";
                }
            } else {
                theLogger.log(Level.INFO, "conf directory is present.");
            }
            String string4 = (String)object + "/sys.odbc.ini";
            String string5 = System.getProperty("SYSODBCINI", string4);
            theLogger.log(Level.INFO, "Using SYSODBCINI file" + string5);
            arrayList.add(string5);
            arrayList.add(DEFAULT_SYSTEM_INIFILE);
            arrayList.add(COMMON_INIFILE);
            return arrayList;
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot access one or more system properties, DSN list may be incomplete", exception);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getDsnListFromOdbcIniFile(String string) {
        Object[] objectArray = new Object[2];
        ArrayList<String> arrayList = new ArrayList<String>(8);
        ArrayList<String> arrayList2 = new ArrayList<String>(8);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return objectArray;
        }
        try {
            String string2;
            theLogger.info("Processing" + string);
            bufferedReader = new BufferedReader(fileReader);
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.length() <= 0 || string2.matches("\\s*#.*")) continue;
                if (string2.matches("\\s*\\[.*\\]") && bl) {
                    break;
                }
                if (string2.matches(DATA_SOURCES_SECTION_REGEX)) {
                    theLogger.info("Found data store section<" + string2 + ">");
                    bl = true;
                    continue;
                }
                if (!bl || (stringArray = string2.split("=")).length != 2 || !TIMESTEN_DRIVERS_REGEX_PATTERN.matcher(stringArray[1]).matches()) continue;
                arrayList.add(stringArray[0].trim());
                if (stringArray[1].toUpperCase().indexOf("CLIENT") == -1) continue;
                arrayList2.add(stringArray[0].trim());
            }
        }
        catch (IOException iOException) {
            theLogger.log(Level.WARNING, "Unexpected IO error", iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return objectArray;
    }

    private void processUnixDsn() {
        List<String> list = this.getUnixODBCFiles();
        for (String string : list) {
            Object[] objectArray = TTBasicPanel.getDsnListFromOdbcIniFile(string);
            List list2 = (List)objectArray[0];
            List list3 = (List)objectArray[1];
            for (String string2 : list2) {
                if (this.theCompleteDSNList.contains(string2)) continue;
                this.theCompleteDSNList.add(string2);
            }
            this.theClientDSN.addAll(list3);
        }
        Collections.sort(this.theCompleteDSNList);
        for (String string : this.theCompleteDSNList) {
            this.theDsnListJCB.addItem(string);
        }
    }

    private void processWindowsDsn() {
        NativeHandler nativeHandler = new NativeHandler();
        nativeHandler.initialize();
        this.processWindowsSystemDsn(nativeHandler);
        this.processWindowsUserDsn(nativeHandler);
        Collections.sort(this.theCompleteDSNList);
        for (Object e : this.theCompleteDSNList) {
            this.theDsnListJCB.addItem(e);
        }
        try {
            Class<?> clazz = Class.forName(DIRECT_DRIVER_CLASSNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processWindowsSystemDsn(NativeHandler nativeHandler) {
        try {
            RegistryKey registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(ODBC_REGISTRY_KEY, 131097L);
            Iterator iterator = registryKey.iterateSubKeys();
            Object var4_6 = null;
            String string = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
            RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string, 131097L);
            this.addToWindowsDsnList(iterator, registryKey2);
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            theLogger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
        }
        catch (RegistryException registryException) {
            theLogger.log(Level.WARNING, registryException.getStackTrace()[0].toString(), registryException);
        }
    }

    private void processWindowsUserDsn(NativeHandler nativeHandler) {
        try {
            RegistryKey registryKey = NativeHandler.getRegistry().getCurrentUserKey().openKey(ODBC_REGISTRY_KEY, 131097L);
            Iterator iterator = registryKey.iterateSubKeys();
            Object var4_6 = null;
            String string = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
            RegistryKey registryKey2 = NativeHandler.getRegistry().getCurrentUserKey().openKey(string, 131097L);
            this.addToWindowsDsnList(iterator, registryKey2);
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            theLogger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
        }
        catch (RegistryException registryException) {
            theLogger.log(Level.WARNING, registryException.getStackTrace()[0].toString(), registryException);
        }
    }

    private void addToWindowsDsnList(Iterator iterator, RegistryKey registryKey) {
        String string = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            string = e.toString();
            try {
                String string2 = registryKey.getStringValue(string);
                if (!TIMESTEN_DRIVERS_REGEX_PATTERN.matcher(string2).matches() || this.theCompleteDSNList.contains(e)) continue;
                this.theCompleteDSNList.add(e);
                if (string2.indexOf("Client") == -1) continue;
                this.theClientDSN.add(e.toString());
            }
            catch (RegistryException registryException) {}
        }
    }

    private boolean isCSDsn(String string) {
        return this.theClientDSN.contains(string);
    }

    public void cleanCacheParameters() {
        this.theCachePWDField.setText("");
        this.theOraServiceNameJTF.setText("");
    }

    private class DsnSelectListener
    implements ActionListener {
        private final ButtonGroup theBg;

        DsnSelectListener(ButtonGroup buttonGroup) {
            this.theBg = buttonGroup;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TTBasicPanel.this.theDsnListJCB == null || TTBasicPanel.this.theDsnListJCB.getSelectedItem() == null) {
                return;
            }
            String string = TTBasicPanel.this.theDsnListJCB.getSelectedItem().toString();
        }
    }
}

