/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.timesten.advisor.WorksheetIndexAdvisorPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;

public class IndexAdvisorTask
extends RaptorTask<Boolean> {
    private final WorksheetContext theContext;
    private final String theId;
    private WorksheetIndexAdvisorPanel theResultPanel;
    private int theCursorPosition = 0;
    private int theCursorStart = 0;
    private int theCursorEnd = 0;
    private Connection theConnection;
    private final Connections theConnections = Connections.getInstance();
    private final int theCaptureLevel;
    private final int theCaptureMode;
    private static final String CAPTURE_START_SQL = "call ttIndexAdviceCaptureStart(?,?)";
    private static final String CAPTURE_END_SQL = "call ttIndexAdviceCaptureEnd(?)";
    private boolean autoCommitValue;
    private static Logger LOGGER = Logger.getLogger(IndexAdvisorTask.class.getPackage().getName());
    private boolean includeHints;
    private String hints;

    public IndexAdvisorTask(String string, WorksheetContext worksheetContext) {
        this(string, worksheetContext, 0, 0, false, "");
    }

    public IndexAdvisorTask(String string, WorksheetContext worksheetContext, int n, int n2, boolean bl, String string2) {
        super("TimesTen Index Advisor", true, IRaptorTaskRunMode.TASKVIEWER);
        this.includeHints = bl;
        this.hints = string2;
        this.theCaptureLevel = n;
        this.theCaptureMode = n2;
        this.theContext = worksheetContext;
        this.theId = string;
        try {
            this.theConnection = this.theConnections.getConnection(worksheetContext.getConnectionName());
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, "Can't get connection", dBException);
        }
    }

    public static Connection getConnection(WorksheetContext worksheetContext) {
        try {
            return Connections.getInstance().getConnection(worksheetContext.getConnectionName());
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doWork() throws TaskException {
        this.showResultPanel();
        String[] stringArray = this.extractSql(null);
        Statement statement = null;
        PreparedStatement[] preparedStatementArray = new PreparedStatement[2];
        boolean bl = false;
        try {
            this.autoCommitValue = this.theConnection.getAutoCommit();
            statement = this.theConnection.createStatement();
            preparedStatementArray[0] = this.theConnection.prepareStatement(CAPTURE_START_SQL);
            preparedStatementArray[0].setInt(1, this.theCaptureLevel);
            preparedStatementArray[0].setInt(2, this.theCaptureMode);
            preparedStatementArray[0].execute();
            bl = true;
            if (this.includeHints) {
                Object[] objectArray = this.getHints();
                String[] stringArray2 = objectArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray2[i];
                    if (string == null) continue;
                    if (string.toLowerCase().contains("autocommit")) {
                        String string2 = string.toLowerCase().replace("autocommit", "").trim();
                        if (string2.contains("0")) {
                            this.theConnection.setAutoCommit(false);
                            continue;
                        }
                        this.theConnection.setAutoCommit(true);
                        continue;
                    }
                    statement.execute(string);
                }
            }
            for (String string : stringArray) {
                statement.execute(string);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Can't execute statement ", sQLException);
        }
        finally {
            if (bl) {
                try {
                    preparedStatementArray[1] = this.theConnection.prepareStatement(CAPTURE_END_SQL);
                    preparedStatementArray[1].setInt(1, this.theCaptureLevel);
                    preparedStatementArray[1].execute();
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Can't execute statement ", sQLException);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Can't close statement", sQLException);
                }
            }
            for (PreparedStatement preparedStatement : preparedStatementArray) {
                if (preparedStatement == null) continue;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Can't close statement", sQLException);
                }
            }
            try {
                LOGGER.log(Level.INFO, "Autocommit last value:" + this.theConnection.getAutoCommit());
                this.theConnection.setAutoCommit(this.autoCommitValue);
                LOGGER.log(Level.INFO, "Autocommit new value: " + this.theConnection.getAutoCommit());
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, "Can't set back autocommit", sQLException);
            }
        }
        this.theResultPanel.displayAdvice(stringArray, this.theConnection);
        return true;
    }

    public final String[] extractSql(String string) {
        String string2 = this.getSqlStatement();
        this.theCursorPosition = this.theContext.getEditor().getCaretPosition();
        this.theCursorStart = this.theContext.getEditor().getSelectionStart();
        this.theCursorEnd = this.theContext.getEditor().getSelectionEnd();
        BasicDocument basicDocument = (BasicDocument)this.theContext.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n = lineMap.getLineFromOffset(this.theCursorPosition);
        ScriptParser scriptParser = new ScriptParser(string2, this.theConnection);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        String[] stringArray = new String[iSQLCommandArray.length];
        for (int i = 0; i < iSQLCommandArray.length; ++i) {
            stringArray[i] = iSQLCommandArray[i].getSql();
        }
        return stringArray;
    }

    private final String[] getHints() {
        ScriptParser scriptParser = new ScriptParser(this.hints, this.theConnection);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        String[] stringArray = new String[iSQLCommandArray.length];
        for (int i = 0; i < iSQLCommandArray.length; ++i) {
            String string = iSQLCommandArray[i].getSql();
            if (string.startsWith("--")) continue;
            stringArray[i] = iSQLCommandArray[i].getSql();
        }
        return stringArray;
    }

    private String getSqlStatement() {
        String string = this.theContext.getEditor().getSelectedText();
        if (string == null) {
            string = this.theContext.getEditor().getText();
        }
        return string;
    }

    public void setIndexAdvisorPanel(WorksheetIndexAdvisorPanel worksheetIndexAdvisorPanel) {
        this.theResultPanel = worksheetIndexAdvisorPanel;
    }

    protected void showResultPanel() {
        if (this.theContext != null) {
            this.theContext.getCallback().showResultPanel((WorksheetResultPanel)this.theResultPanel);
        }
    }
}

