/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.panels.TTCreateTableHeader;
import oracle.dbtools.raptor.timesten.panels.TTIndexPanelLibrary;
import oracle.dbtools.raptor.timesten.panels.TTLatestTablePanelLibrary;
import oracle.dbtools.raptor.timesten.panels.TTSequencePanelLibrary;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.ora.FunctionPanelLibrary;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.ora.PackagePanelLibrary;
import oracle.ideimpl.db.ora.ProcedurePanelLibrary;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.ideimpl.db.panels.TableWithTabbedChildSplitPane;
import oracle.ideimpl.db.panels.TraversableProxy;
import oracle.ideimpl.db.panels.table.ColumnsTableEditorPanel;
import oracle.ideimpl.db.panels.table.ColumnsTabsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.ideimpl.db.validate.ModalValidationManager;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemplateExpander;

public class TTDBEditorFactory
extends BaseDBEditorFactory {
    public static final Dimension NO_PANELS_DIALOG_SIZE = new Dimension(400, 200);
    public static final Dimension SMALL_DIALOG_SIZE = new Dimension(400, 400);
    public static final Dimension SMALL_BUT_TALL_DIALOG_SIZE = new Dimension(400, 550);
    public static final Dimension MEDIUM_DIALOG_SIZE = new Dimension(600, 550);
    protected static Logger logger = Logger.getLogger(TTDBEditorFactory.class.getPackage().getName());
    private static TTDBEditorFactory s_instance;

    public static TTDBEditorFactory getInstance() {
        if (s_instance == null) {
            s_instance = new TTDBEditorFactory();
        }
        return s_instance;
    }

    public TTDBEditorFactory() {
        this.registerLibrary("TABLE", TTLatestTablePanelLibrary.class);
        this.registerLibrary("SEQUENCE", TTSequencePanelLibrary.class);
        this.registerLibrary("INDEX", TTIndexPanelLibrary.class);
        this.registerLibrary("PROCEDURE", ProcedurePanelLibrary.class);
        this.registerLibrary("PACKAGE", PackagePanelLibrary.class);
        this.registerLibrary("FUNCTION", FunctionPanelLibrary.class);
    }

    public void registerLibrary(String string, Class clazz) {
        super.registerLibrary(string, clazz);
    }

    protected void initializeLibrary(PanelLibrary panelLibrary) {
        super.initializeLibrary(panelLibrary);
    }

    public boolean canCreateDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        OracleTypeModeImpl oracleTypeModeImpl;
        Connection connection;
        if ((string.equals("PROCEDURE") || string.equals("FUNCTION") || string.equals("PACKAGE")) && dBObjectProvider instanceof OracleTypeModeImpl && TimesTenPlugInDatabaseImpl.isGridDatabase(connection = (oracleTypeModeImpl = (OracleTypeModeImpl)dBObjectProvider).getConnection())) {
            return false;
        }
        return super.canCreateDBObject(schema, dBObjectProvider, string);
    }

    protected Runnable prepareEditor(DBEditorConfig dBEditorConfig, PanelLibrary panelLibrary, boolean bl) throws DBException {
        Runnable runnable;
        Object object;
        dBEditorConfig.setException(null);
        dBEditorConfig.setResult(DBEditorConfig.Result.IN_PROGRESS);
        DBEditorFactory.EditorType editorType = this.determineEditorType(dBEditorConfig);
        try {
            object = dBEditorConfig.getClass().getDeclaredMethod("setEditorType", editorType.getClass());
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)dBEditorConfig, editorType);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        object = panelLibrary.getNavigables(dBEditorConfig);
        if (object == null) {
            Object object2 = dBEditorConfig.isChildEditOnly() ? dBEditorConfig.getChildObject() : dBEditorConfig.getUpdatedObject();
            dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
            if (!bl && TemplateExpander.isPendingObject((DBObject)object2)) {
                String[] stringArray = TemplateExpander.getTemplateObjectName((DBObject)object2).split("\\.");
                throw new DBException(object2, UIBundle.format((String)"DBOBJECT_CREATE_INVALID_TEMPLATE", (Object[])new Object[]{DBTypeDisplayRegistry.getSingularDisplayName((String)object2.getType()), stringArray[stringArray.length - 1]}));
            }
            throw new DBException(object2, this.getUnsupportedErrorMessage(object2.getType(), object2.getName()));
        }
        Traversable traversable = panelLibrary.getMainDialogPanel(dBEditorConfig, object.toArray(new Navigable[object.size()]));
        if (traversable == null) {
            runnable = () -> panelLibrary.commitToProvider(dBEditorConfig);
        } else {
            Namespace namespace = this.createNamespace(dBEditorConfig);
            namespace.put(PanelLibrary.class.getName(), (Object)panelLibrary);
            String string = (bl ? "edit" : "create") + dBEditorConfig.getObjectType();
            String string2 = bl ? panelLibrary.getEditTitle() : panelLibrary.getCreateTitle();
            Dimension dimension = panelLibrary.getSize(bl);
            Dimension dimension2 = dimension == null && object.size() == 0 ? OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE : dimension;
            panelLibrary.prepareObjectForEditor(dBEditorConfig, (List)object);
            runnable = () -> this.launchDialog(namespace, string2, bl, traversable, panelLibrary, dimension2, string);
        }
        CancelledException.checkInterrupt();
        return runnable;
    }

    public void launchDialog(Namespace namespace, String string, boolean bl, Traversable traversable, PanelLibrary panelLibrary, Dimension dimension, String string2) {
        Component component = DBMessageDialog.getDialogParent();
        TraversableProxy traversableProxy = new TraversableProxy(traversable);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(component, string, (Traversable)traversableProxy, namespace);
        if (dimension != null) {
            tDialogLauncher.setInitialSize(dimension);
        }
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setName(string2);
        namespace.put(JEWTDialog.class.getName(), (Object)jEWTDialog);
        if (Boolean.getBoolean("ide.db.liveValidate") && namespace.get(DBValidationManager.class) == null) {
            namespace.put(DBValidationManager.class.getName(), (Object)new ModalValidationManager(jEWTDialog));
        }
        DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.find(DBEditorConfig.class);
        jEWTDialog.setOKButtonEnabled(dBEditorConfig.isEditable());
        Component component2 = this.getDialogHeader(dBEditorConfig);
        if (component2 != null) {
            jEWTDialog.setDialogHeader(component2);
        }
        traversableProxy.enable();
        Component component3 = panelLibrary.getInitialFocus(traversable);
        this.changesPanel(traversable, dBEditorConfig);
        if (component3 != null) {
            jEWTDialog.setInitialFocus(component3);
        }
        if (!tDialogLauncher.showDialog() && dBEditorConfig.getResult() == DBEditorConfig.Result.IN_PROGRESS) {
            dBEditorConfig.setResult(DBEditorConfig.Result.CANCELLED);
        }
    }

    private void changesPanel(Traversable traversable, DBEditorConfig dBEditorConfig) {
        try {
            TabbedEditorPanel tabbedEditorPanel = (TabbedEditorPanel)traversable;
            DBTabbedPanel dBTabbedPanel = (DBTabbedPanel)tabbedEditorPanel.getComponent(0);
            JTabbedPane jTabbedPane = (JTabbedPane)dBTabbedPanel.getComponent(0);
            Component[] componentArray = jTabbedPane.getComponents();
            ColumnsTableEditorPanel columnsTableEditorPanel = (ColumnsTableEditorPanel)componentArray[0];
            TableWithTabbedChildSplitPane tableWithTabbedChildSplitPane = (TableWithTabbedChildSplitPane)columnsTableEditorPanel.getComponents()[0];
            ColumnsTabsPanel columnsTabsPanel = (ColumnsTabsPanel)tableWithTabbedChildSplitPane.getComponents()[1];
            DBTabbedPanel dBTabbedPanel2 = (DBTabbedPanel)columnsTabsPanel.getComponents()[0];
            JTabbedPane jTabbedPane2 = (JTabbedPane)dBTabbedPanel2.getComponents()[0];
            TabSelectedListener tabSelectedListener = new TabSelectedListener(tableWithTabbedChildSplitPane, jTabbedPane2);
            tableWithTabbedChildSplitPane.addPropertyChangeListener("dividerLocation", (PropertyChangeListener)tabSelectedListener);
            jTabbedPane2.addChangeListener(tabSelectedListener);
            String string = Messages.getString("TimestenTable.indexConfiguration");
            TTCreateTableHeader tTCreateTableHeader = new TTCreateTableHeader(dBEditorConfig, new DBUILayoutHelper((JPanel)tabbedEditorPanel));
            jTabbedPane2.addTab(string, (Component)((Object)tTCreateTableHeader));
            tableWithTabbedChildSplitPane.setDividerLocation(tableWithTabbedChildSplitPane.getHeight() - 38);
            tabSelectedListener.setEnable(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getUnsupportedErrorMessage(String string, String string2) {
        return UIBundle.format((String)"DBOBJECT_EDIT_OBJ_UNSUPPORTED", (Object[])new Object[]{DBTypeDisplayRegistry.getSingularDisplayName((String)string), string2});
    }

    private class TabSelectedListener
    implements ChangeListener,
    PropertyChangeListener {
        private final int DEFAULT_DIVIDER_LOCATION = 250;
        private final int MINIMUM_BOTTOM_SIZE = 38;
        private final int MINIMUM_TOP_SIZE = 87;
        private boolean m_dragging = true;
        TableWithTabbedChildSplitPane childTabbedPane;
        JTabbedPane tabPane;

        public TabSelectedListener(TableWithTabbedChildSplitPane tableWithTabbedChildSplitPane, JTabbedPane jTabbedPane) {
            this.childTabbedPane = tableWithTabbedChildSplitPane;
            this.tabPane = jTabbedPane;
        }

        public void setEnable(boolean bl) {
            this.m_dragging = bl;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane;
            if (changeEvent.getSource() instanceof JTabbedPane && (jTabbedPane = (JTabbedPane)changeEvent.getSource()).getSelectedIndex() == 2) {
                int n = this.childTabbedPane.getDividerLocation();
                this.setSplitLocation(n);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof TableWithTabbedChildSplitPane && !this.m_dragging && this.tabPane.getSelectedIndex() == 2) {
                this.m_dragging = true;
                this.setSplitLocation(this.childTabbedPane.getDividerLocation());
                this.m_dragging = false;
            }
        }

        public int getMinimumLocation() {
            return this.childTabbedPane.getHeight() - 38;
        }

        private void setSplitLocation(int n) {
            int n2 = n;
            int n3 = this.getMinimumLocation();
            if (n < 87) {
                n2 = 87;
            } else if (n > 250 && n <= n3) {
                n2 = 250;
            } else if (n > n3) {
                n2 = n3;
                this.tabPane.setSelectedIndex(-1);
            }
            this.childTabbedPane.setDividerLocation(n2);
        }
    }
}

