/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.BasicObjectCheck;
import oracle.dbtools.raptor.timesten.ObjectPrivilegeCheck;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.IObjectCheck;
import oracle.dbtools.util.objectpriv.PermissionRegistry;

public class ObjectCheckWrapper
implements IObjectCheck {
    private static final Logger _logger = Logger.getLogger(ObjectCheckWrapper.class.getPackage().getName());
    private IObjectCheck m_BOCheck = new BasicObjectCheck();
    private IObjectCheck m_OPCheck = new ObjectPrivilegeCheck();

    public boolean canCreate(DBObject dBObject) {
        String string = TimesTenUtil.ttVersion(dBObject);
        if (string.startsWith("07.") || string.startsWith("7.")) {
            return this.m_BOCheck.canCreate(dBObject);
        }
        return this.m_OPCheck.canCreate(dBObject);
    }

    public boolean canAlter(DBObject dBObject) {
        String string = TimesTenUtil.ttVersion(dBObject);
        if (string.startsWith("07.") || string.startsWith("7.")) {
            return this.m_BOCheck.canAlter(dBObject);
        }
        return this.m_OPCheck.canAlter(dBObject);
    }

    public boolean canDrop(DBObject dBObject) {
        String string = TimesTenUtil.ttVersion(dBObject);
        if (string.startsWith("07.") || string.startsWith("7.")) {
            return this.m_BOCheck.canDrop(dBObject);
        }
        return this.m_OPCheck.canDrop(dBObject);
    }

    static void registerACLObject() {
        for (String string : TimesTenUtil.getSupportedObjects()) {
            PermissionRegistry.registerHandler((String)"TimesTen", (String)string, ObjectCheckWrapper.class);
            PermissionRegistry.registerHandler((String)"TimesTen", (String)(string + "_FOLDER"), ObjectCheckWrapper.class);
        }
    }
}

