/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.dbtools.rest.generators.RestCodeGenResults;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.wizard.RestSummaryTabPanel;
import oracle.dbtools.rest.wizard.ScriptRunnerTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RestWizSummaryTabPanel
extends ScriptRunnerTraversablePanel {
    private RestSummaryTabPanel summaryTabPanel;

    private void jbInit(TraversableContext traversableContext) {
        RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
        RestTemplate restTemplate = (RestTemplate)traversableContext.get("REST_TEMPLATE");
        this.summaryTabPanel = new RestSummaryTabPanel(restModule, restTemplate, null, this.createScriptPane(this.getCodeGenResults(traversableContext)));
        this.setLayout(new GridBagLayout());
        this.add(this.summaryTabPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    private String getCodeGenResults(TraversableContext traversableContext) {
        RestCodeGenResults restCodeGenResults = new RestCodeGenResults();
        RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
        RestTemplate restTemplate = (RestTemplate)traversableContext.get("REST_TEMPLATE");
        if (restModule != null) {
            return restCodeGenResults.generateModuleTemplate(restModule, restTemplate, true);
        }
        if (restTemplate != null) {
            String string = (String)traversableContext.get("REST_MODULE_NAME");
            return restCodeGenResults.generateTemplate(string, restTemplate, true);
        }
        return null;
    }

    @Override
    protected String getTitle() {
        return "SummaryTitle";
    }

    @Override
    protected void validateData(TraversableContext traversableContext) throws TraversalException {
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.summaryTabPanel == null) {
            this.jbInit(traversableContext);
        } else {
            RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
            RestTemplate restTemplate = (RestTemplate)traversableContext.get("REST_TEMPLATE");
            this.summaryTabPanel.buildSummaryTree(restModule, restTemplate, null);
            this.summaryTabPanel.setSqlEditorCode(this.getCodeGenResults(traversableContext));
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }
}

