/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.utils.RestValidator;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;

public class RestValidateDialog {
    public static void validateRESTfulServices(List<RestModule> list, List<RestPrivilege> list2) {
        if ((list == null || list.isEmpty()) && (list2 == null || list2.isEmpty())) {
            return;
        }
        RestValidateDialog restValidateDialog = new RestValidateDialog();
        restValidateDialog.validateREST(list, list2);
    }

    public static boolean isModuleValid(RestModule restModule, boolean bl) {
        if (restModule == null) {
            return false;
        }
        RestValidateDialog restValidateDialog = new RestValidateDialog();
        return restValidateDialog.validModule(restModule, bl);
    }

    public static boolean isPrivilegeValid(RestPrivilege restPrivilege, boolean bl) {
        if (restPrivilege == null) {
            return false;
        }
        RestValidateDialog restValidateDialog = new RestValidateDialog();
        return restValidateDialog.validPrivilege(restPrivilege, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateREST(List<RestModule> list, List<RestPrivilege> list2) {
        RestValidator restValidator = new RestValidator();
        String string = "";
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            waitCursor.show();
            string = restValidator.isValidRESTfulServices(list, list2) ? RestArb.getString("VALIDATE_SUCCESS") : restValidator.getErrorMessages();
        }
        finally {
            waitCursor.hide();
        }
        this.showValidationDialog(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validModule(RestModule restModule, boolean bl) {
        RestValidator restValidator = new RestValidator();
        boolean bl2 = false;
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            waitCursor.show();
            bl2 = restValidator.isValidResourceModule(restModule);
        }
        finally {
            waitCursor.hide();
        }
        if (!bl2) {
            this.showValidationDialog(restValidator.getErrorMessages());
        } else if (bl) {
            String string = RestArb.format("VALIDATE_SUCCESS2", RestArb.getString("LABEL_MODULE"), restModule.getName());
            this.showValidationDialog(string);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validPrivilege(RestPrivilege restPrivilege, boolean bl) {
        RestValidator restValidator = new RestValidator();
        boolean bl2 = false;
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            waitCursor.show();
            bl2 = restValidator.isValidPrivilege(restPrivilege);
        }
        finally {
            waitCursor.hide();
        }
        if (!bl2) {
            this.showValidationDialog(restValidator.getErrorMessages());
        } else if (bl) {
            String string = RestArb.format("VALIDATE_SUCCESS2", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
            this.showValidationDialog(string);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showValidationDialog(String string) {
        JEWTDialog jEWTDialog = null;
        try {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JTextArea jTextArea = new JTextArea();
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextArea, (String)RestArb.getString("VALIDATE_HEADER"));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            Dimension dimension = new Dimension(500, 300);
            jTextArea.setMinimumSize(dimension);
            jTextArea.setText(string);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 3, 8), 0, 0));
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 8, 8, 8), 0, 0));
            jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)RestArb.getString("VALIDATION_TITLE"), (int)16);
            Dimension dimension2 = new Dimension(500, 300);
            jEWTDialog.setPreferredSize(dimension2);
            jEWTDialog.setSize(dimension2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
        }
        catch (Exception exception) {
        }
        finally {
            if (jEWTDialog != null) {
                jEWTDialog.dispose();
                jEWTDialog = null;
            }
        }
    }
}

