/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.rest.RestArb;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public class RestTablePanel
extends JPanel
implements TableModelListener {
    private DefaultTableModel _tableModel;
    private JTable _table;

    public RestTablePanel(String string, String string2, List<String> list) {
        this.createPanel(string, string2, list);
    }

    private void createPanel(String string, String string2, List<String> list) {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(150, 125));
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(string);
        this.setValues(list);
        this._table = new JTable(this._tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JTextPane jTextPane = null;
        if (string2 != null) {
            jTextPane = new JTextPane();
            jTextPane.setPreferredSize(new Dimension(200, 35));
            jTextPane.setText(string2);
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setRequestFocusEnabled(false);
            jTextPane.setFocusable(false);
        }
        this._table.setPreferredScrollableViewportSize(new Dimension(200, 300));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        jButton.setToolTipText(RestArb.format("TOOLTIP_ADD_BUTTON", string));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        jButton2.setToolTipText(RestArb.format("TOOLTIP_REMOVE_BUTTON", string));
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        n = 0;
        if (jTextPane != null) {
            this.add((Component)jTextPane, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (RestTablePanel.this._table.getEditingColumn() > -1 && RestTablePanel.this._table.getEditingRow() > -1) {
                    RestTablePanel.this._table.getCellEditor(RestTablePanel.this._table.getEditingRow(), RestTablePanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestTablePanel.this.addRow(null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (RestTablePanel.this._table.getSelectedRowCount() > 0) {
                    RestTablePanel.this._tableModel.removeRow(RestTablePanel.this._table.getSelectedRow());
                }
            }
        });
    }

    public void setValues(List<String> list) {
        if (list != null) {
            for (String string : list) {
                this.addRow(string);
            }
        }
    }

    private void addRow(String string) {
        this._tableModel.addRow(new Object[]{string});
    }

    public List<String> getValues() {
        if (this._table == null) {
            return null;
        }
        this.stopCellEditing();
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            string = (String)this._table.getModel().getValueAt(i, 0);
            if (string == null || string.isEmpty() || string.trim().isEmpty()) continue;
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    public JTable getTable() {
        return this._table;
    }

    public void removeAllRows() {
        if (this._tableModel != null) {
            this.stopCellEditing();
            while (this._tableModel.getRowCount() > 0) {
                this._tableModel.removeRow(this._tableModel.getRowCount() - 1);
            }
        }
    }

    private void stopCellEditing() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

