/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.ShuttlePanel;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.ui.RestTablePanel;
import oracle.dbtools.rest.utils.RestPrivilegeURIPattern;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestSecurityPanel
extends JPanel {
    private JTextField _name;
    private JTextField _label;
    private JTextField _descrip;
    private JTextField _comments;
    private ShuttlePanel _shuttleModules;
    private ShuttlePanel _shuttleRoles;
    private RestTablePanel _uriPatterns;
    private RestPrivilege _security;
    private List<String> _errMsg;
    private List<String> _existingNames;
    private boolean _edit;
    private boolean _showComments;

    public RestSecurityPanel(RestPrivilege restPrivilege, List<String> list, List<String> list2, boolean bl, boolean bl2) {
        this._security = restPrivilege;
        this._edit = bl;
        this._showComments = bl2;
        this.createPanel(list, list2);
    }

    private void initializeComponents(List<String> list, List<String> list2) {
        this._name = new JTextField();
        this._label = new JTextField();
        this._descrip = new JTextField();
        this._comments = new JTextField();
        this._shuttleRoles = new ShuttlePanel();
        this._shuttleModules = new ShuttlePanel();
        if (this._security != null) {
            this._name.setText(this._security.getName());
            this._label.setText(this._security.getTitle());
            this._descrip.setText(this._security.getDescription());
            this._comments.setText(this._security.getComments());
            this._shuttleRoles.setLists(this.getSourceList(list, this._security.getRoles()), this._security.getRoles());
            this._shuttleModules.setLists(this.getSourceList(list2, this._security.getModules()), this._security.getModules());
        } else {
            this._shuttleRoles.setLists(list, null);
            this._shuttleModules.setLists(list2, null);
        }
        this._uriPatterns = new RestTablePanel(RestArb.getString("SEC_PROTECT_RESOURCES_DESC"), null, this._security != null ? this._security.getURIPatterns() : null);
        if (!this._edit) {
            this._name.requestFocusInWindow();
        }
    }

    private List<String> getSourceList(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null) {
            return null;
        }
        if (list2 == null) {
            return list;
        }
        for (String string : list) {
            if (list2.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void createPanel(List<String> list, List<String> list2) {
        JComponent jComponent;
        this.initializeComponents(list, list2);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel(RestArb.getString("SEC_AVAIL_GROUPS"));
        JLabel jLabel5 = new JLabel(RestArb.getString("SEC_SELECTED_GROUPS"));
        JLabel jLabel6 = new JLabel(RestArb.getString("SEC_AVAIL_MODULES"));
        JLabel jLabel7 = new JLabel(RestArb.getString("SEC_SELECTED_MODULES"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)RestArb.getString("SEC_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._label, (String)RestArb.getString("SEC_LABEL"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._descrip, (String)RestArb.getString("SEC_DESCRIP"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._shuttleRoles, (String)RestArb.getString("SEC_AVAIL_GROUPS"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._shuttleModules, (String)RestArb.getString("SEC_AVAIL_MODULES"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(0, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._label, new GridBagConstraints(1, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._descrip, new GridBagConstraints(1, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        if (this._showComments) {
            jComponent = new JLabel();
            ResourceUtils.resLabel((JLabel)jComponent, (Component)this._comments, (String)DDLResources.getString((String)"GEN_COMMENTS"));
            jPanel.add((Component)jComponent, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
            jPanel.add((Component)this._comments, new GridBagConstraints(1, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        }
        if (this._edit) {
            this._name.setEnabled(false);
        }
        n = 0;
        jComponent = new JPanel(new GridBagLayout());
        jComponent.add((Component)jLabel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 8, 0, 0), 0, 0));
        jComponent.add(Box.createHorizontalGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        jComponent.add((Component)jLabel5, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this._shuttleRoles.getPanel(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.5, 23, 1, new Insets(0, 8, 0, 8), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel6, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 8, 0, 0), 0, 0));
        jPanel3.add(Box.createHorizontalGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel7, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this._shuttleModules.getPanel(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.25, 23, 1, new Insets(0, 8, 0, 8), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel4, (int)(++n));
        n = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this._uriPatterns, new GridBagConstraints(0, ++n, 1, 4, 1.0, 0.25, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(RestArb.getString("SEC_PROTECT_MODULES"), jPanel4);
        jTabbedPane.addTab(RestArb.getString("SEC_PROTECT_RESOURCES"), jPanel5);
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(8, 0, 0, 0), 0, 0));
        this.add((Component)jTabbedPane, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.25, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        if (RestUtils.emptyValue(this._name.getText())) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_SEC_NAME")));
            this._name.requestFocusInWindow();
        } else if (this.isExistName(this._name.getText())) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_SEC_NAME")));
            this._name.requestFocusInWindow();
        }
        int n = 0;
        List<String> list = this._uriPatterns.getValues();
        for (String string : list) {
            if (string == null || string.isEmpty()) continue;
            try {
                RestPrivilegeURIPattern.validateURIPattern(string);
            }
            catch (Exception exception) {
                ++n;
                this.setErrorMessage(RestArb.format("SEC_URI_SYNTAX_ERROR", string, exception.getMessage()));
            }
        }
        if (n > 0) {
            this.setErrorMessage(RestArb.getString("SEC_HELP_URI"));
            this._uriPatterns.requestFocusInWindow();
        }
        return this._errMsg.size() == 0;
    }

    public RestPrivilege getValues() {
        if (this._security == null) {
            this._security = new RestPrivilege();
        }
        this._security.setName(this._name.getText());
        this._security.setTitle(this._label.getText());
        this._security.setDescription(this._descrip.getText());
        this._security.setComments(this._comments.getText());
        this._security.setRoles(this._shuttleRoles.getSelected());
        this._security.setModules(this._shuttleModules.getSelected());
        this._security.setURIPatterns(this._uriPatterns.getValues());
        return this._security;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this._existingNames = list;
    }

    public boolean isExistName(String string) {
        if (this._existingNames == null || this._existingNames.isEmpty()) {
            return false;
        }
        return this._existingNames.contains(string);
    }

    public boolean valuesChanged(RestPrivilege restPrivilege) {
        if (restPrivilege != null) {
            if (this.valuesDifferent(restPrivilege.getTitle(), this._label.getText())) {
                return true;
            }
            if (this.valuesDifferent(restPrivilege.getDescription(), this._descrip.getText())) {
                return true;
            }
            if (this._showComments && this.valuesDifferent(restPrivilege.getDescription(), this._comments.getText())) {
                return true;
            }
            if (this.valuesDifferent(restPrivilege.getRoles(), this._shuttleRoles.getSelected())) {
                return true;
            }
            if (this.valuesDifferent(restPrivilege.getModules(), this._shuttleModules.getSelected())) {
                return true;
            }
            if (this.valuesDifferent(restPrivilege.getURIPatterns(), this._uriPatterns.getValues())) {
                return true;
            }
        }
        return false;
    }

    private boolean valuesDifferent(String string, String string2) {
        String string3;
        String string4 = string != null ? string : "";
        String string5 = string3 = string2 != null ? string2 : "";
        return !string4.equals(string3);
    }

    private boolean valuesDifferent(List<String> list, List<String> list2) {
        String string;
        String string2 = this.formatCommaDelimited(list);
        return !string2.equals(string = this.formatCommaDelimited(list2));
    }

    private String formatCommaDelimited(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    stringBuilder.append(list.get(i));
                    continue;
                }
                stringBuilder.append(",").append(list.get(i));
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

