/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.io.StringReader;
import oracle.dbtools.rest.patterns.GlobParser;
import oracle.dbtools.rest.patterns.GlobPattern;
import oracle.dbtools.rest.patterns.GlobPatternImpl;
import oracle.dbtools.rest.patterns.LiteralParser;
import oracle.dbtools.rest.patterns.LiteralPatternImpl;
import oracle.dbtools.rest.patterns.NamedPattern;
import oracle.dbtools.rest.patterns.NamedPatternImpl;
import oracle.dbtools.rest.patterns.NamedPatternParser;
import oracle.dbtools.rest.patterns.ParserBase;
import oracle.dbtools.rest.patterns.PathToken;
import oracle.dbtools.rest.patterns.RoutePattern;
import oracle.dbtools.rest.patterns.RoutePatterns;

public class RoutePatternsProvider
implements RoutePatterns {
    @Override
    public GlobPattern.Builder globPattern() {
        return new GlobPatternImpl.Builder();
    }

    @Override
    public NamedPattern.Builder namedPattern() {
        return new NamedPatternImpl.Builder();
    }

    @Override
    public RoutePattern routePattern(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        String string = charSequence.toString();
        if (string.indexOf(58) != -1) {
            return this.parseNamedPattern(string);
        }
        if (string.indexOf("*") != -1) {
            return this.parseGlobPattern(string);
        }
        return this.parseLiteralPattern(string);
    }

    @Override
    public GlobPattern parseGlobPattern(String string) {
        try {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            GlobPatternImpl.Builder builder = new GlobPatternImpl.Builder();
            StringReader stringReader = new StringReader(string);
            GlobParser globParser = new GlobParser(stringReader);
            PathToken pathToken = ((ParserBase)globParser).next();
            while (pathToken != null) {
                builder.add(pathToken);
                pathToken = ((ParserBase)globParser).next();
            }
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException("Error parsing pattern, reason: " + illegalStateException.getMessage(), illegalStateException);
        }
    }

    @Override
    public RoutePattern parseLiteralPattern(String string) {
        try {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            LiteralPatternImpl.Builder builder = new LiteralPatternImpl.Builder();
            StringReader stringReader = new StringReader(string);
            LiteralParser literalParser = new LiteralParser(stringReader);
            PathToken pathToken = ((ParserBase)literalParser).next();
            while (pathToken != null) {
                builder.add(pathToken);
                pathToken = ((ParserBase)literalParser).next();
            }
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException("Error parsing pattern, reason: " + illegalStateException.getMessage(), illegalStateException);
        }
    }

    @Override
    public NamedPattern parseNamedPattern(String string) {
        try {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            NamedPatternImpl.Builder builder = new NamedPatternImpl.Builder();
            StringReader stringReader = new StringReader(string);
            NamedPatternParser namedPatternParser = new NamedPatternParser(stringReader);
            PathToken pathToken = ((ParserBase)namedPatternParser).next();
            while (pathToken != null) {
                builder.add(pathToken);
                pathToken = ((ParserBase)namedPatternParser).next();
            }
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException("Error parsing pattern, reason: " + illegalStateException.getMessage(), illegalStateException);
        }
    }
}

