/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class InstallWizStandalonePanel
extends DefaultTraversablePanel {
    private static final String DEFAULT_HTTP_PORT = "8080";
    private JPanel m_titledApexPanel;
    private JTextPane m_apexDescrip = new JTextPane();
    private JTextField m_httpPort = new JTextField();
    private JTextField m_apexImagesDir = new JTextField();
    private JCheckBox m_runStandalone = new JCheckBox();
    private RestInstallConstants.InstallType m_installType;

    public InstallWizStandalonePanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_runStandalone.setSelected(true);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_runStandalone, (String)RestArb.getString("WIZ_RUN_STANDALONE"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_httpPort, (String)RestArb.getString("HTTP_PORT"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_apexImagesDir, (String)RestArb.getString("WIZ_APEX_IMAGE_DIR"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_STANDALONE_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_runStandalone, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_STANDALONE"), (Component)jPanel);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_httpPort, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)2);
        this.m_apexDescrip.setText(RestArb.getString("WIZ_APEX_IMAGES_DESCRIP"));
        this.m_apexDescrip.setEditable(false);
        this.m_apexDescrip.setOpaque(false);
        this.m_apexDescrip.setRequestFocusEnabled(false);
        this.m_apexDescrip.setFocusable(false);
        n = 0;
        JPanel jPanel4 = LayoutControl.GBC.createPanel();
        jPanel4.add((Component)this.m_apexDescrip, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel4.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP));
        jPanel4.add((Component)this.m_apexImagesDir, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.m_titledApexPanel = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("APEX"), (Component)jPanel4);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.m_titledApexPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_runStandalone.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InstallWizStandalonePanel.this.enableDisableOptions(InstallWizStandalonePanel.this.m_runStandalone.isSelected());
            }
        });
    }

    private void enableDisableOptions(boolean bl) {
        this.m_httpPort.setEnabled(bl);
        this.m_titledApexPanel.setEnabled(bl);
        this.m_apexDescrip.setEnabled(bl);
        this.m_apexImagesDir.setEnabled(bl);
    }

    private void validateValues() throws TraversalException {
        if (this.m_httpPort.getText() == null || this.m_httpPort.getText().trim().length() == 0) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_HTTP_PORT"));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        Map map2 = (Map)traversableContext.get("ORDS_PARAMS");
        if (map2 != null && map2.containsKey("INSTALL_KEY_PARAMS") && (map = (Map)map2.get("INSTALL_KEY_PARAMS")) != null) {
            boolean bl = Boolean.parseBoolean((String)map.get("standalone.mode"));
            this.m_runStandalone.setSelected(bl);
            this.m_httpPort.setText(map.get("standalone.http.port") != null ? (String)map.get("standalone.http.port") : DEFAULT_HTTP_PORT);
            if (map.get("standalone.static.images") != null) {
                this.m_apexImagesDir.setText((String)map.get("standalone.static.images"));
            }
            this.enableDisableOptions(bl);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            if (this.m_runStandalone.isSelected()) {
                this.validateValues();
                if (this.m_httpPort.getText() != null && this.m_httpPort.getText().trim().length() > 0) {
                    map2.put("standalone.http.port", this.m_httpPort.getText());
                }
                if (this.m_apexImagesDir.getText() != null && this.m_apexImagesDir.getText().trim().length() > 0) {
                    map2.put("standalone.static.images", this.m_apexImagesDir.getText());
                }
            }
            map2.put("standalone.mode", Boolean.toString(this.m_runStandalone.isSelected()));
        }
    }

    public Object getExitTransition() {
        if (this.m_runStandalone.isSelected()) {
            switch (this.m_installType) {
                case REQUIRES_CONFIG: {
                    return "Transition.ORDSUsers";
                }
                case MIGRATE_V2: {
                    return "Transition.Finish";
                }
                case MIGRATE_V1: {
                    return "Transition.Finish";
                }
                case VERIFY_SCHEMA: {
                    return "Transition.Finish";
                }
            }
        }
        return "Transition.Finish";
    }
}

