/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public abstract class RestXMLResponseHandler<V>
implements HttpClientResponseHandler<V> {
    private String _entityTag;
    private String _charsetName;

    public final V handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
        int n = classicHttpResponse.getCode();
        if (n != 200) {
            throw new IOException((Throwable)new SessionException(classicHttpResponse.getReasonPhrase()));
        }
        Header header = classicHttpResponse.getFirstHeader("Content-Type");
        if (header == null) {
            throw new IOException(RestArb.getString("MISSING_CONTENT_TYPE"));
        }
        ContentType contentType = ContentType.contentType((CharSequence)header.getValue());
        if (contentType == null || !contentType.matches(ContentTypes.XML_TYPES)) {
            throw new IOException(RestArb.getString("UNEXPECTED_CONTENT_TYPE") + contentType);
        }
        this._charsetName = contentType.parameter("charset");
        header = classicHttpResponse.getFirstHeader("ETag");
        if (header != null) {
            this._entityTag = header.getValue();
        }
        HttpEntity httpEntity = null;
        InputStream inputStream = null;
        try {
            httpEntity = classicHttpResponse.getEntity();
            if (httpEntity == null) {
                throw new IOException(RestArb.getString("ENTITY_ERROR"));
            }
            inputStream = httpEntity.getContent();
            V v = this.load(inputStream);
            return v;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
    }

    protected String getEntityTag() {
        return this._entityTag;
    }

    protected String getCharacterSetName() {
        return this._charsetName;
    }

    protected abstract V load(InputStream var1) throws IOException;
}

