/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.config;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class RestConfig
extends HashStructureAdapter
implements Copyable {
    public static final String KEY = "RestConfig";
    public static final String SQLDEV_ORDS_CONFIGDIR = "SQLDEV_ORDS_CONFIGDIR";
    public static final String SQLDEV_ORDS_WARFILE = "SQLDEV_ORDS_WARFILE";
    public static final String USER_ORDS_CONFIGDIR = "USER_ORDS_CONFIGDIR";
    public static final String USER_ORDS_WARFILE = "USER_ORDS_WARFILE";
    public static final String USE_SQLDEV_ORDS_WAR = "USE_SQLDEV_ORDS_WAR";
    private static Map<String, Object> s_defaults = new HashMap<String, Object>();

    private RestConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static RestConfig getInstance(PropertyStorage propertyStorage) {
        return new RestConfig(RestConfig.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static RestConfig getInstance(TraversableContext traversableContext) {
        return RestConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized RestConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return RestConfig.getInstance((PropertyStorage)preferences);
    }

    private static String getStringDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    private static Integer getIntegerDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    private static Boolean getBooleanDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.valueOf(object.toString()) : null);
    }

    public String getString(String string) {
        return this._hash.getString(string, RestConfig.getStringDefault(string));
    }

    public void setString(String string, String string2) {
        this._hash.putString(string, string2);
    }

    public int getInt(String string) {
        return this._hash.getInt(string, RestConfig.getIntegerDefault(string).intValue());
    }

    public void setInt(String string, int n) {
        this._hash.putInt(string, n);
    }

    public Boolean getBoolean(String string) {
        return this._hash.getBoolean(string, RestConfig.getBooleanDefault(string).booleanValue());
    }

    public void setBoolean(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    static {
        s_defaults.put(SQLDEV_ORDS_CONFIGDIR, null);
        s_defaults.put(SQLDEV_ORDS_WARFILE, null);
        s_defaults.put(USER_ORDS_CONFIGDIR, null);
        s_defaults.put(USER_ORDS_WARFILE, null);
        s_defaults.put(USE_SQLDEV_ORDS_WAR, true);
    }
}

