/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public abstract class AbstractScriptRunnerTraversablePanel
extends DefaultTraversablePanel {
    public static final String KEY_DIALOG = "KEY_DIALOG";
    public static final String KEY_DBOBJECT = "KEY_DBOBJECT";
    private transient ScriptProcessor scriptProcessor;
    protected BasicEditorPane scriptEditor;
    private boolean scriptEditingEnabled;
    private boolean closeOnError = false;
    private transient ScriptRunnerRaptorTask scriptRunnerTask = null;

    public final void onFinish(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateData(traversableContext);
            try {
                DBObject dBObject = (DBObject)traversableContext.get(KEY_DBOBJECT);
                JDialog jDialog = (JDialog)traversableContext.get(KEY_DIALOG);
                String string = dBObject.getConnectionName();
                Connection connection = Connections.getInstance().getConnection(string);
                Properties properties = Connections.getInstance().getConnectionInfo(string);
                this.scriptRunnerTask = new ScriptRunnerRaptorTask(jDialog, connection, string, properties);
                this.scriptRunnerTask.setCancellable(this.getScriptProcessor().isCancellable());
                this.scriptRunnerTask.getDescriptor().addListener((IRaptorTaskListener)new ScriptRunnerRaptorTaskAdapter(jDialog));
                RaptorTaskManager.getInstance().addTask((RaptorTask)this.scriptRunnerTask);
                Boolean bl = (Boolean)this.scriptRunnerTask.getResult();
                if (bl == null || !bl.booleanValue()) {
                    throw new TraversalException("Task '" + this.getTitle() + "' failed");
                }
            }
            catch (Throwable throwable) {
                throw new TraversalException(throwable.getMessage());
            }
        }
    }

    protected abstract String getScriptForProcessing();

    protected ScriptProcessor getScriptProcessor() {
        if (this.scriptProcessor == null) {
            this.scriptProcessor = this.createScriptProcessor();
        }
        return this.scriptProcessor;
    }

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor();
    }

    protected JEditorPaneScrollPaneWrapper createScriptPane() {
        JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper = null;
        ScriptProcessor scriptProcessor = this.getScriptProcessor();
        if (scriptProcessor != null) {
            this.scriptEditor = this.getScriptProcessor().getEditorPane();
            this.scriptEditor.setEditable(this.scriptEditingEnabled);
            jEditorPaneScrollPaneWrapper = new JEditorPaneScrollPaneWrapper((JEditorPane)this.scriptEditor);
            jEditorPaneScrollPaneWrapper.setVerticalScrollBarPolicy(22);
            jEditorPaneScrollPaneWrapper.setHorizontalScrollBarPolicy(32);
        }
        return jEditorPaneScrollPaneWrapper;
    }

    public void setScriptEditingEnabled(boolean bl) {
        this.scriptEditingEnabled = bl;
    }

    public boolean isScriptEditingEnabled() {
        return this.scriptEditingEnabled;
    }

    public void setCloseOnError(boolean bl) {
        this.closeOnError = bl;
    }

    public boolean isCloseOnError() {
        return this.closeOnError;
    }

    protected void checkAllowApplyScript() throws IllegalStateException {
    }

    protected void onCommandComplete() {
    }

    private static void invokeOnDispatchThreadLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected abstract String getTitle();

    protected abstract void validateData(TraversableContext var1) throws TraversalException;

    private class ScriptRunnerRaptorTask
    extends RaptorTask<Boolean> {
        final JDialog dialog;
        final Connection connection;
        final String cName;
        final Properties connectionProperties;
        private Boolean success;

        public ScriptRunnerRaptorTask(JDialog jDialog, Connection connection, String string, Properties properties) {
            super(UiResources.getString((String)"PERFORM_ACTION"), true, IRaptorTaskRunMode.MODAL);
            this.success = Boolean.FALSE;
            this.dialog = jDialog;
            this.connection = connection;
            this.cName = string;
            this.connectionProperties = properties;
        }

        /*
         * Loose catch block
         */
        protected Boolean doWork() throws TaskException {
            block12: {
                this.success = Boolean.FALSE;
                if (!AbstractScriptRunnerTraversablePanel.this.isCloseOnError()) {
                    AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new Runnable(){

                        @Override
                        public void run() {
                            ScriptRunnerRaptorTask.this.dialog.setEnabled(false);
                            ScriptRunnerRaptorTask.this.dialog.setModalityType(Dialog.ModalityType.MODELESS);
                        }
                    });
                }
                AbstractScriptRunnerTraversablePanel.this.checkAllowApplyScript();
                AbstractScriptRunnerTraversablePanel.this.getScriptProcessor().processScript((ScriptProcessorContext)new ScriptProcessorContextImpl(this.dialog, this.connection, this.cName, this.connectionProperties, AbstractScriptRunnerTraversablePanel.this.getScriptForProcessing()));
                AbstractScriptRunnerTraversablePanel.this.onCommandComplete();
                String string = AbstractScriptRunnerTraversablePanel.this.getScriptProcessor().getSuccessMessage();
                this.setMessage(string);
                this.success = Boolean.TRUE;
                if (this.success.booleanValue() || !AbstractScriptRunnerTraversablePanel.this.isCloseOnError()) {
                    // empty if block
                }
                try {
                    AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new Runnable(){

                        @Override
                        public void run() {
                            ScriptRunnerRaptorTask.this.dialog.setEnabled(true);
                            ScriptRunnerRaptorTask.this.dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
                        }
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break block12;
                catch (Exception exception) {
                    try {
                        String string2 = AbstractScriptRunnerTraversablePanel.this.getScriptProcessor().getFailureMessage(exception);
                        this.setMessage(string2);
                        this.success = Boolean.FALSE;
                    }
                    catch (Throwable throwable) {
                        try {
                            AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            return this.success;
        }

        public Boolean getSuccess() {
            return this.success;
        }
    }

    private class ScriptRunnerRaptorTaskAdapter
    extends RaptorTaskAdapter {
        final JDialog dialog;

        public ScriptRunnerRaptorTaskAdapter(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractScriptRunnerTraversablePanel.this.getScriptProcessor().cancel();
                    ScriptRunnerRaptorTaskAdapter.this.dialog.setVisible(false);
                }
            };
            AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string;
                    if (!AbstractScriptRunnerTraversablePanel.this.isCloseOnError()) {
                        ScriptRunnerRaptorTaskAdapter.this.dialog.setEnabled(true);
                        ScriptRunnerRaptorTaskAdapter.this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                        ScriptRunnerRaptorTaskAdapter.this.dialog.setVisible(true);
                    }
                    if ((string = raptorTaskEvent.getTaskDescriptor().getMessage()) != null) {
                        MessageDialog.error((Component)ScriptRunnerRaptorTaskAdapter.this.dialog, (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString((String)"ERROR_TITLE"), null);
                    }
                }
            };
            AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }

        public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string = raptorTaskEvent.getTaskDescriptor().getMessage();
                    if (string != null) {
                        boolean bl = AbstractScriptRunnerTraversablePanel.this.scriptRunnerTask.getSuccess() == null ? false : AbstractScriptRunnerTraversablePanel.this.scriptRunnerTask.getSuccess();
                        String string2 = bl ? UiResources.getString((String)"SUCCESS_TITLE") : UiResources.getString((String)"ERROR_TITLE");
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)string2, null);
                    }
                }
            };
            AbstractScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }
    }

    protected class ScriptProcessorContextImpl
    implements ScriptProcessorContext {
        private Component _parent;
        private Connection _connection;
        private String _cName;
        private Properties _connectionProperties;
        private String _script;

        ScriptProcessorContextImpl(Component component, Connection connection, String string, Properties properties, String string2) {
            this._parent = component;
            this._connection = connection;
            this._cName = string;
            this._connectionProperties = properties;
            this._script = string2;
        }

        public Component getParent() {
            return this._parent;
        }

        public String getConnectionName() {
            return this._cName;
        }

        public Connection getConnection() {
            return this._connection;
        }

        public Properties getConnectionProperties() {
            return this._connectionProperties;
        }

        public String getActionTitle() {
            return AbstractScriptRunnerTraversablePanel.this.getTitle();
        }

        public String getScript() {
            return this._script;
        }

        public String getParameter(String string) {
            return null;
        }
    }
}

