/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestObjectData;

public class RestObjectDetailsPanel
extends JPanel {
    private transient RestObjectData restObjectDataModel;
    private List<String> existingNames;
    private ArrayList<String> _errMsg;
    private ArrayList<String> ignorePropertyList = new ArrayList();
    private transient ObjectDataModelListener objectDataModelListener = new ObjectDataModelListener();
    private transient EnableCheckBoxListener enableCheckBoxListener = new EnableCheckBoxListener();
    private transient AuthReqCheckBoxListener authReqCheckBoxListener = new AuthReqCheckBoxListener();
    private transient CommitCheckBoxListener commitCheckBoxListener = new CommitCheckBoxListener();
    private transient AliasInputVerifier aliasInputVerifier = new AliasInputVerifier();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel enableLabel = new JLabel();
    private JCheckBox enableCheckBox = new JCheckBox();
    private JLabel aliasLabel = new JLabel();
    private JTextField aliasTextField = new JTextField();
    private JTextArea invalidMsgTextArea = new JTextArea();
    private JCheckBox authReqCheckBox = new JCheckBox();
    private JLabel authReqLabel = new JLabel();
    private JLabel objectURIExample = new JLabel();
    private JLabel commitLabel = new JLabel();
    private JCheckBox commitCheckBox = new JCheckBox();

    public RestObjectDetailsPanel(RestObjectData restObjectData) {
        this.restObjectDataModel = restObjectData;
        this.restObjectDataModel.addPropertyChangeListener(this.objectDataModelListener);
        this.jbInit();
    }

    private void jbInit() {
        this.setName("RestObjectDetailsPanel");
        this.enableLabel.setName("enableLabel");
        this.enableCheckBox.setName("enableCheckBox");
        this.aliasLabel.setName("aliasLabel");
        this.aliasTextField.setName("aliasTextField");
        this.authReqCheckBox.setName("authReqCheckBox");
        this.authReqLabel.setName("authReqLabel");
        this.objectURIExample.setName("objectURIExample");
        this.commitLabel.setName("commitLabel");
        this.commitCheckBox.setName("commitCheckBox");
        this.invalidMsgTextArea.setName("invalidMsgTextArea");
        this.setLayout(this.gridBagLayout1);
        this.enableLabel.setText("Enable object");
        this.enableLabel.setText(AutoRestArb.get("PANEL_OBJECT_DETAILS_ENABLE_OBJECT"));
        this.enableLabel.setLabelFor(this.enableCheckBox);
        this.enableCheckBox.addItemListener(this.enableCheckBoxListener);
        this.aliasLabel.setText("Object alias");
        this.aliasLabel.setText(AutoRestArb.get("PANEL_OBJECT_DETAILS_OBJECT_ALIAS"));
        this.aliasLabel.setLabelFor(this.aliasTextField);
        this.aliasTextField.setInputVerifier(this.aliasInputVerifier);
        this.authReqLabel.setText("Authorisation Required");
        this.authReqLabel.setText(AutoRestArb.get("PANEL_SCHEMA_DETAILS_AUTHORISATION_REQUIRED"));
        this.authReqLabel.setLabelFor(this.authReqCheckBox);
        this.authReqCheckBox.addItemListener(this.authReqCheckBoxListener);
        this.commitLabel.setText("Commit");
        this.commitLabel.setText(AutoRestArb.get("PANEL_OBJECT_DETAILS_COMMIT"));
        this.commitLabel.setLabelFor(this.commitCheckBox);
        this.commitCheckBox.addItemListener(this.commitCheckBoxListener);
        this.add((Component)this.enableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.enableCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.aliasLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.aliasTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.authReqCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.authReqLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.invalidMsgTextArea, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.initialise();
    }

    public void addListeners() {
        if (this.aliasTextField != null && this.aliasTextField.getKeyListeners().length == 0) {
            this.aliasTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    Object object = RestObjectDetailsPanel.this.aliasTextField.getText();
                    if (object != null && !((String)object).isEmpty() && !((String)object).startsWith("/")) {
                        object = "/" + (String)object;
                    }
                    RestObjectDetailsPanel.this.objectURIExample.setText("http://host:port/ords" + (String)object);
                }
            });
        }
    }

    public void removeListeners() {
        if (this.aliasTextField != null) {
            KeyListener[] keyListenerArray;
            for (KeyListener keyListener : keyListenerArray = this.aliasTextField.getKeyListeners()) {
                this.aliasTextField.removeKeyListener(keyListener);
            }
        }
    }

    public boolean validInfo() {
        Matcher matcher;
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        Pattern pattern = Pattern.compile("\\p{Lower}([\\p{Lower}\\p{Digit}#$_])*$");
        String string = this.aliasTextField.getText();
        if (string.length() == 0) {
            this.setErrorMessage(AutoRestArb.format("VALUE_REQUIRED", AutoRestArb.getString("LABEL_MODULE_NAME")));
        }
        if (!(matcher = pattern.matcher(string)).matches()) {
            String string2 = AutoRestArb.format("INVALID_ALIAS", string);
            this.setErrorMessage(string2);
        }
        if (string.length() == 0) {
            this.setErrorMessage(AutoRestArb.format("VALUE_REQUIRED", AutoRestArb.getString("LABEL_MODULE_NAME")));
        }
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        if (this._errMsg.size() > 0 && bl) {
            this.aliasTextField.requestFocusInWindow();
        }
        return this._errMsg.size() == 0;
    }

    public RestObjectData getValues() {
        String string = this.aliasTextField.getText() != null ? this.aliasTextField.getText().trim() : "";
        this.restObjectDataModel.setObjectAlias(string);
        return this.restObjectDataModel;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this.existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this.existingNames == null || this.existingNames.isEmpty()) {
            return false;
        }
        return this.existingNames.contains(string);
    }

    private void setInvalidMsg(String string) {
        if ((string = string.trim()) == null || string.length() == 0) {
            this.invalidMsgTextArea.setText("");
            this.invalidMsgTextArea.setVisible(false);
        } else {
            this.invalidMsgTextArea.setText(string);
            this.invalidMsgTextArea.setVisible(true);
            this.invalidMsgTextArea.setEditable(false);
            this.invalidMsgTextArea.setForeground(Color.RED);
        }
        this.validate();
        this.repaint();
    }

    private void initialise() {
        if (this.restObjectDataModel != null) {
            this.aliasTextField.setText(this.restObjectDataModel.getObjectAlias());
            if (this.restObjectDataModel.isInvalidObject()) {
                this.enableCheckBox.setSelected(false);
                this.enableCheckBox.setEnabled(false);
                String string = this.restObjectDataModel.getInvalidMembers();
                this.setInvalidMsg(AutoRestArb.format("PANEL_OBJECT_DETAILS_INVALID_MEMBERS", string));
            } else {
                this.enableCheckBox.setSelected(this.restObjectDataModel.isEnabled());
                this.enableCheckBox.setEnabled(true);
                this.setInvalidMsg("");
            }
            this.commitCheckBox.setSelected(this.restObjectDataModel.isCommit());
            this.authReqCheckBox.setSelected(this.restObjectDataModel.isAuthorisationRequired());
        }
    }

    public void updatePanel() {
        this.initialise();
    }

    private class ObjectDataModelListener
    implements PropertyChangeListener {
        private ObjectDataModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ArrayList<String> arrayList = RestObjectDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectDetailsPanel.this.ignorePropertyList.contains(string)) {
                    if (string.equals("objectAlias")) {
                        RestObjectDetailsPanel.this.aliasTextField.setText(RestObjectDetailsPanel.this.restObjectDataModel.getObjectAlias());
                    } else if (string.equals("enabled")) {
                        RestObjectDetailsPanel.this.enableCheckBox.setSelected(RestObjectDetailsPanel.this.restObjectDataModel.isEnabled());
                    } else if (string.equals("commit")) {
                        RestObjectDetailsPanel.this.commitCheckBox.setSelected(RestObjectDetailsPanel.this.restObjectDataModel.isCommit());
                    } else if (string.equals("authorisationRequired")) {
                        RestObjectDetailsPanel.this.authReqCheckBox.setSelected(RestObjectDetailsPanel.this.restObjectDataModel.isAuthorisationRequired());
                    } else if (string.equals("invalidObject")) {
                        if (RestObjectDetailsPanel.this.restObjectDataModel.isInvalidObject()) {
                            RestObjectDetailsPanel.this.enableCheckBox.setSelected(false);
                            RestObjectDetailsPanel.this.enableCheckBox.setEnabled(false);
                            String string2 = RestObjectDetailsPanel.this.restObjectDataModel.getInvalidMembers();
                            RestObjectDetailsPanel.this.setInvalidMsg(AutoRestArb.format("PANEL_OBJECT_DETAILS_INVALID_MEMBERS", string2));
                        } else {
                            RestObjectDetailsPanel.this.enableCheckBox.setSelected(RestObjectDetailsPanel.this.restObjectDataModel.isEnabled());
                            RestObjectDetailsPanel.this.enableCheckBox.setEnabled(true);
                            RestObjectDetailsPanel.this.setInvalidMsg("");
                        }
                    } else if (string.equals("invalidMembers")) {
                        String string3 = RestObjectDetailsPanel.this.restObjectDataModel.getInvalidMembers();
                        if (string3 == null || string3.length() == 0) {
                            RestObjectDetailsPanel.this.setInvalidMsg("");
                        } else {
                            RestObjectDetailsPanel.this.setInvalidMsg(AutoRestArb.format("PANEL_OBJECT_DETAILS_INVALID_MEMBERS", string3));
                        }
                    }
                }
            }
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.propertyChangeImpl(propertyChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ObjectDataModelListener.this.propertyChangeImpl(propertyChangeEvent);
                    }
                });
            }
        }
    }

    private class EnableCheckBoxListener
    implements ItemListener {
        private EnableCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList<String> arrayList = RestObjectDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectDetailsPanel.this.ignorePropertyList.contains("enabled")) {
                    try {
                        RestObjectDetailsPanel.this.ignorePropertyList.add("enabled");
                        RestObjectDetailsPanel.this.restObjectDataModel.setEnabled(RestObjectDetailsPanel.this.enableCheckBox.isSelected());
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        RestObjectDetailsPanel.this.ignorePropertyList.remove("enabled");
                    }
                }
            }
        }
    }

    private class AuthReqCheckBoxListener
    implements ItemListener {
        private AuthReqCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList<String> arrayList = RestObjectDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectDetailsPanel.this.ignorePropertyList.contains("authorisationRequired")) {
                    try {
                        RestObjectDetailsPanel.this.ignorePropertyList.add("authorisationRequired");
                        RestObjectDetailsPanel.this.restObjectDataModel.setAuthorisationRequired(RestObjectDetailsPanel.this.authReqCheckBox.isSelected());
                        if (RestObjectDetailsPanel.this.authReqCheckBox.isSelected()) {
                            RestObjectDetailsPanel.this.authReqCheckBox.setText(AutoRestArb.format("PANEL_REQUIRED_ROLE_NAME", "oracle.dbtools.role.autorest." + RestObjectDetailsPanel.this.restObjectDataModel.getOwner() + "." + RestObjectDetailsPanel.this.restObjectDataModel.getObjectName()));
                        } else {
                            RestObjectDetailsPanel.this.authReqCheckBox.setText("");
                        }
                    }
                    finally {
                        RestObjectDetailsPanel.this.ignorePropertyList.remove("authorisationRequired");
                    }
                }
            }
        }
    }

    private class CommitCheckBoxListener
    implements ItemListener {
        private CommitCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList<String> arrayList = RestObjectDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectDetailsPanel.this.ignorePropertyList.contains("commit")) {
                    try {
                        RestObjectDetailsPanel.this.ignorePropertyList.add("commit");
                        RestObjectDetailsPanel.this.restObjectDataModel.setCommit(RestObjectDetailsPanel.this.commitCheckBox.isSelected());
                    }
                    finally {
                        RestObjectDetailsPanel.this.ignorePropertyList.remove("commit");
                    }
                }
            }
        }
    }

    private class AliasInputVerifier
    extends InputVerifier {
        private AliasInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            if (string != null) {
                return !string.matches("^.*[:/?#\\[\\]@!$&'()*+,;=].*$");
            }
            return false;
        }
    }
}

