/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.model;

import java.util.Map;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.autorest.model.AutoRestListTask;
import oracle.dbtools.autorest.model.AutoRestRowTask;
import oracle.dbtools.autorest.model.RestSchemaData;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.utils.DBObject;

public class RestSchemaDataInitialiser
implements Runnable {
    private RestSchemaData restSchemaDataModel;
    private DBObject dbObj;
    private AutoRestRowTask ordsDetailsTask;

    public RestSchemaDataInitialiser(RestSchemaData restSchemaData, DBObject dBObject) {
        this.restSchemaDataModel = restSchemaData;
        this.dbObj = dBObject;
        try {
            this.restSchemaDataModel.setSchemaName(dBObject.getConnection().getMetaData().getUserName());
        }
        catch (Throwable throwable) {
            this.restSchemaDataModel.setSchemaName(dBObject.getSchemaName());
        }
        this.restSchemaDataModel.setVersion(dBObject.getDBVersion());
        this.ordsDetailsTask = new TableRowMapTask(){

            @Override
            public String getTemplatName() {
                return "SCHEMA_METADATA";
            }
        };
    }

    @Override
    public void run() {
        try {
            Boolean[] booleanArray;
            String[] stringArray;
            int n;
            RaptorTaskManager.getInstance().addTask((RaptorTask)this.ordsDetailsTask);
            this.restSchemaDataModel.setCommit(true);
            Map map = (Map)this.ordsDetailsTask.getResult();
            if (map.size() == 0) {
                this.restSchemaDataModel.setEnabled(false);
                this.restSchemaDataModel.setSchemaAlias(this.dbObj.getSchemaName().toLowerCase());
                this.restSchemaDataModel.setAuthorisationRequired(true);
                n = 0xFFFFFF;
            } else {
                stringArray = (String[])map.get("STATUS");
                booleanArray = (Boolean[])map.get("PATTERN");
                String string = (String)map.get("AUTO_REST_AUTH");
                this.restSchemaDataModel.setEnabled(stringArray == null ? false : stringArray.equalsIgnoreCase("enabled"));
                this.restSchemaDataModel.setSchemaAlias((String)(booleanArray == null ? this.dbObj.getSchemaName().toLowerCase() : booleanArray));
                this.restSchemaDataModel.setAuthorisationRequired(string == null ? true : string.equalsIgnoreCase("enabled"));
                n = map.get("OPS_ALLOWED") == null ? 0xFFFFFF : Integer.valueOf((String)map.get("OPS_ALLOWED"));
            }
            stringArray = new String[RestSchemaData.operationNames.length];
            booleanArray = new Boolean[RestSchemaData.operationNames.length];
            for (int i = 0; i < RestSchemaData.operationNames.length; ++i) {
                stringArray[i] = AutoRestArb.getString(RestSchemaData.operationNames[i]);
                booleanArray[i] = (n & 1 << i) != 0;
            }
            this.restSchemaDataModel.setOperations(stringArray);
            this.restSchemaDataModel.setAllowed(booleanArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private abstract class TableRowMapTask
    extends AutoRestRowTask {
        public abstract String getTemplatName();

        @Override
        public String getQuery() {
            AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
            String string = RestSchemaDataInitialiser.this.dbObj.getSchemaName();
            String string2 = RestSchemaDataInitialiser.this.dbObj.getObjectName();
            String string3 = RestSchemaDataInitialiser.this.dbObj.getDBVersion();
            String string4 = autoRestCodeGenerator.generate(string3, this.getTemplatName(), "owner", string, "object", string2);
            return string4;
        }

        @Override
        public DBObject getDBObject() {
            return RestSchemaDataInitialiser.this.dbObj;
        }
    }

    private abstract class TableColumnsListTask
    extends AutoRestListTask {
        public abstract String getTemplateName();

        @Override
        public String getQuery() {
            if (this.getTemplateName() == null) {
                return "";
            }
            AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
            String string = RestSchemaDataInitialiser.this.dbObj.getSchemaName();
            String string2 = RestSchemaDataInitialiser.this.dbObj.getObjectName();
            String string3 = RestSchemaDataInitialiser.this.dbObj.getDBVersion();
            String string4 = autoRestCodeGenerator.generate(string3, this.getTemplateName(), "owner", string, "connection", string2);
            return string4;
        }

        @Override
        public DBObject getDBObject() {
            return RestSchemaDataInitialiser.this.dbObj;
        }
    }
}

