/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.navigator.SshController;
import oracle.dbtools.raptor.ssh.navigator.SshFolderElement;
import oracle.dbtools.raptor.ssh.navigator.SshTunnelElement;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

class SshHostElement
extends SshFolderElement<SshTunnelElement> {
    private String m_name;
    private HostDescriptor m_host;

    static SshHostElement createHostElement(HostDescriptor hostDescriptor) {
        SshHostElement sshHostElement = new SshHostElement(hostDescriptor.getName(), hostDescriptor);
        sshHostElement.initListeners();
        return sshHostElement;
    }

    private SshHostElement(String string, HostDescriptor hostDescriptor) {
        this.m_name = string;
        this.m_host = hostDescriptor;
    }

    HostDescriptor getHost() {
        return this.m_host;
    }

    public String getShortLabel() {
        return this.m_name;
    }

    @Override
    protected Icon loadIcon() {
        return OracleIcons.getIcon((String)"hostconnection.png");
    }

    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    protected List<SshTunnelElement> loadChildren() {
        ArrayList<SshTunnelElement> arrayList = new ArrayList<SshTunnelElement>();
        Store store = Client.getInstance().getStore();
        for (String string : store.listTunnels(this.m_name)) {
            TunnelDescriptor tunnelDescriptor = store.getTunnelDescriptor(this.m_name, string);
            SshTunnelElement sshTunnelElement = SshTunnelElement.createTunnelElement(string, tunnelDescriptor);
            arrayList.add(sshTunnelElement);
        }
        return arrayList;
    }

    @Override
    protected void handleHostChanged(StoreEvent storeEvent) {
        if (this.m_host.equals((Object)storeEvent.getOldDescriptor())) {
            HostDescriptor hostDescriptor = storeEvent.getHostDescriptor();
            this.m_name = hostDescriptor.getName();
            this.m_host = hostDescriptor;
            UpdateMessage.fireObjectRenamed((Subject)this);
        }
    }

    @Override
    protected void handleTunnelAdded(StoreEvent storeEvent) {
        if (this.m_name.equals(storeEvent.getHostDescriptor().getName())) {
            TunnelDescriptor tunnelDescriptor = storeEvent.getTunnelDescriptor();
            String string = tunnelDescriptor.getName();
            SshTunnelElement sshTunnelElement = SshTunnelElement.createTunnelElement(string, tunnelDescriptor);
            this.addChild(sshTunnelElement);
        }
    }

    @Override
    protected void handleTunnelRemoved(StoreEvent storeEvent) {
        TunnelDescriptor tunnelDescriptor;
        String string;
        SshTunnelElement sshTunnelElement;
        if (this.m_name.equals(storeEvent.getHostDescriptor().getName()) && (sshTunnelElement = this.findChild(new SshFolderElement.Matcher<SshTunnelElement>(){
            final /* synthetic */ String val$tunnel;
            {
                this.val$tunnel = string;
            }

            @Override
            public boolean matches(SshTunnelElement sshTunnelElement) {
                TunnelDescriptor tunnelDescriptor = sshTunnelElement.getTunnel();
                return ModelUtil.areEqual((Object)this.val$tunnel, (Object)tunnelDescriptor.getName());
            }
        })) != null) {
            this.removeChild(sshTunnelElement);
        }
    }

    @Override
    protected void processClientEvent(ClientEvent clientEvent) {
        switch (clientEvent.getType()) {
            case SESSION_CLOSED: 
            case SESSION_OPENED: {
                HostConnection hostConnection = clientEvent.getConnection();
                HostDescriptor hostDescriptor = hostConnection.getDescriptor();
                if (!this.m_host.equals((Object)hostDescriptor)) break;
                SshController.updateOverlays((Element)this);
                break;
            }
        }
    }
}

