/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import java.awt.Component;
import java.util.concurrent.Callable;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;

public class InteractionSupport {
    private static String promptForPassword(final String string, final String string2) {
        Worker<String> worker = new Worker<String>(){

            @Override
            public void run() {
                SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow()){

                    protected JTextComponent createInputComponent() {
                        return new JPasswordField(15);
                    }
                };
                String string3 = simpleInputDialog.show(string, string2, null) ? simpleInputDialog.getInputValue() : null;
                this.setResult(string3);
            }
        };
        String string3 = null;
        try {
            string3 = (String)worker.call();
        }
        catch (Exception exception) {
            Logger.severe(InteractionSupport.class, (Throwable)exception);
        }
        return string3;
    }

    private static void displayMessage(String string, final String string2) {
        Worker<Void> worker = new Worker<Void>(){

            @Override
            public void run() {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)SshSupportResources.getString("SSH_AUTHORIZATION_TITLE"), null);
            }
        };
        try {
            worker.call();
        }
        catch (Exception exception) {
            Logger.severe(InteractionSupport.class, (Throwable)exception);
        }
    }

    public static FilePasswordProvider getPasswordProvider() {
        return (sessionContext, namedResource, n) -> InteractionSupport.promptForPassword(SshSupportResources.getString("SSH_AUTHORIZATION_REQUIRED_TITLE"), SshSupportResources.format("SSH_AUTHORIZATION_PASSPHRASE", namedResource.getName()));
    }

    public static UserInteraction getUserInteraction() {
        return UserInteractionImpl.INSTANCE;
    }

    public static String promptForPassword(ClientSession clientSession) {
        return InteractionSupport.promptForPassword(SshSupportResources.getString("SSH_AUTHORIZATION_TITLE"), SshSupportResources.format("SSH_PASSWORD_PROMPT", clientSession.getUsername()));
    }

    private InteractionSupport() {
    }

    private static abstract class Worker<V>
    implements Callable<V>,
    Runnable {
        private volatile V result;

        private Worker() {
        }

        protected void setResult(V v) {
            this.result = v;
        }

        @Override
        public V call() throws Exception {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeAndWait(this);
            }
            return this.result;
        }
    }

    private static class UserInteractionImpl
    implements UserInteraction {
        static final UserInteractionImpl INSTANCE = new UserInteractionImpl();

        private UserInteractionImpl() {
        }

        public String getUpdatedPassword(ClientSession clientSession, String string, String string2) {
            return InteractionSupport.promptForPassword(SshSupportResources.getString("SSH_AUTHORIZATION_TITLE"), string);
        }

        public String[] interactive(ClientSession clientSession, String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            return new String[0];
        }
    }
}

