/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.gallery;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.gallery.GalleryItem;
import oracle.dbtools.raptor.gallery.GalleryManager;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class NewObjectPanel
extends DefaultTraversablePanel
implements Helpable {
    private static final String KEY_ITEM = GalleryItem.class.getName();
    public static final String CONTEXT_KEY = "NewObjectPanel.CONTEXT";
    private ListSelectionModel m_selModel;
    private List<Wrapper> m_items;
    private DialogCallbacks m_callbacks;

    NewObjectPanel() {
        this.setLayout(new GridBagLayout());
        this.m_selModel = new SelModel();
        this.m_selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (NewObjectPanel.this.m_callbacks != null) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    boolean bl = false;
                    int n = listSelectionModel.getLeadSelectionIndex();
                    if (n != -1) {
                        Wrapper wrapper = NewObjectPanel.this.m_items.get(n);
                        bl = wrapper.getItem() != null;
                    }
                    NewObjectPanel.this.m_callbacks.enableOKButton(bl);
                }
            }
        });
        JList jList = new JList();
        jList.setSelectionModel(this.m_selModel);
        jList.setCellRenderer(Renderer.INSTANCE);
        ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
        boolean bl = false;
        GalleryManager galleryManager = GalleryManager.getInstance();
        for (String string : galleryManager.getCategories()) {
            if (bl) {
                arrayList.add(new Wrapper(null));
            }
            for (GalleryItem galleryItem : galleryManager.getItems(string)) {
                arrayList.add(new Wrapper(galleryItem));
            }
            bl = true;
        }
        this.m_items = Collections.unmodifiableList(arrayList);
        jList.setModel(new GalleryListModel());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, jList, (String)ExtrasArb.getString("NEW_GALLERY_CREATE_LABEL_1"));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_callbacks = traversableContext.getDialogCallbacks();
        GalleryItem galleryItem = (GalleryItem)traversableContext.get(KEY_ITEM);
        if (galleryItem != null) {
            Wrapper wrapper = new Wrapper(galleryItem);
            int n = this.m_items.indexOf(wrapper);
            this.m_selModel.setSelectionInterval(n, n);
        } else {
            this.m_selModel.setSelectionInterval(-1, -1);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        int n = this.m_selModel.getLeadSelectionIndex();
        if (n != -1) {
            GalleryItem galleryItem = this.m_items.get(n).getItem();
            traversableContext.put(KEY_ITEM, (Object)galleryItem);
        }
        this.m_callbacks = null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idenewobjectgallery_html");
    }

    private class SelModel
    implements ListSelectionModel {
        private List<ListSelectionListener> m_listeners = new CopyOnWriteArrayList<ListSelectionListener>();
        private int m_idx;

        private SelModel() {
        }

        private void fireSelectionChanged(int n) {
            ListSelectionEvent listSelectionEvent = null;
            for (ListSelectionListener listSelectionListener : this.m_listeners) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n, false);
                }
                listSelectionListener.valueChanged(listSelectionEvent);
            }
        }

        private void updateSelection(int n) {
            if (n == -1) {
                n = 0;
            } else {
                Wrapper wrapper = NewObjectPanel.this.m_items.get(n);
                if (wrapper.getItem() == null) {
                    n = n > this.m_idx ? ++n : --n;
                }
            }
            this.fireSelectionChanged(this.m_idx);
            this.m_idx = n;
            this.fireSelectionChanged(n);
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.m_listeners.add(listSelectionListener);
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            this.setSelectionInterval(n, n2);
        }

        @Override
        public void clearSelection() {
            this.updateSelection(-1);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.m_idx;
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.m_idx;
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.m_idx;
        }

        @Override
        public int getMinSelectionIndex() {
            return this.m_idx;
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
        }

        @Override
        public boolean isSelectedIndex(int n) {
            return this.m_idx == n;
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.m_idx == -1;
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.m_listeners.remove(listSelectionListener);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (this.m_idx == n2) {
                this.clearSelection();
            }
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            this.updateSelection(n);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            this.setLeadSelectionIndex(n2);
        }

        @Override
        public void setSelectionMode(int n) {
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
        }
    }

    private static final class Renderer
    implements ListCellRenderer {
        static final Renderer INSTANCE = new Renderer();
        private ListCellRenderer m_delegate = new DefaultListCellRenderer();
        private JSeparator m_separator = new JSeparator(0);

        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Wrapper wrapper = (Wrapper)object;
            GalleryItem galleryItem = wrapper.getItem();
            if (galleryItem == null) {
                return this.m_separator;
            }
            JLabel jLabel = (JLabel)this.m_delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            Icon icon = galleryItem.getIcon();
            if (icon != null) {
                jLabel.setIcon(icon);
            }
            jLabel.setText(galleryItem.getShortLabel());
            return jLabel;
        }
    }

    private static class Wrapper {
        private static final String SEPARATOR_LABEL = "Separator";
        private GalleryItem m_obj;

        Wrapper(GalleryItem galleryItem) {
            this.m_obj = galleryItem;
        }

        GalleryItem getItem() {
            return this.m_obj;
        }

        public String toString() {
            return this.m_obj != null ? this.m_obj.toString() : SEPARATOR_LABEL;
        }

        public int hashCode() {
            return this.m_obj != null ? this.m_obj.hashCode() : SEPARATOR_LABEL.hashCode();
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Wrapper && ModelUtil.areEqual((Object)this.m_obj, (Object)((Wrapper)object).m_obj);
        }
    }

    private class GalleryListModel
    extends AbstractListModel {
        private GalleryListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return NewObjectPanel.this.m_items.get(n);
        }

        @Override
        public int getSize() {
            return NewObjectPanel.this.m_items.size();
        }
    }
}

