/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.connection;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import oracle.dbtools.connections.db.ora.LegacyOracleConnectionCreator;
import oracle.dbtools.connections.db.ora.OracleConnectionCreator;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.ssh.TunnelOpenRunnable;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.JDBCProxyUtil;
import oracle.dbtools.raptor.utils.WindowsOSUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleDataSource;

public class RaptorConnectionCreator
extends LegacyOracleConnectionCreator {
    private boolean useJDBCProxy = true;
    public static final String EXPORT_PASSWORD_CHECKSUM = "ExportKeyChecksum";
    private static final Logger LOGGER = Logger.getLogger(OracleConnectionCreator.class.getName());
    private static String CANCEL_CONNECTION = "RaptorConnectionCreator.cancel_connection";

    public void setUseJDBCProxy(boolean bl) {
        this.useJDBCProxy = bl;
    }

    public boolean isUseJDBCProxy() {
        return this.useJDBCProxy;
    }

    public boolean shouldPromptForPassword(Properties properties) {
        return true;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        Connection connection = null;
        Properties properties2 = properties;
        Properties properties3 = new Properties();
        properties3.putAll((Map<?, ?>)properties2);
        Connections.populateConnectionInfo((Properties)properties3);
        OracleConnectionProcessor oracleConnectionProcessor = OracleConnectionType.getConnectionProcessor((String)properties3.getProperty("OracleConnectionType"));
        oracleConnectionProcessor.validateProperties(properties3);
        properties3 = this.updateForSSH(properties3);
        DBConfig dBConfig = DBConfig.getInstance();
        Boolean bl = dBConfig.getBoolean("USE_THICK_DRIVER") != false || Boolean.parseBoolean(properties3.getProperty("useOCI"));
        String string = properties3.getProperty("customUrl");
        if (Connections.isOCIDriverAvailable() && bl.booleanValue() && ConnectionUtils.scrubOraDriverType(string).equalsIgnoreCase("thin")) {
            properties3.setProperty("customUrl", ConnectionUtils.getOCIUrl(properties3));
        }
        connection = bl == false && Boolean.parseBoolean(properties2.getProperty("KERBEROS_AUTHENTICATION")) ? this.getKerberosConnection(properties2, properties3, dBConfig) : this.getConnectionImpl(properties3);
        if (Boolean.parseBoolean(properties3.getProperty("IS_PROXY"))) {
            this.openProxySession(connection, properties3);
        }
        return connection;
    }

    private Connection getKerberosConnection(Properties properties, Properties properties2, DBConfig dBConfig) throws SQLException, ConnectionCanceledException {
        Connection connection = null;
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        String string3 = dBConfig.getString("KERBEROS_CONFIG");
        properties2.setProperty("customUrl", ConnectionUtils.getThinUrl(properties2));
        if (string3 != null && new File(string3).exists()) {
            System.setProperty("java.security.krb5.conf", string3);
        } else {
            System.clearProperty("java.security.krb5.conf");
        }
        properties2.setProperty("user", "");
        properties2.setProperty("password", "");
        String string4 = dBConfig.getString("KERBEROS_CACHE");
        if (string == null || string.equals("")) {
            properties2.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
            properties2.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
            if (string4 != null && !string4.equals("")) {
                properties2.setProperty("oracle.net.kerberos5_cc_name", string4);
            }
            connection = this.getConnectionImpl(properties2);
        } else {
            boolean bl;
            Subject subject = new Subject();
            final String string5 = string2;
            final Properties properties3 = new Properties();
            properties3.putAll((Map<?, ?>)properties);
            Krb5LoginModule krb5LoginModule = new Krb5LoginModule();
            HashMap hashMap = new HashMap();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("doNotPrompt", "false");
            if (string4 != null && !string4.equals("")) {
                hashMap2.put("useTicketCache", "true");
                hashMap2.put("ticketCache", string4);
            } else {
                hashMap2.put("useTicketCache", "false");
            }
            hashMap2.put("principal", string);
            krb5LoginModule.initialize(subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbackArray.length; ++i) {
                        if (callbackArray[i] instanceof PasswordCallback) {
                            PasswordCallback passwordCallback = (PasswordCallback)callbackArray[i];
                            if (string5 == null || string5.equals("")) {
                                Properties properties = new Properties();
                                properties.putAll((Map<?, ?>)properties3);
                                String string = null;
                                string = RaptorConnectionCreator.this.getPassword(properties, properties3);
                                properties3.setProperty("password", string);
                                if (string == null) {
                                    passwordCallback.setPassword(null);
                                    continue;
                                }
                                passwordCallback.setPassword(string.toCharArray());
                                continue;
                            }
                            passwordCallback.setPassword(string5.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbackArray[i], CreateDialogArb.getString((String)"UNRECOGNISED_CALLBACK"));
                    }
                }
            }, hashMap, hashMap2);
            try {
                bl = krb5LoginModule.login();
                krb5LoginModule.commit();
            }
            catch (LoginException loginException) {
                String string6 = properties3.getProperty(CANCEL_CONNECTION);
                if (string6 != null && string6.equals("true")) {
                    throw new ConnectionCanceledException();
                }
                throw new SQLException(loginException.getLocalizedMessage());
            }
            if (!bl) {
                throw new SQLException(CreateDialogArb.getString((String)"KERBEROS_CREDENTIALS"));
            }
            properties2.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
            if (string4 != null && !string4.equals("")) {
                properties2.setProperty("oracle.net.kerberos5_cc_name", string4);
            }
            Properties properties4 = new Properties();
            properties4.putAll((Map<?, ?>)properties2);
            final Properties properties5 = properties4;
            try {
                String string7;
                connection = Subject.doAs(subject, new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws SQLException {
                        return RaptorConnectionCreator.this.getConnectionImpl(properties5);
                    }
                });
                if (connection != null && ModelUtil.hasLength((String)(string7 = properties3.getProperty("password"))) && !ModelUtil.hasLength((String)string2)) {
                    properties.setProperty("password", string7);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                LOGGER.log(Level.WARNING, privilegedActionException.getStackTrace()[0].toString(), privilegedActionException);
            }
        }
        return connection;
    }

    protected boolean allowNullPassword() {
        return true;
    }

    private static void updateProperty(Properties properties, Properties properties2, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            properties2.setProperty(string, string2);
        }
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        String[] stringArray;
        super.setCustomProperties(properties, properties2);
        String string2 = ConnectionUtils.scrubOraDriverType(properties.getProperty("customUrl"));
        if (Boolean.parseBoolean(properties.getProperty("OS_AUTHENTICATION")) && PlatformUtils.isWindows() && string2.equalsIgnoreCase("thin")) {
            properties2.setProperty("v$session.osuser", WindowsOSUtils.getUserWithDomain());
        }
        RaptorConnectionCreator.updateProperty(properties, properties2, "OCINewPassword");
        RaptorConnectionCreator.updateProperty(properties, properties2, "oracle.jdbc.newPassword");
        for (String string3 : stringArray = new String[]{"oracle.net.authentication_services", "oracle.net.kerberos5_cc_name", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "access.alternate.url"}) {
            String string4 = null;
            string4 = properties.getProperty(string3);
            if (string4 == null) continue;
            properties2.setProperty(string3, string4);
        }
        String string5 = System.getProperty("jdbc.machine");
        if (string5 == null) {
            properties2.remove("v$session.machine");
        } else {
            String oracleConnectionProcessor = properties2.getProperty("v$session.machine");
            if (oracleConnectionProcessor != null && oracleConnectionProcessor.length() > 60) {
                properties2.setProperty("v$session.machine", oracleConnectionProcessor.substring(0, 60));
            }
        }
        properties.stringPropertyNames().stream().filter(string -> string.startsWith("sqldev.advanced.")).forEach(string -> properties2.put(string.substring("sqldev.advanced.".length()), properties.get(string)));
        OracleConnectionProcessor oracleConnectionProcessor = OracleConnectionType.getConnectionProcessor((String)properties.getProperty("OracleConnectionType"));
        properties2.putAll((Map<?, ?>)oracleConnectionProcessor.finalizeProperties(properties));
    }

    private void openProxySession(Connection connection, Properties properties) throws SQLException {
        String string = properties.getProperty("PROXY_TYPE");
        Properties properties2 = new Properties();
        if (string.equals("USER NAME")) {
            String string2 = properties.getProperty("PROXY_USER_NAME");
            String string3 = properties.getProperty("PROXY_USER_PASSWORD");
            properties2.put("PROXY_USER_NAME", string2);
            if (string3 != null && string3.length() > 0) {
                properties2.put("PROXY_USER_PASSWORD", string3);
            }
            ((OracleConnection)connection).openProxySession(1, properties2);
        } else if (string.equals("DISTINGUISHED NAME")) {
            properties2.put("PROXY_USER_NAME", properties.getProperty("PROXY_USER_NAME"));
            properties2.put("PROXY_DISTINGUISHED_NAME", properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            ((OracleConnection)connection).openProxySession(2, properties2);
        }
    }

    String getPassword(Properties properties, Properties properties2) throws IOException {
        String string = null;
        Properties properties3 = new Properties();
        properties3.putAll((Map<?, ?>)properties);
        properties2.remove(CANCEL_CONNECTION);
        try {
            ConnectionInfoPanel.promptForConnection((Properties)properties3);
            string = properties3.getProperty("password") == null ? "" : properties3.getProperty("password");
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            properties2.setProperty(CANCEL_CONNECTION, Boolean.toString(true));
            throw new IOException(connectionCanceledException.getLocalizedMessage());
        }
        return string;
    }

    public boolean shouldEncrypt(String string) {
        boolean bl = false;
        if (EXPORT_PASSWORD_CHECKSUM.equals(string)) {
            bl = true;
        } else if ("PROXY_USER_PASSWORD".equals(string)) {
            bl = true;
        } else {
            for (OracleConnectionProcessor oracleConnectionProcessor : OracleConnectionType.getConnectionProcessors()) {
                if (!oracleConnectionProcessor.shouldEncrypt(string)) continue;
                bl = true;
                break;
            }
        }
        return bl || super.shouldEncrypt(string);
    }

    private Connection getConnectionImpl(Properties properties) throws SQLException {
        Connection connection = this.createConnection(properties);
        if (this.isUseJDBCProxy()) {
            try {
                Connection connection2 = JDBCProxyUtil.getInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).jdbcProxyFor(connection, properties);
                if (connection2 != null) {
                    connection = connection2;
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return connection;
    }

    private Connection createConnection(Properties properties) throws SQLException {
        String string = this.getConnectionURL(properties);
        Properties properties2 = this.getJDBCProperties(properties);
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setURL(string);
        oracleDataSource.setConnectionProperties(properties2);
        return oracleDataSource.getConnection();
    }

    private Properties updateForSSH(Properties properties) throws SQLException {
        Properties properties2 = properties;
        String string = properties.getProperty("SshHost.NAME");
        if (string != null) {
            String string2 = properties.getProperty("SshTunnel.NAME");
            Client client = Client.getInstance();
            Store store = client.getStore();
            TunnelDescriptor tunnelDescriptor = store.getTunnelDescriptor(string, string2);
            if (tunnelDescriptor == null) {
                throw new SQLException("Bad SSH details");
            }
            try {
                Tunnel tunnel = TunnelOpenRunnable.openTunnel((Client)client, (TunnelDescriptor)tunnelDescriptor);
                int n = tunnel.getPort();
                properties2 = new Properties();
                properties2.putAll((Map<?, ?>)properties);
                properties2.setProperty("hostname", "localhost");
                properties2.setProperty("port", Integer.toString(n));
                properties2.setProperty("customUrl", this.getConnectionURL(properties2));
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
        }
        return properties2;
    }
}

