/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import javax.ide.util.MetaClass;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ideri.util.BundlePropertyResolver;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;

public final class ActionUtil {
    private ActionUtil() {
    }

    public static IdeAction getAction(Class resourceClass, int cmdId, MetaClass command, String baseRes, final String sharedIconId) {
        IdeAction action = ActionUtil.getAction(resourceClass, cmdId, command, baseRes);
        if (sharedIconId == null) {
            return action;
        }
        action.addPropertyResolver(new PropertyResolver(){

            public Object get(String key) {
                if ("SmallIcon" != key) {
                    return null;
                }
                try {
                    return VCSIconArb.getIcon(sharedIconId);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        return action;
    }

    public static IdeAction getAction(Class resourceClass, int cmdId, MetaClass command, String baseRes) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            action = IdeAction.get((int)cmdId);
            HashMap<String, CallSite> actionToBundle = new HashMap<String, CallSite>();
            actionToBundle.put("SmallIcon", (CallSite)((Object)(baseRes + "_ICON")));
            actionToBundle.put("Name", (CallSite)((Object)(baseRes + "_NAME")));
            actionToBundle.put("NoCtxName", (CallSite)((Object)(baseRes + "_INDEPENDENT_NAME")));
            actionToBundle.put("MnemonicKey", (CallSite)((Object)(baseRes + "_MNEMONIC")));
            actionToBundle.put("ShortDescription", (CallSite)((Object)(baseRes + "_TOOLTIP")));
            action.addPropertyResolver((PropertyResolver)new BundlePropertyResolver(resourceClass.getName(), resourceClass.getClassLoader(), actionToBundle));
            action.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
            action.setEnabled(true);
            action.setCommand(command);
        }
        return action;
    }
}

