/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.ClassUtil;

public class VCSGenericUtil {
    public static VCSOverlayItemProducer newOverlayProducer(VCSProfile profile, Class<? extends VCSOverlayItemProducer> theClass) {
        return VCSGenericUtil.newOverlayProducer(profile, theClass, null);
    }

    public static VCSOverlayItemProducer newOverlayProducer(VCSProfile profile, Class<? extends VCSOverlayItemProducer> theClass, StatusCacheBridge statusCache) {
        try {
            if (theClass == null) {
                profile.getLogger().fine("using a default overlay item producer");
                return new VCSOverlayItemProducer(profile.getId(), statusCache != null ? statusCache : profile.getStatusCacheBridge());
            }
            try {
                Constructor<? extends VCSOverlayItemProducer> theConstructor = theClass.getConstructor(StatusCache.class);
                return ClassUtil.newInstance(theConstructor, statusCache != null ? statusCache : profile.getPolicyStatusCache());
            }
            catch (NoSuchMethodException nsme) {
                profile.getLogger().warning("no policy status cache (StatusCache) constructor on  " + theClass.getName());
                try {
                    Constructor<? extends VCSOverlayItemProducer> theConstructor = theClass.getConstructor(VCSStatusCache.class);
                    return ClassUtil.newInstance(theConstructor, statusCache != null ? statusCache : profile.getStatusCache());
                }
                catch (NoSuchMethodException nsme2) {
                    profile.getLogger().warning("no legacy status cache (VCSStatusCache) constructor on  " + theClass.getName());
                    profile.getLogger().warning("using default constructor for " + theClass.getName());
                    VCSOverlayItemProducer theInstance = ClassUtil.newInstance(theClass);
                    try {
                        Method theMethod = theClass.getMethod("setPolicyStatusCache", StatusCache.class);
                        theMethod.invoke((Object)theInstance, statusCache != null ? statusCache : profile.getPolicyStatusCache());
                        return theInstance;
                    }
                    catch (NoSuchMethodException nsme1) {
                        profile.getLogger().warning("could not find method 'setPolicyStatusCache' on " + theClass.getName());
                        try {
                            Method theMethod = theClass.getMethod("setStatusCache", VCSStatusCache.class);
                            theMethod.invoke((Object)theInstance, statusCache != null ? statusCache : profile.getStatusCache());
                            return theInstance;
                        }
                        catch (NoSuchMethodException nsme12) {
                            profile.getLogger().warning("could not find method 'setStatusCache' on " + theClass.getName());
                            profile.getLogger().warning("assuming no arg constructor sufficient");
                            return theInstance;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Exception cause = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            profile.getLogger().log(Level.SEVERE, "unable to instantiate overlay item producer, using a default instance", cause);
            return new VCSOverlayItemProducer(profile.getId(), statusCache != null ? statusCache : profile.getStatusCacheBridge());
        }
    }

    public static URL getContextDirectoryURL(Context context, VCSProfile profile) {
        URL defaultUrl = URLFactory.newDirURL((String)Ide.getWorkDirectory());
        if (defaultUrl == null || !URLFileSystem.exists((URL)defaultUrl)) {
            defaultUrl = URLFactory.newDirURL((String)System.getProperty("user.home"));
        }
        if (context == null) {
            return defaultUrl;
        }
        if (VCSModelUtils.findCachedProjects().length <= 0) {
            return defaultUrl;
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables(context, profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT"));
        if (locatables.length <= 0) {
            return defaultUrl;
        }
        URL[] contextUrls = VCSModelUtils.convertNodesToURLs(locatables);
        ArrayList<URL> contextDirectoryUrls = new ArrayList<URL>();
        for (int i = 0; i < contextUrls.length; ++i) {
            URL contextDirectoryUrl;
            URL contextUrl = locatables[i].getURL();
            URL uRL = contextDirectoryUrl = URLFileSystem.isDirectoryPath((URL)contextUrl) || URLFileSystem.isDirectory((URL)contextUrl) ? contextUrl : URLFileSystem.getParent((URL)contextUrl);
            if (!URLFileSystem.exists((URL)contextDirectoryUrl)) continue;
            contextDirectoryUrls.add(contextDirectoryUrl);
        }
        URL[] coalescedUrls = VCSFileSystemUtils.coalesceURLs(contextDirectoryUrls.toArray(new URL[0]));
        return coalescedUrls.length > 0 ? coalescedUrls[0] : defaultUrl;
    }
}

