/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayCoordinator;
import oracle.ide.explorer.IconOverlayRegistry;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.model.Displayable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.wizard.Wizard;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.SwingClosure;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.cache.ConcurrentStatusCache;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.cache.SynchronizedStatusCache;
import oracle.jdeveloper.vcs.cache.TransactionalStatusCache;
import oracle.jdeveloper.vcs.cache.UnsynchronizedStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListDockableFactory;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.generic.BaseStatusResolver;
import oracle.jdeveloper.vcs.generic.CheckOutProvider;
import oracle.jdeveloper.vcs.generic.ConflictsFinder;
import oracle.jdeveloper.vcs.generic.MultiChangeList;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.RemovedEntryLister;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VersionNameProvider;
import oracle.jdeveloper.vcs.properties.PropertiesPanelProvider;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.share.ShareWizard;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSHistoryGraphProvider;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.spi.VCSSingleNodeObserver;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.ClassUtil;
import oracle.jdevimpl.vcs.generic.GLazyIdeAction;
import oracle.jdevimpl.vcs.generic.GenericContextMenuListener;
import oracle.jdevimpl.vcs.generic.GenericController;
import oracle.jdevimpl.vcs.generic.GenericHistoryAction;
import oracle.jdevimpl.vcs.generic.GenericHistoryProvider;
import oracle.jdevimpl.vcs.generic.GenericPropertyPanelProvider;
import oracle.jdevimpl.vcs.generic.ProfileInfoRegistry;
import oracle.jdevimpl.vcs.generic.VCSActionInfoImpl;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.generic.changelist.GenericChangeListDockableFactory;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedChangeListWindow;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedMultiChangeList;
import oracle.jdevimpl.vcs.generic.changelist.ViewPendingChangesAction;
import oracle.jdevimpl.vcs.generic.profile.ActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionsInfo;
import oracle.jdevimpl.vcs.generic.profile.AutomaticActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.EventBusInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemHelperInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryGraphProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.PropertyProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.res.Resource;
import oracle.jdevimpl.vcs.generic.util.CandidateStatusFilter;
import oracle.jdevimpl.vcs.generic.util.RecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnrecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnversionedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.generic.util.VersionedStatusFilter;

public final class VCSProfileImpl
extends VCSProfile {
    private static final VCSStatus STATUS_UNRECOGNIZED = VCSDefaultUtils.createUnrecognizedStatus();
    private static final String AUTO_OP_CHECKOUT_NODE = "CHECKOUT_NODE";
    private Logger _logger;
    private ProfileInfo _profile;
    private URL _systemDirectory;
    private VCSExtensionInformation _clientInfo;
    private IdeAction _versionHistoryAction;
    private IdeAction _viewPendingChangesAction;
    private String _changeListViewID;
    private final Map<String, ChangeList> _changeListsById = new HashMap<String, ChangeList>(10);
    private final Map<String, ChangeListInfo> _changeListInfosById = new HashMap<String, ChangeListInfo>(10);
    private final Map<String, Object> _userData = new HashMap<String, Object>();
    private final Computable<StatusResolver> _statusResolver = new BaseLazyComputable<StatusResolver>("StatusResolver"){

        @Override
        protected StatusResolver getImplEx() throws Exception {
            if (VCSProfileImpl.this.getProfileInfo().getFileSystem() == null || VCSProfileImpl.this.getProfileInfo().getFileSystem().getStatuses() == null) {
                return null;
            }
            Class<StatusResolver> c = VCSProfileImpl.this.getProfileInfo().getFileSystem().getStatuses().getResolverClass();
            return c != null ? this.newInstance(c) : null;
        }
    };
    private final Computable<StatusesInfo> _statusesInfo = new BaseLazyComputable<StatusesInfo>("StatusesInfo"){

        @Override
        protected StatusesInfo getImplEx() throws Exception {
            FileSystemInfo fsi = VCSProfileImpl.this.getProfileInfo().getFileSystem();
            if (fsi == null || fsi.getStatuses() == null) {
                return null;
            }
            StatusesInfo s = fsi.getStatuses();
            s.addStatusFilter(new VersionedStatusFilter());
            s.addStatusFilter(new UnversionedStatusFilter());
            s.addStatusFilter(new CandidateStatusFilter());
            s.addStatusFilter(new RecognizedStatusFilter(STATUS_UNRECOGNIZED));
            s.addStatusFilter(new UnrecognizedStatusFilter(STATUS_UNRECOGNIZED));
            return s;
        }
    };
    private final Computable<Integer> _controlPrecedence = new BaseLazyComputable<Integer>("Control Precedence"){

        @Override
        protected Integer getImplEx() throws Exception {
            Integer precedence = VCSProfileImpl.this.getProfileInfo().getControlPrecedence();
            return precedence != null ? precedence : this.getFallback();
        }

        @Override
        protected Integer getFallback() {
            return VCSProfileImpl.super.getControlPrecedence();
        }
    };
    private final Computable<URLFilter> _controlFilter = new BaseLazyComputable<URLFilter>("Control Filter"){

        @Override
        protected URLFilter getImplEx() {
            URLFilter filter = VCSProfileImpl.this.getProfileInfo().getFileSystem().getURLFilter("oracle.jdeveloper.vcs.filters.url.CONTROL");
            return filter != null ? filter : this.getFallback();
        }

        @Override
        protected URLFilter getFallback() {
            return new URLFilter(){

                public final boolean accept(URL url) {
                    return false;
                }
            };
        }
    };
    private final Computable<VCSOverlayItemProducer> _overlayProducer = new BaseLazyComputable<VCSOverlayItemProducer>("VCSOverlayItemProducer"){

        @Override
        protected VCSOverlayItemProducer getImplEx() throws Exception {
            Class<VCSOverlayItemProducer> c = null;
            StatusesInfo statuses = VCSProfileImpl.this.getStatusesInfo();
            if (statuses != null) {
                c = statuses.getOverlayProducerClass();
            }
            if (c == null) {
                c = VCSProfileImpl.this.getProfileInfo().getOverlayProducerClass();
            }
            return VCSGenericUtil.newOverlayProducer(VCSProfileImpl.this, c);
        }

        @Override
        protected VCSOverlayItemProducer getFallback() {
            return new VCSOverlayItemProducer(VCSProfileImpl.this.getId(), VCSProfileImpl.this.getStatusCacheBridge());
        }

        @Override
        protected void init(VCSOverlayItemProducer value) {
        }
    };
    private final Computable<StatusCacheBridge<VCSStatus>> _statusCache = new BaseLazyComputable<StatusCacheBridge<VCSStatus>>("Status Cache"){

        @Override
        protected StatusCacheBridge<VCSStatus> getImplEx() throws Exception {
            String policyId;
            if (VCSProfileImpl.this.getProfileInfo().getStatusCacheClass() != null) {
                return this.newInstance(VCSProfileImpl.this.getProfileInfo().getStatusCacheClass());
            }
            if (VCSProfileImpl.this.getProfileInfo().getPolicyStatusCacheClass() != null) {
                return this.newInstance(VCSProfileImpl.this.getProfileInfo().getPolicyStatusCacheClass());
            }
            if (VCSProfileImpl.this.getStatusResolver() == null) {
                return new NullStatusCache();
            }
            StatusesInfo s = VCSProfileImpl.this.getStatusesInfo();
            String string = policyId = s != null && s.getCachePolicy() != null ? s.getCachePolicy().getPolicyId() : null;
            if (policyId == null) {
                return new LegacyStatusCacheAdapter(VCSProfileImpl.this.getStatusResolver());
            }
            if ("TRANSACTIONAL".equals(policyId)) {
                return new TransactionalStatusCacheAdapter(VCSProfileImpl.this.getStatusResolver());
            }
            if ("CONCURRENT".equals(policyId)) {
                return new ConcurrentStatusCacheAdapter(VCSProfileImpl.this.getStatusResolver());
            }
            if ("SYNCHRONIZED".equals(policyId)) {
                return new SynchronizedStatusCacheAdapter(VCSProfileImpl.this.getStatusResolver());
            }
            throw new IllegalArgumentException("Not a recognized status cache policy: " + policyId);
        }

        @Override
        protected StatusCacheBridge<VCSStatus> getFallback() {
            return new NullStatusCache();
        }

        final class NullStatusCache
        extends UnsynchronizedStatusCache<VCSStatus> {
            public NullStatusCache() {
                super(VCSStatus.class);
            }

            protected final void getNatively(URL[] urls, VCSStatus[] statuses) {
                for (int i = 0; i < statuses.length; ++i) {
                    statuses[i] = STATUS_UNRECOGNIZED;
                }
            }
        }

        final class LegacyStatusCacheAdapter
        extends VCSStatusCache {
            private final StatusResolver _statusResolver;

            LegacyStatusCacheAdapter(StatusResolver statusResolver) {
                this._statusResolver = statusResolver;
            }

            @Override
            protected void getImpl(URL[] urls, VCSStatus[] statuses) throws Exception {
                this._statusResolver.populateStatuses(VCSProfileImpl.this, urls, statuses);
            }

            @Override
            protected void clearValues(URLFilter filter, boolean invalidate) {
                if (this._statusResolver instanceof BaseStatusResolver) {
                    ((BaseStatusResolver)this._statusResolver).clearStatuses(filter);
                }
                super.clearValues(filter, invalidate);
            }
        }

        final class TransactionalStatusCacheAdapter
        extends TransactionalStatusCache<VCSStatus> {
            private final StatusResolver _statusResolver;

            TransactionalStatusCacheAdapter(StatusResolver statusResolver) {
                super(VCSStatus.class);
                this._statusResolver = statusResolver;
            }

            protected final void getNatively(URL[] urls, VCSStatus[] statuses) throws Exception {
                this._statusResolver.populateStatuses(VCSProfileImpl.this, urls, statuses);
            }
        }

        final class ConcurrentStatusCacheAdapter
        extends ConcurrentStatusCache<VCSStatus> {
            private final StatusResolver _statusResolver;

            ConcurrentStatusCacheAdapter(StatusResolver statusResolver) {
                super(VCSStatus.class);
                this._statusResolver = statusResolver;
            }

            protected final void getNatively(URL[] urls, VCSStatus[] statuses) throws Exception {
                this._statusResolver.populateStatuses(VCSProfileImpl.this, urls, statuses);
            }
        }

        final class SynchronizedStatusCacheAdapter
        extends SynchronizedStatusCache<VCSStatus> {
            private final StatusResolver _statusResolver;

            SynchronizedStatusCacheAdapter(StatusResolver statusResolver) {
                super(VCSStatus.class);
                this._statusResolver = statusResolver;
            }

            protected final void getNatively(URL[] urls, VCSStatus[] statuses) throws Exception {
                this._statusResolver.populateStatuses(VCSProfileImpl.this, urls, statuses);
            }
        }
    };
    private final Computable<VCSExceptionHandler> _exceptionHandler = new BaseLazyComputable<VCSExceptionHandler>("VCSExceptionHandler"){

        @Override
        protected VCSExceptionHandler getImplEx() throws Exception {
            Class<VCSExceptionHandler> c = VCSProfileImpl.this.getProfileInfo().getExceptionHandlerClass();
            return c != null ? this.newInstance(c) : this.getFallback();
        }

        @Override
        protected VCSExceptionHandler getFallback() {
            return VCSProfileImpl.super.getExceptionHandler();
        }
    };
    private final Computable<VersionNameProvider> _versionNameProvider = new BaseLazyComputable<VersionNameProvider>("VersionNameProvider"){

        @Override
        protected VersionNameProvider getImplEx() throws Exception {
            Class<VersionNameProvider> c = VCSProfileImpl.this.getProfileInfo().getVersionNameProviderClass();
            return c != null ? this.newInstance(c) : this.getFallback();
        }

        @Override
        protected VersionNameProvider getFallback() {
            return new NullVersionNameProvider();
        }

        final class NullVersionNameProvider
        extends VersionNameProvider {
            NullVersionNameProvider() {
            }

            @Override
            public final String getVersionName(URL url) {
                return null;
            }
        }
    };
    private final Computable<CheckOutProvider> _checkOutProvider = new BaseLazyComputable<CheckOutProvider>("CheckOutProvider"){

        @Override
        protected CheckOutProvider getImplEx() throws Exception {
            Class<CheckOutProvider> c = VCSProfileImpl.this.getProfileInfo().getCheckOutClass();
            return c != null ? this.newInstance(c) : null;
        }
    };
    private final Computable<ConflictsFinder> _conflictsFinder = new BaseLazyComputable<ConflictsFinder>("ConflictsFinder"){

        @Override
        protected ConflictsFinder getImplEx() throws Exception {
            Class<ConflictsFinder> c = VCSProfileImpl.this.getProfileInfo().getConflictsFinderClass();
            return c != null ? this.newInstance(c) : null;
        }
    };
    private final Computable<Map<String, VCSActionInfo>> _actionInfos = new BaseLazyComputable<Map<String, VCSActionInfo>>("Action Infos"){

        @Override
        protected Map<String, VCSActionInfo> getImplEx() throws Exception {
            HashMap<String, VCSActionInfo> actionInfos = new HashMap<String, VCSActionInfo>(20);
            if (VCSProfileImpl.this.getProfileInfo().getHistoryProviderClass() == null) {
                VCSActionInfoImpl historyActionInfo = new VCSActionInfoImpl(VCSProfileImpl.this, VCSProfileImpl.this.getProfileInfo().getHistoryProvider()){

                    @Override
                    public VCSCommandStyle getStyle() {
                        return VCSCommandStyle.NORMAL;
                    }

                    @Override
                    public VCSCommandType getType() {
                        return VCSCommandType.BOTH;
                    }
                };
                actionInfos.put(Ide.findCmdName((int)VCSProfileImpl.this.getVersionHistoryAction().getCommandId()), historyActionInfo);
            }
            if (VCSProfileImpl.this.getProfileInfo().getPendingChanges() != null) {
                actionInfos.put(Ide.findCmdName((int)VCSProfileImpl.this.getViewPendingChangesAction().getCommandId()), new VCSActionInfo(){

                    @Override
                    public VCSCommandStyle getStyle() {
                        return VCSCommandStyle.NORMAL;
                    }

                    @Override
                    public VCSCommandType getType() {
                        return VCSCommandType.BOTH;
                    }

                    @Override
                    public Boolean getToggleStatus() {
                        return null;
                    }

                    @Override
                    public boolean requirementsSatisfied(Context context) {
                        return true;
                    }

                    @Override
                    public Collection getFilteredSelection(Context context) {
                        return Collections.EMPTY_SET;
                    }

                    @Override
                    public boolean isChangeListAction() {
                        return false;
                    }

                    @Override
                    public String getDialogTitle() {
                        return null;
                    }

                    @Override
                    public String getDialogHint() {
                        return null;
                    }

                    @Override
                    public String getHelpTopicId() {
                        return null;
                    }
                });
            }
            return actionInfos;
        }

        @Override
        protected Map<String, VCSActionInfo> getFallback() {
            return Collections.emptyMap();
        }
    };
    private final Computable<VCSHistoryProvider> _historyProvider = new BaseLazyComputable<VCSHistoryProvider>("VCSHistoryProvider"){

        @Override
        protected VCSHistoryProvider getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            HistoryProviderInfo historyProviderInfo = VCSProfileImpl.this.getProfileInfo().getHistoryProvider();
            if (historyProviderInfo != null || VCSProfileImpl.this.getProfileInfo().hasHistoryProviderClass()) {
                if (VCSProfileImpl.this.getProfileInfo().getHistoryProviderClass() != null) {
                    return this.newInstance(VCSProfileImpl.this.getProfileInfo().getHistoryProviderClass());
                }
                return new VCSHistoryProvider(new GenericHistoryProvider(VCSProfileImpl.this, historyProviderInfo, VCSProfileImpl.this.getProfileInfo().getClientInfo(), VCSProfileImpl.this.getActionInfos().get(Ide.findCmdName((int)VCSProfileImpl.this.getVersionHistoryAction().getCommandId()))), VCSProfileImpl.this.getVersionHistoryAction());
            }
            return null;
        }

        @Override
        protected void init(VCSHistoryProvider value) {
            HistoryProviderInfo historyProviderInfo = VCSProfileImpl.this.getProfileInfo().getHistoryProvider();
            if (historyProviderInfo == null) {
                return;
            }
            try {
                Class versionTreeActionClass = historyProviderInfo.getVersionTreeActionClass();
                if (versionTreeActionClass != null) {
                    IdeAction versionTreeAction = VersionTreeCommand.getVersionTreeAction(versionTreeActionClass.getName(), VCSProfileImpl.this.getId());
                    value.setVersionTreeAction(versionTreeAction);
                }
            }
            catch (ClassNotFoundException cnfe) {
                VCSProfileImpl.this.getLogger().log(Level.SEVERE, "unable to load version tree action class " + cnfe.getMessage());
            }
        }
    };
    private final Computable<PendingChangesAdapter> _pendingChangesAdapter = new BaseLazyComputable<PendingChangesAdapter>("PendingChangesAdapter"){

        @Override
        protected PendingChangesAdapter getImplEx() throws Exception {
            if (VCSProfileImpl.this.getProfileInfo().getPendingChanges() == null) {
                return null;
            }
            PendingChangesAdapter adapter = VCSProfileImpl.this.getProfileInfo().getPendingChanges().getAdapter();
            if (adapter == null) {
                adapter = new PendingChangesAdapter(){

                    @Override
                    public VCSProfile getProfile() {
                        return VCSProfileImpl.this;
                    }
                };
            }
            return adapter;
        }
    };
    private final Computable<RemovedEntryLister> _removedEntryLister = new BaseLazyComputable<RemovedEntryLister>("RemovedEntryLister"){

        @Override
        protected RemovedEntryLister getImplEx() throws Exception {
            Class<RemovedEntryLister> c = VCSProfileImpl.this.getProfileInfo().getRemovedEntryListerClass();
            return c != null ? this.newInstance(c) : null;
        }
    };
    private final Computable<ChangeList[]> _changeLists = new BaseLazyComputable<ChangeList[]>("Change Lists"){

        @Override
        protected ChangeList[] getImplEx() throws Exception {
            ChangeList[] changeLists = null;
            PendingChangesInfo pci = VCSProfileImpl.this.getProfileInfo().getPendingChanges();
            if (pci != null) {
                Collection<ChangeListInfo> declaredLists = pci.getChangeLists();
                ArrayList<ChangeList> lists = new ArrayList<ChangeList>(declaredLists.size() * 2);
                for (ChangeListInfo o : declaredLists) {
                    if (o instanceof ChangeListInfo) {
                        ChangeListInfo clInfo = o;
                        ChangeList cl = null;
                        try {
                            Class<ChangeList> changeListClass = clInfo.getChangeListClass();
                            if (changeListClass != null) {
                                if (changeListClass != null) {
                                    cl = this.newInstance(changeListClass);
                                    cl.setCodeReview(clInfo.includeCodeReview());
                                }
                            } else {
                                StatusBasedMultiChangeList.sContextProfile = VCSProfileImpl.this;
                                StatusBasedMultiChangeList.sContextInfo = clInfo;
                                cl = new StatusBasedMultiChangeList(VCSProfileImpl.this, clInfo);
                                StatusBasedMultiChangeList.sContextProfile = null;
                                StatusBasedMultiChangeList.sContextInfo = null;
                            }
                        }
                        catch (Exception e) {
                            VCSProfileImpl.this.getLogger().severe("error instantiating change list class: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        if (cl == null) continue;
                        lists.add(cl);
                        VCSProfileImpl.this._changeListsById.put(clInfo.getID(), cl);
                        VCSProfileImpl.this._changeListInfosById.put(clInfo.getID(), clInfo);
                        continue;
                    }
                    if (!(o instanceof MultiChangeList)) continue;
                    ChangeList cl = (ChangeList)((Object)o);
                    lists.add(cl);
                    VCSProfileImpl.this._changeListsById.put(cl.getClass().getName(), cl);
                    VCSProfileImpl.this._changeListInfosById.put(cl.getClass().getName(), null);
                }
                changeLists = lists.toArray(new ChangeList[lists.size()]);
            }
            return changeLists;
        }
    };
    private final Computable<ChangeSetAdapter> _changeSetAdapter = new BaseLazyComputable<ChangeSetAdapter>("ChangeSetAdapter"){

        @Override
        protected ChangeSetAdapter getImplEx() throws Exception {
            if (VCSProfileImpl.this.getProfileInfo().getChangeSetsClass() != null) {
                ChangeSetAdapter changeSetAdapter = this.newInstance(VCSProfileImpl.this.getProfileInfo().getChangeSetsClass().getConstructor(String.class), VCSProfileImpl.this.getId());
                ChangeSetRegistry.register(changeSetAdapter);
                return changeSetAdapter;
            }
            return null;
        }
    };
    private final Computable<StructureChangeListener> _preferencesChangeListener = new BaseLazyComputable<StructureChangeListener>("Property ChangeListener"){

        @Override
        protected StructureChangeListener getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            VCSPreferences preferences = VCSProfileImpl.this.getPreferences();
            ClientChangeListener preferencesChangeListener = VCSProfileImpl.this.getProfileInfo().getPreferencesChangeListenerClass() != null ? this.newInstance(VCSProfileImpl.this.getProfileInfo().getPreferencesChangeListenerClass()) : new ClientChangeListener();
            preferences.addStructureChangeListener(preferencesChangeListener);
            preferencesChangeListener.structureValuesChanged(new StructureChangeEvent((Object)this, (ChangeInfo)null));
            return preferencesChangeListener;
        }

        final class ClientChangeListener
        extends StructureChangeListener {
            ClientChangeListener() {
            }

            public void structureValuesChanged(StructureChangeEvent e) {
                if (!VCSConfigUtils.isSignificantStructureChange(e)) {
                    return;
                }
                VCSOverlayItemProducer overlayItemProducer = VCSProfileImpl.this.getOverlayItemProducer();
                if (overlayItemProducer != null) {
                    overlayItemProducer.preferencesChanged();
                }
                if (VCSProfileImpl.this.getOverlayTracker() != null) {
                    VCSProfileImpl.this.getOverlayTracker().validateOverlays();
                    VCSProfileImpl.this.getOverlayTracker().repaintOverlays();
                }
            }
        }
    };
    private final Computable<ContextMenuListener> _contextMenuListener = new BaseLazyComputable<ContextMenuListener>("ContextMenuListener"){

        @Override
        protected ContextMenuListener getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            Object contextMenuListener = VCSProfileImpl.this.getProfileInfo().getContextMenuListenerClass() != null ? this.newInstance(VCSProfileImpl.this.getProfileInfo().getContextMenuListenerClass()) : new GenericContextMenuListener(VCSProfileImpl.this, VCSProfileImpl.this.getProfileInfo(), VCSProfileImpl.this.getLogger());
            VCSMenuUtils.installContextMenuListener(contextMenuListener);
            return contextMenuListener;
        }
    };
    private final Computable<Map<String, URLFileSystemHelper>> _fsHelpers = new BaseLazyComputable<Map<String, URLFileSystemHelper>>("File System Helpers"){

        @Override
        protected Map<String, URLFileSystemHelper> getImplEx() throws Exception {
            HashMap<String, URLFileSystemHelper> fsHelpers = new HashMap<String, URLFileSystemHelper>(5);
            for (FileSystemHelperInfo helperInfo : VCSProfileImpl.this.getProfileInfo().getFileSystem().getHelpers()) {
                Class<URLFileSystemHelper> helperClass = helperInfo.getHelperClass();
                URLFileSystemHelper helperInstance = this.newInstance(helperClass);
                if (helperInstance instanceof URLFileSystemHelperDecorator) {
                    VCSFileSystemUtils.registerDecorator(helperInfo.getProtocol(), (URLFileSystemHelperDecorator)helperInstance);
                } else {
                    URLFileSystem.registerHelper((String)helperInfo.getProtocol(), (URLFileSystemHelper)helperInstance);
                }
                fsHelpers.put(helperInfo.getProtocol(), helperInstance);
                if (!(helperInstance instanceof VCSURLFileSystemHelper)) continue;
                ((VCSURLFileSystemHelper)helperInstance).setEnabled(true);
            }
            return fsHelpers;
        }
    };
    private final Computable<Controller> _controller = new BaseLazyComputable<Controller>("Controller"){

        @Override
        protected Controller getImplEx() throws Exception {
            if (VCSProfileImpl.this.getProfileInfo().getActionControllerClass() != null) {
                return this.newInstance(VCSProfileImpl.this.getProfileInfo().getActionControllerClass());
            }
            return new GenericController(VCSProfileImpl.this, VCSProfileImpl.this.getProfileInfo());
        }

        @Override
        protected Controller getFallback() {
            return new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    return false;
                }
            };
        }
    };
    private final Computable<IdeAction[]> _actions = new BaseLazyComputable<IdeAction[]>("Actions"){

        @Override
        protected IdeAction[] getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return new IdeAction[0];
            }
            IdeAction[] actions = this.createActions();
            for (int i = 0; i < actions.length; ++i) {
                actions[i].addController(VCSProfileImpl.this.getController());
            }
            return actions;
        }

        private IdeAction[] createActions() {
            ActionsInfo opInfo = VCSProfileImpl.this.getProfileInfo().getActions();
            List operations = opInfo.getActions();
            if (operations != null && operations.size() > 0) {
                ArrayList<IdeAction> actions = new ArrayList<IdeAction>(operations.size() * 2);
                for (ActionInfo op : operations) {
                    Boolean toggleStatus;
                    IdeAction action;
                    int commandIdeId = Ide.findOrCreateCmdID((String)op.getID());
                    MetaClass actionClass = op.getActionMetaClass();
                    if (op.getResourcePrefix() != null) {
                        try {
                            if (op.getIcon() != null) {
                                ImageIcon icon = null;
                                String text = op.getIcon().trim();
                                if (text.startsWith("uri:") && text.length() > 4) {
                                    try {
                                        URI uri = URIFactory.newURI((String)text.substring(4));
                                        URL url = uri != null ? VirtualFileSystem.getVirtualFileSystem().toURL(uri) : null;
                                        ImageIcon imageIcon = icon = url != null ? ImageIconCache.get((URL)url) : null;
                                        if (icon != null && icon.getImageLoadStatus() != 8) {
                                            VCSProfileImpl.this.getLogger().severe("Failed to load icon for URL: " + text);
                                        }
                                    }
                                    catch (MalformedURLException e) {
                                        VCSProfileImpl.this.getLogger().severe("Unexpected MalformedURLException");
                                    }
                                }
                                action = GLazyIdeAction.getAction(commandIdeId, actionClass, VCSProfileImpl.this.getProfileInfo().getRsbundleClass(), op.getResourcePrefix(), icon);
                            } else {
                                action = GLazyIdeAction.getAction(commandIdeId, actionClass, VCSProfileImpl.this.getProfileInfo().getRsbundleClass(), op.getResourcePrefix(), op.getIconRef());
                            }
                            toggleStatus = op.getToggleStatus();
                            if (toggleStatus != null) {
                                action.putValue("Check", (Object)Boolean.TRUE);
                                action.putValue("State", (Object)toggleStatus);
                            }
                            actions.add(action);
                        }
                        catch (ClassNotFoundException cnfe) {
                            VCSProfileImpl.this.getLogger().severe("Unable to init lazy status, could not load resource class. " + cnfe.getMessage());
                        }
                        continue;
                    }
                    action = IdeAction.findOrCreate((int)commandIdeId, (MetaClass)actionClass, (String)op.getLabel(), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)Integer.valueOf(op.getMnemonic()), null, null, (boolean)true);
                    toggleStatus = op.getToggleStatus();
                    if (toggleStatus != null) {
                        action.putValue("Check", (Object)Boolean.TRUE);
                        action.putValue("State", (Object)toggleStatus);
                    }
                    actions.add(action);
                }
                if (VCSProfileImpl.this.getProfileInfo().getPendingChanges() != null) {
                    actions.add(VCSProfileImpl.this.getViewPendingChangesAction());
                }
                return actions.toArray(new IdeAction[actions.size()]);
            }
            return new IdeAction[0];
        }
    };
    private final Computable<PropertiesPanelProvider[]> _propertiesPanelProvider = new BaseLazyComputable<PropertiesPanelProvider[]>("Properties Panel Providers"){

        @Override
        protected PropertiesPanelProvider[] getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return new PropertiesPanelProvider[0];
            }
            ArrayList<PropertiesPanelProvider> providers = new ArrayList<PropertiesPanelProvider>();
            if (VCSProfileImpl.this.getProfileInfo().getPropertiesPanelProviderClasses() != null) {
                propProviders = VCSProfileImpl.this.getProfileInfo().getPropertiesPanelProviderClasses();
                for (Class clazz : propProviders) {
                    providers.add((PropertiesPanelProvider)this.newInstance(clazz));
                }
            } else {
                propProviders = VCSProfileImpl.this.getProfileInfo().getPropertyProvider();
                Iterator<Object> it = propProviders.iterator();
                while (it.hasNext()) {
                    GenericPropertyPanelProvider genericPropertyPanelProvider = new GenericPropertyPanelProvider(VCSProfileImpl.this, (PropertyProviderInfo)it.next());
                    providers.add(genericPropertyPanelProvider);
                }
            }
            for (PropertiesPanelProvider provider : providers) {
                PropertiesPanelRegistry.registerPanelProvider(provider);
            }
            return providers.toArray(new PropertiesPanelProvider[providers.size()]);
        }
    };
    private final Computable<Wizard> _shareWizard = new BaseLazyComputable<Wizard>("Share Wizard"){

        @Override
        protected Wizard getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            if (VCSProfileImpl.this.getProfileInfo().getShareWizardClass() != null) {
                Wizard shareWizard = this.newInstance(VCSProfileImpl.this.getProfileInfo().getShareWizardClass());
                ShareWizard.registerShareWizard((Wizard)shareWizard);
                return shareWizard;
            }
            return null;
        }
    };
    private final Computable<IdeAction> _annotationsAction = new BaseLazyComputable<IdeAction>("Annotations Action"){

        @Override
        protected IdeAction getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            if (VCSProfileImpl.this.getProfileInfo().getAnnotationsCommandClass() != null) {
                return AnnotationsCommand.getAnnotationsAction(VCSProfileImpl.this.getProfileInfo().getAnnotationsCommandClass().getName(), VCSProfileImpl.this.getId());
            }
            return null;
        }
    };
    private final Computable<VCSEBComponent[]> _eventBusComponents = new BaseLazyComputable<VCSEBComponent[]>("Event Bus Components"){

        @Override
        protected VCSEBComponent[] getImplEx() throws Exception {
            EventBusInfo ebi = VCSProfileImpl.this.getProfileInfo().getEventBus();
            if (ebi == null) {
                return null;
            }
            ArrayList<VCSEBComponent> eventBusComponents = new ArrayList<VCSEBComponent>();
            VCSSingleNodeObserver nodeObserver = ebi.getNodeObserver();
            if (nodeObserver != null) {
                nodeObserver.setSystemId(VCSProfileImpl.this.getId());
                nodeObserver.setStatusCacheBridge(VCSProfileImpl.this.getStatusCacheBridge());
                nodeObserver.setURLFilter(VCSProfileImpl.this.getURLFilter());
                eventBusComponents.add(nodeObserver);
            }
            Iterator<VCSEBComponent> it = ebi.getComponents().iterator();
            while (it.hasNext()) {
                eventBusComponents.add(it.next());
            }
            for (VCSEBComponent eventBusComponent : eventBusComponents) {
                VCSEventBus.addToBus(eventBusComponent);
            }
            return eventBusComponents.toArray(new VCSEBComponent[eventBusComponents.size()]);
        }
    };
    private final Computable<ChangeListDockableFactory> _changeListDockableFactory = new BaseLazyComputable<ChangeListDockableFactory>("ChangeListDockableFactory"){

        @Override
        protected ChangeListDockableFactory getImplEx() throws Exception {
            if (VCSProfileImpl.this.getProfileInfo().getChangeListDockableFactoryClass() != null) {
                return this.newInstance(VCSProfileImpl.this.getProfileInfo().getChangeListDockableFactoryClass());
            }
            if (VCSProfileImpl.this.getProfileInfo().getPendingChanges() != null) {
                new GenericChangeListDockableFactory(ChangeListViewId.getViewId(VCSProfileImpl.this), StatusBasedChangeListWindow.class.getName(), VCSProfileImpl.this);
            }
            return null;
        }
    };
    private final Computable<String[]> _globalIgnoreFilters = new BaseLazyComputable<String[]>("Global Ignore Filters"){

        @Override
        protected String[] getImplEx() throws Exception {
            Collection<String> ignoreFilters = VCSProfileImpl.this.getProfileInfo().getGlobalIgnoreFilter();
            for (String filter : ignoreFilters) {
                VCSConfigUtils.registerGlobalIgnoreFilter(filter);
            }
            return ignoreFilters.toArray(new String[ignoreFilters.size()]);
        }
    };
    private final Computable<KeyStrokeContext> _keyStrokeContext = new BaseLazyComputable<KeyStrokeContext>("KeyStrokeContext"){

        @Override
        protected KeyStrokeContext getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            KeyStrokeContext ksc = VCSDefaultUtils.createKeyStrokeContext(VCSProfileImpl.this.getActions(), VCSProfileImpl.this.getInformation().getShortLabel());
            Ide.getKeyStrokeContextRegistry().addContext(ksc);
            return ksc;
        }
    };
    private final Computable<VCSHistoryGraphProvider> _historyGraphProvider = new BaseLazyComputable<VCSHistoryGraphProvider>("VCSHistoryGraphProvider"){

        @Override
        protected VCSHistoryGraphProvider getImplEx() throws Exception {
            if (!Ide.getIdeArgs().getCreateUI()) {
                return null;
            }
            HistoryGraphProviderInfo historyGraphProviderInfo = VCSProfileImpl.this.getProfileInfo().getHistoryGraphProvider();
            if (historyGraphProviderInfo != null) {
                return new VCSHistoryGraphProvider(VCSProfileImpl.this, historyGraphProviderInfo);
            }
            return null;
        }
    };

    public VCSProfileImpl(String id) {
        super(id);
    }

    @Override
    public final IconOverlayTracker getOverlayTracker() {
        IconOverlayCoordinator overlayCoordinator = IconOverlayRegistry.lookupOverlayCoordinator((String)this.getId());
        return overlayCoordinator != null ? overlayCoordinator.getOverlayTracker() : null;
    }

    @Override
    public final Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger(this.getProfileInfo().getID());
            this._logger.addHandler(this.createDefaultLogHandler());
            this._logger.setUseParentHandlers(false);
        }
        return this._logger;
    }

    public final ProfileInfo getProfileInfo() {
        if (this._profile == null) {
            this._profile = ProfileInfoRegistry.getInstance().lookupProfileInfo(this.getId());
        }
        return this._profile;
    }

    @Override
    public final URL getSystemDirectory() {
        if (this._systemDirectory == null) {
            this._systemDirectory = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this.getProfileInfo().getID());
        }
        return this._systemDirectory;
    }

    @Override
    public final VCSExtensionInformation getInformation() {
        if (this._clientInfo == null) {
            this._clientInfo = new VCSExtensionInformation(new Displayable(){

                public Icon getIcon() {
                    return null;
                }

                public String getLongLabel() {
                    return VCSProfileImpl.this.getProfileInfo().getClientInfo().getLongLabel();
                }

                public String getShortLabel() {
                    return VCSProfileImpl.this.getProfileInfo().getClientInfo().getShortLabel();
                }

                public String getToolTipText() {
                    return this.getLongLabel();
                }

                public String toString() {
                    return this.getShortLabel();
                }
            });
        }
        return this._clientInfo;
    }

    private final StatusResolver getStatusResolver() {
        return this._statusResolver.get();
    }

    private final StatusesInfo getStatusesInfo() {
        return this._statusesInfo.get();
    }

    @Override
    public final int getControlPrecedence() {
        return this._controlPrecedence.get();
    }

    private final URLFilter getControlFilter() {
        return this._controlFilter.get();
    }

    @Override
    public final VCSOverlayItemProducer getOverlayItemProducer() {
        return this._overlayProducer.get();
    }

    @Override
    public final VCSStatusCache getStatusCache() {
        StatusCacheBridge<VCSStatus> cache = this._getStatusCacheBridge();
        return cache instanceof VCSStatusCache ? (VCSStatusCache)cache : null;
    }

    @Override
    public final StatusCache<VCSStatus> getPolicyStatusCache() {
        StatusCacheBridge<VCSStatus> cache = this._getStatusCacheBridge();
        return cache instanceof StatusCache ? (StatusCache)cache : null;
    }

    private final StatusCacheBridge<VCSStatus> _getStatusCacheBridge() {
        return this._statusCache.get();
    }

    @Override
    public final boolean isControlled(URL url) {
        return this.getControlFilter().accept(url);
    }

    @Override
    public final void shutdown() {
    }

    @Override
    public final VCSExceptionHandler getExceptionHandler() {
        return this._exceptionHandler.get();
    }

    @Override
    public final String getID() {
        return this.getProfileInfo().getID();
    }

    @Override
    public final URLFilter getURLFilter() {
        return this.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    @Override
    public final URLFilter getURLFilter(String id) {
        FileSystemInfo fsi = this.getProfileInfo().getFileSystem();
        return fsi != null ? fsi.getURLFilter(id) : null;
    }

    @Override
    public final VCSStatusFilter getStatusFilter(String id) {
        StatusesInfo si = this.getStatusesInfo();
        return si != null ? si.getStatusFilter(id) : null;
    }

    @Override
    public final String getCheckOutCommand() {
        ActionsInfo ops = this.getProfileInfo().getActions();
        AutomaticActionInfo op = ops.getAutomaticAction(AUTO_OP_CHECKOUT_NODE);
        return op != null ? op.getActionClassName() : null;
    }

    @Override
    public final String getVersionName(URL url) {
        return this._versionNameProvider.get().getVersionName(url);
    }

    @Override
    public final CheckOutProvider getCheckOutProvider() {
        return this._checkOutProvider.get();
    }

    @Override
    public final boolean canCheckOut(URL url) throws Exception {
        return this.getCheckOutProvider() != null ? this.getCheckOutProvider().canCheckOut(url) : super.canCheckOut(url);
    }

    @Override
    public final boolean setReadWrite(URL url) throws Exception {
        if (this.getCheckOutProvider() != null) {
            try {
                return this.getCheckOutProvider().checkOut(url);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return super.setReadWrite(url);
    }

    @Override
    public final boolean setReadWrite(URL[] urls, VCSProgress progress) throws Exception {
        if (this.getCheckOutProvider() != null) {
            try {
                return this.getCheckOutProvider().checkOut(urls, progress);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return super.setReadWrite(urls, progress);
    }

    @Override
    public final boolean isConflictsStatus(VCSStatus status) {
        return status instanceof StatusInfo && ((StatusInfo)status).isConflicts();
    }

    private final ConflictsFinder getConflictsFinder() {
        return this._conflictsFinder.get();
    }

    @Override
    public final boolean isConflictsStatus(URL url) {
        return this.getConflictsFinder() != null ? this.getConflictsFinder().containsConflicts(url) : super.isConflictsStatus(url);
    }

    @Override
    public final VCSPreferences getPreferences() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), this.getId());
    }

    @Override
    public final VCSStatus getStatusInstance(String id) {
        if ("oracle.jdeveloper.vcs.status.UNRECOGNIZED".equals(id)) {
            return STATUS_UNRECOGNIZED;
        }
        return this.getStatusesInfo().getStatus(id);
    }

    private final IdeAction getVersionHistoryAction() {
        if (this.getProfileInfo().getHistoryProvider() == null && !this.getProfileInfo().hasHistoryProviderClass()) {
            return null;
        }
        if (this._versionHistoryAction == null) {
            this._versionHistoryAction = GenericHistoryAction.getAction(this);
        }
        return this._versionHistoryAction;
    }

    private final IdeAction getViewPendingChangesAction() {
        if (this.getProfileInfo().getPendingChanges() == null) {
            return null;
        }
        if (this._viewPendingChangesAction == null) {
            this._viewPendingChangesAction = ViewPendingChangesAction.getAction(this, this.getProfileInfo().getPendingChanges().getMenuLabel());
        }
        return this._viewPendingChangesAction;
    }

    private final Map<String, VCSActionInfo> getActionInfos() {
        return this._actionInfos.get();
    }

    @Override
    public final VCSActionInfo getActionInfo(String actionId) {
        ActionInfo actionInfo;
        VCSActionInfo ai = this.getActionInfos().get(actionId);
        if (ai == null && (actionInfo = this.getProfileInfo().getActions().getAction(actionId)) != null) {
            ai = this.getProfileInfo().getPendingChanges() != null ? new ActionInfoImpl((VCSProfile)this, actionInfo, this.getProfileInfo().getPendingChanges().getChangeLists()) : new ActionInfoImpl((VCSProfile)this, actionInfo);
            this.getActionInfos().put(actionId, ai);
        }
        return ai;
    }

    @Override
    public final VCSHistoryProvider getHistoryProvider() {
        return this._historyProvider.get();
    }

    @Override
    public final VCSHistoryGraphProvider getHistoryGraphProvider() {
        return this._historyGraphProvider.get();
    }

    @Override
    public final HistoryProperty getHistoryProperty(String id) {
        HistoryProvider provider;
        VCSHistoryProvider historyProvider = this.getHistoryProvider();
        if (historyProvider != null && (provider = historyProvider.getHistoryProvider()) != null && provider instanceof GenericHistoryProvider) {
            return ((GenericHistoryProvider)provider).getProperty(id);
        }
        return null;
    }

    @Override
    public final String getChangeListViewID() {
        if (this.getProfileInfo().getPendingChanges() != null) {
            if (this._changeListViewID == null) {
                this._changeListViewID = ChangeListViewId.getViewId(this);
            }
            return this._changeListViewID;
        }
        return null;
    }

    @Override
    public final PendingChangesAdapter getPendingChangesAdapter() {
        return this._pendingChangesAdapter.get();
    }

    @Override
    public final RemovedEntryLister getRemovedEntryLister() {
        return this._removedEntryLister.get();
    }

    public final ChangeList[] getChangeLists() {
        return this._changeLists.get();
    }

    public final ChangeList getChangeList(String id) {
        this.getChangeLists();
        return this._changeListsById.get(id);
    }

    public final ChangeListInfo getChangeListInfo(String id) {
        this.getChangeLists();
        return this._changeListInfosById.get(id);
    }

    private final ChangeSetAdapter getChangeSetAdapter() {
        return this._changeSetAdapter.get();
    }

    private final StructureChangeListener getPreferencesChangeListener() {
        return this._preferencesChangeListener.get();
    }

    private final ContextMenuListener getContextMenuListener() {
        return this._contextMenuListener.get();
    }

    private final Map<String, URLFileSystemHelper> getFileSystemHelpers() {
        return this._fsHelpers.get();
    }

    private final Controller getController() {
        return this._controller.get();
    }

    private final IdeAction[] getActions() {
        return this._actions.get();
    }

    private final PropertiesPanelProvider[] getPropertiesPanelProviders() {
        return this._propertiesPanelProvider.get();
    }

    private final Wizard getShareWizard() {
        return this._shareWizard.get();
    }

    private final IdeAction getAnnotationsAction() {
        return this._annotationsAction.get();
    }

    private final VCSEBComponent[] getEventBusComponents() {
        return this._eventBusComponents.get();
    }

    private final ChangeListDockableFactory getChangeListDockableFactory() {
        return this._changeListDockableFactory.get();
    }

    private final String[] getGlobalIgnoreFilters() {
        return this._globalIgnoreFilters.get();
    }

    private final KeyStrokeContext getKeyStrokeContext() {
        return this._keyStrokeContext.get();
    }

    @Override
    public final void initializeImpl() {
        if (!Ide.getIdeArgs().getCreateUI() && !this.getProfileInfo().getHeadless()) {
            return;
        }
        this.getChangeSetAdapter();
        this.getPreferencesChangeListener();
        this.getContextMenuListener();
        this.getFileSystemHelpers();
        this.getPropertiesPanelProviders();
        this.getShareWizard();
        this.getAnnotationsAction();
        this.getEventBusComponents();
        this.getChangeListDockableFactory();
        this.getGlobalIgnoreFilters();
        this.getKeyStrokeContext();
        IdeAction action = IdeAction.find((int)51);
        if (action != null) {
            action.addController(this.getController());
        }
        try {
            new SwingClosure(true){

                protected void runImpl() {
                    VCSProfileImpl.this.activateMenus();
                }
            }.run();
            return;
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "error initializing vcs profile " + this.getProfileInfo().getID(), t);
            if (FeedbackManager.isOn()) {
                FeedbackManager.reportException((Throwable)t);
            }
            return;
        }
    }

    private final void activateMenus() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return;
        }
        if (this.getProfileInfo().getMenus() != null) {
            SectionsInfo menuInfo = null;
            menuInfo = this.getProfileInfo().getMenus().getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_MENU");
            if (menuInfo != null) {
                this.installVersioningMenuItems(menuInfo.getSections());
            } else {
                this.getLogger().fine("no main versioning menu items found");
            }
            menuInfo = this.getProfileInfo().getMenus().getMenu("oracle.jdeveloper.vcs.menus.COMPARE_MENU");
            if (menuInfo != null) {
                this.installCompareMenuItems(menuInfo.getSections());
            } else {
                this.getLogger().fine("no compare menu items found");
            }
            menuInfo = this.getProfileInfo().getMenus().getMenu("oracle.jdeveloper.vcs.menus.REPLACE_MENU");
            if (menuInfo != null) {
                this.installReplaceWithMenuItems(menuInfo.getSections());
            } else {
                this.getLogger().fine("no replace-with menu items found");
            }
        }
    }

    private final void installCompareMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this.getLogger().warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installCompareMenuItem(cmdId, this.getId());
            }
        }
    }

    private final void installReplaceWithMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this.getLogger().warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installReplaceMenuItem(cmdId, this.getId());
            }
        }
    }

    private final void installVersioningMenuItems(Collection menuSections) {
        JMenu menu = VCSMenuUtils.installMainSystemMenu(this.getId(), this.getInformation());
        float sectionIdentifier = 1.0f;
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                ActionInfo referencedOp = this.getProfileInfo().getActions().getAction(actionRef);
                if (referencedOp == null) {
                    this.getLogger().warning("unsatisfied action reference in menu declarations: " + actionRef);
                    continue;
                }
                Integer cmdId = Ide.findCmdID((String)referencedOp.getID());
                if (cmdId == null) {
                    this.getLogger().warning("unrecognized operation in menu declarations: " + actionRef);
                    continue;
                }
                VCSMenuUtils.addMenuItem(menu, (int)cmdId, sectionIdentifier);
            }
            sectionIdentifier += 1.0f;
        }
        if (this.getProfileInfo().getPendingChanges() != null) {
            this.installPendingChangesMenuItem(menu);
        }
    }

    private final void installPendingChangesMenuItem(JMenu menu) {
        VCSMenuUtils.addMenuItem(menu, this.getViewPendingChangesAction().getCommandId(), 99.7f);
        StringBuilder sb = new StringBuilder(Resource.get("VIEW_PENDING_CHANGES_ACTION"));
        sb.append(" (");
        sb.append(this.getInformation().getShortLabel());
        sb.append(")");
        VCSMenuUtils.addMenuItemToTeamMenu(this.getViewPendingChangesAction().getCommandId(), sb.toString(), 102.0f);
    }

    private final Handler createDefaultLogHandler() {
        final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS z dd.MM.yy");
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord r) {
                StringBuilder buff = new StringBuilder(100);
                buff.append('[');
                buff.append(df.format(new Date(r.getMillis())));
                buff.append("] ").append(r.getMessage()).append("\n");
                return buff.toString();
            }
        };
        try {
            FileHandler handler = new FileHandler(URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((URL)this.getSystemDirectory(), (String)"vcs.log")));
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            return handler;
        }
        catch (IOException ioe) {
            Logger.getLogger("").log(Level.SEVERE, "unable to use default vcs log file", ioe);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            return handler;
        }
    }

    @Override
    public void putObject(String key, Object value) {
        if (value == null) {
            this._userData.remove(key);
        } else {
            this._userData.put(key, value);
        }
    }

    @Override
    public Object getObject(String key) {
        return this._userData.get(key);
    }

    private static interface Computable<T> {
        public T get();
    }

    private static final class ActionInfoImpl
    extends VCSActionInfoImpl {
        private final ActionInfo _actionInfo;

        private ActionInfoImpl(VCSProfile profile, ActionInfo info) {
            super(profile, info);
            this._actionInfo = info;
        }

        private ActionInfoImpl(VCSProfile profile, ActionInfo info, Collection changeListInfos) {
            super(profile, info, changeListInfos);
            this._actionInfo = info;
        }

        @Override
        public String getDialogTitle() {
            return this._actionInfo.getDialogTitle();
        }

        @Override
        public String getDialogHint() {
            return this._actionInfo.getDialogHint();
        }

        @Override
        public String getHelpTopicId() {
            return this._actionInfo.getHelpTopicId();
        }
    }

    private abstract class BaseLazyComputable<T>
    extends LazyComputable<T> {
        private final String _name;

        BaseLazyComputable(String name) {
            this._name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final T getImpl() {
            if (!Ide.getIdeArgs().getCreateUI() && !VCSProfileImpl.this.getProfileInfo().getHeadless()) {
                return this.getFallback();
            }
            long start = System.currentTimeMillis();
            try {
                T value = this.getImplEx();
                this._init(value);
                T t = value;
                return t;
            }
            catch (Throwable t) {
                T fallback = this.getFallback();
                this._init(fallback);
                VCSProfileImpl.this.getLogger().log(Level.SEVERE, "error initializing VCS profile: " + VCSProfileImpl.this.getProfileInfo().getID() + "(" + this._name + ")", t);
                if (FeedbackManager.isOn()) {
                    FeedbackManager.reportException((Throwable)t);
                }
                T t2 = fallback;
                return t2;
            }
            finally {
                VCSProfileImpl.this.getLogger().info("VCS profile initialization: " + VCSProfileImpl.this.getProfileInfo().getID() + "(" + this._name + "), time elapsed " + String.valueOf(System.currentTimeMillis() - start) + "ms");
            }
        }

        protected abstract T getImplEx() throws Exception;

        protected T getFallback() {
            return null;
        }

        protected void init(T value) {
        }

        private final void _init(T value) {
            if (value != null) {
                this.init(value);
            }
        }

        protected <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
            return ClassUtil.newInstance(clazz);
        }

        protected <T> T newInstance(Constructor<T> ctor, Object ... initargs) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
            return ClassUtil.newInstance(ctor, initargs);
        }
    }

    private abstract class LazyComputable<T>
    implements Computable<T> {
        private Object[] _value;

        private LazyComputable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T get() {
            if (this._value == null) {
                LazyComputable lazyComputable = this;
                synchronized (lazyComputable) {
                    if (this._value == null) {
                        this._value = new Object[]{this.getImpl()};
                    }
                }
            }
            return (T)this._value[0];
        }

        protected abstract T getImpl();
    }
}

