/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSRegistry;
import oracle.ide.vcs.VCSTask;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSFileContentProvider;
import oracle.jdeveloper.vcs.spi.VCSModifiedFile;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public final class VCSManagerImpl
extends VCSManager {
    public static final String VCS_EXTENSION_ID = "oracle.jdeveloper.vcs";
    private Collection<ContextMenuListener> _contextMenuListeners = new ArrayList<ContextMenuListener>();
    private ExecutorService _executor;
    private static DTCache _dtcache;

    public final Future<Boolean> checkOutUsingUI(VCSTask task) {
        this.getTaskProperties(task).put("operation", "checkout");
        if (!Ide.getIdeArgs().getCreateUI()) {
            return this.executeConfirmedTask(task);
        }
        if (!EventQueue.isDispatchThread()) {
            new IllegalStateException("checkOutUsingUI() called from non-event thread").printStackTrace();
        }
        ArrayList<URL> readOnlyUrls = new ArrayList<URL>();
        for (URL url : task.getURLs()) {
            if (url == null) {
                return this.executeNoOpTask(task);
            }
            if (!URLFileSystem.isReadOnly((URL)url)) continue;
            readOnlyUrls.add(url);
        }
        for (URL url : readOnlyUrls) {
            if (this.canCheckOut(url)) continue;
            return this.executeNoOpTask(task);
        }
        Map<VCSExtension, Collection<URL>> urlMap = this.organizeURLsByExtension(readOnlyUrls.toArray(new URL[0]));
        assert (!urlMap.containsKey(null));
        ArrayList<URL> confirmationUrls = new ArrayList<URL>();
        for (Map.Entry<VCSExtension, Collection<URL>> entry : urlMap.entrySet()) {
            if (VCSManagerImpl.isAutoCheckoutsSet(entry.getKey())) continue;
            confirmationUrls.addAll(entry.getValue());
        }
        if (!VCSManagerImpl.confirmCheckOutUI(confirmationUrls)) {
            return this.executeCancelledTask(task);
        }
        return this.executeConfirmedTask(task);
    }

    private final Future<Boolean> executeNoOpTask(VCSTask task) {
        this.getTaskProperties(task).put("noop", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    private final Future<Boolean> executeConfirmedTask(VCSTask task) {
        this.getTaskProperties(task).put("confirmed", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    private final Future<Boolean> executeCancelledTask(VCSTask task) {
        this.getTaskProperties(task).put("cancelled", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    public static final boolean confirmCheckOutUI(Collection<URL> confirmationUrls) {
        if (confirmationUrls.size() == 1) {
            String message = VCSArb.format("CONFIRM_CHECK_OUT", URLFileSystem.getPlatformPathName((URL)confirmationUrls.iterator().next()));
            return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)message, (String)VCSArb.get("CONFIRM_CHECK_OUT_TITLE"), null, (boolean)false);
        }
        if (confirmationUrls.size() > 1) {
            CheckBoxListModel listModel = VCSComponents.createCheckBoxListModel(VCSModelUtils.findOrCreateNodes(confirmationUrls.toArray(new URL[0])), false);
            CheckOutFilesPanel checkOutFilesPanel = new CheckOutFilesPanel(listModel, VCSArb.get("CONFIRM_CHECK_OUT_MULTI"));
            return CheckOutFilesPanel.showDialog(VCSWindowUtils.getCurrentWindow(), VCSArb.get("CONFIRM_CHECK_OUT_TITLE"), (Component)((Object)checkOutFilesPanel), null) != 1;
        }
        return true;
    }

    public final boolean checkOut(URL[] urls) {
        VCSTask task = new VCSTask(urls){};
        this.getTaskProperties(task).put("operation", "checkout");
        return this.executeTaskImpl(task);
    }

    public String getRevisionIdentifier(URL url) throws Exception {
        VCSExtension vcsId = VCSExtensionUtils.getActiveExtension(url);
        if (vcsId != null) {
            VCSFileContentProvider provider = VCSFileContentProvider.lookupProvider(vcsId.getId());
            return provider.getRevision(url);
        }
        return null;
    }

    public InputStream getRevisionContent(URL url, String revision) throws IOException {
        VCSExtension vcsId = VCSExtensionUtils.getActiveExtension(url);
        if (vcsId != null) {
            VCSFileContentProvider provider = VCSFileContentProvider.lookupProvider(vcsId.getId());
            return provider.getInputStream(url, revision);
        }
        return null;
    }

    public Collection<URL> getAllModifiedFiles(URL url) throws Exception {
        Context context;
        VCSFileContentProvider provider;
        Collection<VCSModifiedFile> files;
        VCSExtension vcsId = VCSExtensionUtils.getActiveExtension(url);
        if (vcsId != null && !(files = (provider = VCSFileContentProvider.lookupProvider(vcsId.getId())).getModifiedFiles(context = Context.newIdeContext((Node)NodeFactory.findOrCreate((URL)url)), null)).isEmpty()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            Iterator<VCSModifiedFile> it = files.iterator();
            while (it.hasNext()) {
                urls.add(it.next().getUrl());
            }
            return urls;
        }
        return Collections.emptyList();
    }

    protected final boolean executeTaskImpl(VCSTask task) {
        Boolean noOp = (Boolean)this.getTaskProperties(task).get("noop");
        if (noOp != null && noOp.booleanValue()) {
            return false;
        }
        URL[] cancelled = (URL[])this.getTaskProperties(task).get("cancelled");
        if (cancelled != null && cancelled.booleanValue()) {
            task.cancel(false);
            return false;
        }
        if ("checkout".equals(this.getTaskProperties(task).get("operation"))) {
            ArrayList<URL> readOnlyUrls = new ArrayList<URL>();
            for (URL url : task.getURLs()) {
                if (url == null) {
                    return false;
                }
                if (!URLFileSystem.isReadOnly((URL)url)) continue;
                readOnlyUrls.add(url);
            }
            for (URL url : readOnlyUrls) {
                if (this.canCheckOut(url)) continue;
                return false;
            }
            Boolean confirmed = (Boolean)this.getTaskProperties(task).get("confirmed");
            if (!this._checkOut(readOnlyUrls.toArray(new URL[0]), new ProgressAdapter(task), confirmed != null && confirmed != false)) {
                return false;
            }
            for (URL url : readOnlyUrls) {
                if (!URLFileSystem.isReadOnly((URL)url)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final synchronized ExecutorService getExecutor() {
        if (this._executor == null) {
            this._executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
                private final ThreadFactory _delegate = Executors.defaultThreadFactory();

                @Override
                public final Thread newThread(Runnable r) {
                    Thread t = this._delegate.newThread(r);
                    t.setName("VCSManager");
                    return t;
                }
            });
        }
        return this._executor;
    }

    public final boolean canCheckOut(URL url) {
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return false;
        }
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        if (extension == null) {
            return false;
        }
        try {
            return extension.canCheckOut(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public boolean checkOutNode(Node node) {
        try {
            return this.checkOutUsingUI(new VCSTask(new URL[]{node.getURL()}){}).get();
        }
        catch (CancellationException ce) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public final boolean checkOutNode(Node node, CommandProcessor processor) {
        return VCSUtil.checkOutOnUndoStack((Node)node);
    }

    @Deprecated
    public final String getCheckOutCommand(Node node) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(node.getURL());
        return vcs != null ? vcs.getCheckOutCommand() : null;
    }

    public final MetaClass getMetaCheckOutCommand(Node node) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(node.getURL());
        if (vcs == null) {
            return null;
        }
        String command = vcs.getCheckOutCommand();
        if (command != null) {
            MetaClass mClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(vcs.getId()), command);
            return mClass;
        }
        return null;
    }

    @Deprecated
    public final boolean setReadWrite(URL[] urls) {
        return this.checkOut(urls);
    }

    private final boolean _checkOut(URL[] urls, ProgressAdapter progress, boolean confirmed) {
        progress.setMaximum(urls.length);
        progress.setCeiling(0);
        Map<VCSExtension, Collection<URL>> urlMap = this.organizeURLsByExtension(urls);
        if (urlMap.containsKey(null)) {
            return false;
        }
        if (!confirmed) {
            for (VCSExtension vCSExtension : urlMap.keySet()) {
                if (VCSManagerImpl.isAutoCheckoutsSet(vCSExtension)) continue;
                return false;
            }
        }
        for (Map.Entry entry : urlMap.entrySet()) {
            try {
                progress.setCeiling(progress.getCeiling() + ((Collection)entry.getValue()).size());
                if (progress.isCancelled()) {
                    return false;
                }
                if (!((VCSExtension)entry.getKey()).setReadWrite(((Collection)entry.getValue()).toArray(new URL[0]), progress)) {
                    return false;
                }
                for (URL url : (Collection)entry.getValue()) {
                    Node node = NodeFactory.find((URL)url);
                    if (node == null) continue;
                    node.isReadOnly();
                }
                progress.setProgress(progress.getCeiling());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        progress.setCeiling(-1);
        progress.setProgress(urls.length);
        return true;
    }

    private final Map<VCSExtension, Collection<URL>> organizeURLsByExtension(URL[] urls) {
        LinkedHashMap<VCSExtension, Collection<URL>> map = new LinkedHashMap<VCSExtension, Collection<URL>>();
        for (URL url : urls) {
            VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
            ArrayList<URL> c = (ArrayList<URL>)map.get(vcs);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(vcs, c);
            }
            c.add(url);
        }
        return map;
    }

    @Deprecated
    public final boolean isAutoCheckOutEnabled(URL url) {
        return VCSManagerImpl.isAutoCheckoutsSet(url);
    }

    public static final boolean isAutoCheckoutsSet(URL url) {
        return VCSManagerImpl.isAutoCheckoutsSet(VCSExtensionUtils.getActiveExtension(url));
    }

    public static final boolean isAutoCheckoutsSet(VCSExtension extension) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return true;
        }
        if (extension == null) {
            return true;
        }
        VCSPreferences preferences = VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), extension.getId());
        return preferences != null ? preferences.getAutoCheckouts() : true;
    }

    public final boolean isVersioned(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs == null) {
            return false;
        }
        try {
            StatusCacheBridge<VCSStatus> statusCache = vcs.getStatusCacheBridge();
            return statusCache != null && statusCache.get(url).isVersioned();
        }
        catch (Exception e) {
            FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((Throwable)e);
            return false;
        }
    }

    public final void validateStatus(URL url) {
        for (String id : VCSRegistry.keySet()) {
            StatusCacheBridge<VCSStatus> statusCache;
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || (statusCache = ((VCSExtension)vcs).getStatusCacheBridge()) == null) continue;
            statusCache.clear(url);
        }
    }

    @Deprecated
    public final void validateStatus(URLFilter filter) {
        for (String id : VCSRegistry.keySet()) {
            VCSStatusCache statusCache;
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || (statusCache = ((VCSExtension)vcs).getStatusCache()) == null) continue;
            statusCache.clear(filter);
        }
    }

    public final void validateStatus(URL[] urls) {
        for (String id : VCSRegistry.keySet()) {
            StatusCacheBridge<VCSStatus> statusCache;
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || (statusCache = ((VCSExtension)vcs).getStatusCacheBridge()) == null) continue;
            statusCache.clear(urls);
        }
    }

    public final Collection<URLFilter> getMgrVCSListenerFilters() {
        LinkedHashSet<URLFilter> filters = new LinkedHashSet<URLFilter>(this.getVCSListeners().values());
        filters.remove(null);
        return filters;
    }

    public final Map<VCSListener, URLFilter> getMgrVCSListeners() {
        return this.getVCSListeners();
    }

    public final Collection<String> getMgrWorkspaceArtifacts() {
        return this.getWorkspaceArtifacts();
    }

    public final String getVersionName(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        return vcs != null ? vcs.getVersionName(url) : null;
    }

    public final boolean canCheckOutForIDE(Node node) {
        for (NodeFilter filter : this.getCheckOutFilters()) {
            if (filter.accept(node)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsConflicts(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs != null) {
            return vcs.isConflictsStatus(url);
        }
        return false;
    }

    public final InputStream openConflictsStreamAsContributor(URL url) throws IOException {
        return VCSFileSystemUtils.openConflictsStreamAsContributor(url, StreamDecoder.getDefaultEncoding((URL)url));
    }

    public void registerContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.add(l);
    }

    public void deregisterContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.remove(l);
    }

    public ContextMenuListener[] getContextMenuListeners() {
        return this._contextMenuListeners.toArray(new ContextMenuListener[0]);
    }

    public Locatable[] getContextLocatables(Context context) {
        return VCSContextUtils.getContextLocatables(context);
    }

    public void deleteRecursively(URL url, URLFilter filter, boolean tolerant, Collection<URL> nonDeletedUrls) throws IOException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            Assert.printStackTrace((Throwable)new IllegalStateException("deleteRecursively() called from AWT event thread"));
        }
        URLFileSystemHelper helper = URLFileSystem.findHelper((String)url.getProtocol());
        while (helper instanceof URLFileSystemHelperDecorator) {
            if (!((helper = ((URLFileSystemHelperDecorator)helper).getHelper()) instanceof VCSURLFileSystemHelper)) continue;
            ((VCSURLFileSystemHelper)helper).deleteRecursively(url, filter, tolerant, nonDeletedUrls);
            return;
        }
        super.deleteRecursively(url, filter, tolerant, nonDeletedUrls);
    }

    public static void _test_SelectNoSystem() {
    }

    public static void _test_SelectSystem(VCS vcs) {
        vcs.toString();
    }

    public static DTCache getDTCache() {
        if (Boolean.getBoolean("ide.vcs.nodtcache")) {
            if (_dtcache == null) {
                _dtcache = new DTCache();
            }
            return _dtcache;
        }
        return Ide.getDTCache();
    }

    private static class CheckOutFilesPanel
    extends SelectFilesPanel {
        private static final int OK_BUTTON = 0;
        private static final int CANCEL_BUTTON = 1;
        private static final int DLG_MAX_WIDTH = 800;
        private static final int DLG_MAX_HEIGHT = 600;
        private static final int DLG_MIN_WIDTH = 400;
        private static final int DLG_MIN_HEIGHT = 300;

        CheckOutFilesPanel(CheckBoxListModel listModel, String prompt) {
            super(listModel, true, prompt);
        }

        public static final int showDialog(Component parent, String title, Component pnl, String helpTopic) {
            int displayButtons = 3;
            if (helpTopic != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)pnl, helpTopic);
                displayButtons += 4;
            }
            JEWTDialog dialog = CheckOutFilesPanel.newDialog(parent, title, pnl, displayButtons);
            dialog.setDefaultButton(1);
            return VCSDialogRunner.runDialog((JDialog)dialog) ? 0 : 1;
        }

        private static JEWTDialog newDialog(Component parent, String title, Component pnl, int buttons) {
            JEWTDialog dlg = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttons);
            dlg.setMinimumSize(400, 300);
            dlg.setMaximumInitialSize(800, 600);
            dlg.setContent(pnl);
            dlg.setResizable(true);
            return dlg;
        }
    }

    private final class ProgressAdapter
    extends VCSProgress {
        private final VCSTask _task;
        private int _maximum;
        private int _progress;
        private int _ceiling = -1;

        ProgressAdapter(VCSTask task) {
            this._task = task;
        }

        @Override
        public void incrementProgress(int amount) {
            this.setProgress(this.getProgress() + amount);
        }

        @Override
        public boolean isCancelled() {
            return this._task != null && this._task.isCancelled();
        }

        protected final synchronized void setProgress(int progress) {
            if (this._ceiling >= 0 && progress > this._ceiling) {
                new IllegalArgumentException("Progress exceeds current ceiling (" + progress + " > " + this._ceiling + ")").printStackTrace();
            }
            if (this._ceiling >= 0) {
                progress = Math.min(progress, this._ceiling);
            }
            if (this._task != null) {
                int oldValue = this.calculateProgressPercent(this._progress);
                int newValue = this.calculateProgressPercent(progress);
                this._task.getPropertyChangeSupport().firePropertyChange("external-progress", oldValue, newValue);
            }
            this._progress = progress;
        }

        private final int calculateProgressPercent(int progress) {
            return this._maximum > 0 ? Math.min(100, Math.max(0, Math.round((float)progress / (float)this._maximum))) : 0;
        }

        protected final synchronized int getProgress() {
            return this._progress;
        }

        private final void setMaximum(int maximum) {
            this._maximum = maximum;
        }

        private final void setCeiling(int ceiling) {
            this._ceiling = ceiling;
        }

        private final int getCeiling() {
            return this._ceiling;
        }
    }
}

