/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.annotations.VCSAnnotationExtention;
import oracle.jdeveloper.vcs.historygraph.VCSHistoryGraphExtension;
import oracle.jdeveloper.vcs.tracking.VCSBugTracking;

public final class VCSBugTrackingHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName HOOK = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-bugtracking-hook");
    private static final ElementName CLASSNAME = new ElementName("http://xmlns.oracle.com/ide/extension", "bugtracking-class");
    private static final ElementName ANN_CLASSNAME = new ElementName("http://xmlns.oracle.com/ide/extension", "annotation-class");
    private static final ElementName CG_CLASSNAME = new ElementName("http://xmlns.oracle.com/ide/extension", "history-graph-class");
    private static final ElementName VCSBUGTRACKING = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-bugtracking");
    private static final ElementName VCSANNOTATION = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-annotation-extend");
    private static final ElementName VCSCOMMITGRAPH = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-history-graph-extend");
    private static final String VCSTYPE = "vcstype";
    private static final String PRIORITY = "priority";
    private final ElementVisitor _classNameVisitor = new BugTrackClassVisitor();
    private final ElementVisitor _vcsBugtrackingVisitor = new VCSBugtrackingVisitor();
    private final ElementVisitor _vcsAnnotationVisitor = new VCSAnnotationVistor();
    private final ElementVisitor _classNameAnnVisitor = new AnnotateClassVisitor();
    private final ElementVisitor _vcsHistoryGraphVisitor = new VCSHistoryGraphVisitor();
    private final ElementVisitor _classNameHGVisitor = new HistoryGraphClassVisitor();
    private final Map<String, MetaClass> _bugtracking = new HashMap<String, MetaClass>();
    private String _vcsType = null;
    private Integer _annotatePrority = null;
    private Integer _commitGraphPrority = null;
    private final Collection<Pair<MetaClass, Integer>> _annotations = new TreeSet<Pair<MetaClass, Integer>>(new PriorityComparator());
    private final Collection<VCSAnnotationExtention> _annotateInstance = new ArrayList<VCSAnnotationExtention>();
    private final Collection<Pair<MetaClass, Integer>> _historyGraph = new TreeSet<Pair<MetaClass, Integer>>(new PriorityComparator());
    private final Collection<VCSHistoryGraphExtension> _historyGraphInstance = new ArrayList<VCSHistoryGraphExtension>();

    public VCSBugTracking getObject(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this._bugtracking.containsKey(type)) {
            return (VCSBugTracking)this._bugtracking.get(type).newInstance();
        }
        return null;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(VCSBUGTRACKING, this._vcsBugtrackingVisitor);
        context.registerChildVisitor(VCSANNOTATION, this._vcsAnnotationVisitor);
        context.registerChildVisitor(VCSCOMMITGRAPH, this._vcsHistoryGraphVisitor);
    }

    public Collection<VCSAnnotationExtention> getAnnotations() {
        if (this._annotateInstance.size() < this._annotations.size()) {
            this._annotateInstance.clear();
            for (Pair<MetaClass, Integer> annotate : this._annotations) {
                try {
                    this._annotateInstance.add((VCSAnnotationExtention)((MetaClass)annotate.getFirst()).newInstance());
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (IllegalAccessException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (InstantiationException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
        return this._annotateInstance;
    }

    public Collection<VCSHistoryGraphExtension> getCommitGraph() {
        if (this._historyGraphInstance.size() < this._historyGraph.size()) {
            this._historyGraphInstance.clear();
            for (Pair<MetaClass, Integer> annotate : this._historyGraph) {
                try {
                    this._historyGraphInstance.add((VCSHistoryGraphExtension)((MetaClass)annotate.getFirst()).newInstance());
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (IllegalAccessException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (InstantiationException e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
        return this._historyGraphInstance;
    }

    private final class BugTrackClassVisitor
    extends MetaClassVisitor {
        private BugTrackClassVisitor() {
        }

        public void metaClass(ElementContext context, MetaClass metaClass) {
            VCSBugTrackingHook.this._bugtracking.put(VCSBugTrackingHook.this._vcsType, metaClass);
        }
    }

    private final class VCSBugtrackingVisitor
    extends ElementVisitor {
        private VCSBugtrackingVisitor() {
        }

        public final void start(ElementStartContext context) {
            VCSBugTrackingHook.this._vcsType = this.getAttributeHelper(context, VCSBugTrackingHook.VCSTYPE, true, true);
            context.registerChildVisitor(CLASSNAME, VCSBugTrackingHook.this._classNameVisitor);
        }
    }

    private final class VCSAnnotationVistor
    extends ElementVisitor {
        private VCSAnnotationVistor() {
        }

        public final void start(ElementStartContext context) {
            String prority = this.getAttributeHelper(context, VCSBugTrackingHook.PRIORITY, true, true);
            VCSBugTrackingHook.this._annotatePrority = Integer.valueOf(prority);
            context.registerChildVisitor(ANN_CLASSNAME, VCSBugTrackingHook.this._classNameAnnVisitor);
        }
    }

    private final class AnnotateClassVisitor
    extends MetaClassVisitor {
        private AnnotateClassVisitor() {
        }

        public void metaClass(ElementContext context, MetaClass metaClass) {
            VCSBugTrackingHook.this._annotations.add((Pair<MetaClass, Integer>)new Pair((Object)metaClass, (Object)VCSBugTrackingHook.this._annotatePrority));
        }
    }

    private final class VCSHistoryGraphVisitor
    extends ElementVisitor {
        private VCSHistoryGraphVisitor() {
        }

        public final void start(ElementStartContext context) {
            String prority = this.getAttributeHelper(context, VCSBugTrackingHook.PRIORITY, true, true);
            VCSBugTrackingHook.this._commitGraphPrority = Integer.valueOf(prority);
            context.registerChildVisitor(CG_CLASSNAME, VCSBugTrackingHook.this._classNameHGVisitor);
        }
    }

    private final class HistoryGraphClassVisitor
    extends MetaClassVisitor {
        private HistoryGraphClassVisitor() {
        }

        public void metaClass(ElementContext context, MetaClass metaClass) {
            VCSBugTrackingHook.this._historyGraph.add((Pair<MetaClass, Integer>)new Pair((Object)metaClass, (Object)VCSBugTrackingHook.this._commitGraphPrority));
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Pair)) {
                return -1;
            }
            if (!(o2 instanceof Pair)) {
                return 1;
            }
            Pair p1 = (Pair)o1;
            Pair p2 = (Pair)o2;
            if ((Integer)p1.getSecond() < (Integer)p2.getSecond()) {
                return -1;
            }
            if ((Integer)p1.getSecond() > (Integer)p2.getSecond()) {
                return 1;
            }
            return 0;
        }
    }
}

