/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class VCSWaitRunnable
implements Runnable {
    private final VCSExceptionHandler _exceptionHandler;
    private VCSOptionsCustomizer _optionsCustomizer;
    private IndeterminateProgressMonitor _progressMonitor;
    private Exception _exception;

    public VCSWaitRunnable() {
        this(null);
    }

    public VCSWaitRunnable(VCSExceptionHandler exceptionHandler) {
        this(exceptionHandler, null);
    }

    public VCSWaitRunnable(VCSExceptionHandler exceptionHandler, VCSOptionsCustomizer optionsCustomizer) {
        this._exceptionHandler = exceptionHandler;
        this.setOptionsCustomizer(optionsCustomizer);
    }

    public void setIndeterminateProgressMonitor(IndeterminateProgressMonitor progressMonitor) {
        this._progressMonitor = progressMonitor;
    }

    public IndeterminateProgressMonitor getIndeterminateProgressMonitor() {
        return this._progressMonitor;
    }

    public void setOptionsCustomizer(VCSOptionsCustomizer optionsCustomizer) {
        this._optionsCustomizer = optionsCustomizer;
    }

    public VCSOptionsCustomizer setOptionsCustomizer() {
        return this._optionsCustomizer;
    }

    public Exception getException() {
        return this._exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WaitCursor waitCursor;
        block9: {
            Window currentWindow = VCSWindowUtils.getCurrentWindow();
            WaitCursor waitCursor2 = waitCursor = currentWindow == IdeUtil.getMainWindow() ? Ide.getWaitCursor() : new WaitCursor((Component)currentWindow);
            if (EventQueue.isDispatchThread()) {
                waitCursor.show();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        waitCursor.show();
                    }
                });
            }
            this._exception = null;
            try {
                if (this._optionsCustomizer != null) {
                    this._optionsCustomizer.validateOptions();
                }
                if (this._progressMonitor != null) {
                    this._progressMonitor.start();
                }
                this.runImpl();
                if (this._progressMonitor == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        this._exception = e;
                        if (this._progressMonitor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (this._progressMonitor != null) {
                            this._progressMonitor.close();
                        }
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ WaitCursor val$waitCursor;
                            {
                                this.val$waitCursor = waitCursor;
                            }

                            @Override
                            public final void run() {
                                Exception exception = VCSWaitRunnable.this._exception;
                                if (exception == null) {
                                    try {
                                        VCSWaitRunnable.this.runPostOperationAWT();
                                    }
                                    catch (Exception e) {
                                        exception = e;
                                    }
                                }
                                this.val$waitCursor.hide();
                                if (exception == null) {
                                    return;
                                }
                                if (VCSWaitRunnable.this._exceptionHandler != null) {
                                    VCSWaitRunnable.this._exceptionHandler.handleException(exception);
                                } else {
                                    exception.printStackTrace();
                                }
                            }
                        });
                        throw throwable;
                    }
                    this._progressMonitor.close();
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            this._progressMonitor.close();
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    protected abstract void runImpl() throws Exception;

    protected void runPostOperationAWT() throws Exception {
    }

    protected final Map<?, ?> getOptions() {
        return this._optionsCustomizer != null ? this._optionsCustomizer.getOptions() : null;
    }
}

