/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSSingleNodeObserver
implements VCSEBComponent {
    private StatusCacheBridge<VCSStatus> _cache;
    private URLFilter _filter;
    private String _vcsId;

    public VCSSingleNodeObserver() {
    }

    @Deprecated
    public VCSSingleNodeObserver(VCSStatusCache cache, URLFilter urlfilter) {
        this(cache, urlfilter, null);
    }

    public VCSSingleNodeObserver(VCSStatusCache cache, URLFilter urlfilter, String vcsId) {
        this._cache = cache;
        this._filter = urlfilter;
        this._vcsId = vcsId;
    }

    @Deprecated
    public VCSStatusCache getStatusCache() {
        return this._cache instanceof VCSStatusCache ? (VCSStatusCache)this._cache : null;
    }

    public StatusCache<VCSStatus> getPolicyStatusCache() {
        return this._cache instanceof StatusCache ? (StatusCache)this._cache : null;
    }

    public StatusCacheBridge<VCSStatus> getStatusCacheBridge() {
        return this._cache;
    }

    public void setStatusCache(VCSStatusCache cache) {
        this._cache = cache;
    }

    public void setStatusCacheBridge(StatusCacheBridge<VCSStatus> cache) {
        this._cache = cache;
    }

    public void setPolicyStatusCache(StatusCache<VCSStatus> cache) {
        this._cache = cache;
    }

    public URLFilter getURLFilter() {
        return this._filter;
    }

    public void setURLFilter(URLFilter filter) {
        this._filter = filter;
    }

    public String getSystemId() {
        return this._vcsId;
    }

    public void setSystemId(String systemId) {
        this._vcsId = systemId;
    }

    protected boolean isSaveStateChange(URL url) {
        return true;
    }

    protected void clearStatusCacheParentURLs(URL url) {
        this._cache.clear(VCSFileSystemUtils.getParentURLs(url));
    }

    protected void nodeSaved(URL url) {
        this.nodeSaved(new URL[]{url});
    }

    protected void nodeSaved(URL[] urls) {
        this._cache.clear(urls);
        for (int i = 0; i < urls.length; ++i) {
            this.clearStatusCacheParentURLs(urls[i]);
        }
    }

    protected void nodeReloaded(URL url) {
        this._cache.clear(url);
    }

    protected void nodeRenamed(URL oldUrl, URL newUrl) {
        if (this._cache instanceof VCSStatusCache) {
            ((VCSStatusCache)this._cache).recache(oldUrl, newUrl);
        }
        this._cache.clear(newUrl);
    }

    @Override
    public void handleMessage(VCSEBMessage message) {
        if (!(message instanceof VCSNodeUpdate)) {
            return;
        }
        VCSNodeUpdate nodeUpdate = (VCSNodeUpdate)message;
        Node node = nodeUpdate.getNode();
        URL url = VCSModelUtils.getLocatableURL(node);
        if (url != null && !this.acceptable(url)) {
            return;
        }
        if (nodeUpdate.getWhat() == VCSNodeUpdate.RELOADED && url != null) {
            this.nodeReloaded(url);
        }
        if (nodeUpdate.getWhat() == VCSNodeUpdate.SAVED) {
            URL[] urls = null;
            if (CompositeFileElementRegistry.isCompositeElement((Element)node, null)) {
                urls = CompositeFileElementRegistry.getCompositeFileURLs((Element)node, null);
            }
            if (urls == null || urls.length <= 0) {
                if (url != null) {
                    URL[] uRLArray = new URL[1];
                    v1 = uRLArray;
                    uRLArray[0] = url;
                } else {
                    v1 = urls = null;
                }
            }
            if (urls != null) {
                this._nodeSaved(urls);
            }
        }
        if (nodeUpdate.getWhat() == VCSNodeUpdate.RENAMED && url != null) {
            this.nodeRenamed(nodeUpdate.getOldURL(), url);
        }
    }

    private void _nodeSaved(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (this.acceptable(url) && this.isSaveStateChange(url)) continue;
            itr.remove();
        }
        if (urls0.size() > 0) {
            this.nodeSaved(urls0.toArray(new URL[0]));
        }
    }

    private boolean acceptable(URL url) {
        if (this._vcsId != null && !this.isControlled(url)) {
            return false;
        }
        if (this._filter == null) {
            return true;
        }
        return this._filter.accept(url);
    }

    private final boolean isControlled(URL url) {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        return extension != null && extension.getId().equals(this._vcsId);
    }
}

