/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;

public class VCSPreferencesCustomizer
extends VCSPreferencesTraversable<VCSPreferences> {
    private final String _extensionId;
    private static final int TIMEOUT_SCALE_SECONDS = 1;
    private static final int TIMEOUT_SCALE_MINUTES = 2;
    private static final int TIMEOUT_SCALE_HOURS = 3;
    private CustomizerUI _customizerUI;
    private final Collection<String> _propertyKeys;
    private final ResourceProxy _resourceProxy;
    public static final String RES_ID_USE_OVERLAYS_CHECKBOX_TEXT = "USE_OVERLAYS_CHECKBOX_TEXT";
    public static final String RES_ID_USE_OVERLAYS_CHECKBOX_MNEMONIC = "USE_OVERLAYS_CHECKBOX_MNEMONIC";
    public static final String RES_ID_SILENTLY_SAVE_CHECKBOX_TEXT = "SILENTLY_SAVE_CHECKBOX_TEXT";
    public static final String RES_ID_SILENTLY_SAVE_CHECKBOX_MNEMONIC = "SILENTLY_SAVE_CHECKBOX_MNEMONIC";
    public static final String RES_ID_AUTO_CHECKOUTS_CHECKBOX_TEXT = "AUTO_CHECKOUTS_CHECKBOX_TEXT";
    public static final String RES_ID_AUTO_CHECKOUTS_CHECKBOX_MNEMONIC = "AUTO_CHECKOUTS_CHECKBOX_MNEMONIC";
    public static final String RES_ID_USE_LABEL_DECORATIONS_TEXT = "USE_LABEL_DECORATIONS_TEXT";
    public static final String RES_ID_USE_LABEL_DECORATIONS_MNEMONIC = "USE_LABEL_DECORATIONS_MNEMONIC";
    public static final String RES_ID_AUTO_CHECKOUTS_COMMENT_TEXT = "AUTO_CHECKOUTS_COMMENT_TEXT";
    public static final String RES_ID_AUTO_CHECKOUTS_COMMENT_MNEMONIC = "AUTO_CHECKOUTS_COMMENT_MNEMONIC";
    public static final String RES_ID_AUTO_ADDFILE_TEXT = "AUTO_ADDFILE_TEXT";
    public static final String RES_ID_AUTO_ADDFILE_MNEMONIC = "AUTO_ADDFILE_MNEMONIC";
    public static final String RES_ID_AUTO_PROGRESS_ON_CHECKOUT_TEXT = "AUTO_PROGRESS_ON_CHECKOUT_TEXT";
    public static final String RES_ID_AUTO_PROGRESS_ON_CHECKOUT_MNEMONIC = "AUTO_PROGRESS_ON_CHECKOUT_MNEMONIC";
    public static final String RES_ID_AUTO_LOG_MESSAGE_TEXT = "AUTO_LOG_MESSAGE_TEXT";
    public static final String RES_ID_AUTO_LOG_MESSAGE_MNEMONIC = "AUTO_LOG_MESSAGE_MNEMONIC";
    public static final String RES_ID_AUTO_CHECKOUTS_EXTEND_MESSAGE_TEXT = "auto-checkouts-extend-text";
    public static final String RES_ID_AUTO_CHECKOUTS_EXTEND_MNEMONIC = "auto-checkouts-extend-mnemonic";
    public static final String RES_ID_AUTO_ADD_EXTEND_MESSAGE_TEXT = "auto-add-extend-text";
    public static final String RES_ID_AUTO_ADD_EXTEND_MNEMONIC = "auto-add-extend-mnemonic";

    public VCSPreferencesCustomizer(String extensionId, String[] keys) {
        this(extensionId, keys, null);
    }

    public VCSPreferencesCustomizer(String extensionId, String[] keys, ResourceProxy resourceProxy) {
        this._extensionId = extensionId;
        this._propertyKeys = keys != null ? Arrays.asList(keys) : null;
        this._resourceProxy = resourceProxy != null ? resourceProxy : new ResourceProxy();
    }

    @Override
    protected VCSPreferences getPreferences(PropertyStorage prefs) {
        return VCSPreferences.getInstance(prefs, this._extensionId);
    }

    @Override
    protected Component getPage() {
        if (this._customizerUI == null) {
            int displayFlags = 0;
            if (this.isHandlingProperty("useOverlays")) {
                displayFlags |= 1;
            }
            if (this.isHandlingProperty("autoCheckouts")) {
                displayFlags |= 4;
            }
            if (this.isHandlingProperty("autoAddFiles")) {
                displayFlags |= 0x40;
            }
            if (this.isHandlingProperty("autoAddExtended")) {
                displayFlags |= 0x400;
            }
            if (this.isHandlingProperty("operationTimeout")) {
                displayFlags |= 8;
            }
            if (this.isHandlingProperty("useLabelDecorations")) {
                displayFlags |= 0x10;
            }
            if (this.isHandlingProperty("autoCheckoutComment")) {
                displayFlags |= 0x20;
            }
            if (this.isHandlingProperty("autoProgressOnCheckout")) {
                displayFlags |= 0x80;
            }
            if (this.isHandlingProperty("autoCheckoutExtended")) {
                displayFlags |= 0x200;
            }
            if (this.isHandlingProperty("autoLogMessages")) {
                displayFlags |= 0x100;
            }
            this._customizerUI = new CustomizerUI(displayFlags, this._resourceProxy);
        }
        return this._customizerUI;
    }

    @Override
    protected void loadPreferences(VCSPreferences preferences) {
        this.getComponent();
        if (this.isHandlingProperty("useOverlays")) {
            this._customizerUI.getUseOverlaysCheckBox().setSelected(preferences.getUseOverlays());
        }
        if (this.isHandlingProperty("autoCheckouts")) {
            this._customizerUI.getAutoCheckoutsCheckBox().setSelected(preferences.getAutoCheckouts());
            if (!preferences.getAutoCheckouts()) {
                this._customizerUI.getAutoProgessOnCheckoutCheckBox().setEnabled(false);
                this._customizerUI.getAutoCheckoutExtended().setEnabled(false);
            }
        }
        if (this.isHandlingProperty("autoAddFiles")) {
            this._customizerUI.getAutoAddFilesCheckBox().setSelected(preferences.getAutoAddFiles());
            if (!preferences.getAutoAddFiles()) {
                this._customizerUI.getAutoAddExtended().setEnabled(false);
            }
        }
        if (this.isHandlingProperty("autoAddExtended")) {
            this._customizerUI.getAutoAddExtended().setSelected(preferences.getAutoAddExtended());
        }
        if (this.isHandlingProperty("useLabelDecorations")) {
            this._customizerUI.getUseLabelDecorationsCheckBox().setSelected(preferences.getUseLabelDecorations());
        }
        if (this.isHandlingProperty("autoProgressOnCheckout")) {
            this._customizerUI.getAutoProgessOnCheckoutCheckBox().setSelected(preferences.getAutoProgressOnCheckout());
        }
        if (this.isHandlingProperty("autoCheckoutExtended")) {
            this._customizerUI.getAutoCheckoutExtended().setSelected(preferences.getAutoCheckoutExtended());
        }
        if (this.isHandlingProperty("operationTimeout")) {
            int seconds = preferences.getOperationTimeout();
            int scale = this.calculateTimeoutScale(seconds);
            this._customizerUI.getOperationTimeoutQuantity().setNumber((Number)this.calculateTimeoutQuantity(seconds, scale));
            if (scale == 3) {
                this._customizerUI.getOperationTimeoutHours().setSelected(true);
            }
            if (scale == 2) {
                this._customizerUI.getOperationTimeoutMinutes().setSelected(true);
            }
            if (scale == 1) {
                this._customizerUI.getOperationTimeoutSeconds().setSelected(true);
            }
        }
        if (this.isHandlingProperty("autoCheckoutComment")) {
            this._customizerUI.getAutoCheckoutCommentField().setText(preferences.getAutoCheckoutComment());
        }
        if (this.isHandlingProperty("autoLogMessages")) {
            this._customizerUI.getAutoLogMessagesField().setSelected(preferences.getAutoLogMessages());
        }
    }

    @Override
    protected void savePreferences(VCSPreferences preferences) {
        this.getComponent();
        if (this.isHandlingProperty("useOverlays")) {
            preferences.setUseOverlays(this._customizerUI.getUseOverlaysCheckBox().isSelected());
        }
        if (this.isHandlingProperty("autoCheckouts")) {
            preferences.setAutoCheckouts(this._customizerUI.getAutoCheckoutsCheckBox().isSelected());
        }
        if (this.isHandlingProperty("useLabelDecorations")) {
            preferences.setUseLabelDecorations(this._customizerUI.getUseLabelDecorationsCheckBox().isSelected());
        }
        if (this.isHandlingProperty("autoAddFiles")) {
            preferences.setAutoAddFiles(this._customizerUI.getAutoAddFilesCheckBox().isSelected());
        }
        if (this.isHandlingProperty("autoAddExtended")) {
            preferences.setAutoAddExtended(this._customizerUI.getAutoAddExtended().isSelected());
        }
        if (this.isHandlingProperty("autoProgressOnCheckout")) {
            preferences.setAutoProgressOnCheckout(this._customizerUI.getAutoProgessOnCheckoutCheckBox().isSelected());
        }
        if (this.isHandlingProperty("autoCheckoutExtended")) {
            preferences.setAutoCheckoutExtended(this._customizerUI.getAutoCheckoutExtended().isSelected());
        }
        if (this.isHandlingProperty("operationTimeout")) {
            Integer quantity;
            Integer quantity0;
            int scale = 1;
            if (this._customizerUI.getOperationTimeoutHours().isSelected()) {
                scale = 3;
            }
            if (this._customizerUI.getOperationTimeoutMinutes().isSelected()) {
                scale = 2;
            }
            Integer n = quantity0 = (quantity = (Integer)this._customizerUI.getOperationTimeoutQuantity().getNumber()) != null ? Integer.valueOf(this.calculateTimeoutSeconds(quantity, scale)) : null;
            if (quantity0 != null) {
                preferences.setOperationTimeout(quantity0);
            }
        }
        if (this.isHandlingProperty("autoCheckoutComment")) {
            preferences.setAutoCheckoutComment(this._customizerUI.getAutoCheckoutCommentField().getText());
        }
        if (this.isHandlingProperty("autoLogMessages")) {
            preferences.setAutoLogMessages(this._customizerUI.getAutoLogMessagesField().isSelected());
        }
    }

    @Override
    protected void validatePreferences() throws TraversalException {
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 3;
        }
        if (seconds > 0 && seconds % 60 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 3) {
            return seconds / 3600;
        }
        if (scale == 2) {
            return seconds / 60;
        }
        return seconds;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 3) {
            return quantity * 3600;
        }
        if (scale == 2) {
            return quantity * 60;
        }
        return quantity;
    }

    private boolean isHandlingProperty(String propertyKey) {
        return VCSPreferencesCustomizer.isHandlingProperty(this._propertyKeys, propertyKey);
    }

    private static final boolean isHandlingProperty(Collection propertyKeys, String requiredPropertyKey) {
        return propertyKeys == null || propertyKeys.contains(requiredPropertyKey);
    }

    public static class ResourceProxy {
        protected String getString(String id) {
            if (VCSArb.getBundle().containsKey(id)) {
                return VCSArb.get(id);
            }
            return null;
        }

        protected int getMnemonic(String id) {
            if (VCSArb.getBundle().containsKey(id)) {
                return VCSArb.get(id).charAt(0);
            }
            return 0;
        }
    }

    private static class CustomizerUI
    extends JPanel {
        private static final int DISPLAY_USE_OVERLAYS_CHECKBOX = 1;
        private static final int DISPLAY_SILENTLY_SAVE_CHECKBOX = 2;
        private static final int DISPLAY_AUTO_CHECKOUTS_CHECKBOX = 4;
        private static final int DISPLAY_OPERATION_TIMEOUT_CONTROL = 8;
        private static final int DISPLAY_USE_LABEL_DECORATIONS_CHECKBOX = 16;
        private static final int DISPLAY_AUTO_CHECKOUT_COMMENT_FIELD = 32;
        private static final int DISPLAY_AUTO_ADD_FILES_CHECKBOX = 64;
        private static final int DISPLAY_AUTO_PROGRESS_ON_CHECKOUT = 128;
        private static final int DISPLAY_AUTO_LOG_MESSAGES = 256;
        private static final int DISPLAY_AUTO_CHECKOUT_EXTENDED = 512;
        private static final int DISPLAY_AUTO_ADD_EXTENDED = 1024;
        private JLabel _environmentSettingsLabel = new JLabel();
        private JCheckBox _useOverlaysCheckBox = new JCheckBox();
        private JCheckBox _silentlySaveCheckBox;
        private JCheckBox _autoCheckoutsCheckBox;
        private JCheckBox _useLabelDecorationsCheckBox;
        private JCheckBox _autoAddFilesCheckBox;
        private JCheckBox _autoProgressOnCheckBox;
        private JCheckBox _autoLogMessagesCheckBox;
        private JCheckBox _autoCheckOutBoxExtended;
        private JCheckBox _autoAddBoxExtended;
        private JLabel _operationTimeoutLabel;
        private JRadioButton _operationTimeoutSeconds;
        private JRadioButton _operationTimeoutMinutes;
        private JRadioButton _operationTimeoutHours;
        private NumberTextField _operationTimeoutQuantity;
        private JLabel _autoCheckoutCommentLabel;
        private JTextField _autoCheckoutCommentField;

        CustomizerUI(int displayFlags, ResourceProxy resourceProxy) {
            this._useOverlaysCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_USE_OVERLAYS_CHECKBOX_TEXT));
            this._useOverlaysCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_USE_OVERLAYS_CHECKBOX_MNEMONIC));
            this._silentlySaveCheckBox = new JCheckBox();
            this._silentlySaveCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_SILENTLY_SAVE_CHECKBOX_TEXT));
            this._silentlySaveCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_SILENTLY_SAVE_CHECKBOX_MNEMONIC));
            this._autoCheckoutsCheckBox = new JCheckBox();
            this._autoCheckoutsCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_CHECKBOX_TEXT));
            this._autoCheckoutsCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_CHECKBOX_MNEMONIC));
            this._autoAddFilesCheckBox = new JCheckBox();
            this._autoAddFilesCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_ADDFILE_TEXT));
            this._autoAddFilesCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_ADDFILE_MNEMONIC));
            this._useLabelDecorationsCheckBox = new JCheckBox();
            this._useLabelDecorationsCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_USE_LABEL_DECORATIONS_TEXT));
            this._useLabelDecorationsCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_USE_LABEL_DECORATIONS_MNEMONIC));
            this._autoCheckoutCommentLabel = new JLabel();
            this._autoCheckoutCommentLabel.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_COMMENT_TEXT));
            this._autoCheckoutCommentLabel.setDisplayedMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_COMMENT_MNEMONIC));
            this._autoProgressOnCheckBox = new JCheckBox();
            this._autoProgressOnCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_PROGRESS_ON_CHECKOUT_TEXT));
            this._autoProgressOnCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_PROGRESS_ON_CHECKOUT_MNEMONIC));
            this._autoLogMessagesCheckBox = new JCheckBox();
            this._autoLogMessagesCheckBox.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_LOG_MESSAGE_TEXT));
            this._autoLogMessagesCheckBox.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_LOG_MESSAGE_MNEMONIC));
            this._autoCheckOutBoxExtended = new JCheckBox();
            this._autoCheckOutBoxExtended.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_EXTEND_MESSAGE_TEXT));
            this._autoCheckOutBoxExtended.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_CHECKOUTS_EXTEND_MNEMONIC));
            this._autoAddBoxExtended = new JCheckBox();
            this._autoAddBoxExtended.setText(resourceProxy.getString(VCSPreferencesCustomizer.RES_ID_AUTO_ADD_EXTEND_MESSAGE_TEXT));
            this._autoAddBoxExtended.setMnemonic(resourceProxy.getMnemonic(VCSPreferencesCustomizer.RES_ID_AUTO_ADD_EXTEND_MNEMONIC));
            this._operationTimeoutLabel = new JLabel();
            this._operationTimeoutSeconds = new JRadioButton();
            this._operationTimeoutMinutes = new JRadioButton();
            this._operationTimeoutHours = new JRadioButton();
            this._operationTimeoutQuantity = new NumberTextField();
            this._autoCheckoutCommentField = new JTextField();
            this._autoCheckoutCommentLabel.setLabelFor(this._autoCheckoutCommentField);
            ResourceUtils.resLabel((JLabel)this._environmentSettingsLabel, (Component)this._environmentSettingsLabel, (String)VCSArb.get("ENVIRONMENT_SETTINGS"));
            ResourceUtils.resLabel((JLabel)this._operationTimeoutLabel, (Component)this._operationTimeoutQuantity, (String)VCSArb.get("OPERATION_TIMEOUT"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutSeconds, (String)VCSArb.get("OPERATION_TIMEOUT_SECONDS"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutMinutes, (String)VCSArb.get("OPERATION_TIMEOUT_MINUTES"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutHours, (String)VCSArb.get("OPERATION_TIMEOUT_HOURS"));
            ButtonGroup operationTimeoutButtonGroup = new ButtonGroup();
            operationTimeoutButtonGroup.add(this._operationTimeoutSeconds);
            operationTimeoutButtonGroup.add(this._operationTimeoutMinutes);
            operationTimeoutButtonGroup.add(this._operationTimeoutHours);
            operationTimeoutButtonGroup = null;
            this._operationTimeoutQuantity.setColumns(10);
            this._operationTimeoutQuantity.setDecimal(true);
            this._operationTimeoutQuantity.setSigned(false);
            this._operationTimeoutQuantity.setDataType(Integer.class);
            if ((displayFlags & 1) <= 0) {
                this._useOverlaysCheckBox.setEnabled(false);
            }
            if ((displayFlags & 2) <= 0) {
                this._silentlySaveCheckBox.setEnabled(false);
            }
            if ((displayFlags & 4) <= 0) {
                this._autoCheckoutsCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x40) <= 0) {
                this._autoAddFilesCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x10) <= 0) {
                this._useLabelDecorationsCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x80) <= 0) {
                this._autoProgressOnCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x200) <= 0) {
                this._autoCheckOutBoxExtended.setEnabled(false);
            }
            if ((displayFlags & 0x400) <= 0) {
                this._autoAddBoxExtended.setEnabled(false);
            }
            if ((displayFlags & 8) <= 0) {
                this._operationTimeoutLabel.setEnabled(false);
                this._operationTimeoutSeconds.setEnabled(false);
                this._operationTimeoutMinutes.setEnabled(false);
                this._operationTimeoutHours.setEnabled(false);
                this._operationTimeoutQuantity.setEnabled(false);
            }
            if (!(this._useOverlaysCheckBox.isEnabled() || this._useLabelDecorationsCheckBox.isEnabled() || this._silentlySaveCheckBox.isEnabled() || this._autoCheckoutsCheckBox.isEnabled())) {
                this._environmentSettingsLabel.setEnabled(false);
            }
            this.layoutComponents(displayFlags);
            this.addListener();
        }

        public JCheckBox getUseOverlaysCheckBox() {
            return this._useOverlaysCheckBox;
        }

        public JCheckBox getSilentlySaveCheckBox() {
            return this._silentlySaveCheckBox;
        }

        public JCheckBox getAutoCheckoutsCheckBox() {
            return this._autoCheckoutsCheckBox;
        }

        public JCheckBox getAutoAddFilesCheckBox() {
            return this._autoAddFilesCheckBox;
        }

        public JCheckBox getUseLabelDecorationsCheckBox() {
            return this._useLabelDecorationsCheckBox;
        }

        public JRadioButton getOperationTimeoutSeconds() {
            return this._operationTimeoutSeconds;
        }

        public JRadioButton getOperationTimeoutMinutes() {
            return this._operationTimeoutMinutes;
        }

        public JRadioButton getOperationTimeoutHours() {
            return this._operationTimeoutHours;
        }

        public NumberTextField getOperationTimeoutQuantity() {
            return this._operationTimeoutQuantity;
        }

        public JTextField getAutoCheckoutCommentField() {
            return this._autoCheckoutCommentField;
        }

        private void layoutComponents(int displayFlags) {
            Insets i = new Insets(2, 2, 2, 2);
            Insets il = new Insets(2, 30, 2, 2);
            LayoutBuilder builder = new LayoutBuilder();
            int columns = (displayFlags & 8) > 0 ? 7 : 2;
            builder.setDefaultAnchor(18);
            builder.add((Component)this._environmentSettingsLabel, i, columns, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addHGap();
            builder.add((Component)this._useOverlaysCheckBox, i, columns - 1, false, true);
            builder.nl();
            if ((displayFlags & 0x10) > 0) {
                builder.addHGap();
                builder.add((Component)this._useLabelDecorationsCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x40) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoAddFilesCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x400) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoAddBoxExtended, il, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x100) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoLogMessagesCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 4) > 0) {
                builder.setDefaultAnchor(18);
                builder.addHGap();
                builder.add((Component)this._autoCheckoutsCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x200) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoCheckOutBoxExtended, il, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x80) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoProgressOnCheckBox, il, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x20) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoCheckoutCommentLabel, i, columns - 1, false, true);
                builder.nl();
                builder.addHGap();
                builder.add((Component)this._autoCheckoutCommentField, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 2) > 0) {
                builder.setDefaultAnchor(18);
                builder.addHGap();
                builder.add((Component)this._silentlySaveCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            builder.setDefaultAnchor(18);
            builder.addVGap();
            builder.nl();
            builder.setDefaultAnchor(18);
            if ((displayFlags & 8) > 0) {
                builder.add((Component)this._operationTimeoutLabel, i, columns, false, true);
                builder.nl();
                builder.addHGap();
                builder.add((Component)this._operationTimeoutQuantity, i, 1, false, true);
                builder.add((Component)this._operationTimeoutSeconds, i, 1, false, false);
                builder.add((Component)this._operationTimeoutMinutes, i, 1, false, false);
                builder.add((Component)this._operationTimeoutHours, i, 1, false, false);
                builder.addHFiller();
                builder.nl();
                builder.addVGap();
                builder.nl();
            }
            builder.addToPanel((Container)this);
        }

        private JCheckBox getAutoProgessOnCheckoutCheckBox() {
            return this._autoProgressOnCheckBox;
        }

        private JCheckBox getAutoLogMessagesField() {
            return this._autoLogMessagesCheckBox;
        }

        private JCheckBox getAutoCheckoutExtended() {
            return this._autoCheckOutBoxExtended;
        }

        private JCheckBox getAutoAddExtended() {
            return this._autoAddBoxExtended;
        }

        private void addListener() {
            this._autoCheckoutsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox _check = (JCheckBox)e.getSource();
                    _autoProgressOnCheckBox.setEnabled(_check.isSelected());
                    _autoCheckOutBoxExtended.setEnabled(_check.isSelected());
                }
            });
            this._autoAddFilesCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox _check = (JCheckBox)e.getSource();
                    _autoAddBoxExtended.setEnabled(_check.isSelected());
                }
            });
        }
    }
}

