/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuConstants;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

public abstract class VCSContextMenuListener
implements ContextMenuListener {
    private final String _vcsId;

    public VCSContextMenuListener(String vcsId) {
        this._vcsId = vcsId;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public void menuWillShow(ContextMenu popup) {
        VCSExtension extension;
        Context context = popup.getContext();
        if (context == null) {
            return;
        }
        if (!(this._vcsId == null || (extension = VCSExtensionUtils.getActiveExtension(context)) != null && extension.getId().equals(this._vcsId))) {
            return;
        }
        Component[] contextMenuItems = this.getContextMenuItems(context);
        if (contextMenuItems == null || contextMenuItems.length <= 0) {
            return;
        }
        for (int i = 0; i < contextMenuItems.length; ++i) {
            popup.add(contextMenuItems[i], this.getSection(), false);
        }
    }

    protected abstract Component[] getContextMenuItems(Context var1);

    protected float getSection() {
        return MenuConstants.SECTION_ADDITIONAL_CTXT_MENU;
    }
}

