/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.historygraph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.historygraph.DrawConnector;
import oracle.jdeveloper.vcs.historygraph.DrawLabel;
import oracle.jdeveloper.vcs.historygraph.DrawNode;
import oracle.jdeveloper.vcs.historygraph.GraphContextMenuListener;
import oracle.jdeveloper.vcs.historygraph.GraphController;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.historygraph.GraphUpdateListener;
import oracle.jdeveloper.vcs.historygraph.HistoryGraphHover;
import oracle.jdeveloper.vcs.historygraph.TimeDrawNode;
import oracle.jdeveloper.vcs.historygraph.VersionHistoryGraphNode;
import oracle.jdeveloper.vcs.historygraph.VersionHistoryGraphURLHelper;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSHistoryGraphProvider;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

public class VersionHistoryGraphEditor
extends Editor
implements PopupManager {
    private static final int STARTX = 100;
    private static final int XWIDTH = 100;
    private static final int GAPWIDTH = 2;
    private static final int YHEIGHT = 25;
    private static final int STARTY = 20;
    private static final int BOTTOMMARGIN = 20;
    private static final int SEARCHFIELD_WIDTH = 270;
    private static final int COMMITDATEFIELD_WIDTH = 200;
    private GraphToolbar _toolbar;
    private GraphController _controller;
    private ContextMenu _contextMenu;
    private URL _root;
    private GraphPanel _panel;
    private Map<GraphNode, DrawNode> _drawNodes = Collections.emptyMap();
    private List<DrawLabel> _labels = Collections.emptyList();
    private Collection<DrawConnector> _drawConnector = Collections.synchronizedCollection(new ArrayList());
    private List<TimeDrawNode> _timeNodes = Collections.synchronizedList(new ArrayList());
    private int _height;
    private List<Color> _colors = new ArrayList<Color>();
    private VCSHistoryGraphProvider _provider;
    private GraphContextMenuListener _menuListener;
    private VCSExceptionHandler _exceptionHandler;
    private Collection<GraphUpdateListener> _listener = new ArrayList<GraphUpdateListener>();

    public void open() {
        Node node = this.getContext().getNode();
        if (node instanceof VersionHistoryGraphNode) {
            this._root = VersionHistoryGraphURLHelper.getFileURL(node.getURL());
        }
    }

    public void close() {
        this._drawNodes.clear();
        this._drawConnector.clear();
        this._timeNodes.clear();
        this._labels.clear();
        this._panel.dispose();
        this._toolbar.removeAll();
        this._toolbar.dispose();
        this._toolbar = null;
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = new GraphPanel();
            this._panel.addPopupManager(this);
            this.refresh();
        }
        return this._panel;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new GraphToolbar();
        }
        return this._toolbar;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new GraphController();
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener(this.getContextMenuListener());
        }
        return this._contextMenu;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute == "vertical_unit_increment") {
            return 25;
        }
        if (attribute == "vertical_block_increment") {
            return 50;
        }
        return super.getEditorAttribute(attribute);
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context == null || this._root == null) {
            return context;
        }
        try {
            context.setNode(NodeFactory.findOrCreate((URL)this._root));
            for (GraphNode gNode : this._drawNodes.keySet()) {
                DrawNode dNode = this._drawNodes.get(gNode);
                if (!dNode.isHighLight()) continue;
                context.setProperty("version-history-graph-node", (Object)gNode);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return context;
    }

    public void clearSelection() {
        for (GraphNode gNode : this._drawNodes.keySet()) {
            DrawNode dNode = this._drawNodes.get(gNode);
            if (!dNode.isHighLight()) continue;
            dNode.clearHighLight();
            this._panel.repaint();
            return;
        }
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        if (this.getContextMenu() != null) {
            this.getContextMenu().show(this.getContext(mouseEvent));
        }
    }

    public void hidePopup(BasicEditorPane editorPane) {
    }

    public void refresh() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String commitLabel = null;
                VersionHistoryGraphEditor.this._drawNodes.clear();
                VersionHistoryGraphEditor.this._drawConnector.clear();
                VersionHistoryGraphEditor.this._timeNodes.clear();
                VersionHistoryGraphEditor.this._colors.clear();
                GraphNode[] nodes = VersionHistoryGraphEditor.this.getProvider().getEntries(VersionHistoryGraphEditor.this._root);
                VersionHistoryGraphEditor.this._drawNodes = VersionHistoryGraphEditor.this.getDrawNodes(nodes);
                VersionHistoryGraphEditor.this._drawConnector.addAll(VersionHistoryGraphEditor.this.getConnectors(VersionHistoryGraphEditor.this._drawNodes));
                VersionHistoryGraphEditor.this._timeNodes.addAll(VersionHistoryGraphEditor.this.getCommitTimeNode(VersionHistoryGraphEditor.this._drawNodes));
                VersionHistoryGraphEditor.this._labels = VersionHistoryGraphEditor.this.getBranchLabels(nodes);
                commitLabel = VersionHistoryGraphEditor.this.getProvider().getCommitLabel(VersionHistoryGraphEditor.this._root);
                Collections.sort(VersionHistoryGraphEditor.this._timeNodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        TimeDrawNode t1 = null;
                        TimeDrawNode t2 = null;
                        if (o1 instanceof TimeDrawNode) {
                            t1 = (TimeDrawNode)o1;
                        }
                        if (o2 instanceof TimeDrawNode) {
                            t2 = (TimeDrawNode)o2;
                        }
                        if (t1 == null || t2 == null) {
                            return 0;
                        }
                        if (t1.getY() < t2.getY()) {
                            return -1;
                        }
                        if (t1.getY() > t2.getY()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                return commitLabel;
            }

            @Override
            protected void done() {
                Dimension dim = VersionHistoryGraphEditor.this._panel.getPreferredSize();
                VersionHistoryGraphEditor.this._panel.setPreferredSize(new Dimension(1000, VersionHistoryGraphEditor.this._height + 20));
                if (dim.height != VersionHistoryGraphEditor.this._height + 20) {
                    VersionHistoryGraphEditor.this._panel.revalidate();
                }
                VersionHistoryGraphEditor.this._panel.repaint();
                VersionHistoryGraphEditor.this._panel.setFocusable(true);
                VersionHistoryGraphEditor.this.notifyListeners();
                try {
                    ((GraphToolbar)VersionHistoryGraphEditor.this.getToolbar()).updateLabel((String)this.get());
                }
                catch (Exception e) {
                    VersionHistoryGraphEditor.this.getExceptionHandler().handleException(e);
                }
            }
        };
        worker.execute();
    }

    private void notifyListeners() {
        this._listener.stream().forEach(e -> e.update());
    }

    private void addUpdateListener(GraphUpdateListener listener) {
        if (!this._listener.contains(listener)) {
            this._listener.add(listener);
        }
    }

    private void removeUpdateListener(GraphUpdateListener listener) {
        if (this._listener.contains(listener)) {
            this._listener.remove(listener);
        }
    }

    private VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    private final IdeAction createLocalAction(IdeAction globalAction) {
        IdeAction localAction = globalAction.newLocalAction((View)this);
        return localAction;
    }

    private final IdeAction getLocalAction(IdeAction globalAction) {
        return this.createLocalAction(globalAction);
    }

    private final IdeAction getLocalAction(int cmdId) {
        return this.getLocalAction(IdeAction.find((int)cmdId));
    }

    private VCSHistoryGraphProvider getProvider() {
        if (this._provider == null) {
            VCSExtension vcs = VCSExtensionUtils.getActiveExtension(this._root);
            this._provider = vcs.getHistoryGraphProvider();
        }
        return this._provider;
    }

    private int findColumn(GraphNode node, Map<Integer, GraphNode> colIndex) {
        for (Integer col : colIndex.keySet()) {
            GraphNode resident = colIndex.get(col);
            if (!resident.getParents().contains(node)) continue;
            return col;
        }
        return colIndex.size();
    }

    private void deleteFromColumn(GraphNode node, Map<Integer, GraphNode> colIndex) {
        for (Integer col : colIndex.keySet()) {
            Collection<GraphNode> parents;
            GraphNode resident = colIndex.get(col);
            if (resident == null || (parents = resident.getParents()).size() != 1) continue;
            for (GraphNode parent : parents) {
                if (parent == null || !parent.equals(node)) continue;
                colIndex.remove(col);
                return;
            }
        }
    }

    private Map<GraphNode, DrawNode> getDrawNodes(GraphNode[] nodes) {
        LinkedHashMap<Integer, GraphNode> colIndex = new LinkedHashMap<Integer, GraphNode>();
        LinkedHashMap<GraphNode, DrawNode> mapNodes = new LinkedHashMap<GraphNode, DrawNode>();
        int y = -5;
        int maxCol = 0;
        int pCol = 0;
        for (GraphNode node : nodes) {
            int col = this.findColumn(node, colIndex);
            if (pCol == col) {
                y += 25;
            } else if (col != pCol && this.isOccupied(100 + col * 100, y, mapNodes)) {
                y += 25;
            }
            DrawNode drNode = new DrawNode(100 + col * 100, y, node, col);
            pCol = col;
            mapNodes.put(node, drNode);
            colIndex.put(col, node);
            this.deleteFromColumn(node, colIndex);
            maxCol = Math.max(maxCol, col);
            drNode.setColor(Color.black);
        }
        this.setColorDrawNodes(maxCol, mapNodes);
        this._height = y;
        return mapNodes;
    }

    private void setColorDrawNodes(int num, Map<GraphNode, DrawNode> nodes) {
        Color color = new Color(31726);
        this._colors.add(Color.black);
        if (num == 0) {
            return;
        }
        int alphaDelta = Math.max(5, 230 / num);
        for (int c = 1; c <= num; ++c) {
            this._colors.add(color);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.max(25, color.getAlpha() - alphaDelta));
        }
        for (GraphNode gNode : nodes.keySet()) {
            DrawNode dNode = nodes.get(gNode);
            dNode.setColor(this._colors.get(dNode.getColumn()));
        }
    }

    private Collection<DrawConnector> getConnectors(Map<GraphNode, DrawNode> nodes) {
        ArrayList<DrawConnector> drawConn = new ArrayList<DrawConnector>();
        for (GraphNode node : nodes.keySet()) {
            DrawNode drChild = nodes.get(node);
            for (GraphNode parent : node.getParents()) {
                DrawNode drParent = nodes.get(parent);
                if (drParent == null) continue;
                ArrayList<DrawNode> exclude = new ArrayList<DrawNode>();
                exclude.add(drParent);
                exclude.add(drChild);
                Point par = drParent.getCentre();
                Point ch = drChild.getCentre();
                ArrayList<Point> pts = new ArrayList<Point>();
                if (drChild.getColumn() == drParent.getColumn()) {
                    pts.add(new Point(par.x, par.y - drParent.getHeight() / 2));
                    pts.add(new Point(ch.x, ch.y + drChild.getHeight() / 2 + 2));
                } else if (ch.x > par.x) {
                    Point st = new Point(par.x, par.y);
                    Point end = new Point(ch.x - drChild.getWidth() / 2 - 2, ch.y);
                    if (par.y == ch.y && !this.passThroughNodes(st, end, exclude)) {
                        pts.add(st);
                        pts.add(end);
                    } else {
                        st = new Point(par.x, par.y);
                        end = new Point(ch.x, ch.y + drChild.getHeight() / 2 + 2);
                        Point mid = new Point(end.x, st.y);
                        if (!this.passThroughNodes(st, mid, exclude)) {
                            pts.add(st);
                            pts.add(mid);
                            pts.add(end);
                        } else {
                            st = new Point(par.x, par.y - drParent.getHeight() / 2);
                            pts.add(st);
                            end = new Point(ch.x - 6, ch.y + drChild.getHeight() / 2 + 2);
                            mid = new Point(par.x, end.y);
                            pts.add(mid);
                            pts.add(end);
                        }
                    }
                } else {
                    pts.add(new Point(par.x, par.y - drParent.getHeight() / 2));
                    pts.add(new Point(par.x, ch.y + drChild.getHeight() / 2 + 2));
                    pts.add(new Point(ch.x + 6, ch.y + drChild.getHeight() / 2 + 2));
                }
                DrawConnector dc = new DrawConnector(pts.toArray(new Point[0]), Math.max(drChild.getColumn(), drParent.getColumn()));
                if (dc.getColumn() < this._colors.size()) {
                    dc.setColor(this._colors.get(dc.getColumn()));
                }
                drawConn.add(dc);
            }
        }
        return drawConn;
    }

    private boolean passThroughNodes(Point st, Point end, Collection<DrawNode> exclude) {
        for (GraphNode gNode : this._drawNodes.keySet()) {
            DrawNode dNode = this._drawNodes.get(gNode);
            Point centre = dNode.getCentre();
            if (exclude.contains(dNode) || !this.lineIntersectRectangle(st, end, dNode.getRectangle())) continue;
            return true;
        }
        return false;
    }

    private boolean lineIntersectRectangle(Point pointA, Point pointB, Rectangle rect) {
        Line2D.Float line = new Line2D.Float(pointA.x, pointA.y, pointB.x, pointB.y);
        return line.intersects(rect);
    }

    private Collection<TimeDrawNode> getCommitTimeNode(Map<GraphNode, DrawNode> dataNodes) {
        ArrayList<TimeDrawNode> mapTime = new ArrayList<TimeDrawNode>();
        for (GraphNode node : dataNodes.keySet()) {
            TimeDrawNode tNode = new TimeDrawNode(node.getCommitTime(), 30, dataNodes.get(node).getY());
            mapTime.add(tNode);
        }
        return mapTime;
    }

    private List<DrawLabel> getBranchLabels(GraphNode[] nodes) throws VCSException {
        ArrayList<DrawLabel> labels = new ArrayList<DrawLabel>();
        ArrayList<GraphNode> tobelabel = new ArrayList<GraphNode>();
        for (GraphNode gNode : nodes) {
            tobelabel.add(gNode);
        }
        for (GraphNode gNode : nodes) {
            Collection<GraphNode> pNodes = gNode.getParents();
            pNodes.stream().forEach(e -> tobelabel.remove(e));
        }
        for (GraphNode lnode : tobelabel) {
            String label = this.getProvider().getBranchLabelFor(this._root, lnode);
            DrawNode dNode = this._drawNodes.get(lnode);
            if (dNode == null) continue;
            DrawLabel dlabel = new DrawLabel(label, dNode.getX(), dNode.getY());
            labels.add(dlabel);
        }
        return labels;
    }

    private ContextMenuListener getContextMenuListener() {
        if (this._menuListener == null) {
            this._menuListener = new GraphContextMenuListener(this.getProvider().getContextMenuListener());
        }
        return this._menuListener;
    }

    private boolean isOccupied(int x, int y, Map<GraphNode, DrawNode> nodes) {
        Collection<DrawNode> dnodes = nodes.values();
        boolean found = dnodes.stream().anyMatch(e -> e.contains(new Point(x, y)));
        return found;
    }

    private class GraphPanel
    extends JPanel
    implements Hoverable {
        private Stroke stroke = new BasicStroke(2.0f);
        private InfoTipHover _hover;
        private GraphMouseMotionListener _motionListener;
        private GraphMouseListener _mouseListener;
        private PopupManager _popupManager;

        GraphPanel() {
            this.setBackground(Color.white);
            this.addMouseMotionListener(this.getMouseMotionListener());
            HoverableRegistry.registerComponent((Component)this, (Hoverable)this);
            this.addMouseListener(this.getMouseListener());
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            SwingUtilities.convertPointFromScreen(p, VersionHistoryGraphEditor.this.getGUI());
            for (GraphNode gNode : VersionHistoryGraphEditor.this._drawNodes.keySet()) {
                DrawNode dNode = VersionHistoryGraphEditor.this._drawNodes.get(gNode);
                if (!dNode.contains(p)) continue;
                Rectangle r = new Rectangle(p.x + dNode.getWidth() / 2, p.y, 0, 0);
                this._hover = HistoryGraphHover.get(VersionHistoryGraphEditor.this.getProvider(), VersionHistoryGraphEditor.this._root, gNode, this, r, InfoTipStyles.DEFAULT);
                this._hover.setOrientation(InfoTipOrientation.RIGHT_LEFT);
                this._hover.showHover();
                return this._hover;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D gd = (Graphics2D)g;
            String value = "";
            gd.setStroke(this.stroke);
            Collection<DrawConnector> collection = VersionHistoryGraphEditor.this._drawConnector;
            synchronized (collection) {
                VersionHistoryGraphEditor.this._drawConnector.stream().forEach(e -> e.paint(gd));
            }
            for (GraphNode gNode : VersionHistoryGraphEditor.this._drawNodes.keySet()) {
                DrawNode drNode = VersionHistoryGraphEditor.this._drawNodes.get(gNode);
                drNode.paint(gd);
            }
            VersionHistoryGraphEditor.this._labels.stream().forEach(e -> e.paint(gd));
        }

        public void dispose() {
            this.removeMouseMotionListener(this.getMouseMotionListener());
            this.removeMouseListener(this.getMouseListener());
            HoverableRegistry.unregisterComponent((Component)this, (Hoverable)this);
        }

        void addPopupManager(PopupManager popupManager) {
            this._popupManager = popupManager;
        }

        private MouseMotionListener getMouseMotionListener() {
            if (this._motionListener == null) {
                this._motionListener = new GraphMouseMotionListener();
            }
            return this._motionListener;
        }

        private MouseListener getMouseListener() {
            if (this._mouseListener == null) {
                this._mouseListener = new GraphMouseListener();
            }
            return this._mouseListener;
        }

        private void highLight(Point point) {
            boolean repaint = false;
            String revId = null;
            for (GraphNode gNode : VersionHistoryGraphEditor.this._drawNodes.keySet()) {
                DrawNode dNode = VersionHistoryGraphEditor.this._drawNodes.get(gNode);
                if (!dNode.highLight(point)) continue;
                revId = dNode.getUserObject().getRevId();
                repaint = true;
            }
            if (repaint) {
                this.repaint();
            }
            if (revId != null) {
                final String rev = revId;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VersionHistoryGraphEditor.this.getProvider().getHighLightListener().highLighted(VersionHistoryGraphEditor.this._root, rev);
                    }
                });
            }
        }

        private boolean isHighLight() {
            for (GraphNode gNode : VersionHistoryGraphEditor.this._drawNodes.keySet()) {
                DrawNode dNode = VersionHistoryGraphEditor.this._drawNodes.get(gNode);
                if (!dNode.isHighLight()) continue;
                return true;
            }
            return false;
        }

        private void makeVisible(Point point) {
            Container parent = this.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof JViewport) {
                Point pt;
                JViewport viewport = (JViewport)parent;
                Rectangle rect = viewport.getViewRect();
                if (rect.contains(pt = viewport.toViewCoordinates(point))) {
                    return;
                }
                viewport.setViewPosition(new Point(rect.x, pt.y - rect.height / 2));
            }
        }

        private class GraphMouseMotionListener
        implements MouseMotionListener {
            private GraphMouseMotionListener() {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GraphPanel.this.highLight(e.getPoint());
            }
        }

        private class GraphMouseListener
        implements MouseListener {
            private GraphMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && GraphPanel.this.isHighLight() && GraphPanel.this._popupManager != null) {
                    GraphPanel.this._popupManager.showPopup(null, e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        }
    }

    private class GraphToolbar
    extends Toolbar {
        private SearchControl _fldSearch;
        private CalendarPopupButton _calendar;
        private JComboBox _cmbCommit;
        private JLabel _lblLabel;

        GraphToolbar() {
            this.initialize();
        }

        private void initialize() {
            this._lblLabel = new JLabel();
            this._cmbCommit = this.createCommitCombo(VersionHistoryGraphEditor.this.getProvider().getDateDuration(VersionHistoryGraphEditor.this._root));
            Dimension preferredSize = this._cmbCommit.getPreferredSize();
            this._cmbCommit.setMinimumSize(new Dimension(200, preferredSize.height));
            this._cmbCommit.setMaximumSize(new Dimension(200, preferredSize.height));
            this._fldSearch = new SearchControl();
            VersionHistoryGraphEditor.this.addUpdateListener(this._fldSearch);
            this.add((Component)this._fldSearch.getUI());
            this.addSeparator();
            this.add((Component)((Object)new RefreshToolButton(VersionHistoryGraphEditor.this.getLocalAction(51))));
            this.add(this._cmbCommit);
            this.add((Component)this.getCalendarPopup());
            this.addSeparator();
            this.add(this._lblLabel);
        }

        private String dateString(LocalDate lDate) {
            DateTimeFormatter format = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(GraphToolbar.getDefaultLocale());
            return lDate.format(format);
        }

        private CalendarPopupButton getCalendarPopup() {
            if (this._calendar == null) {
                this._calendar = new CalendarPopupButton();
                CalendarPanel panel = this._calendar.getCalendarPanel();
                LocalDate lDate = VersionHistoryGraphEditor.this.getProvider().getStartDate(VersionHistoryGraphEditor.this._root);
                panel.getModel().setSelectedDate(lDate);
                panel.getModel().setMaxDate(LocalDate.now());
                panel.getModel().setVisibleDate(lDate);
                this._calendar.getModel().addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 2) {
                            ZonedDateTime date = GraphToolbar.this._calendar.getCalendarPanel().getModel().getSelectedDate();
                            if (date == null) {
                                return;
                            }
                            VersionHistoryGraphEditor.this.getProvider().setStartDate(VersionHistoryGraphEditor.this._root, date.toLocalDate(), true);
                            CommitDateItem item = (CommitDateItem)GraphToolbar.this._cmbCommit.getItemAt(3);
                            item.setLabel(VCSArb.format("GRAPH_COMMIT_FROM", GraphToolbar.this.dateString(VersionHistoryGraphEditor.this.getProvider().getStartDate(VersionHistoryGraphEditor.this._root))));
                            item.setDate(date.toLocalDate());
                            GraphToolbar.this._cmbCommit.setSelectedItem(item);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GraphToolbar.this._cmbCommit.repaint();
                                }
                            });
                            VersionHistoryGraphEditor.this.refresh();
                        }
                    }
                });
            }
            return this._calendar;
        }

        public void updateLabel(String txt) {
            this._lblLabel.setText(txt);
        }

        private Collection<CommitDateItem> getDateItems() {
            LocalDate now = LocalDate.now();
            ArrayList<CommitDateItem> items = new ArrayList<CommitDateItem>();
            items.add(new CommitDateItem(VCSArb.get("GRAPH_COMMIT_FROM_30"), now.minusDays(30L)));
            items.add(new CommitDateItem(VCSArb.get("GRAPH_COMMIT_FROM_60"), now.minusDays(60L)));
            items.add(new CommitDateItem(VCSArb.get("GRAPH_COMMIT_FROM_90"), now.minusDays(90L)));
            items.add(new CommitDateItem(VCSArb.format("GRAPH_COMMIT_FROM", this.dateString(VersionHistoryGraphEditor.this.getProvider().getUserEnteredDate(VersionHistoryGraphEditor.this._root))), VersionHistoryGraphEditor.this.getProvider().getUserEnteredDate(VersionHistoryGraphEditor.this._root)));
            return items;
        }

        private JComboBox<CommitDateItem> createCommitCombo(int duration) {
            Collection<CommitDateItem> items = this.getDateItems();
            JComboBox<CommitDateItem> combo = new JComboBox<CommitDateItem>(items.toArray(new CommitDateItem[0]));
            CommitDateItem defItem = this.getDefaultItem(items, duration);
            combo.setSelectedItem(defItem);
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cmb = (JComboBox)e.getSource();
                    CommitDateItem item = (CommitDateItem)cmb.getSelectedItem();
                    VersionHistoryGraphEditor.this.getProvider().setStartDate(VersionHistoryGraphEditor.this._root, item._date, false);
                    VersionHistoryGraphEditor.this.refresh();
                }
            });
            return combo;
        }

        private CommitDateItem getDefaultItem(Collection<CommitDateItem> items, int duration) {
            for (CommitDateItem item : items) {
                int dDays = (int)ChronoUnit.DAYS.between(item._date, LocalDate.now());
                if (dDays != duration) continue;
                return item;
            }
            return items.toArray(new CommitDateItem[0])[items.size() - 1];
        }

        private class CommitDateItem {
            private String _label;
            private LocalDate _date;

            CommitDateItem(String label, LocalDate date) {
                this._label = label;
                this._date = date;
            }

            void setLabel(String label) {
                this._label = label;
            }

            void setDate(LocalDate ldate) {
                this._date = ldate;
            }

            public String toString() {
                return this._label;
            }
        }
    }

    private static class RefreshToolButton
    extends ToolButton {
        private RefreshToolButton(IdeAction ideAction) {
            super((Action)ideAction);
        }

        protected void configurePropertiesFromAction(Action a) {
            super.configurePropertiesFromAction(a);
            this.setToolTipText(VCSArb.get("GRAPH_BUTTON_TOOLTIP_REFRESH"));
        }
    }

    private class SearchControl
    implements GraphUpdateListener {
        private SearchField _fldSearch;
        private JCheckBoxMenuItem _author;
        private JCheckBoxMenuItem _description;
        private JCheckBoxMenuItem _commit;
        private int searchIndex = -1;
        private List<DrawNode> _searchIndexes = new ArrayList<DrawNode>();

        SearchControl() {
            this.initSearch();
        }

        private SearchField getUI() {
            return this._fldSearch;
        }

        private void clear() {
            this._searchIndexes.clear();
        }

        private void initSearch() {
            this._fldSearch = new SearchField();
            this._fldSearch.setPrompt(Bundle.get("HISTORY_GRAPH_PROMPT"));
            this._fldSearch.setStyle(SearchField.Style.FIND);
            this._fldSearch.addCategoryMenuItem(this.getAuthorMenu());
            this._fldSearch.addCategoryMenuItem(this.getDescMenu());
            this._fldSearch.addCategoryMenuItem(this.getCommitMenu());
            this._fldSearch.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    if (se.getDirection() == SearchEvent.Direction.FORWARD) {
                        SearchControl.this.forwardSearch();
                    } else {
                        SearchControl.this.backwardSearch();
                    }
                }

                public void searchCategoryChanged(SearchEvent se) {
                }
            });
            this._fldSearch.getTextField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SearchControl.this.locateAndUpdateSearch();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SearchControl.this.locateAndUpdateSearch();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            Dimension preferredSize = this._fldSearch.getPreferredSize();
            this._fldSearch.setMaximumSize(new Dimension(270, preferredSize.height));
            this._fldSearch.setMinimumSize(new Dimension(270, preferredSize.height));
            this._fldSearch.setPreferredSize(new Dimension(Math.max(preferredSize.width, 270), preferredSize.height));
        }

        private DrawNode getSelectedNode() {
            if (this.searchIndex > -1 && this.searchIndex < this._searchIndexes.size()) {
                return this._searchIndexes.get(this.searchIndex);
            }
            return null;
        }

        private void locateSearchItems(String text) {
            GraphNode[] nodes = VersionHistoryGraphEditor.this._drawNodes.keySet().toArray(new GraphNode[0]);
            this._searchIndexes.clear();
            if (!text.isEmpty()) {
                for (int ind = 0; ind < nodes.length; ++ind) {
                    if (!(this._author.isSelected() && nodes[ind].getAuthor().contains(text) || this._description.isSelected() && nodes[ind].getDescription().contains(text)) && (!this._commit.isSelected() || !nodes[ind].getRevId().startsWith(text))) continue;
                    this._searchIndexes.add(VersionHistoryGraphEditor.this._drawNodes.get(nodes[ind]));
                }
            }
            this.updateCountInfo(0, this._searchIndexes.size());
        }

        private void searchFromPosition() {
            int index;
            int n = index = this.searchIndex == -1 ? 0 : this.searchIndex;
            if (index > this._searchIndexes.size()) {
                index = 0;
            }
            this.updateSearch(index);
        }

        private void forwardSearch() {
            int index = this.searchIndex + 1;
            if (index >= this._searchIndexes.size()) {
                index = 0;
            }
            this.updateSearch(index);
        }

        private void backwardSearch() {
            int index = this.searchIndex - 1;
            if (index < 0) {
                index = this._searchIndexes.size() - 1;
            }
            this.updateSearch(index);
        }

        private void updateSearch(int index) {
            if (this._searchIndexes.isEmpty() || this._searchIndexes.get(index).isSelected()) {
                return;
            }
            this._searchIndexes.get(index).setSelected(true);
            if (this.searchIndex > -1 && this.searchIndex < this._searchIndexes.size()) {
                this._searchIndexes.get(this.searchIndex).setSelected(false);
            }
            this.updateCountInfo(index, this._searchIndexes.size());
            this.searchIndex = index;
            VersionHistoryGraphEditor.this._panel.makeVisible(this._searchIndexes.get(index).getCentre());
            VersionHistoryGraphEditor.this._panel.repaint();
        }

        private void clearSearch(DrawNode dNode) {
            dNode.setSelected(false);
            this.searchIndex = -1;
            VersionHistoryGraphEditor.this._panel.repaint();
        }

        private void updateCountInfo(int index, int count) {
            index = count > 0 ? index + 1 : index;
            this._fldSearch.setInfoText(Bundle.format("HISTORY_GRAPH_SEARCH_COUNT", index, count));
        }

        private JCheckBoxMenuItem createCheckBoxMenu(String label, boolean selected) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            item.setSelected(selected);
            ResourceUtils.resButton((AbstractButton)item, (String)label);
            return item;
        }

        private JMenuItem getAuthorMenu() {
            if (this._author == null) {
                this._author = this.createCheckBoxMenu(Bundle.get("HISTORY_GRAPH_AUTHOR"), true);
            }
            return this._author;
        }

        private JMenuItem getDescMenu() {
            if (this._description == null) {
                this._description = this.createCheckBoxMenu(Bundle.get("HISTORY_GRAPH_DESC"), false);
            }
            return this._description;
        }

        private JMenuItem getCommitMenu() {
            if (this._commit == null) {
                this._commit = this.createCheckBoxMenu(Bundle.get("HISTORY_GRAPH_COMMIT"), true);
            }
            return this._commit;
        }

        private void locateAndUpdateSearch() {
            DrawNode selected = this.getSelectedNode();
            this.locateSearchItems(this._fldSearch.getTextField().getText());
            if (this._searchIndexes.isEmpty() && selected != null) {
                this.clearSearch(selected);
            } else {
                this.searchFromPosition();
            }
        }

        @Override
        public void update() {
            this.locateSearchItems(this._fldSearch.getTextField().getText());
            if (this._searchIndexes.isEmpty()) {
                this.searchIndex = -1;
            } else if (this.searchIndex >= this._searchIndexes.size()) {
                this.searchIndex = this._searchIndexes.size() - 1;
            }
            if (this.searchIndex != -1) {
                this._searchIndexes.get(this.searchIndex).setSelected(true);
                this.updateCountInfo(this.searchIndex, this._searchIndexes.size());
            }
        }
    }
}

