/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.Category;

public class ChangeSetController
implements Controller {
    static final int MAX_QUERY_URLS = 10;

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        ChangeSetAdapter adapter = ChangeSetController.getContextChangeSetAdapter(context);
        if (adapter == null) {
            return false;
        }
        try {
            if (action.getCommandId() == ChangeSetChangeList.COMMIT_CHANGE_SET_COMMAND_ID) {
                action.setEnabled(ChangeSetController.getContextChangeSetName(context) != null);
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.EDIT_CHANGE_SET_COMMAND_ID) {
                action.setEnabled(ChangeSetController.getContextChangeSetName(context) != null);
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.MAKE_DEFAULT_CHANGE_SET_COMMAND_ID) {
                String name = ChangeSetController.getContextChangeSetName(context);
                action.setEnabled(name != null && !name.equals(adapter.getDefaultChangeSet()));
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.UNSET_DEFAULT_CHANGE_SET_COMMAND_ID) {
                String name = ChangeSetController.getContextChangeSetName(context);
                action.setEnabled(name != null && name.equals(adapter.getDefaultChangeSet()));
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.REMOVE_CHANGE_SET_COMMAND_ID) {
                action.setEnabled(ChangeSetController.getContextChangeSetName(context) != null);
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.REMOVE_FROM_CHANGE_SET_COMMAND_ID) {
                URL[] urls = ChangeSetController.getContextURLs(context);
                action.setEnabled(ChangeSetController.getContextChangeSetName(context) == null && urls.length > 0 && (urls.length > 10 || !adapter.getChangeSets(urls).isEmpty()));
                return true;
            }
            if (action.getCommandId() == ChangeSetChangeList.NEW_CHANGE_SET_COMMAND_ID) {
                action.setEnabled(ChangeSetController.getContextChangeSetName(context) == null && ChangeSetController.getContextURLs(context).length > 0);
                return true;
            }
        }
        catch (ChangeSetException cse) {
            FeedbackManager.reportException((Throwable)cse);
        }
        return false;
    }

    public static final ChangeSetAdapter getContextChangeSetAdapter(Context context) {
        ChangeList changeList;
        if (context.getView() instanceof ChangeListWindow && (changeList = ((ChangeListWindow)context.getView()).getContextChangeList()) instanceof ChangeSetChangeList) {
            return ((ChangeSetChangeList)changeList).getChangeSetAdapter();
        }
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(context);
        if (extension == null) {
            return null;
        }
        for (String id : ChangeSetRegistry.keySet()) {
            if (!extension.getId().equals(id)) continue;
            return ChangeSetRegistry.lookup(id);
        }
        return null;
    }

    public static final URL[] getContextURLs(Context context) {
        return ChangeSetController.removeDirectoryPathURLs(ChangeSetController._getContextURLs(context));
    }

    private static final URL[] _getContextURLs(Context context) {
        if (context.getElement() instanceof Category) {
            String name = ((Category)context.getElement()).getName();
            if (name == null) {
                return new URL[0];
            }
            if (!(context.getView() instanceof ChangeListWindow)) {
                return new URL[0];
            }
            ChangeListWindow window = (ChangeListWindow)context.getView();
            if (!(window.getContextChangeList() instanceof ChangeSetChangeList)) {
                return new URL[0];
            }
            return ((ChangeSetChangeList)window.getContextChangeList()).getChangeSetURLs(name);
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables(context);
        return VCSModelUtils.convertNodesToURLs(locatables);
    }

    public static final String getContextChangeSetName(Context context) {
        return context.getSelection().length == 1 && context.getElement() instanceof Category ? ((Category)context.getElement()).getName() : null;
    }

    private static final URL[] removeDirectoryPathURLs(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            if (!URLFileSystem.isDirectoryPath((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        return urls0.toArray(new URL[urls0.size()]);
    }
}

