/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist.cmd;

import java.awt.datatransfer.StringSelection;
import java.net.URL;
import oracle.ide.IdeClipboard;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;

public class CopyFileListCommand
extends Command {
    public CopyFileListCommand() {
        super(ChangeListWindow.COPY_FILE_LIST_CMD_ID, 1);
    }

    public CopyFileListCommand(int commandId) {
        super(commandId, 1);
    }

    public int doit() {
        Element[] allItems = this.getContextElements();
        StringBuilder copyBuffer = new StringBuilder();
        for (int i = 0; i < allItems.length; ++i) {
            URL url;
            Element thisElement = allItems[i];
            if (!(thisElement instanceof Locatable) || (url = ((Locatable)thisElement).getURL()) == null) continue;
            copyBuffer.append(URLFileSystem.getPlatformPathName((URL)url));
            copyBuffer.append("\n");
        }
        StringSelection ssel = new StringSelection(copyBuffer.toString());
        ClipboardStack.pushCurrentClipboard();
        IdeClipboard.getClipboard().setContents(ssel, ssel);
        return 0;
    }

    protected Element[] getContextElements() {
        ChangeListWindow changeListWindow = (ChangeListWindow)this.getContext().getView();
        Element[] allItems = changeListWindow.getContextChangeList().getElements();
        return allItems;
    }
}

