/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;
import oracle.ide.ExtensionRegistry;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.jdeveloper.vcs.annotations.AnnotationMark;
import oracle.jdeveloper.vcs.annotations.VCSAnnotationExtention;
import oracle.jdeveloper.vcs.spi.VCSExtendHover;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingHook;

final class AnnotationHover
extends InfoTipHover {
    static AnnotationHover get(final AnnotationMark mark, JComponent parent, Rectangle r, final InfoTipStyles style) {
        Collection<String> bugs;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = style.getBorderInsets();
        panel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        panel.setOpaque(false);
        String revision = mark.getRevisionLabel();
        CopyableLabel revisionField = new CopyableLabel(revision);
        revisionField.setBorder(BorderFactory.createEmptyBorder());
        revisionField.setOpaque(false);
        revisionField.setEditable(false);
        revisionField.setFont(style.getItemTitleFont());
        Component comp = AnnotationHover.compareButtons(revisionField, mark);
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        panel.add(comp, gbc);
        String date = mark.getDate();
        if (date != null) {
            CopyableLabel dateField = new CopyableLabel(date);
            dateField.setBorder(BorderFactory.createEmptyBorder());
            dateField.setForeground(style.getContentTextColor());
            gbc.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)dateField, gbc);
        }
        CopyableLabel authorField = new CopyableLabel(mark.getAuthor());
        authorField.setBorder(BorderFactory.createEmptyBorder());
        authorField.setForeground(style.getContentTextColor());
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)authorField, gbc);
        String comment = mark.getComment();
        int preferredWidth = Math.max(200, revisionField.getPreferredSize().width);
        if (comment != null && !comment.isEmpty()) {
            JTextArea text = new JTextArea(comment.trim());
            text.setBackground(Color.WHITE);
            text.setEditable(false);
            text.setColumns(50);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setRows(10);
            text.setForeground(style.getContentTextColor());
            JScrollPane pane = new JScrollPane(text);
            pane.setBorder(BorderFactory.createLineBorder(style.getInternalBorderColor()));
            pane.setHorizontalScrollBarPolicy(31);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(3, 0, 0, 0);
            panel.add((Component)pane, gbc);
            preferredWidth = Math.max(preferredWidth, pane.getPreferredSize().width);
        }
        if ((bugs = mark.getBugNumbers()).size() > 0) {
            VCSExtendHover.addExtendedProperties(style, panel, mark.getLink().getLabel(), gbc, preferredWidth, mark.getLink().isEnabled(), bugs, new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (mark.getLink().isEnabled()) {
                        e.getComponent().setForeground(style.getHyperLinkTextColor(true));
                        e.getComponent().setEnabled(true);
                    } else {
                        e.getComponent().setEnabled(false);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (mark.getLink().isEnabled()) {
                        e.getComponent().setForeground(style.getHyperLinkTextColor(false));
                    }
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof AbstractButton) {
                        mark.getLink().openLink(mark.getURL(), ((AbstractButton)obj).getText());
                    }
                }
            });
        } else {
            int pW = preferredWidth;
            for (final VCSAnnotationExtention annotate : AnnotationHover.getAnnotations()) {
                Collection<String> issues = annotate.getIssues(mark.getComment());
                issues.stream().filter(e -> !e.isEmpty()).forEach(e -> VCSExtendHover.addExtendedProperties(style, panel, annotate.getLabel(), gbc, pW, annotate.isEnabled(), issues, new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (annotate.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(true));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (annotate.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(false));
                        }
                    }
                }, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object obj = e.getSource();
                        if (obj instanceof AbstractButton) {
                            annotate.openIssue(mark.getURL(), ((AbstractButton)obj).getText());
                        }
                    }
                }));
            }
        }
        return new AnnotationHover((Template)new BasicTemplate((JComponent)panel), InfoTipStyles.DEFAULT, parent, r);
    }

    private AnnotationHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location) {
        super(template, style, parent, location, HoverFlavor.getFlavor((String)"info"));
    }

    public boolean shouldHideHover(KeyEvent event) {
        return false;
    }

    private static Collection<VCSAnnotationExtention> getAnnotations() {
        VCSBugTrackingHook hook = (VCSBugTrackingHook)ExtensionRegistry.getExtensionRegistry().getHook(VCSBugTrackingHook.HOOK);
        return hook.getAnnotations();
    }

    private static Component compareButtons(CopyableLabel revisionField, AnnotationMark mark) {
        Collection<Action> compareAction = mark.getCompareActions();
        if (compareAction.isEmpty()) {
            return revisionField;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)revisionField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        int col = 0;
        for (Action action : compareAction) {
            action.putValue("Revision", revisionField.getText());
            HyperlinkButton button = new HyperlinkButton(action);
            button.setOpaque(false);
            panel.add((Component)button, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        return panel;
    }

    private static final class CopyableLabel
    extends JTextField {
        public CopyableLabel(String text) {
            super(text);
            this.setOpaque(false);
            this.setEditable(false);
            this.setCaret(new DefaultCaret(){

                @Override
                public void paint(Graphics g) {
                }
            });
        }
    }
}

