/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JavaProvider2;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.classfile.ClClass;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.ModuleClass;
import oracle.javatools.parser.java.v2.common.AbstractPackage;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFileSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.provider.ProviderConstants;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.util.ClassFileCache;

public abstract class BaseFileProvider
implements JavaFileProvider,
ProviderConstants,
JavaProvider2 {
    private final boolean NO_LIGHT_SOURCE_FILES;
    private JdkVersion jdkVersion;
    protected ProviderContext context;

    public abstract JavaClassLocator getClassLocator();

    public JavaClassLocator getClassLocatorInterruptibly() throws InterruptedException {
        return this.getClassLocator();
    }

    protected BaseFileProvider(ProviderContext context) {
        boolean bl = this.NO_LIGHT_SOURCE_FILES = System.getProperty("NO_LIGHT_SOURCE_FILES") != null;
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
        this.context.setProvider(this);
    }

    public ProviderContext getContext() {
        return this.context;
    }

    public void notifyOfChange(URL url) {
    }

    protected final int getFileType(URL url) {
        return this.context.getFileType(url);
    }

    @Override
    public JavaFile getFile(URL url) {
        int fileType = this.getFileType(url);
        switch (fileType) {
            case 2: {
                JavaFile javaFile;
                if (!this.NO_LIGHT_SOURCE_FILES && (javaFile = this.getLightSourceFileImpl(url)) != null) {
                    return javaFile;
                }
                return this.getSourceFileImpl(url);
            }
            case 1: {
                return this.getClassFileImpl(url);
            }
        }
        return null;
    }

    public TextBuffer getTextBuffer(URL url) {
        try {
            return this.context.getTextBuffer(url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public SourceFile getSourceFile(URL sourceURL) {
        try {
            return this.getSourceFileImpl(sourceURL);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public SourceFile getSourceFile(TextBuffer textBuffer) {
        return this.context.getSourceFile(textBuffer, this.getJdkVersion());
    }

    protected JavaFile getClassFileImpl(URL classURL) {
        ClassFile classFile = ClassFileCache.getClassFile(classURL);
        if (classFile != null) {
            if (classFile.isModule()) {
                ModuleBaseClass moduleClass = new ModuleBaseClass(classFile, this);
                ClFile javaFile = new ClFile((ModuleClass)moduleClass, classURL);
                moduleClass._javaFile = javaFile;
                return javaFile;
            }
            BaseClass javaClass = new BaseClass(classFile, this);
            ClFile javaFile = new ClFile((ClClass)javaClass, classURL);
            javaClass._javaFile = javaFile;
            return javaFile;
        }
        return null;
    }

    protected JavaFile getJavaFile(JavaClass javaClass) {
        if (javaClass instanceof SourceClass) {
            return ((SourceClass)javaClass).getOwningSourceFile();
        }
        if (javaClass instanceof BaseClass) {
            return ((BaseClass)javaClass)._javaFile;
        }
        return null;
    }

    protected SourceFile getSourceFileImpl(URL sourceURL) throws IllegalArgumentException {
        return this.context.getSourceFile(sourceURL, this.getJdkVersion());
    }

    protected JavaFile getLightSourceFileImpl(URL sourceURL) {
        JavaFile javaFile = this.context.getLightSourceFile(sourceURL, this.getJdkVersion());
        if (javaFile instanceof JavaFileSym) {
            JavaClass primaryClass = javaFile.getPrimaryClass();
            if (primaryClass == null || primaryClass.getRawName() == null) {
                return null;
            }
            LightSourceFileProvider lightProvider = new LightSourceFileProvider(this, sourceURL);
            lightProvider.javaFile = javaFile = new JavaFileSym((JavaFileSym)javaFile, (JavaProvider)lightProvider);
        }
        return javaFile;
    }

    @Override
    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        return this.context.createSourceFile(sourceURL, this.getJdkVersion());
    }

    public JavaClass getClass(String fqName) {
        try {
            return this.getClassImpl(fqName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public JavaClass getClassInterruptibly(String fqName) throws InterruptedException {
        return this.getClassImpl(fqName, true);
    }

    protected JavaClass getClassImpl(String fqName, boolean interruptibly) throws InterruptedException {
        JavaClass primitiveClass;
        int firstBrackets;
        if (interruptibly) {
            this.checkInterrupt();
        }
        if (fqName == null || fqName.startsWith(".")) {
            return null;
        }
        int firstAngle = fqName.indexOf(60);
        if (firstAngle != -1) {
            SourceFactory factory;
            SourceTypeReference type;
            TextBuffer tmpBuffer = TextBufferFactory.createArrayTextBuffer();
            SourceFile tmpFile = this.getSourceFile(tmpBuffer);
            if (interruptibly) {
                this.checkInterrupt();
            }
            if ((type = (factory = tmpFile.getFactory()).createTypeFromText(fqName)) == null) {
                return null;
            }
            CallerContext context = CallerContext.createContext((SourceElement)tmpFile, (boolean)true);
            type.setContext(context);
            JavaType result = type.getResolvedType();
            if (result instanceof JavaClass) {
                return (JavaClass)result;
            }
            return null;
        }
        if (interruptibly) {
            this.checkInterrupt();
        }
        if ((firstBrackets = fqName.indexOf(91)) != -1) {
            JavaClass foundClass;
            int dimensions = (fqName.length() - firstBrackets) / 2;
            String nonArrayName = fqName.substring(0, firstBrackets).trim();
            JavaClass javaClass = foundClass = interruptibly ? this.getClassInterruptibly(nonArrayName) : this.getClass(nonArrayName);
            if (foundClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)foundClass, dimensions);
        }
        if (interruptibly) {
            this.checkInterrupt();
        }
        if ((primitiveClass = this.getPrimitiveClass(fqName)) != null) {
            return primitiveClass;
        }
        return interruptibly ? this.getClassLeftToRightInterruptibly(fqName) : this.getClassLeftToRight(fqName);
    }

    protected JavaClass getClassLeftToRight(String fqName) {
        try {
            return this.getClassLeftToRightImpl(fqName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected JavaClass getClassLeftToRightInterruptibly(String fqName) throws InterruptedException {
        return this.getClassLeftToRightImpl(fqName, true);
    }

    protected JavaClass getClassLeftToRightImpl(String fqName, boolean interruptibly) throws InterruptedException {
        String prefix = "";
        String suffix = fqName;
        while (suffix.length() > 0) {
            JavaClass searchClass;
            JavaClass foundClass;
            int firstDot;
            if (interruptibly) {
                this.checkInterrupt();
            }
            String className = (firstDot = suffix.indexOf(46)) != -1 ? suffix.substring(0, firstDot) : suffix;
            String fqOuterClassName = BaseClassLocator.buildFQName(prefix, className);
            JavaClass javaClass = foundClass = interruptibly ? this.getClassExactImplInterruptibly(fqOuterClassName) : this.getClassExactImpl(fqOuterClassName);
            if (foundClass != null && (searchClass = this.locateClass(foundClass, fqName)) != null) {
                return searchClass;
            }
            int prefixLength = prefix.length();
            int classLength = className.length();
            prefix = prefixLength > 0 ? fqName.substring(0, prefixLength + classLength + 1) : className;
            suffix = firstDot != -1 ? suffix.substring(firstDot + 1) : "";
        }
        return null;
    }

    protected JavaClass getClassExactImpl(String fqOuterClassName) {
        try {
            return this.getClassExactImplImpl(fqOuterClassName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected JavaClass getClassExactImplInterruptibly(String fqOuterClassName) throws InterruptedException {
        return this.getClassExactImplImpl(fqOuterClassName, true);
    }

    private JavaClass getClassExactImplImpl(String fqOuterClassName, boolean interruptibly) throws InterruptedException {
        JavaFile javaFile;
        if (interruptibly) {
            this.checkInterrupt();
        }
        if (fqOuterClassName.length() == 0) {
            return null;
        }
        URL url = null;
        if (interruptibly) {
            locator = this.getClassLocatorInterruptibly();
            if (locator instanceof JavaClassLocator2) {
                url = ((JavaClassLocator2)locator).getURLInterruptibly(fqOuterClassName);
            } else if (locator != null) {
                url = locator.getURL(fqOuterClassName);
            }
        } else {
            locator = this.getClassLocator();
            if (locator != null) {
                url = locator.getURL(fqOuterClassName);
            }
        }
        if (url != null && (javaFile = this.getFile(url)) != null) {
            return this.locateClass(javaFile, fqOuterClassName);
        }
        return null;
    }

    protected void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public JavaClass getClass(String fqPrefix, String name) {
        try {
            return this.getClassImpl(fqPrefix, name, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public JavaClass getClassInterruptibly(String fqPrefix, String name) throws InterruptedException {
        return this.getClassImpl(fqPrefix, name, true);
    }

    protected JavaClass getClassImpl(String fqPrefix, String name, boolean interruptibly) throws InterruptedException {
        String concatName = BaseClassLocator.buildFQName(fqPrefix, name);
        return interruptibly ? this.getClassInterruptibly(concatName) : this.getClass(concatName);
    }

    public JavaClass getClassByVMName(String fqVMName) {
        try {
            return this.getClassByVMNameImpl(fqVMName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public JavaClass getClassByVMNameInterruptibly(String fqVMName) throws InterruptedException {
        return this.getClassByVMNameImpl(fqVMName, true);
    }

    protected JavaClass getClassByVMNameImpl(String fqVMName, boolean interruptibly) throws InterruptedException {
        int firstBrackets;
        if (interruptibly) {
            this.checkInterrupt();
        }
        if ((firstBrackets = fqVMName.indexOf(91)) != -1) {
            JavaClass foundClass;
            int dimensions = (fqVMName.length() - firstBrackets) / 2;
            String nonArrayName = fqVMName.substring(0, firstBrackets).trim();
            JavaClass javaClass = foundClass = interruptibly ? this.getClassByVMNameInterruptibly(nonArrayName) : this.getClassByVMName(nonArrayName);
            if (foundClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)foundClass, dimensions);
        }
        JavaClass primitiveClass = this.getPrimitiveClass(fqVMName);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int lastSlash = fqVMName.lastIndexOf(47);
        String packagePrefix = lastSlash == -1 ? "" : fqVMName.substring(0, lastSlash);
        packagePrefix = packagePrefix.replace('/', '.');
        String className = lastSlash == -1 ? fqVMName : fqVMName.substring(lastSlash + 1);
        String checkName = "";
        int nextStartPos = 0;
        while (checkName.length() < className.length()) {
            JavaClass searchClass;
            int firstDollar = className.indexOf(36, nextStartPos);
            if (firstDollar == -1) {
                checkName = className;
            } else {
                checkName = className.substring(0, firstDollar);
                nextStartPos = firstDollar + 1;
            }
            String fqOuterClassName = BaseClassLocator.buildFQName(packagePrefix, checkName);
            JavaClass foundClass = interruptibly ? this.getClassExactImplInterruptibly(fqOuterClassName) : this.getClassExactImpl(fqOuterClassName);
            if (foundClass == null || (searchClass = this.locateClassByVMName(foundClass, fqVMName)) == null) continue;
            return searchClass;
        }
        return null;
    }

    protected JavaClass getInnerClassByVMName(String fqVMName) {
        JavaClass javaClass;
        JavaFile javaFile;
        String className = fqVMName.replace('/', '.');
        URL classURL = null;
        JavaClassLocator locator = this.getClassLocator();
        if (locator != null) {
            classURL = locator.getClassURL(className);
        }
        if (classURL != null && (javaFile = this.getFile(classURL)) != null && fqVMName.equals((javaClass = javaFile.getPrimaryClass()).getVMName())) {
            return javaClass;
        }
        return null;
    }

    protected JavaClass locateClass(JavaFile javaFile, String fqName) {
        Collection classes = javaFile.getClasses();
        if (classes != null) {
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                JavaClass javaClass = this.locateClass((JavaClass)iter.next(), fqName);
                if (javaClass == null) continue;
                return javaClass;
            }
        }
        return null;
    }

    protected JavaClass locateClass(JavaClass javaClass, String fqName) {
        if (javaClass == null) {
            return null;
        }
        String javaClassName = javaClass.getRawName();
        if (!fqName.startsWith(javaClassName)) {
            return null;
        }
        if (fqName.length() == javaClassName.length()) {
            return javaClass;
        }
        if (fqName.charAt(javaClassName.length()) != '.') {
            return null;
        }
        Collection innerClasses = javaClass.getDeclaredClasses();
        for (JavaClass innerClass : innerClasses) {
            JavaClass foundClass;
            if (innerClass == null || (foundClass = this.locateClass(innerClass, fqName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    protected JavaClass locateClassByVMName(JavaClass javaClass, String fqVMName) {
        String rawJavaClassName = javaClass.getVMName();
        if (!fqVMName.startsWith(rawJavaClassName)) {
            return null;
        }
        if (fqVMName.length() == rawJavaClassName.length()) {
            return javaClass;
        }
        if (fqVMName.charAt(rawJavaClassName.length()) != '$') {
            return null;
        }
        Collection innerClasses = javaClass.getDeclaredClasses();
        for (JavaClass innerClass : innerClasses) {
            JavaClass foundClass;
            if (innerClass == null || (foundClass = this.locateClassByVMName(innerClass, fqVMName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    public SourceClass getSourceClass(String fqName) {
        try {
            return this.getSourceClassImpl(fqName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public SourceClass getSourceClassInterruptibly(String fqName) throws InterruptedException {
        return this.getSourceClassImpl(fqName, true);
    }

    protected SourceClass getSourceClassImpl(String fqName, boolean interruptibly) throws InterruptedException {
        JavaClass javaClass;
        if (interruptibly) {
            this.checkInterrupt();
        }
        if (fqName.startsWith(".")) {
            return null;
        }
        JavaClass javaClass2 = javaClass = interruptibly ? this.getClassInterruptibly(fqName) : this.getClass(fqName);
        if (javaClass != null) {
            return javaClass.getSourceElement();
        }
        return null;
    }

    protected SourceClass getSourceClassByHint(JavaClass searchClass, String sourceFileHint) {
        SourceFile sourceFile;
        String hintToUse;
        String packagePrefix = searchClass.getPackageName();
        if (sourceFileHint != null) {
            int lastDot = sourceFileHint.lastIndexOf(46);
            hintToUse = lastDot != -1 ? sourceFileHint.substring(0, lastDot) : sourceFileHint;
        } else {
            String fqName = searchClass.getRawName();
            int packageLength = packagePrefix != null ? packagePrefix.length() : 0;
            String classNameToUse = packageLength > 0 ? fqName.substring(packageLength + 1) : fqName;
            int firstDot = classNameToUse.indexOf(46);
            hintToUse = firstDot == -1 ? classNameToUse : classNameToUse.substring(0, firstDot);
        }
        String fullName = BaseClassLocator.buildFQName(packagePrefix, hintToUse);
        URL sourceURL = null;
        JavaClassLocator locator = this.getClassLocator();
        if (locator != null) {
            sourceURL = locator.getSourceURL(fullName);
        }
        if (sourceURL != null && (sourceFile = this.getSourceFile(sourceURL)) != null) {
            String searchClassName = searchClass.getRawName();
            return this.locateSourceClass(sourceFile, searchClassName);
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceFile sourceFile, String fqName) {
        Collection classes = sourceFile.getClasses();
        for (SourceClass sourceClass : classes) {
            SourceClass foundClass;
            if (sourceClass == null || (foundClass = this.locateSourceClass(sourceClass, fqName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceClass sourceClass, String fqName) {
        JavaClass foundClass = this.locateClass((JavaClass)sourceClass, fqName);
        if (foundClass == null) {
            return null;
        }
        if (foundClass instanceof SourceClass) {
            return (SourceClass)foundClass;
        }
        throw new IllegalStateException("Not a SourceClass");
    }

    protected JavaClass getPrimitiveClass(String name) {
        PrimitiveType primitive = CommonUtilities.getPrimitiveType((String)name);
        return primitive;
    }

    public JavaType getArrayType(JavaType component, int dimensions) {
        if (component == null) {
            return null;
        }
        if (dimensions == 0) {
            return component;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        Object key = component.getUniqueIdentifier();
        for (int i = dimensions; i > 0; --i) {
            key = (String)key + "[]";
        }
        return this.getArrayTypeImpl((String)key, component, dimensions);
    }

    protected JavaType getArrayTypeImpl(String typeKey, JavaType component, int dimensions) {
        return CommonUtilities.createArrayType((JavaProvider)this, (JavaType)component, (int)dimensions);
    }

    public JavaPackage getPackage(String fqName) {
        if (fqName.startsWith(".")) {
            return null;
        }
        return this.getPackageImpl(fqName);
    }

    protected BasePackage getPackageImpl(String fqName) {
        return fqName != null ? new BasePackage(fqName) : null;
    }

    protected JavaPackage getPackage(String packagePrefix, String name) {
        String fqName = BaseClassLocator.buildFQName(packagePrefix, name);
        return this.getPackage(fqName);
    }

    public JdkVersion getJdkVersion() {
        if (this.jdkVersion != null) {
            return this.jdkVersion;
        }
        this.jdkVersion = JdkVersion.getLoaderJdkVersion((version, typeName) -> {
            this.jdkVersion = version;
            return this.getClass(typeName) != null;
        });
        return this.jdkVersion;
    }

    public synchronized void setJdkVersion(JdkVersion jdkVersion) {
        this.jdkVersion = jdkVersion;
    }

    protected final class ModuleBaseClass
    extends ModuleClass {
        protected JavaFile _javaFile;

        protected ModuleBaseClass(ClassFile classFile, BaseFileProvider provider) {
            super(classFile, (JavaProvider)provider);
        }
    }

    protected final class BaseClass
    extends ClClass {
        protected JavaFile _javaFile;

        protected BaseClass(ClassFile classFile, BaseFileProvider provider) {
            super(classFile, (JavaProvider)provider);
        }

        protected JavaClass getInnerClassByVMName(String fqInnerVMName) {
            return BaseFileProvider.this.getInnerClassByVMName(fqInnerVMName);
        }

        protected SourceClass getSourceClass(String sourceFileNameHint) {
            return BaseFileProvider.this.getSourceClassByHint((JavaClass)this, sourceFileNameHint);
        }
    }

    private class LightSourceFileProvider
    implements JavaProvider2 {
        private JavaProvider2 provider;
        private URL url;
        private JavaFile javaFile;

        LightSourceFileProvider(JavaProvider2 provider, URL url) {
            this.provider = provider;
            this.url = url;
        }

        public JavaClass getClass(String fqName) {
            return this.provider.getClass(fqName);
        }

        public JavaClass getClass(String fqPrefix, String name) {
            return this.provider.getClass(fqPrefix, name);
        }

        public JavaClass getClassByVMName(String fqVmName) {
            return this.provider.getClassByVMName(fqVmName);
        }

        public JavaType getArrayType(JavaType componentType, int dimensions) {
            return this.provider.getArrayType(componentType, dimensions);
        }

        public SourceClass getSourceClass(String fqName) {
            return this.getSourceClassImpl(fqName);
        }

        private SourceClass getSourceClassImpl(String fqName) {
            SourceFile sourceFile = BaseFileProvider.this.getSourceFile(this.url);
            if (sourceFile != null) {
                return BaseFileProvider.this.locateSourceClass(sourceFile, fqName);
            }
            return null;
        }

        public JavaPackage getPackage(String fqPrefix) {
            return this.provider.getPackage(fqPrefix);
        }

        public TextBuffer getTextBuffer(URL url) {
            return this.provider.getTextBuffer(url);
        }

        public JavaClass getClassInterruptibly(String fqName) throws InterruptedException {
            return this.provider.getClassInterruptibly(fqName);
        }

        public JavaClass getClassInterruptibly(String fqPrefix, String name) throws InterruptedException {
            return this.provider.getClassInterruptibly(fqPrefix, name);
        }

        public JavaClass getClassByVMNameInterruptibly(String fqVmName) throws InterruptedException {
            return this.provider.getClassByVMNameInterruptibly(fqVmName);
        }

        public SourceClass getSourceClassInterruptibly(String fqName) throws InterruptedException {
            return this.getSourceClassImpl(fqName);
        }
    }

    protected class BasePackage
    extends AbstractPackage {
        protected String _packageName;
        protected Collection<JavaClass> _classes;
        protected Collection<JavaPackage> _packages;

        protected BasePackage(String name) {
            this._packageName = name;
        }

        public String getQualifiedName() {
            return this._packageName;
        }

        protected synchronized void clear() {
            this._classes = null;
            this._packages = null;
        }

        public Collection<JavaAnnotation> getDeclaredAnnotations() {
            JavaClass c;
            String qualifiedName = this.getQualifiedName();
            if (qualifiedName.length() == 0) {
                return Collections.emptyList();
            }
            String packageInfo = qualifiedName + ".package-info";
            URL url = null;
            JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
            if (locator != null) {
                url = locator.getURL(packageInfo);
            }
            if (url != null) {
                Collection classes;
                JavaFile javaFile = BaseFileProvider.this.getFile(url);
                if (javaFile instanceof SourceFile) {
                    SourceFile file = (SourceFile)javaFile;
                    SourcePackage p = file.getSourcePackage();
                    if (p != null) {
                        return new ArrayList<JavaAnnotation>(p.getSourceAnnotations());
                    }
                } else if (javaFile != null && !(classes = javaFile.getClasses()).isEmpty()) {
                    JavaClass c2 = (JavaClass)classes.iterator().next();
                    return c2.getDeclaredAnnotations();
                }
            }
            if ((c = BaseFileProvider.this.getClass(packageInfo)) != null) {
                return c.getDeclaredAnnotations();
            }
            return Collections.emptyList();
        }

        public synchronized Collection<JavaClass> getDeclaredClasses() {
            if (this._classes == null) {
                Collection<String> classNames = null;
                JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
                if (locator != null) {
                    classNames = locator.getClassesInPackage(this._packageName);
                }
                this._classes = new ArrayList<JavaClass>();
                if (classNames != null) {
                    Iterator<String> nameIterator = classNames.iterator();
                    while (nameIterator.hasNext()) {
                        String className = nameIterator.next().toString();
                        JavaClass javaClass = BaseFileProvider.this.getClass(this._packageName, className);
                        if (javaClass == null) continue;
                        this._classes.add(javaClass);
                    }
                }
                if (this._classes.size() == 0) {
                    this._classes = Collections.emptyList();
                }
            }
            return this._classes;
        }

        public JavaPackage getOwningPackage() {
            if (this._packageName.length() == 0) {
                return null;
            }
            int lastDot = this._packageName.lastIndexOf(46);
            String target = lastDot == -1 ? "" : this._packageName.substring(0, lastDot);
            return BaseFileProvider.this.getPackage(target);
        }

        public JavaPackage getPackage(String name) {
            return BaseFileProvider.this.getPackage(this._packageName, name);
        }

        public synchronized Collection<JavaPackage> getPackages() {
            if (this._packages == null) {
                Collection<String> subNames = null;
                JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
                if (locator != null) {
                    subNames = locator.getPackages(this._packageName);
                }
                this._packages = new ArrayList<JavaPackage>();
                if (subNames != null) {
                    for (String subName : subNames) {
                        JavaPackage javaPackage = BaseFileProvider.this.getPackage(this._packageName, subName);
                        if (javaPackage == null) continue;
                        this._packages.add(javaPackage);
                    }
                }
                if (this._packages.size() == 0) {
                    this._packages = Collections.emptyList();
                }
            }
            return this._packages;
        }

        public boolean exists() {
            if ("".equals(this._packageName)) {
                return true;
            }
            return this.getOwningPackage().getPackages().contains((Object)this);
        }
    }
}

