/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.java.locator.ModularizedJdkBaseLocator;
import oracle.jdeveloper.java.locator.PackageEntry;

class ModularizedPackageEntry
extends PackageEntry {
    private Map<String, ModularizedJdkBaseLocator.ClassDetails> classNamesToDetails;

    ModularizedPackageEntry(String packageName, Map<String, ModularizedJdkBaseLocator.ClassDetails> classNamesToDetails, Collection<String> subPackageNames) {
        super(packageName, null, subPackageNames);
        String[] classes = null;
        if (classNamesToDetails != null) {
            classes = classNamesToDetails.keySet().toArray(new String[classNamesToDetails.size()]);
            this.classNamesToDetails = classNamesToDetails;
        }
        this.setClasses(classes, true);
    }

    String getModuleIndexForClass(String className) {
        if (!this.containsClass(className)) {
            return null;
        }
        return this.classNamesToDetails == null ? null : this.classNamesToDetails.get((Object)className).moduleIndex;
    }

    long getLengthForClass(String className) {
        if (!this.containsClass(className)) {
            return -1L;
        }
        return this.classNamesToDetails == null ? -1L : this.classNamesToDetails.get((Object)className).length;
    }
}

