/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeIcons;
import oracle.jdeveloper.java.locator.ModularizedJdkBaseLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkJmodLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkJrtfsLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkSourceLocator;

public class ModularizedJdkURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String MODULE_JDK_PROTOCOL = "mjdk";
    private static final String FILE_URL_PATH_SEPARATOR = "!/";

    static URL createDirURL(String filePath, LocatorType locatorType, String dirName) {
        if (filePath == null || filePath.isEmpty()) {
            assert (false) : "filePath can't be null or empty";
            return null;
        }
        if (locatorType == null || locatorType == LocatorType.UNKNOWN_LOCATOR) {
            assert (false) : "Need valid locatorType";
            return null;
        }
        if (dirName == null) {
            assert (false) : "dirName can't be null";
            return null;
        }
        if (((String)dirName).length() > 0 && !((String)(dirName = ((String)dirName).replace('.', '/'))).endsWith("/")) {
            dirName = (String)dirName + "/";
        }
        try {
            URL url = URLFactory.newURL((String)MODULE_JDK_PROTOCOL, (String)(filePath + FILE_URL_PATH_SEPARATOR + locatorType.type + FILE_URL_PATH_SEPARATOR + (String)dirName));
            return url;
        }
        catch (Exception ex) {
            if (ex.getClass().getName().endsWith("MalformedURLException")) {
                return null;
            }
            assert (false) : "Exception creating directory URL";
            return null;
        }
    }

    static URL createClassURL(String filePath, LocatorType locatorType, String module, String className) {
        if (filePath == null || filePath.isEmpty()) {
            assert (false) : "filePath can't be null or empty";
            return null;
        }
        if (locatorType == null || locatorType == LocatorType.UNKNOWN_LOCATOR) {
            assert (false) : "Need valid locatorType";
            return null;
        }
        if (className == null || className.isEmpty()) {
            assert (false) : "className can't be null or empty";
            return null;
        }
        try {
            URL url = URLFactory.newURL((String)MODULE_JDK_PROTOCOL, (String)(filePath + FILE_URL_PATH_SEPARATOR + locatorType.type + FILE_URL_PATH_SEPARATOR + (String)(module == null ? "" : module + FILE_URL_PATH_SEPARATOR) + className.replace('.', '/') + ".class"));
            return url;
        }
        catch (Exception ex) {
            if (ex.getClass().getName().endsWith("MalformedURLException")) {
                return null;
            }
            assert (false) : "Exception creating class file URL";
            return null;
        }
    }

    static URL createSourceURL(String filePath, LocatorType locatorType, String module, String className) {
        if (filePath == null || filePath.isEmpty()) {
            assert (false) : "filePath can't be null or empty";
            return null;
        }
        if (locatorType == null || locatorType == LocatorType.UNKNOWN_LOCATOR) {
            assert (false) : "Need valid locatorType";
            return null;
        }
        if (className == null || className.isEmpty()) {
            assert (false) : "className can't be null or empty";
            return null;
        }
        try {
            URL url = URLFactory.newURL((String)MODULE_JDK_PROTOCOL, (String)(filePath + FILE_URL_PATH_SEPARATOR + locatorType.type + FILE_URL_PATH_SEPARATOR + (String)(module == null ? "" : module + FILE_URL_PATH_SEPARATOR) + className.replace('.', '/') + ".java"));
            return url;
        }
        catch (Exception ex) {
            if (ex.getClass().getName().endsWith("MalformedURLException")) {
                return null;
            }
            assert (false) : "Exception creating source file URL";
            return null;
        }
    }

    public boolean exists(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        ModularizedJdkBaseLocator locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts);
        if (locator != null) {
            String name = urlParts.name;
            if (name.endsWith(".class")) {
                return locator.classExists(urlParts.moduleIndex, name.substring(0, name.length() - 6));
            }
            if (name.endsWith(".java")) {
                return locator.classExists(urlParts.moduleIndex, name.substring(0, name.length() - 5));
            }
            if (url.getPath().endsWith("/")) {
                return locator.packageExists(name.replace('/', '.'));
            }
        }
        return false;
    }

    public boolean canCreate(URL url) {
        return false;
    }

    public boolean canDelete(URL url) {
        return false;
    }

    public boolean canRead(URL url) {
        return this.exists(url);
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.openInputStream(url), encoding);
        return reader;
    }

    public String getFileName(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        if (urlParts != null) {
            String pathName = urlParts.name;
            int index = pathName.lastIndexOf(47);
            return index > 0 ? pathName.substring(index + 1) : pathName;
        }
        return null;
    }

    public long getLength(URL url) {
        try {
            ModularizedJdkBaseLocator locator;
            String name;
            UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
            if (urlParts != null && (name = (name = urlParts.name).endsWith(".class") ? name.substring(0, name.length() - 6) : (name.endsWith(".java") ? name.substring(0, name.length() - 5) : null)) != null && (locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts)) != null) {
                return locator.getLength(urlParts.moduleIndex, name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    public long lastModified(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        ModularizedJdkBaseLocator locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts);
        if (locator != null) {
            return locator.getLastModified();
        }
        return -1L;
    }

    public URL getParent(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        if (urlParts != null) {
            String lastName = urlParts.name;
            int index = lastName.lastIndexOf(47);
            if (index > 0) {
                return ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.file, urlParts.locatorType, lastName.substring(0, index));
            }
            return ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.file, urlParts.locatorType, "");
        }
        return null;
    }

    public InputStream openInputStream(URL url) throws IOException {
        ModularizedJdkBaseLocator locator;
        String name;
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        if (urlParts != null && (name = (name = urlParts.name).endsWith(".class") ? name.substring(0, name.length() - 6) : (name.endsWith(".java") ? name.substring(0, name.length() - 5) : null)) != null && (locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts)) != null) {
            byte[] bytes = locator.getBytes(urlParts.moduleIndex, name);
            return new ByteArrayInputStream(bytes);
        }
        throw new FileNotFoundException();
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        throw new UnknownServiceException();
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        if (this.isDirectory(url1)) {
            UrlParts urlParts1 = ModularizedJdkURLFileSystemHelper.getUrlParts(url1);
            UrlParts urlParts2 = ModularizedJdkURLFileSystemHelper.getUrlParts(url2);
            if (urlParts1 != null && urlParts2 != null) {
                return urlParts1.file.equals(urlParts2.file) && (urlParts1.name.isEmpty() || urlParts2.name.startsWith(urlParts1.name + "/"));
            }
        }
        return false;
    }

    public URL canonicalize(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        if (urlParts == null) {
            return url;
        }
        boolean isSource = urlParts.name.endsWith(".java");
        boolean isClass = urlParts.name.endsWith(".class");
        if (isSource || isClass) {
            ModularizedJdkBaseLocator locator;
            int decrement = isSource ? 5 : 6;
            String sourceClassName = urlParts.name.substring(0, urlParts.name.length() - decrement);
            String moduleIndex = urlParts.moduleIndex;
            if (moduleIndex == null && (locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts)) != null) {
                moduleIndex = locator.getModuleIndexForClass(sourceClassName.replace('/', '.'));
            }
            if (isSource) {
                return ModularizedJdkURLFileSystemHelper.createSourceURL(urlParts.file, urlParts.locatorType, moduleIndex, sourceClassName);
            }
            return ModularizedJdkURLFileSystemHelper.createClassURL(urlParts.file, urlParts.locatorType, moduleIndex, sourceClassName);
        }
        if (urlParts.name.endsWith("/")) {
            return ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.file, urlParts.locatorType, urlParts.name);
        }
        return url;
    }

    public Icon getDefaultIcon(URL url) {
        if (url != null) {
            if (this.isDirectory(url)) {
                return IdeIcons.getIcon((int)26);
            }
            return IdeIcons.getIcon((int)28);
        }
        return null;
    }

    public boolean isDirectory(URL url) {
        return url.getPath().endsWith("/") && this.exists(url);
    }

    public boolean isDirectoryPath(URL url) {
        return this.isDirectory(url);
    }

    public boolean isLocal(URL url) {
        UrlParts urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url);
        ModularizedJdkBaseLocator locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts);
        if (locator != null) {
            return locator.isLocal();
        }
        return true;
    }

    public URL[] list(URL url) {
        UrlParts urlParts;
        ModularizedJdkBaseLocator locator;
        if (this.isDirectory(url) && (locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(url))) != null) {
            ArrayList<String> packages = new ArrayList<String>();
            String dottedPackage = urlParts.name.replace('/', '.');
            locator.getPackages(dottedPackage, packages);
            Collection<String> classes = locator.getClassesInPackage(dottedPackage);
            ArrayList<URL> urls = new ArrayList<URL>(packages.size() + classes.size());
            String dirName = urlParts.name + (urlParts.name.length() == 0 ? "" : "/");
            for (String onePackage : packages) {
                URL packageUrl = ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.file, urlParts.locatorType, dirName + onePackage);
                if (packageUrl == null) continue;
                urls.add(packageUrl);
            }
            for (String oneClass : classes) {
                URL oneClassUrl = urlParts.locatorType == LocatorType.SRC_LOCATOR ? ModularizedJdkURLFileSystemHelper.createSourceURL(urlParts.file, urlParts.locatorType, null, dirName + oneClass) : ModularizedJdkURLFileSystemHelper.createClassURL(urlParts.file, urlParts.locatorType, null, dirName + oneClass);
                if (oneClassUrl == null) continue;
                urls.add(oneClassUrl);
            }
            return urls.toArray(new URL[urls.size()]);
        }
        return null;
    }

    public String toRelativeSpec(URL url, URL base) {
        return url.toString();
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        return this.isDirectory(url) ? url : this.getParent(url);
    }

    public boolean equals(URL url1, URL url2) {
        URL canonicalized1 = this.canonicalize(url1);
        URL canonicalized2 = this.canonicalize(url2);
        UrlParts urlParts1 = ModularizedJdkURLFileSystemHelper.getUrlParts(canonicalized1);
        UrlParts urlParts2 = ModularizedJdkURLFileSystemHelper.getUrlParts(canonicalized2);
        if (urlParts1 == null || urlParts2 == null) {
            return url1 == url2;
        }
        return urlParts1.equals(urlParts2);
    }

    static String getModuleNameOfClass(URL classURL) {
        String name;
        UrlParts urlParts;
        ModularizedJdkBaseLocator locator;
        if (classURL != null && MODULE_JDK_PROTOCOL.equals(classURL.getProtocol()) && (locator = ModularizedJdkURLFileSystemHelper.getLocator(urlParts = ModularizedJdkURLFileSystemHelper.getUrlParts(classURL))) != null && (name = (name = urlParts.name).endsWith(".class") ? name.substring(0, name.length() - 6) : (name.endsWith(".java") ? name.substring(0, name.length() - 5) : null)) != null) {
            name = name.replace('\\', '.').replace('/', '.');
            return locator.getModuleNameOfClass(name);
        }
        return null;
    }

    private static UrlParts getUrlParts(URL url) {
        String path;
        if (url != null && (path = url.getPath()) != null) {
            LocatorType locatorType;
            String[] parts = path.split(FILE_URL_PATH_SEPARATOR);
            if (parts != null && parts.length >= 2 && parts.length <= 4 && (locatorType = LocatorType.getLocatorType(parts[1])) != LocatorType.UNKNOWN_LOCATOR) {
                if (parts.length == 4) {
                    return new UrlParts(parts[0], locatorType, parts[2], parts[3]);
                }
                if (parts.length == 3) {
                    if (parts[2].endsWith("/")) {
                        parts[2] = parts[2].substring(0, parts[2].length() - 1);
                    }
                    return new UrlParts(parts[0], locatorType, null, parts[2]);
                }
                if (parts.length == 2) {
                    return new UrlParts(parts[0], locatorType, null, "");
                }
            }
            assert (false) : "Incorrect modularized URL: " + url.toString();
        }
        return null;
    }

    private static ModularizedJdkBaseLocator getLocator(UrlParts urlParts) {
        if (urlParts != null) {
            switch (urlParts.locatorType) {
                case JRT_LOCATOR: {
                    return ModularizedJdkJrtfsLocator.getInstance(urlParts.file);
                }
                case MOD_LOCATOR: {
                    return ModularizedJdkJmodLocator.getInstance(urlParts.file);
                }
                case SRC_LOCATOR: {
                    return ModularizedJdkSourceLocator.getInstance(urlParts.file);
                }
            }
            return null;
        }
        return null;
    }

    static enum LocatorType {
        SRC_LOCATOR("src"),
        MOD_LOCATOR("mod"),
        JRT_LOCATOR("jrt"),
        UNKNOWN_LOCATOR("");

        private String type;
        private static Map<String, LocatorType> types;

        private LocatorType(String type) {
            this.type = type;
        }

        static LocatorType getLocatorType(String locatorType) {
            LocatorType type;
            if (types == null) {
                HashMap<String, LocatorType> collectTypes = new HashMap<String, LocatorType>(6);
                for (LocatorType existingLocatorType : LocatorType.values()) {
                    collectTypes.put(existingLocatorType.type, existingLocatorType);
                }
                types = collectTypes;
            }
            return (type = types.get(locatorType)) == null ? UNKNOWN_LOCATOR : type;
        }
    }

    private static class UrlParts {
        String file;
        LocatorType locatorType;
        String moduleIndex;
        String name;

        UrlParts(String file, LocatorType locatorType, String module, String name) {
            this.file = file;
            this.locatorType = locatorType;
            this.moduleIndex = module;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UrlParts)) {
                return false;
            }
            UrlParts other = (UrlParts)o;
            if (this.file.equals(other.file) && this.locatorType == other.locatorType && this.name.equals(other.name)) {
                if (this.moduleIndex == null || other.moduleIndex == null) {
                    return this.moduleIndex == other.moduleIndex;
                }
                return this.moduleIndex.equals(other.moduleIndex);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode() + this.locatorType.hashCode() + (this.moduleIndex == null ? 0 : this.moduleIndex.hashCode()) + this.name.hashCode();
        }
    }
}

