/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.filter;

import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;

public class SimpleNameFilter
implements ClassNameFilter,
PackageNameFilter {
    public static final int MATCH_WHOLE = 1;
    public static final int MATCH_PREFIX = 2;
    public static final int MATCH_SUBSTRING = 3;
    public static final int MATCH_SUFFIX = 4;
    protected int _matchType;
    protected boolean _matchCase;
    protected String _matchName;

    public SimpleNameFilter(String matchName, boolean matchCase, int matchType) {
        this._matchName = matchName;
        this._matchCase = matchCase;
        this._matchType = matchType;
    }

    public int getMatchType() {
        return this._matchType;
    }

    public boolean getMatchCase() {
        return this._matchCase;
    }

    public String getMatchName() {
        return this._matchName;
    }

    @Override
    public void setMatchName(String matchName) {
        if (matchName == null) {
            throw new IllegalArgumentException("The match name cannot be null.");
        }
        this._matchName = matchName.trim();
    }

    @Override
    public boolean acceptClassName(String className, String packagePrefix) {
        return this.acceptName(className);
    }

    @Override
    public boolean acceptPackageName(String packageName) {
        return this.acceptName(packageName);
    }

    public boolean acceptName(String testName) {
        int testInitialOffset;
        int testCompareLength;
        String matchName = this.getMatchName();
        int matchNameLength = matchName.length();
        int testNameLength = testName.length();
        if (testNameLength < matchNameLength) {
            return false;
        }
        int matchType = this.getMatchType();
        int matchesToPerform = switch (matchType) {
            case 2 -> {
                testCompareLength = matchNameLength;
                testInitialOffset = 0;
                yield 1;
            }
            case 4 -> {
                testCompareLength = matchNameLength;
                testInitialOffset = testNameLength - testCompareLength;
                yield 1;
            }
            case 1 -> {
                testCompareLength = Math.max(testNameLength, matchNameLength);
                testInitialOffset = 0;
                yield 1;
            }
            case 3 -> {
                testInitialOffset = 0;
                testCompareLength = matchNameLength;
                yield testNameLength - matchNameLength + 1;
            }
            default -> throw new IllegalStateException("unexpected match type");
        };
        boolean matchCase = this.getMatchCase();
        for (int i = 0; i < matchesToPerform; ++i) {
            int startOffset;
            if (!testName.regionMatches(!matchCase, startOffset = testInitialOffset + i, matchName, 0, testCompareLength)) continue;
            return true;
        }
        return false;
    }
}

