/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java;

import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.PathClassLocator;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.provider.SimpleFileProvider;

public class JavaModelFactory {
    private static JavaModelFactory instance = null;
    protected ClassLocatorFactory locatorFactory = this.newLocatorFactory();

    public static synchronized JavaModelFactory getInstance() {
        if (instance == null) {
            JavaModelFactory.setInstance(new JavaModelFactory());
        }
        return instance;
    }

    public static synchronized void setInstance(JavaModelFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        if (instance != null) {
            throw new UnsupportedOperationException("Only one factory allowed");
        }
        instance = factory;
    }

    protected JavaModelFactory() {
        if (this.locatorFactory == null) {
            Class<?> thisClass = this.getClass();
            String name = thisClass.getName();
            String message = name + ".newLocatorFactory() must return non-null";
            throw new UnsupportedOperationException(message);
        }
    }

    public final JavaModel newInstance(URLPath sourcepath, URLPath classpath) {
        CachedFileProvider provider = this.newFileProvider(sourcepath, classpath);
        JavaModel model = this.newInstance(provider);
        if (model == null) {
            Class<?> thisClass = this.getClass();
            String name = thisClass.getName();
            String message = name + ".newInstance() must return non-null";
            throw new UnsupportedOperationException(message);
        }
        return model;
    }

    public final CachedFileProvider newFileProvider(URLPath sourcepath, URLPath classpath) {
        if (sourcepath == null && classpath == null) {
            throw new IllegalArgumentException("No path provided for the file provider");
        }
        ProviderContext e = this.newContext();
        ClassLocatorFactory factory = this.getLocatorFactory();
        BaseClassLocator sourceLocator = factory.getSourceLocator(sourcepath);
        BaseClassLocator classpathLocator = factory.getClassLocator(classpath);
        PathClassLocator finalLocator = PathClassLocator.getInstance(sourceLocator, classpathLocator);
        return new SimpleFileProvider(e, finalLocator);
    }

    public final CachedFileProvider newFileProvider(URLPath sourcepath, URLPath classpath, URLPath modulepath) {
        URLPath _classPath = new URLPath(classpath);
        _classPath.add(modulepath);
        return this.newFileProvider(sourcepath, _classPath);
    }

    protected JavaModel newInstance(CachedFileProvider provider) {
        return new JavaModel(provider);
    }

    public final ClassLocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    protected ClassLocatorFactory newLocatorFactory() {
        return new ClassLocatorFactory();
    }

    public final ProviderContext newContext() {
        ProviderContext context = this.newContextImpl();
        if (context == null) {
            Class<?> thisClass = this.getClass();
            String name = thisClass.getName();
            String message = name + ".newContext() must return non-null";
            throw new UnsupportedOperationException(message);
        }
        return context;
    }

    protected ProviderContext newContextImpl() {
        return new ProviderContext();
    }
}

