/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.lang.ref.WeakReference;
import java.net.URL;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.xml.XmlModelDependencyMediator;

class XmlModelDependency
extends Dependency {
    private static final XmlModelDependencyMediator MEDIATOR = new XmlModelDependencyMediator();
    private WeakReference<XMLSourceNode> node;
    private final URL file;
    private final Project project;
    private final Workspace workspace;
    private final URL projectFile;
    private final URL workspaceFile;
    private static final Log LOG = new Log(new String[]{"xml-dependency", "dependency"});

    XmlModelDependency(XMLSourceNode node, Project project, Workspace workspace) {
        this.node = new WeakReference<XMLSourceNode>(node);
        this.file = node.getURL();
        this.project = project;
        this.workspace = workspace;
        this.projectFile = project != null ? project.getURL() : null;
        this.workspaceFile = workspace != null ? workspace.getURL() : null;
    }

    URL getFile() {
        return this.file;
    }

    Project getProject() {
        return this.project;
    }

    Workspace getWorkspace() {
        return this.workspace;
    }

    public URL getProjectFile() {
        return this.projectFile;
    }

    public URL getWorkspaceFile() {
        return this.workspaceFile;
    }

    XMLSourceNode getNode() {
        return (XMLSourceNode)((Object)this.node.get());
    }

    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        MEDIATOR.addDependency(this);
    }

    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        MEDIATOR.removeDependency(this);
    }

    protected String getShortDescription() {
        return URLFileSystem.getFileName((URL)this.file);
    }

    protected String getLongDescription() {
        return URLFileSystem.getPlatformPathName((URL)this.file);
    }
}

